## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, cache = FALSE)
Design = matrix()

## ------------------------------------------------------------------------
	library(INLA)
	opts = control.inla(int.strategy = "user", int.design = Design)

## ---- eval=FALSE---------------------------------------------------------
#  	opts = control.inla(int.strategy = "user.std", int.design = Design)

## ---- eval=TRUE, echo=TRUE-----------------------------------------------
n = 100
rho = 0.9
x = scale(arima.sim(n, model = list(ar = rho)))
y = x + rnorm(n, sd = 0.1)

## ------------------------------------------------------------------------
plot(y, xlab = "time", ylab = "value")
lines(x, lwd=2)

## ------------------------------------------------------------------------
rho.0 = rho
to.theta = inla.models()$latent$ar1$hyper$theta2$to.theta
rho.0.internal = to.theta(rho.0)

r = inla(y ~ -1 + f(time, model="ar1",
	hyper = list(
		theta1 = list(prior = "loggamma",
		              param = c(1,1)),
	    theta2 = list(initial = rho.0.internal,
		              fixed=TRUE))),
    control.inla = list(int.strategy = "grid"),
	data = data.frame(y, time = 1:n))

sd.0 = r$summary.random$time[1,"sd"]
print(sd.0)

## ------------------------------------------------------------------------
nm = names(r$joint.hyper)
nm = nm[-length(nm)]
print(nm)

## ------------------------------------------------------------------------
Design = as.matrix(cbind(r$joint.hyper[, seq_along(nm)], 1))
head(Design)

## ------------------------------------------------------------------------
h.rho = 0.01
rho.1.internal = to.theta(rho.0 + h.rho)
rr = inla(y ~ -1 + f(time, model="ar1",
	hyper = list(
		theta1 = list(prior = "loggamma",
		              param = c(1,1)),
	    theta2 = list(initial = rho.1.internal,
		              fixed=TRUE))),
	control.mode = list(result = r, restart=FALSE),	
    data = data.frame(y, time = 1:n),
	control.inla = list(
		int.strategy = "user",
		int.design = Design))
sd.1 = rr$summary.random$time[1,"sd"]
print(sd.1)

## ------------------------------------------------------------------------
deriv.1 = (sd.1 - sd.0) / h.rho
print(deriv.1)

