% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barrier.R
\name{inla.barrier.pcmatern}
\alias{inla.barrier.pcmatern}
\alias{inla.barrier}
\alias{barrier}
\alias{barrier.pcmatern}
\alias{inla.barrier.polygon}
\alias{barrier.polygon}
\alias{inla.barrier.q}
\alias{barrier.q}
\alias{inla.barrier.fem}
\alias{barrier.fem}
\title{Functions for defining the Barrier models}
\usage{
inla.barrier.pcmatern(
  mesh,
  barrier.triangles,
  prior.range,
  prior.sigma,
  range.fraction = 0.2
)

inla.barrier.polygon(mesh, barrier.triangles, Omega = NULL)

inla.barrier.q(fem, ranges, sigma = 1, envir = NULL)

inla.barrier.fem(mesh, barrier.triangles, Omega = NULL)
}
\arguments{
\item{mesh}{The mesh to build the model on, from inla.mesh.2d}

\item{barrier.triangles}{The numerical ids of the triangles that make up the
barrier area}

\item{prior.range}{2 parameters \verb{(range0,Prange)} for the prior spatial
range.  If \code{Prange} is \code{NA}, then \code{range0} is used as a fixed
range value (not tested).}

\item{prior.sigma}{2 parameters \verb{(sig0,Psig)} for the prior marginal
standard deviation sigma.  If \code{Psig} is \code{NA}, then \code{sig0} is
used as a fixed sigma value (not tested).}

\item{range.fraction}{The length of the spatial range inside the barrier
area, as a fraction of the range parameter.}

\item{Omega}{Advanced option for creating a set of permeable barriers (not
documented)}

\item{fem}{represents the Barrier model or the Different Terrains (DT) model,
by containing all the needed matrices to solve the SPDE}

\item{ranges, sigma}{the hyperparameters that determine Q}

\item{envir}{the environment used for caching (with optimize=TRUE), if any}
}
\value{
\itemize{
\item \code{inla.barrier.pcmatern} gives the (rgeneric) model object
for fitting the model in INLA
\item \code{inla.barrier.polygon} gives the polygon
around the barrier (mainly for plotting)
\item \code{inla.barrier.q} is an
internal method producing the Q matrix from a result of inla.barrier.fem,
\item \code{inla.barrier.fem} is an internal method producing the Finite Element
matrices.
}
}
\description{
Functions for defining Barrier models as an \verb{inla rgeneric} model
}
\details{
This model is described in the ArXiv preprint arXiv:1608.03787.  For
examples, see \url{https://haakonbakkagit.github.io/btopic128.html}
\itemize{
\item \code{inla.barrier.pcmatern}
This function creates the model component used in inla(...)
}

\itemize{
\item \code{inla.barrier.polygon} This function constructs SpatialPolygons for the different subdomains (areas)
}

\itemize{
\item \code{inla.barrier.q}: This function computes a specific precision matrix
}

\itemize{
\item \code{inla.barrier.fem} This function computes the Finite Element
matrices that are needed to compute the precision matrix Q later
}
}
\seealso{
inla.spde2.pcmatern
}
\author{
Haakon Bakka \email{bakka@r-inla.org}
}
