% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{inla.mesh.map.lim}
\alias{inla.mesh.map.lim}
\alias{inla.mesh.map}
\title{Coordinate mappings for \code{inla.mesh} projections.}
\usage{
inla.mesh.map.lim(
  loc = NULL,
  projection = c("default", "longlat", "longsinlat", "mollweide")
)

inla.mesh.map(
  loc,
  projection = c("default", "longlat", "longsinlat", "mollweide"),
  inverse = TRUE
)
}
\arguments{
\item{loc}{Coordinates to be mapped.}

\item{projection}{The projection type.}

\item{inverse}{If \code{TRUE}, \code{loc} are map coordinates and
coordinates in the mesh domain are calculated.  If \code{FALSE}, \code{loc}
are coordinates in the mesh domain and the forward map projection is
calculated.}
}
\value{
For \code{inla.mesh.map.lim}, a list: \item{xlim }{X axis limits in
the map domain} \item{ylim }{Y axis limits in the map domain} No attempt is
made to find minimal limits for partial spherical domains.
}
\description{
Calculates coordinate mappings for \code{inla.mesh} projections.
}
\section{Functions}{
\itemize{
\item \code{inla.mesh.map.lim}: Projection extent limit calculations
}}

\seealso{
\code{\link[=inla.mesh.project]{inla.mesh.project()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
