% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spde.common.R
\name{inla.spde.make.block.A}
\alias{inla.spde.make.block.A}
\title{Observation matrices for mesh models.}
\usage{
inla.spde.make.block.A(
  A,
  block,
  n.block = max(block),
  weights = NULL,
  rescale = c("none", "count", "weights", "sum")
)
}
\arguments{
\item{A}{A precomputed observation/prediction matrix for locations that are
to be joined.}

\item{block}{Indices specifying block groupings: Entries with the same
\code{block} value are joined into a single row in the resulting matrix, and
the \code{block} values are the row indices.}

\item{n.block}{The number of blocks.}

\item{weights}{Optional scaling weights to be applied row-wise to the input
\code{A} matrix.}

\item{rescale}{Specifies what scaling method should be used when joining the
rows of the \code{A} matrix as grouped by the \code{block} specification.
\itemize{ \item \code{'none'}: Straight sum, no rescaling.  \item
\code{'count'}: Divide by the number of entries in the block.  \item
\code{'weights'}: Divide by the sum of the \code{weight} values within each
block.  \item \code{'sum'}: Divide by the resulting row sums.  }}
}
\description{
Constructs observation/prediction weight matrices for numerical integration
schemes for regional data problems.  Primarily intended for internal use by
\code{\link[=inla.spde.make.A]{inla.spde.make.A()}}.
}
\seealso{
\code{\link[=inla.spde.make.A]{inla.spde.make.A()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
