%%
%% WARNING! DO NOT EDIT!
%% This file is automatically generated from link-functions.R
%%
 \name{link}
 \alias{link}
 \alias{inla.link}
 \alias{inla.link.log}
 \alias{inla.link.invlog}
 \alias{inla.link.neglog}
 \alias{inla.link.invneglog}
 \alias{inla.link.logit}
 \alias{inla.link.invlogit}
 \alias{inla.link.probit}
 \alias{inla.link.invprobit}
 \alias{inla.link.cloglog}
 \alias{inla.link.invcloglog}
 \alias{inla.link.loglog}
 \alias{inla.link.invloglog}
 \alias{inla.link.tan}
 \alias{inla.link.invtan}
 \alias{inla.link.identity}
 \alias{inla.link.invidentity}
 \alias{inla.link.invalid}
 \alias{inla.link.invinvalid}
 \alias{inla.link.cauchit}
 \alias{inla.link.invcauchit}
 \alias{inla.link.inverse}
 \alias{inla.link.invinverse}
 \alias{inla.link.robit}
 \alias{inla.link.invrobit}
 \alias{inla.link.sn}
 \alias{inla.link.invsn}
 \alias{inla.link.invqpoisson}

 \title{Link functions in INLA}

 \description{Define link-functions and its inverse}

 \usage{
 inla.link.log(x, inverse=FALSE)
 inla.link.invlog(x, inverse=FALSE)
 inla.link.neglog(x, inverse=FALSE)
 inla.link.invneglog(x, inverse=FALSE)
 inla.link.logit(x, inverse=FALSE)
 inla.link.invlogit(x, inverse=FALSE)
 inla.link.probit(x, inverse=FALSE)
 inla.link.invprobit(x, inverse=FALSE)
 inla.link.cloglog(x, inverse=FALSE)
 inla.link.invcloglog(x, inverse=FALSE)
 inla.link.loglog(x, inverse=FALSE)
 inla.link.invloglog(x, inverse=FALSE)
 inla.link.tan(x, inverse=FALSE)
 inla.link.invtan(x, inverse=FALSE)
 inla.link.cauchit(x, inverse=FALSE)
 inla.link.invcauchit(x, inverse=FALSE)
 inla.link.identity(x, inverse=FALSE)
 inla.link.invidentity(x, inverse=FALSE)
 inla.link.inverse(x, inverse=FALSE)
 inla.link.invinverse(x, inverse=FALSE)
 inla.link.robit(x, df=7, inverse=FALSE)
 inla.link.invrobit(x, df=7, inverse=FALSE)
 inla.link.sn(x, intercept=0.5, skew=0, a=0, inverse=FALSE)
 inla.link.invsn(x, intercept=0.5, skew=0, a=0, inverse=FALSE)
 inla.link.invalid(x, inverse=FALSE)
 inla.link.invinvalid(x, inverse=FALSE)
 inla.link.invqpoisson(x, inverse = FALSE, quantile = 0.5)
 }

 \arguments{
     \item{x}{The argument. A numeric vector.}
     \item{df}{The degrees of freedom for the Student-t}
     \item{inverse}{Logical. Use the link (\code{inverse=FALSE})
                    or its inverse (\code{inverse=TRUE})}
     \item{intercept}{The quantile level for the intercept in the Skew-Normal link}
     \item{skew}{The skewness in the Skew-Normal.
                 Not both of \code{skew} and \code{a} can be given.}
     \item{a}{The \code{a}-paraeter in the Skew-Normal.
              Not both of \code{skew} and \code{a} can be given.}
     \item{quantile}{The quantile level for quantile links}
}

 \value{Return the values of the link-function or its inverse.}
 \note{The \code{inv}-functions are redundant,  as
       \code{inla.link.invlog(x) = inla.link.log(x, inverse=TRUE)}
       and so on,  but they are simpler to use a arguments
       to other functions.}
 \author{Havard Rue \email{hrue@r-inla.org}}
