%%
%% WARNING! DO NOT EDIT!
%% This file is automatically generated from options.R
%%
 \name{inla.option}
 \alias{inla.option}
 \alias{inla.options}
 \alias{inla.setOption}
 \alias{inla.getOption}

 \title{Set and get global options for INLA}

 \description{Set and get global options for INLA}
 \usage{
 inla.setOption(...)
 inla.getOption(option)
 }

 \arguments{

   \item{...}{Option and value,  like \code{option=value} or \code{option, value}; see the Examples}
   \item{option}{The option to get. If \code{option = NULL} then
     \code{inla.getOption} then \code{inla.getOption} will return a named list of
     current values, otherwise, \code{option} must be one of

     inla.call: The path to the inla-program.

     inla.arg: Additional arguments to \code{inla.call}

     fmesher.call: The path to the fmesher-program

     fmesher.arg: Additional arguments to \code{fmesher.call}

     num.threads: Character string with the number of threads to use as \code{A:B}

     blas.num.threads: Number of threads to use for openblas and mklblas (see \code{inla} for details)

     smtp: Sparse matrix library to use,  one of \code{band}, \code{taucs} (\code{default}) or \code{pardiso}

     mkl: Use binaries buildt with Intel MKL?  (If possible)

     vecLib: This option applies to Mac only. If TRUE and mkl=FALSE, link with vecLib BLAS and LAPACK libs (if available)

     vecLibPath: This option applies to Mac only. Path to vecLib-libraries. If empty, use default.

     pardiso.license: The full path to the PARDISO license file

     keep: Keep temporary files?

     working.directory: The name of the working directory.

     silent: Run the inla-program in a silent mode?

     debug : Run the inla-program in a debug mode?

     cygwin : The home of the Cygwin installation (default "C:/cygwin") [Remote computing for Windows only]

     ssh.auth.sock: The ssh bind-adress (value of $SSH_AUTH_SOCK int the
     Cygwin-shell). [Remote computing for Windows only]

     show.warning.graph.file : Give a warning for using the obsolete argument
                               \code{graph.file} instead of \code{graph}

     scale.model.default : The default value of argument \code{scale.model} which
                           optionally scale intrinisic models to have generalized
                           unit average variance

     short.summary : Use a less verbose output for \code{summary}. Useful for Markdown
                     documents.

     inla.timeout : The timeout limit, in whole seconds, for calls to the
       inla binary. Default is 0, meaning no timeout limit.  Set to a
       positive integer to terminate inla calls if they run to long.
       Fractional seconds are
       rounded up to the nearest integer. This feature is EXPERIMENTAL
       and might change at a later stage. 

     fmesher.timeout : The timeout limit, in whole seconds, for calls to the
       fmesher binary. Default is 0, meaning no timeout limit.  Set to a
       positive integer to terminate fmesher calls that may enter infinite
       loops due to special geometry regularity. Fractional seconds are
       rounded up to the nearest integer.

     inla.mode : Which mode to use in INLA? Default is \code{"classic"}. Other options are
     (USE AT YOUR OWN RISK, THIS IS WORK IN PROGRESS!!!) options are \code{"twostage"} and
     \code{"experimental"}.
   }
 }

 \author{Havard Rue \email{hrue@r-inla.org}}

 \examples{
 ## set number of threads
 inla.setOption("num.threads", "4:1")
 ## alternative format
 inla.setOption(num.threads="4:1")
 ## check it
 inla.getOption("num.threads")
}
