%%
%% WARNING! DO NOT EDIT!
%% This file is automatically generated from pc-gamma.R
%%
 \name{pc.gamma}
 \alias{inla.pc.gamma}
 \alias{pc.gamma}
 \alias{pc.rgamma}
 \alias{inla.pc.rgamma}
 \alias{pc.dgamma}
 \alias{inla.pc.dgamma}
 \alias{pc.pgamma}
 \alias{inla.pc.pgamma}
 \alias{pc.qgamma}
 \alias{inla.pc.qgamma}

 \title{Utility functions for the PC prior for \code{Gamma(1/a, 1/a)}}

 \description{Functions to evaluate, sample, compute quantiles and
              percentiles of the PC prior for \code{Gamma(1/a, 1/a)}}
 \usage{
 inla.pc.rgamma(n, lambda = 1)
 inla.pc.dgamma(x, lambda = 1, log = FALSE)
 inla.pc.qgamma(p, lambda = 1)
 inla.pc.pgamma(q, lambda = 1)
 }
 \arguments{
   \item{n}{Number of observations}
   \item{lambda}{The rate parameter (see Details)}
   \item{x}{Evaluation points}
   \item{log}{Logical. Return the density in natural or log-scale.}
   \item{p}{Vector of probabilities}
   \item{q}{Vector of quantiles}
 }
 \details{
 This gives the PC prior for the \code{Gamma(1/a, 1/a)} case,  where \code{a=0} is the
 base model.
 }
\value{%%
  \code{inla.pc.dgamma} gives the density,
  \code{inla.pc.pgamma} gives the distribution function,
  \code{inla.pc.qgamma} gives the quantile function, and
  \code{inla.pc.rgamma} generates random deviates.
 }
 \seealso{inla.doc("pc.gamma")}
 \author{Havard Rue \email{hrue@r-inla.org}}
 \examples{
 x = inla.pc.rgamma(100,  lambda = 1)
 d = inla.pc.dgamma(x, lambda = 1)
 x = inla.pc.qgamma(0.5, lambda = 1)
 inla.pc.pgamma(x, lambda = 1)
 }
