\name{inla.mesh.create}
\alias{inla.mesh}
\alias{inla.mesh.create}
\alias{inla.delaunay}
\title{
  Low level function for high-quality triangulations
}
\description{
  Create a constrained refined Delaunay triangulation (CRDT) for a set of
  spatial locations.
}
\usage{
inla.mesh.create(loc = NULL,
                 tv = NULL,
                 boundary = NULL, interior = NULL,
                 extend = (missing(tv) || is.null(tv)),
                 refine = FALSE,
                 lattice = NULL,
                 globe = NULL,
                 cutoff = 1e-12,
                 plot.delay = NULL,
                 data.dir,
                 keep = (!missing(data.dir) && !is.null(data.dir)),
                 timings = FALSE,
                 quality.spec = NULL,
                 crs=NULL)

inla.delaunay(loc, ...)
}
\arguments{
  \item{loc}{
    Matrix of point locations.
    Can alternatively be a \code{SpatialPoints} or \code{SpatialPointsDataFrame} object.
  }
  \item{tv}{
    A triangle-vertex index matrix, specifying an existing triangulation.
  }
  \item{boundary}{
    A list of \code{inla.mesh.segment} objects, generated by
    \code{\link{inla.mesh.segment}}, specifying boundary constraint segments.
  }
  \item{interior}{
    A list of \code{inla.mesh.segment} objects, generated by
    \code{\link{inla.mesh.segment}}, specifying interior constraint segments.
  }
  \item{extend}{
    \code{logical} or \code{list} specifying whether to extend the data
    region, with parameters
    \describe{
      \item{\code{n}}{the number of edges in the extended boundary
	(default=8)}
      \item{\code{offset}}{the extension distance.  If negative,
	interpreted as a factor relative to the approximate data
	diameter (default=-0.10)}
    }
    Setting to \code{FALSE} is only useful in combination \code{lattice}
    or \code{boundary}.
  }
  \item{refine}{
    \code{logical} or \code{list} specifying whether to refine the
    triangulation, with parameters
    \describe{
      \item{\code{min.angle}}{the minimum allowed interior angle in any
	triangle.  The algorithm is guaranteed to converge for
	\code{min.angle} at most 21 (default=\code{21})}
      \item{\code{max.edge}}{the maximum allowed edge length in any
	triangle.  If negative, interpreted as a relative factor in an
	ad hoc formula depending on the data density (default=\code{Inf})}
      \item{\code{max.n.strict}}{the maximum number of vertices allowed,
	overriding \code{min.angle} and \code{max.edge}
	(default=-1, meaning no limit)}
      \item{\code{max.n}}{the maximum number of vertices allowed,
	overriding \code{max.edge} only (default=-1, meaning no limit)}
    }
  }
  \item{lattice}{
    An \code{inla.mesh.lattice} object, generated by
    \code{\link{inla.mesh.lattice}}, specifying points on a regular lattice.
  }
  \item{globe}{Subdivision resolution for a semi-regular spherical
    triangulation with equidistant points along equidistant latitude
    bands.}
  \item{cutoff}{
    The minimum allowed distance between points.  Point at most as far
    apart as this are replaced by a single vertex prior to the mesh refinement step.
  }
  \item{plot.delay}{
    On Linux (and Mac if appropriate X11 libraries are installed),
    specifying a numeric value activates a rudimentary plotting system
    in the underlying \code{fmesher} program, showing the triangulation
    algorithm at work.
  }
  \item{data.dir}{
    Where to store the \code{fmesher} data files.  Defaults to
    \code{tempdir()} if \code{keep} is \code{FALSE}, otherwise
    \code{"inla.mesh.data"}.
  }
  \item{keep}{
    \code{TRUE} if the data files should be kept in \code{data.dir} or
    deleted afterwards.  Defaults to true if \code{data.dir} is
    specified, otherwise false.  Warning: If
    \code{keep} is false, \code{data.dir} and its contents will be
    deleted (unless set to \code{tempdir()}).
  }
  \item{timings}{
    If \code{TRUE}, obtain timings for the mesh construction.
  }
  \item{quality.spec}{
    List of vectors of per vertex \code{max.edge} target specification
    for each location in \code{loc}, \code{boundary/interior}
    (\code{segm}), and \code{lattice}.  Only used if refining the mesh.
  }
  \item{crs}{
    An optional \code{CRS} or \code{inla.CRS} object
  }
  \item{...}{
    Optional parameters passed on to \code{inla.mesh.create}.
  }
}
\details{
  \code{inla.mesh.create} generates triangular meshes on subsets of
  \eqn{R^2}{R^2} and \eqn{S^2}{S^2}.  Use the higher level wrapper
  function \code{\link{inla.mesh.2d}} for greater control over mesh
  resolution and coarser domain extensions.

  \code{inla.delaunay} is a wrapper function for obtaining the convex
  hull of a point set and calling \code{inla.mesh.create} to generate
  the classical Delaunay tringulation.
}
\value{
  An \code{inla.mesh} object.
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
%\references{
%}
\author{
  Finn Lindgren \email{finn.lindgren@gmail.com}
}
%\note{
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
  \code{\link{inla.mesh.2d}}, \code{\link{inla.mesh.1d}},
  \code{\link{inla.mesh.segment}}, \code{\link{inla.mesh.lattice}}, \code{\link{inla.mesh.query}}
}
\examples{
loc = matrix(runif(10*2),10,2)

mesh = inla.delaunay(loc)
plot(mesh)

mesh = inla.mesh.create(loc,
                        interior=inla.mesh.segment(idx=1:2),
                        extend=TRUE,
                        refine=list(max.edge=0.1))
plot(mesh)

loc2 = matrix(c(0,1,1,0, 0,0,1,1), 4, 2);
mesh2 = inla.mesh.create(loc=loc,
                         boundary=inla.mesh.segment(loc2),
                         interior=inla.mesh.segment(idx=1:2),
                         quality.spec=list(segm=0.2, loc=0.05),
                         refine=list(min.angle=26))
plot(mesh2)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ fmesher }
