%%
%% WARNING! DO NOT EDIT!
%% This file is automatically generated from pc-alphaw.R
%%
 \name{pc.alphaw}
 \alias{inla.pc.alphaw}
 \alias{pc.alphaw}
 \alias{pc.ralphaw}
 \alias{inla.pc.ralphaw}
 \alias{pc.dalphaw}
 \alias{inla.pc.dalphaw}
 \alias{pc.palphaw}
 \alias{inla.pc.palphaw}
 \alias{pc.qalphaw}
 \alias{inla.pc.qalphaw}
 
 \title{Utility functions for the PC prior for the \code{alpha} parameter in the Weibull likelihood}
 
 \description{Functions to evaluate, sample, compute quantiles and
              percentiles of the PC prior for the \code{alpha} parameter
              in the Weibull likelihood}
 \usage{
 inla.pc.ralphaw(n, lambda = 5)
 inla.pc.dalphaw(alpha, lambda = 5, log = FALSE)
 inla.pc.qalphaw(p, lambda = 5)
 inla.pc.palphaw(q, lambda = 5)
 }
 \arguments{
   \item{n}{Number of observations}
   \item{lambda}{The rate parameter in the PC-prior}
   \item{alpha}{Vector of evaluation points, where \code{alpha>0}.}
   \item{log}{Logical. Return the density in natural or log-scale.}
   \item{p}{Vector of probabilities}
   \item{q}{Vector of quantiles}
 }
 \details{
 This gives the PC prior for the \code{alpha} parameter for the Weibull likelihood,
 where \code{alpha=1} is the base model. 
 }
\value{%%
  \code{inla.pc.dalphaw} gives the density,
  \code{inla.pc.palphaw} gives the distribution function,
  \code{inla.pc.qalphaw} gives the quantile function, and
  \code{inla.pc.ralphaw} generates random deviates.
 }
 \seealso{inla.doc("pc.alphaw")}
 \author{Havard Rue \email{hrue@r-inla.org}}
 \examples{
 x = inla.pc.ralphaw(100,  lambda = 5)
 d = inla.pc.dalphaw(x, lambda = 5)
 x = inla.pc.qalphaw(0.5, lambda = 5)
 inla.pc.palphaw(x, lambda = 5)
 }
