%%
%% WARNING! DO NOT EDIT!
%% This file is automatically generated from pc-cormat.R
%%
 \name{pc.cormat}
 \alias{inla.pc.cormat}
 \alias{inla.pc.cormat.dim2p}
 \alias{cormat.dim2p}
 \alias{inla.pc.cormat.p2dim}
 \alias{cormat.p2dim}
 \alias{inla.pc.cormat.theta2R}
 \alias{cormat.theta2R}
 \alias{inla.pc.cormat.R2theta}
 \alias{cormat.R2theta}
 \alias{inla.pc.cormat.r2R}
 \alias{cormat.r2R}
 \alias{inla.pc.cormat.R2r}
 \alias{cormat.R2r}
 \alias{inla.pc.cormat.r2theta}
 \alias{cormat.r2theta}
 \alias{inla.pc.cormat.theta2r}
 \alias{cormat.theta2r}
 \alias{inla.pc.cormat.permute}
 \alias{cormat.permute}
 \alias{inla.pc.cormat.rtheta}
 \alias{cormat.rtheta}
 \alias{inla.pc.cormat.dtheta}
 \alias{cormat.dtheta}
 
 \title{Utility functions for the PC prior for a correlation matrix}
 
 \description{Functions to evaluate and sample from the 
              PC prior for a correlation matrix.}
 \usage{
    inla.pc.cormat.dim2p(dim)
    inla.pc.cormat.p2dim(p)
    inla.pc.cormat.theta2R(theta)
    inla.pc.cormat.R2theta(R)
    inla.pc.cormat.r2R(r)
    inla.pc.cormat.R2r(R)
    inla.pc.cormat.r2theta(r)
    inla.pc.cormat.theta2r(theta)
    inla.pc.cormat.permute(R)
    inla.pc.cormat.rtheta(n=1, p, lambda = 1)
    inla.pc.cormat.dtheta(theta, lambda = 1, log = FALSE)
 }
 \arguments{
   \item{dim}{The dimension of \code{theta}, the parameterisatin of the correlation matrix}
   \item{p}{The dimension the correlation matrix}
   \item{theta}{A vector of parameters for the correlation matrix}
   \item{r}{The off diagonal elements of a correlation matrix}
   \item{R}{A correlation matrix}
   \item{n}{Number of observations}
   \item{lambda}{The rate parameter in the prior}
   \item{log}{Logical. Return the density in natural or log-scale.}
 }
 \details{
    The parameterisation of a correlation matrix of dimension \code{p} has \code{dim}
    parameters: \code{theta} which are in the interval -pi to pi.
    The alternative parameterisation is through the off-diagonal elements \code{r} of the
    correlation matrix \code{R}. The functions \code{inla.pc.cormat.<A>2<B>} convert between
    parameterisations \code{<A>} to parameterisations \code{<B>},  where both
    \code{<A>} and \code{<B>} are one of \code{theta},  \code{r} and \code{R},
    and \code{p} and \code{dim}. 
 }
 \value{%%
     \code{inla.pc.cormat.rtheta} generate samples from the prior,  returning a matrix
     where each row is a sample of \code{theta}.
     \code{inla.pc.cormat.dtheta} evaluates the density of \code{theta}.
     \code{inla.pc.cormat.permute} randomly permutes a correlation matrix,
     which is useful if an exchangable sample of a correlation matrix is required.
 }
 \author{Havard Rue \email{hrue@r-inla.org}}
 \examples{
  p = 4
  print(paste("theta has length", inla.pc.cormat.p2dim(p)))
  theta = inla.pc.cormat.rtheta(n=1, p=4, lambda = 1)
  print("sample theta:")
  print(theta)
  print(paste("log.dens", inla.pc.cormat.dtheta(theta, log=TRUE)))
  print("r:")
  r = inla.pc.cormat.theta2r(theta)
  print(r)
  print("A sample from the non-exchangable prior, R:")
  R = inla.pc.cormat.r2R(r)
  print(R)
  print("A sample from the exchangable prior, R:")
  R = inla.pc.cormat.permute(R)
  print(R)
 }
