%%
%% WARNING! DO NOT EDIT!
%% This file is automatically generated from pc-gev.R
%%
 \name{pc.gevtail}
 \alias{inla.pc.gevtail}
 \alias{pc.gevtail}
 \alias{pc.rgevtail}
 \alias{inla.pc.rgevtail}
 \alias{pc.dgevtail}
 \alias{inla.pc.dgevtail}
 \alias{pc.pgevtail}
 \alias{inla.pc.pgevtail}
 \alias{pc.qgevtail}
 \alias{inla.pc.qgevtail}
 
 \title{Utility functions for the PC prior for the \code{tail} parameter in the GEV likelihood}
 
 \description{Functions to evaluate, sample, compute quantiles and
              percentiles of the PC prior for the \code{tail} parameter
              in the GEV likelihood}
 \usage{
 inla.pc.rgevtail(n, lambda = 7)
 inla.pc.dgevtail(xi, lambda = 7, log = FALSE)
 inla.pc.qgevtail(p, lambda = 7)
 inla.pc.pgevtail(q, lambda = 7)
 }
 \arguments{
   \item{n}{Number of observations}
   \item{lambda}{The rate parameter in the PC-prior}
   \item{xi}{Vector of evaluation points, where \code{1>xi>0}.}
   \item{log}{Logical. Return the density in natural or log-scale.}
   \item{p}{Vector of probabilities}
   \item{q}{Vector of quantiles}
 }
 \details{
 This gives the PC prior for the \code{tail} parameter for the GEV likelihood,
 where \code{xi=0} is the base model. 
 }
\value{%%
  \code{inla.pc.dgevtail} gives the density,
  \code{inla.pc.pgevtail} gives the distribution function,
  \code{inla.pc.qgevtail} gives the quantile function, and
  \code{inla.pc.rgevtail} generates random deviates.
 }
 \seealso{inla.doc("pc.gevtail")}
 \author{Havard Rue \email{hrue@r-inla.org}}
 \examples{
 xi = inla.pc.rgevtail(100,  lambda = 7)
 d = inla.pc.dgevtail(xi, lambda = 7)
 xi = inla.pc.qgevtail(0.5, lambda = 7)
 inla.pc.pgevtail(xi, lambda = 7)
 }
