%%
%% WARNING! DO NOT EDIT!
%% This file is automatically generated from cpo.R
%%
\name{inla.cpo}
\alias{inla.cpo}
\alias{cpo.inla}

\title{Improved estimates for the CPO/PIT-values}
\description{
 Improve the estimates of the  CPO/PIT-values
 be recomputing the model-fit by removing data-points. 
}
\usage{
inla.cpo(result,
         force = FALSE,
         mc.cores = NULL, 
         verbose = TRUE,
         recompute.mode = TRUE)
}

\arguments{
\item{result}{An object of class \code{inla}, ie a result
of a call to \code{inla()}}
\item{force}{If TRUE,  then recompute all CPO/PIT values and not just 
those with \code{result$cpo$failure > 0}.}
\item{mc.cores}{The number of cores to use in \code{parallel::mclapply}. If
                \code{is.null(mc.cores)}, then check \code{getOption("mc.cores")}
                and \code{inla.getOption("num.threads")} in that order.}
\item{verbose}{Run in verbose mode?}
\item{recompute.mode}{Should be mode (and the integration points) be recomputed when a data-point is removed or not?}
}
\value{
The object returned is the same as  \code{result} but the
new improved estimates of the CPO/PIT values replaced.}
\author{Havard Rue \email{hrue@r-inla.org}}
\examples{
n = 10
y = rnorm(n)
r = inla(y ~ 1, data = data.frame(y), control.compute = list(cpo=TRUE))
\donttest{
rr = inla.cpo(r, force=TRUE)
}
}
\seealso{\code{\link{inla}}}
