%%
%% WARNING! DO NOT EDIT!
%% This file is automatically generated from q.R
%%
\name{inla.qstat}
\alias{inla.qstat}
\alias{inla.q}
\alias{inla.qget}
\alias{inla.qdel}
\alias{inla.qnuke}
\alias{inla.qlog}
\alias{summary.inla.q}
\alias{print.inla.q}
\title{Control and view a remote inla-queue}
\description{
Control and view a remote inla-queue of submitted jobs
}
\usage{
inla.qget(id, remove = TRUE)
inla.qdel(id)
inla.qstat(id)
inla.qlog(id)
inla.qnuke()
\method{summary}{inla.q}(object,...)
\method{print}{inla.q}(x,...)
}
\arguments{
  \item{id}{The job-id which is the output from \code{inla} when the job is submitted,  the
            job-number or job-name. For \code{inla.qstat}, \code{id} is optional and if omitted
            all the jobs will be listed.}
  \item{remove}{Logical If FALSE, leave the job on the server after retrival,
                otherwise remove it (default).}
  \item{x}{An \code{inla.q}-object which is the output from \code{inla.qstat}}
  \item{object}{An \code{inla.q}-object  which is the output from \code{inla.qstat}}
  \item{...}{ other arguments.}
}
\details{
\code{inla.qstat} show job(s) on the server,
\code{inla.qget} fetch the results (and by default remove
the files on the server),  \code{inla.qdel} removes 
a job on the server and \code{inla.qnuke} remove all jobs on the server.
\code{inla.qlog} fetches the logfile only.

The recommended procedure is to use \code{r=inla(...,
inla.call="submit")} and then do \code{r=inla.qget(r)} at a later
stage.  If the job is not finished, then \code{r} will not be
overwritten and this step can be repeated.  The reason for this
procedure, is that some information usually stored in the result
object does not go through the remote server, hence have to be
appended to the results that are retrieved from the server. Hence
doing \code{r=inla(..., inla.call="submit")} and then later retrive
it using \code{r=inla.qget(1)}, say, then \code{r} does not contain
all the usual information.  All the main results are there, but
administrative information which is required to call
\code{inla.hyperpar} or \code{inla.rerun} are not there.
}
\value{
  \code{inla.qstat} returns an \code{inla.q}-object with information about current jobs.
}
\author{Havard Rue}
\seealso{ \code{\link{inla}} }
\examples{
\dontrun{
r = inla(y~1, data = data.frame(y=rnorm(10)), inla.call="submit")
inla.qstat()
r = inla.qget(r, remove=FALSE)
inla.qdel(1)
inla.qnuke()
}
}
