## Export: inla.pc.ddof

##! \name{pc.ddof}
##! \alias{pc.ddof}
##! \alias{inla.pc.ddof}
##! \alias{pc.t}
##! \alias{pc.dof}
##! \alias{inla.pc.t}
##! \alias{inla.pc.dof}
##!
##! \title{PC-prior for dof in a standarized Student-t}
##! 
##! \description{A function to evaluate the PC-prior for the degrees of freedom
##!              in a standarized Student-t distribution}
##! \usage{
##!     inla.pc.ddof(dof, lambda, u, alpha, log=FALSE)
##! }
##! \arguments{
##!   \item{dof}{Degrees of freedom}
##!   \item{log}{Logical. Return the density or the log-density}
##!   \item{lambda}{The optional value of \code{lambda},  instead of defining it implicitely
##!                 through \code{u} and \code{alpha}}
##!   \item{u}{The upper value of dof used to elicitate \code{lambda},  \code{Prob(dof < u) = alpha}}
##!   \item{alpha}{The probability \code{alpha} used to elicitate \code{lambda}}
##!}
##! \details{
##!   These functions implements the PC-prior for the dof in a standarized Student-t
##!   distribution (ie. with unit variance and \code{dof} > 2).
##!   Either \code{lambda}, or \code{u} AND \code{alpha} must be given.
##!   Due the internal tabulation, \code{dof} must be larger than 2.0025.
##! }
##! \value{%%
##!     \code{inla.pc.ddof} returns the prior density for given \code{dof}.
##! }
##! \author{Havard Rue \email{hrue@r-inla.org}}
##! \examples{
##! }


`inla.pc.ddof` = function(dof, lambda, u, alpha, log=FALSE)
{
    func.name.in.env = "inla.pc.t.dof.func"
    dof.lim = 9.0
    dof.min = 2.0025

    pc.dof.kld.approx = function (dof)
    {
        t1 = dof * dof
        t4 = t1 * dof
        t7 = t1 * t1
        t10 = t7 * dof
        t13 = t7 * t1
        t16 = t7 * t4
        t19 = t7 * t7
        t43 = t19 * t19
        t61 = 0.7500000000000000e0 / t1 + 0.1500000000000000e1 / t4 + 0.2125000000000000e1 / t7 + 0.2900000000000000e1 / t10
        + 0.5083333333333333e1 / t13 + 0.1035714285714286e2 / t16 + 0.1706250000000000e2 / t19
        + 0.1983333333333333e2 / t19 / dof + 0.4345000000000000e2 / t19 / t1 + 0.1873181818181818e3 / t19 / t4
        + 0.2570416666666667e3 / t19 / t7 - 0.1155192307692308e4 / t19 / t10 - 0.7801071428571429e3 / t19 / t13
        + 0.3207790000000000e5 / t19 / t16 + 0.3109703125000000e5 / t43 - 0.8438102058823529e6 / t43 / dof
        - 0.7932909722222222e6 / t43 / t1 + 0.2921518928947368e8 / t43 / t4 + 0.2776753702500000e8 / t43 / t7

        return (t61)
    }

    pc.dof.create.spline = function()
    {
        xx = c(
            2.002478752000,
            2.002480761000,
            2.002482771000,
            2.002484783000,
            2.002486797000,
            2.002488812000,
            2.002490829000,
            2.002492848000,
            2.002494868000,
            2.002496890000,
            2.002498914000,
            2.002500939000,
            2.002502966000,
            2.002504994000,
            2.002507024000,
            2.002509056000,
            2.002511089000,
            2.002513124000,
            2.002515161000,
            2.002517199000,
            2.002519239000,
            2.002521281000,
            2.002523324000,
            2.002525369000,
            2.002527415000,
            2.002529464000,
            2.002531514000,
            2.002533565000,
            2.002535618000,
            2.002537673000,
            2.002539730000,
            2.002541788000,
            2.002543848000,
            2.002545909000,
            2.002547973000,
            2.002550038000,
            2.002552104000,
            2.002554172000,
            2.002556242000,
            2.002558314000,
            2.002560387000,
            2.002562462000,
            2.002564539000,
            2.002566617000,
            2.002568697000,
            2.002570779000,
            2.002572862000,
            2.002574947000,
            2.002577034000,
            2.002579123000,
            2.002581213000,
            2.002583305000,
            2.002585398000,
            2.002587493000,
            2.002589590000,
            2.002591689000,
            2.002593789000,
            2.002595891000,
            2.002597995000,
            2.002600100000,
            2.002602208000,
            2.002604316000,
            2.002606427000,
            2.002608539000,
            2.002610653000,
            2.002612769000,
            2.002614886000,
            2.002617005000,
            2.002619126000,
            2.002621249000,
            2.002623373000,
            2.002625499000,
            2.002627627000,
            2.002629756000,
            2.002631888000,
            2.002634020000,
            2.002636155000,
            2.002638291000,
            2.002640430000,
            2.002642569000,
            2.002644711000,
            2.002646854000,
            2.002648999000,
            2.002651146000,
            2.002653295000,
            2.002655445000,
            2.002657597000,
            2.002659751000,
            2.002661906000,
            2.002664063000,
            2.002666222000,
            2.002668383000,
            2.002670545000,
            2.002672710000,
            2.002674876000,
            2.002677043000,
            2.002679213000,
            2.002681384000,
            2.002683557000,
            2.002685732000,
            2.002687908000,
            2.002690087000,
            2.002692267000,
            2.002694449000,
            2.002696632000,
            2.002698818000,
            2.002701005000,
            2.002703194000,
            2.002705384000,
            2.002707577000,
            2.002709771000,
            2.002711967000,
            2.002714165000,
            2.002716365000,
            2.002718566000,
            2.002720769000,
            2.002722974000,
            2.002725181000,
            2.002727389000,
            2.002729600000,
            2.002731812000,
            2.002734026000,
            2.002736241000,
            2.002738459000,
            2.002740678000,
            2.002742899000,
            2.002745122000,
            2.002747347000,
            2.002749573000,
            2.002751801000,
            2.002754031000,
            2.002756263000,
            2.002758497000,
            2.002760733000,
            2.002762970000,
            2.002765209000,
            2.002767450000,
            2.002769693000,
            2.002771937000,
            2.002774184000,
            2.002776432000,
            2.002778682000,
            2.002780934000,
            2.002783188000,
            2.002785443000,
            2.002787700000,
            2.002789960000,
            2.002792221000,
            2.002794483000,
            2.002796748000,
            2.002799015000,
            2.002801283000,
            2.002803553000,
            2.002805825000,
            2.002808099000,
            2.002810375000,
            2.002812652000,
            2.002814932000,
            2.002817213000,
            2.002819496000,
            2.002821781000,
            2.002824068000,
            2.002826356000,
            2.002828647000,
            2.002830939000,
            2.002833234000,
            2.002835530000,
            2.002837828000,
            2.002840127000,
            2.002842429000,
            2.002844733000,
            2.002847038000,
            2.002849345000,
            2.002851654000,
            2.002853965000,
            2.002856278000,
            2.002858593000,
            2.002860910000,
            2.002863228000,
            2.002865548000,
            2.002867871000,
            2.002870195000,
            2.002872521000,
            2.002874849000,
            2.002877179000,
            2.002879510000,
            2.002881844000,
            2.002884179000,
            2.002886517000,
            2.002888856000,
            2.002891197000,
            2.002893540000,
            2.002895885000,
            2.002898232000,
            2.002900581000,
            2.002902931000,
            2.002905284000,
            2.002907638000,
            2.002909995000,
            2.002912353000,
            2.002914713000,
            2.002917075000,
            2.002919439000,
            2.002921805000,
            2.002924173000,
            2.002926543000,
            2.002928915000,
            2.002931288000,
            2.002933664000,
            2.002936041000,
            2.002938421000,
            2.002940802000,
            2.002943185000,
            2.002945571000,
            2.002947958000,
            2.002950347000,
            2.002952738000,
            2.002955131000,
            2.002957525000,
            2.002959922000,
            2.002962321000,
            2.002964722000,
            2.002967124000,
            2.002969529000,
            2.002971936000,
            2.002974344000,
            2.002976754000,
            2.002979167000,
            2.002981581000,
            2.002983997000,
            2.002986416000,
            2.002988836000,
            2.002991258000,
            2.002993682000,
            2.002996108000,
            2.002998536000,
            2.003000966000,
            2.003003398000,
            2.003005832000,
            2.003008268000,
            2.003010706000,
            2.003013146000,
            2.003015588000,
            2.003018032000,
            2.003020478000,
            2.003022926000,
            2.003025375000,
            2.003027827000,
            2.003030281000,
            2.003032737000,
            2.003035195000,
            2.003037654000,
            2.003040116000,
            2.003042580000,
            2.003045046000,
            2.003047513000,
            2.003049983000,
            2.003052455000,
            2.003054928000,
            2.003057404000,
            2.003059882000,
            2.003062362000,
            2.003064843000,
            2.003067327000,
            2.003069813000,
            2.003072301000,
            2.003074791000,
            2.003077283000,
            2.003079776000,
            2.003082272000,
            2.003084770000,
            2.003087270000,
            2.003089772000,
            2.003092276000,
            2.003094782000,
            2.003097290000,
            2.003099800000,
            2.003102312000,
            2.003104826000,
            2.003107343000,
            2.003109861000,
            2.003112381000,
            2.003114903000,
            2.003117428000,
            2.003119954000,
            2.003122483000,
            2.003125013000,
            2.003127546000,
            2.003130080000,
            2.003132617000,
            2.003135155000,
            2.003137696000,
            2.003140239000,
            2.003142784000,
            2.003145331000,
            2.003147880000,
            2.003150431000,
            2.003152984000,
            2.003155539000,
            2.003158097000,
            2.003160656000,
            2.003163217000,
            2.003165781000,
            2.003168346000,
            2.003170914000,
            2.003173484000,
            2.003176056000,
            2.003178630000,
            2.003181206000,
            2.003183784000,
            2.003186364000,
            2.003188946000,
            2.003191530000,
            2.003194117000,
            2.003196705000,
            2.003199296000,
            2.003201889000,
            2.003204484000,
            2.003207081000,
            2.003209680000,
            2.003212281000,
            2.003214884000,
            2.003217489000,
            2.003220097000,
            2.003222706000,
            2.003225318000,
            2.003227932000,
            2.003230548000,
            2.003233166000,
            2.003235786000,
            2.003238409000,
            2.003241033000,
            2.003243660000,
            2.003246288000,
            2.003248919000,
            2.003251552000,
            2.003254187000,
            2.003256824000,
            2.003259464000,
            2.003262105000,
            2.003264749000,
            2.003267395000,
            2.003270043000,
            2.003272693000,
            2.003275345000,
            2.003277999000,
            2.003280656000,
            2.003283314000,
            2.003285975000,
            2.003288638000,
            2.003291303000,
            2.003293971000,
            2.003296640000,
            2.003299312000,
            2.003301986000,
            2.003304661000,
            2.003307340000,
            2.003310020000,
            2.003312702000,
            2.003315387000,
            2.003318074000,
            2.003320763000,
            2.003323454000,
            2.003326147000,
            2.003328843000,
            2.003331541000,
            2.003334241000,
            2.003336943000,
            2.003339647000,
            2.003342353000,
            2.003345062000,
            2.003347773000,
            2.003350486000,
            2.003353201000,
            2.003355919000,
            2.003358638000,
            2.003361360000,
            2.003364084000,
            2.003366811000,
            2.003369539000,
            2.003372270000,
            2.003375003000,
            2.003377738000,
            2.003380475000,
            2.003383215000,
            2.003385957000,
            2.003388701000,
            2.003391447000,
            2.003394195000,
            2.003396946000,
            2.003399699000,
            2.003402454000,
            2.003405211000,
            2.003407971000,
            2.003410733000,
            2.003413497000,
            2.003416263000,
            2.003419032000,
            2.003421803000,
            2.003424576000,
            2.003427351000,
            2.003430129000,
            2.003432908000,
            2.003435691000,
            2.003438475000,
            2.003441261000,
            2.003444050000,
            2.003446841000,
            2.003449635000,
            2.003452430000,
            2.003455228000,
            2.003458028000,
            2.003460831000,
            2.003463635000,
            2.003466442000,
            2.003469252000,
            2.003472063000,
            2.003474877000,
            2.003477693000,
            2.003480511000,
            2.003483332000,
            2.003486155000,
            2.003488980000,
            2.003491808000,
            2.003494637000,
            2.003497470000,
            2.003500304000,
            2.003503141000,
            2.003505980000,
            2.003508821000,
            2.003511664000,
            2.003514510000,
            2.003517358000,
            2.003520209000,
            2.003523062000,
            2.003525917000,
            2.003528774000,
            2.003531634000,
            2.003534496000,
            2.003537361000,
            2.003540227000,
            2.003543096000,
            2.003545968000,
            2.003548841000,
            2.003551717000,
            2.003554596000,
            2.003557476000,
            2.003560359000,
            2.003563245000,
            2.003566132000,
            2.003569022000,
            2.003571915000,
            2.003574810000,
            2.003577707000,
            2.003580606000,
            2.003583508000,
            2.003586412000,
            2.003589318000,
            2.003592227000,
            2.003595138000,
            2.003598052000,
            2.003600968000,
            2.003603886000,
            2.003606807000,
            2.003609730000,
            2.003612655000,
            2.003615583000,
            2.003618513000,
            2.003621445000,
            2.003624380000,
            2.003627317000,
            2.003630257000,
            2.003633199000,
            2.003636143000,
            2.003639090000,
            2.003642039000,
            2.003644991000,
            2.003647945000,
            2.003650901000,
            2.003653860000,
            2.003656821000,
            2.003659784000,
            2.003662750000,
            2.003665719000,
            2.003668689000,
            2.003671663000,
            2.003674638000,
            2.003677616000,
            2.003680596000,
            2.003683579000,
            2.003686564000,
            2.003689552000,
            2.003692542000,
            2.003695535000,
            2.003698529000,
            2.003701527000,
            2.003704527000,
            2.003707529000,
            2.003710533000,
            2.003713540000,
            2.003716550000,
            2.003719562000,
            2.003722576000,
            2.003725593000,
            2.003728612000,
            2.003731634000,
            2.003734658000,
            2.003737685000,
            2.003740714000,
            2.003743745000,
            2.003746779000,
            2.003749816000,
            2.003752855000,
            2.003755896000,
            2.003758940000,
            2.003761986000,
            2.003765035000,
            2.003768086000,
            2.003771140000,
            2.003774196000,
            2.003777254000,
            2.003780316000,
            2.003783379000,
            2.003786445000,
            2.003789514000,
            2.003792585000,
            2.003795658000,
            2.003798734000,
            2.003801813000,
            2.003804894000,
            2.003807978000,
            2.003811064000,
            2.003814152000,
            2.003817243000,
            2.003820337000,
            2.003823433000,
            2.003826531000,
            2.003829632000,
            2.003832736000,
            2.003835842000,
            2.003838951000,
            2.003842062000,
            2.003845175000,
            2.003848291000,
            2.003851410000,
            2.003854531000,
            2.003857655000,
            2.003860781000,
            2.003863910000,
            2.003867042000,
            2.003870175000,
            2.003873312000,
            2.003876451000,
            2.003879592000,
            2.003882736000,
            2.003885883000,
            2.003889032000,
            2.003892184000,
            2.003895338000,
            2.003898495000,
            2.003901654000,
            2.003904816000,
            2.003907981000,
            2.003911148000,
            2.003914317000,
            2.003917490000,
            2.003920664000,
            2.003923842000,
            2.003927022000,
            2.003930204000,
            2.003933389000,
            2.003936577000,
            2.003939767000,
            2.003942960000,
            2.003946155000,
            2.003949353000,
            2.003952554000,
            2.003955757000,
            2.003958963000,
            2.003962171000,
            2.003965382000,
            2.003968596000,
            2.003971812000,
            2.003975031000,
            2.003978252000,
            2.003981476000,
            2.003984703000,
            2.003987932000,
            2.003991164000,
            2.003994398000,
            2.003997636000,
            2.004000875000,
            2.004004118000,
            2.004007363000,
            2.004010610000,
            2.004013860000,
            2.004017113000,
            2.004020369000,
            2.004023627000,
            2.004026888000,
            2.004030151000,
            2.004033417000,
            2.004036686000,
            2.004039957000,
            2.004043231000,
            2.004046508000,
            2.004049787000,
            2.004053069000,
            2.004056354000,
            2.004059641000,
            2.004062931000,
            2.004066224000,
            2.004069519000,
            2.004072817000,
            2.004076118000,
            2.004079421000,
            2.004082727000,
            2.004086036000,
            2.004089347000,
            2.004092661000,
            2.004095978000,
            2.004099297000,
            2.004102619000,
            2.004105944000,
            2.004109272000,
            2.004112602000,
            2.004115935000,
            2.004119270000,
            2.004122609000,
            2.004125950000,
            2.004129293000,
            2.004132640000,
            2.004135989000,
            2.004139341000,
            2.004142695000,
            2.004146053000,
            2.004149413000,
            2.004152775000,
            2.004156141000,
            2.004159509000,
            2.004162880000,
            2.004166254000,
            2.004169630000,
            2.004173009000,
            2.004176391000,
            2.004179775000,
            2.004183163000,
            2.004186553000,
            2.004189946000,
            2.004193341000,
            2.004196740000,
            2.004200141000,
            2.004203544000,
            2.004206951000,
            2.004210360000,
            2.004213773000,
            2.004217187000,
            2.004220605000,
            2.004224025000,
            2.004227449000,
            2.004230875000,
            2.004234303000,
            2.004237735000,
            2.004241169000,
            2.004244606000,
            2.004248046000,
            2.004251489000,
            2.004254934000,
            2.004258382000,
            2.004261834000,
            2.004265287000,
            2.004268744000,
            2.004272203000,
            2.004275666000,
            2.004279131000,
            2.004282599000,
            2.004286069000,
            2.004289543000,
            2.004293019000,
            2.004296498000,
            2.004299980000,
            2.004303465000,
            2.004306952000,
            2.004310443000,
            2.004313936000,
            2.004317432000,
            2.004320931000,
            2.004324433000,
            2.004327937000,
            2.004331445000,
            2.004334955000,
            2.004338468000,
            2.004341984000,
            2.004345503000,
            2.004349024000,
            2.004352549000,
            2.004356076000,
            2.004359606000,
            2.004363139000,
            2.004366675000,
            2.004370214000,
            2.004373756000,
            2.004377300000,
            2.004380848000,
            2.004384398000,
            2.004387951000,
            2.004391507000,
            2.004395066000,
            2.004398628000,
            2.004402193000,
            2.004405760000,
            2.004409331000,
            2.004412904000,
            2.004416480000,
            2.004420059000,
            2.004423641000,
            2.004427226000,
            2.004430814000,
            2.004434405000,
            2.004437999000,
            2.004441595000,
            2.004445195000,
            2.004448797000,
            2.004452403000,
            2.004456011000,
            2.004459622000,
            2.004463236000,
            2.004466853000,
            2.004470473000,
            2.004474096000,
            2.004477722000,
            2.004481351000,
            2.004484982000,
            2.004488617000,
            2.004492255000,
            2.004495895000,
            2.004499539000,
            2.004503185000,
            2.004506835000,
            2.004510487000,
            2.004514142000,
            2.004517801000,
            2.004521462000,
            2.004525126000,
            2.004528793000,
            2.004532464000,
            2.004536137000,
            2.004539813000,
            2.004543492000,
            2.004547174000,
            2.004550859000,
            2.004554547000,
            2.004558238000,
            2.004561932000,
            2.004565629000,
            2.004569329000,
            2.004573032000,
            2.004576738000,
            2.004580447000,
            2.004584159000,
            2.004587875000,
            2.004591593000,
            2.004595314000,
            2.004599038000,
            2.004602765000,
            2.004606495000,
            2.004610228000,
            2.004613964000,
            2.004617703000,
            2.004621446000,
            2.004625191000,
            2.004628939000,
            2.004632691000,
            2.004636445000,
            2.004640202000,
            2.004643963000,
            2.004647726000,
            2.004651493000,
            2.004655263000,
            2.004659035000,
            2.004662811000,
            2.004666590000,
            2.004670372000,
            2.004674156000,
            2.004677944000,
            2.004681735000,
            2.004685530000,
            2.004689327000,
            2.004693127000,
            2.004696930000,
            2.004700737000,
            2.004704546000,
            2.004708359000,
            2.004712175000,
            2.004715993000,
            2.004719815000,
            2.004723640000,
            2.004727468000,
            2.004731300000,
            2.004735134000,
            2.004738971000,
            2.004742812000,
            2.004746655000,
            2.004750502000,
            2.004754352000,
            2.004758205000,
            2.004762061000,
            2.004765920000,
            2.004769783000,
            2.004773648000,
            2.004777517000,
            2.004781388000,
            2.004785263000,
            2.004789141000,
            2.004793023000,
            2.004796907000,
            2.004800794000,
            2.004804685000,
            2.004808579000,
            2.004812476000,
            2.004816376000,
            2.004820279000,
            2.004824185000,
            2.004828095000,
            2.004832008000,
            2.004835923000,
            2.004839843000,
            2.004843765000,
            2.004847690000,
            2.004851619000,
            2.004855551000,
            2.004859486000,
            2.004863424000,
            2.004867365000,
            2.004871310000,
            2.004875257000,
            2.004879208000,
            2.004883163000,
            2.004887120000,
            2.004891081000,
            2.004895044000,
            2.004899011000,
            2.004902981000,
            2.004906955000,
            2.004910932000,
            2.004914911000,
            2.004918895000,
            2.004922881000,
            2.004926870000,
            2.004930863000,
            2.004934859000,
            2.004938858000,
            2.004942861000,
            2.004946867000,
            2.004950876000,
            2.004954888000,
            2.004958903000,
            2.004962922000,
            2.004966944000,
            2.004970969000,
            2.004974998000,
            2.004979030000,
            2.004983065000,
            2.004987103000,
            2.004991145000,
            2.004995190000,
            2.004999238000,
            2.005003289000,
            2.005007344000,
            2.005011402000,
            2.005015463000,
            2.005019528000,
            2.005023596000,
            2.005027667000,
            2.005031741000,
            2.005035819000,
            2.005039900000,
            2.005043984000,
            2.005048072000,
            2.005052163000,
            2.005056257000,
            2.005060355000,
            2.005064456000,
            2.005068560000,
            2.005072668000,
            2.005076779000,
            2.005080893000,
            2.005085011000,
            2.005089132000,
            2.005093256000,
            2.005097384000,
            2.005101515000,
            2.005105649000,
            2.005109786000,
            2.005113928000,
            2.005118072000,
            2.005122220000,
            2.005126371000,
            2.005130525000,
            2.005134683000,
            2.005138844000,
            2.005143009000,
            2.005147177000,
            2.005151348000,
            2.005155523000,
            2.005159701000,
            2.005163882000,
            2.005168067000,
            2.005172255000,
            2.005176447000,
            2.005180642000,
            2.005184840000,
            2.005189042000,
            2.005193248000,
            2.005197456000,
            2.005201668000,
            2.005205884000,
            2.005210103000,
            2.005214325000,
            2.005218551000,
            2.005222780000,
            2.005227012000,
            2.005231248000,
            2.005235488000,
            2.005239731000,
            2.005243977000,
            2.005248227000,
            2.005252480000,
            2.005256737000,
            2.005260997000,
            2.005265260000,
            2.005269527000,
            2.005273798000,
            2.005278072000,
            2.005282349000,
            2.005286630000,
            2.005290914000,
            2.005295202000,
            2.005299494000,
            2.005303788000,
            2.005308087000,
            2.005312388000,
            2.005316694000,
            2.005321002000,
            2.005325314000,
            2.005329630000,
            2.005333949000,
            2.005338272000,
            2.005342598000,
            2.005346928000,
            2.005351261000,
            2.005355598000,
            2.005359938000,
            2.005364282000,
            2.005368629000,
            2.005372980000,
            2.005377334000,
            2.005381692000,
            2.005386053000,
            2.005390418000,
            2.005394787000,
            2.005399159000,
            2.005403534000,
            2.005407913000,
            2.005412296000,
            2.005416682000,
            2.005421072000,
            2.005425465000,
            2.005429862000,
            2.005434262000,
            2.005438666000,
            2.005443074000,
            2.005447485000,
            2.005451900000,
            2.005456318000,
            2.005460740000,
            2.005465165000,
            2.005469594000,
            2.005474027000,
            2.005478463000,
            2.005482903000,
            2.005487346000,
            2.005491793000,
            2.005496244000,
            2.005500698000,
            2.005505156000,
            2.005509617000,
            2.005514082000,
            2.005518551000,
            2.005523023000,
            2.005527499000,
            2.005531979000,
            2.005536462000,
            2.005540949000,
            2.005545439000,
            2.005549933000,
            2.005554431000,
            2.005558932000,
            2.005563437000,
            2.005567946000,
            2.005572458000,
            2.005576974000,
            2.005581494000,
            2.005586017000,
            2.005590544000,
            2.005595075000,
            2.005599609000,
            2.005604147000,
            2.005608689000,
            2.005613234000,
            2.005617783000,
            2.005622336000,
            2.005626892000,
            2.005631452000,
            2.005636016000,
            2.005640583000,
            2.005645155000,
            2.005649729000,
            2.005654308000,
            2.005658890000,
            2.005663476000,
            2.005668066000,
            2.005672660000,
            2.005677257000,
            2.005681858000,
            2.005686462000,
            2.005691071000,
            2.005695683000,
            2.005700299000,
            2.005704918000,
            2.005709541000,
            2.005714169000,
            2.005718799000,
            2.005723434000,
            2.005728072000,
            2.005732714000,
            2.005737360000,
            2.005742010000,
            2.005746663000,
            2.005751320000,
            2.005755981000,
            2.005760646000,
            2.005765314000,
            2.005769987000,
            2.005774663000,
            2.005779343000,
            2.005784026000,
            2.005788714000,
            2.005793405000,
            2.005798100000,
            2.005802799000,
            2.005807501000,
            2.005812208000,
            2.005816918000,
            2.005821632000,
            2.005826350000,
            2.005831072000,
            2.005835797000,
            2.005840527000,
            2.005845260000,
            2.005849997000,
            2.005854738000,
            2.005859483000,
            2.005864231000,
            2.005868984000,
            2.005873740000,
            2.005878500000,
            2.005883264000,
            2.005888032000,
            2.005892804000,
            2.005897579000,
            2.005902359000,
            2.005907142000,
            2.005911929000,
            2.005916720000,
            2.005921515000,
            2.005926314000,
            2.005931117000,
            2.005935923000,
            2.005940734000,
            2.005945548000,
            2.005950367000,
            2.005955189000,
            2.005960015000,
            2.005964845000,
            2.005969679000,
            2.005974517000,
            2.005979359000,
            2.005984205000,
            2.005989054000,
            2.005993908000,
            2.005998765000,
            2.006003627000,
            2.006008492000,
            2.006013361000,
            2.006018235000,
            2.006023112000,
            2.006027993000,
            2.006032878000,
            2.006037767000,
            2.006042660000,
            2.006047557000,
            2.006052458000,
            2.006057363000,
            2.006062272000,
            2.006067185000,
            2.006072102000,
            2.006077023000,
            2.006081948000,
            2.006086877000,
            2.006091810000,
            2.006096747000,
            2.006101687000,
            2.006106632000,
            2.006111581000,
            2.006116534000,
            2.006121491000,
            2.006126452000,
            2.006131417000,
            2.006136386000,
            2.006141359000,
            2.006146336000,
            2.006151317000,
            2.006156302000,
            2.006161291000,
            2.006166284000,
            2.006171281000,
            2.006176283000,
            2.006181288000,
            2.006186297000,
            2.006191311000,
            2.006196328000,
            2.006201350000,
            2.006206375000,
            2.006211405000,
            2.006216439000,
            2.006221477000,
            2.006226519000,
            2.006231565000,
            2.006236615000,
            2.006241669000,
            2.006246727000,
            2.006251790000,
            2.006256856000,
            2.006261927000,
            2.006267002000,
            2.006272080000,
            2.006277163000,
            2.006282251000,
            2.006287342000,
            2.006292437000,
            2.006297536000,
            2.006302640000,
            2.006307748000,
            2.006312860000,
            2.006317976000,
            2.006323096000,
            2.006328220000,
            2.006333349000,
            2.006338481000,
            2.006343618000,
            2.006348759000,
            2.006353904000,
            2.006359053000,
            2.006364207000,
            2.006369364000,
            2.006374526000,
            2.006379692000,
            2.006384862000,
            2.006390036000,
            2.006395215000,
            2.006400398000,
            2.006405585000,
            2.006410776000,
            2.006415971000,
            2.006421171000,
            2.006426375000,
            2.006431583000,
            2.006436795000,
            2.006442011000,
            2.006447232000,
            2.006452457000,
            2.006457686000,
            2.006462919000,
            2.006468157000,
            2.006473399000,
            2.006478645000,
            2.006483895000,
            2.006489150000,
            2.006494409000,
            2.006499672000,
            2.006504939000,
            2.006510211000,
            2.006515487000,
            2.006520767000,
            2.006526051000,
            2.006531340000,
            2.006536633000,
            2.006541931000,
            2.006547232000,
            2.006552538000,
            2.006557848000,
            2.006563163000,
            2.006568482000,
            2.006573805000,
            2.006579132000,
            2.006584464000,
            2.006589800000,
            2.006595141000,
            2.006600486000,
            2.006605835000,
            2.006611188000,
            2.006616546000,
            2.006621908000,
            2.006627274000,
            2.006632645000,
            2.006638020000,
            2.006643400000,
            2.006648784000,
            2.006654172000,
            2.006659565000,
            2.006664962000,
            2.006670363000,
            2.006675769000,
            2.006681179000,
            2.006686593000,
            2.006692012000,
            2.006697435000,
            2.006702863000,
            2.006708295000,
            2.006713732000,
            2.006719172000,
            2.006724618000,
            2.006730067000,
            2.006735522000,
            2.006740980000,
            2.006746443000,
            2.006751910000,
            2.006757382000,
            2.006762858000,
            2.006768339000,
            2.006773824000,
            2.006779314000,
            2.006784808000,
            2.006790306000,
            2.006795809000,
            2.006801317000,
            2.006806828000,
            2.006812345000,
            2.006817866000,
            2.006823391000,
            2.006828921000,
            2.006834455000,
            2.006839994000,
            2.006845537000,
            2.006851084000,
            2.006856637000,
            2.006862193000,
            2.006867754000,
            2.006873320000,
            2.006878890000,
            2.006884465000,
            2.006890044000,
            2.006895628000,
            2.006901216000,
            2.006906809000,
            2.006912406000,
            2.006918008000,
            2.006923615000,
            2.006929226000,
            2.006934841000,
            2.006940461000,
            2.006946086000,
            2.006951715000,
            2.006957349000,
            2.006962987000,
            2.006968630000,
            2.006974277000,
            2.006979929000,
            2.006985586000,
            2.006991247000,
            2.006996913000,
            2.007002583000,
            2.007008258000,
            2.007013938000,
            2.007019622000,
            2.007025311000,
            2.007031004000,
            2.007036702000,
            2.007042405000,
            2.007048112000,
            2.007053824000,
            2.007059540000,
            2.007065261000,
            2.007070987000,
            2.007076718000,
            2.007082453000,
            2.007088192000,
            2.007093937000,
            2.007099686000,
            2.007105439000,
            2.007111198000,
            2.007116961000,
            2.007122728000,
            2.007128501000,
            2.007134278000,
            2.007140059000,
            2.007145846000,
            2.007151637000,
            2.007157432000,
            2.007163233000,
            2.007169038000,
            2.007174848000,
            2.007180662000,
            2.007186482000,
            2.007192306000,
            2.007198134000,
            2.007203968000,
            2.007209806000,
            2.007215649000,
            2.007221497000,
            2.007227349000,
            2.007233206000,
            2.007239068000,
            2.007244934000,
            2.007250806000,
            2.007256682000,
            2.007262563000,
            2.007268449000,
            2.007274339000,
            2.007280234000,
            2.007286134000,
            2.007292039000,
            2.007297948000,
            2.007303863000,
            2.007309782000,
            2.007315706000,
            2.007321634000,
            2.007327568000,
            2.007333506000,
            2.007339449000,
            2.007345397000,
            2.007351350000,
            2.007357308000,
            2.007363270000,
            2.007369237000,
            2.007375210000,
            2.007381186000,
            2.007387168000,
            2.007393155000,
            2.007399146000,
            2.007405143000,
            2.007411144000,
            2.007417150000,
            2.007423161000,
            2.007429177000,
            2.007435197000,
            2.007441223000,
            2.007447253000,
            2.007453289000,
            2.007459329000,
            2.007465374000,
            2.007471424000,
            2.007477479000,
            2.007483539000,
            2.007489603000,
            2.007495673000,
            2.007501748000,
            2.007507827000,
            2.007513912000,
            2.007520001000,
            2.007526095000,
            2.007532194000,
            2.007538299000,
            2.007544408000,
            2.007550522000,
            2.007556641000,
            2.007562765000,
            2.007568894000,
            2.007575028000,
            2.007581166000,
            2.007587310000,
            2.007593459000,
            2.007599613000,
            2.007605772000,
            2.007611935000,
            2.007618104000,
            2.007624278000,
            2.007630457000,
            2.007636641000,
            2.007642829000,
            2.007649023000,
            2.007655222000,
            2.007661426000,
            2.007667635000,
            2.007673849000,
            2.007680068000,
            2.007686292000,
            2.007692521000,
            2.007698755000,
            2.007704994000,
            2.007711238000,
            2.007717487000,
            2.007723742000,
            2.007730001000,
            2.007736266000,
            2.007742535000,
            2.007748810000,
            2.007755090000,
            2.007761374000,
            2.007767664000,
            2.007773959000,
            2.007780259000,
            2.007786564000,
            2.007792875000,
            2.007799190000,
            2.007805511000,
            2.007811836000,
            2.007818167000,
            2.007824503000,
            2.007830844000,
            2.007837190000,
            2.007843542000,
            2.007849898000,
            2.007856260000,
            2.007862627000,
            2.007868998000,
            2.007875376000,
            2.007881758000,
            2.007888145000,
            2.007894538000,
            2.007900936000,
            2.007907339000,
            2.007913747000,
            2.007920160000,
            2.007926579000,
            2.007933003000,
            2.007939432000,
            2.007945866000,
            2.007952305000,
            2.007958750000,
            2.007965200000,
            2.007971655000,
            2.007978115000,
            2.007984581000,
            2.007991051000,
            2.007997527000,
            2.008004009000,
            2.008010495000,
            2.008016987000,
            2.008023484000,
            2.008029986000,
            2.008036494000,
            2.008043007000,
            2.008049525000,
            2.008056048000,
            2.008062577000,
            2.008069111000,
            2.008075650000,
            2.008082195000,
            2.008088745000,
            2.008095300000,
            2.008101860000,
            2.008108426000,
            2.008114997000,
            2.008121574000,
            2.008128156000,
            2.008134743000,
            2.008141335000,
            2.008147933000,
            2.008154536000,
            2.008161145000,
            2.008167759000,
            2.008174378000,
            2.008181002000,
            2.008187632000,
            2.008194268000,
            2.008200908000,
            2.008207554000,
            2.008214206000,
            2.008220863000,
            2.008227525000,
            2.008234193000,
            2.008240866000,
            2.008247544000,
            2.008254228000,
            2.008260917000,
            2.008267612000,
            2.008274312000,
            2.008281018000,
            2.008287729000,
            2.008294445000,
            2.008301167000,
            2.008307895000,
            2.008314627000,
            2.008321366000,
            2.008328109000,
            2.008334859000,
            2.008341613000,
            2.008348373000,
            2.008355139000,
            2.008361910000,
            2.008368687000,
            2.008375469000,
            2.008382256000,
            2.008389049000,
            2.008395848000,
            2.008402652000,
            2.008409461000,
            2.008416277000,
            2.008423097000,
            2.008429923000,
            2.008436755000,
            2.008443592000,
            2.008450435000,
            2.008457283000,
            2.008464137000,
            2.008470997000,
            2.008477862000,
            2.008484732000,
            2.008491608000,
            2.008498490000,
            2.008505377000,
            2.008512270000,
            2.008519168000,
            2.008526072000,
            2.008532982000,
            2.008539897000,
            2.008546818000,
            2.008553745000,
            2.008560677000,
            2.008567614000,
            2.008574557000,
            2.008581506000,
            2.008588461000,
            2.008595421000,
            2.008602387000,
            2.008609358000,
            2.008616335000,
            2.008623318000,
            2.008630307000,
            2.008637301000,
            2.008644300000,
            2.008651306000,
            2.008658317000,
            2.008665334000,
            2.008672356000,
            2.008679384000,
            2.008686418000,
            2.008693458000,
            2.008700503000,
            2.008707554000,
            2.008714611000,
            2.008721673000,
            2.008728741000,
            2.008735815000,
            2.008742895000,
            2.008749980000,
            2.008757071000,
            2.008764168000,
            2.008771270000,
            2.008778379000,
            2.008785493000,
            2.008792613000,
            2.008799738000,
            2.008806870000,
            2.008814007000,
            2.008821150000,
            2.008828298000,
            2.008835453000,
            2.008842613000,
            2.008849779000,
            2.008856951000,
            2.008864129000,
            2.008871313000,
            2.008878502000,
            2.008885697000,
            2.008892898000,
            2.008900105000,
            2.008907318000,
            2.008914537000,
            2.008921761000,
            2.008928991000,
            2.008936227000,
            2.008943469000,
            2.008950717000,
            2.008957971000,
            2.008965231000,
            2.008972496000,
            2.008979768000,
            2.008987045000,
            2.008994328000,
            2.009001617000,
            2.009008912000,
            2.009016213000,
            2.009023520000,
            2.009030833000,
            2.009038151000,
            2.009045476000,
            2.009052806000,
            2.009060143000,
            2.009067485000,
            2.009074834000,
            2.009082188000,
            2.009089548000,
            2.009096915000,
            2.009104287000,
            2.009111665000,
            2.009119049000,
            2.009126439000,
            2.009133835000,
            2.009141238000,
            2.009148646000,
            2.009156060000,
            2.009163480000,
            2.009170906000,
            2.009178338000,
            2.009185777000,
            2.009193221000,
            2.009200671000,
            2.009208127000,
            2.009215590000,
            2.009223058000,
            2.009230533000,
            2.009238013000,
            2.009245500000,
            2.009252992000,
            2.009260491000,
            2.009267996000,
            2.009275507000,
            2.009283024000,
            2.009290547000,
            2.009298076000,
            2.009305611000,
            2.009313152000,
            2.009320700000,
            2.009328254000,
            2.009335813000,
            2.009343379000,
            2.009350951000,
            2.009358529000,
            2.009366113000,
            2.009373704000,
            2.009381300000,
            2.009388903000,
            2.009396512000,
            2.009404127000,
            2.009411748000,
            2.009419375000,
            2.009427009000,
            2.009434649000,
            2.009442295000,
            2.009449947000,
            2.009457605000,
            2.009465270000,
            2.009472940000,
            2.009480617000,
            2.009488300000,
            2.009495990000,
            2.009503686000,
            2.009511387000,
            2.009519095000,
            2.009526810000,
            2.009534530000,
            2.009542257000,
            2.009549990000,
            2.009557730000,
            2.009565476000,
            2.009573228000,
            2.009580986000,
            2.009588750000,
            2.009596521000,
            2.009604298000,
            2.009612082000,
            2.009619871000,
            2.009627667000,
            2.009635470000,
            2.009643278000,
            2.009651093000,
            2.009658915000,
            2.009666742000,
            2.009674576000,
            2.009682417000,
            2.009690263000,
            2.009698117000,
            2.009705976000,
            2.009713842000,
            2.009721714000,
            2.009729593000,
            2.009737478000,
            2.009745369000,
            2.009753267000,
            2.009761171000,
            2.009769081000,
            2.009776998000,
            2.009784922000,
            2.009792851000,
            2.009800788000,
            2.009808730000,
            2.009816679000,
            2.009824635000,
            2.009832597000,
            2.009840565000,
            2.009848540000,
            2.009856521000,
            2.009864509000,
            2.009872504000,
            2.009880504000,
            2.009888512000,
            2.009896525000,
            2.009904546000,
            2.009912572000,
            2.009920606000,
            2.009928645000,
            2.009936692000,
            2.009944744000,
            2.009952804000,
            2.009960870000,
            2.009968942000,
            2.009977021000,
            2.009985106000,
            2.009993198000,
            2.010001297000,
            2.010009402000,
            2.010017514000,
            2.010025632000,
            2.010033757000,
            2.010041888000,
            2.010050026000,
            2.010058171000,
            2.010066322000,
            2.010074480000,
            2.010082645000,
            2.010090816000,
            2.010098993000,
            2.010107178000,
            2.010115369000,
            2.010123566000,
            2.010131770000,
            2.010139981000,
            2.010148199000,
            2.010156423000,
            2.010164654000,
            2.010172891000,
            2.010181136000,
            2.010189386000,
            2.010197644000,
            2.010205908000,
            2.010214179000,
            2.010222457000,
            2.010230741000,
            2.010239032000,
            2.010247330000,
            2.010255635000,
            2.010263946000,
            2.010272264000,
            2.010280589000,
            2.010288920000,
            2.010297258000,
            2.010305603000,
            2.010313955000,
            2.010322314000,
            2.010330679000,
            2.010339051000,
            2.010347430000,
            2.010355816000,
            2.010364208000,
            2.010372607000,
            2.010381013000,
            2.010389426000,
            2.010397846000,
            2.010406272000,
            2.010414706000,
            2.010423146000,
            2.010431593000,
            2.010440047000,
            2.010448508000,
            2.010456975000,
            2.010465450000,
            2.010473931000,
            2.010482419000,
            2.010490914000,
            2.010499416000,
            2.010507925000,
            2.010516441000,
            2.010524963000,
            2.010533493000,
            2.010542029000,
            2.010550572000,
            2.010559123000,
            2.010567680000,
            2.010576244000,
            2.010584815000,
            2.010593393000,
            2.010601978000,
            2.010610570000,
            2.010619169000,
            2.010627775000,
            2.010636388000,
            2.010645008000,
            2.010653634000,
            2.010662268000,
            2.010670909000,
            2.010679557000,
            2.010688212000,
            2.010696873000,
            2.010705542000,
            2.010714218000,
            2.010722901000,
            2.010731591000,
            2.010740288000,
            2.010748992000,
            2.010757703000,
            2.010766421000,
            2.010775146000,
            2.010783879000,
            2.010792618000,
            2.010801365000,
            2.010810118000,
            2.010818879000,
            2.010827646000,
            2.010836421000,
            2.010845203000,
            2.010853992000,
            2.010862788000,
            2.010871592000,
            2.010880402000,
            2.010889220000,
            2.010898044000,
            2.010906876000,
            2.010915715000,
            2.010924562000,
            2.010933415000,
            2.010942275000,
            2.010951143000,
            2.010960018000,
            2.010968900000,
            2.010977789000,
            2.010986686000,
            2.010995590000,
            2.011004501000,
            2.011013419000,
            2.011022344000,
            2.011031277000,
            2.011040217000,
            2.011049164000,
            2.011058118000,
            2.011067080000,
            2.011076048000,
            2.011085025000,
            2.011094008000,
            2.011102999000,
            2.011111997000,
            2.011121002000,
            2.011130014000,
            2.011139034000,
            2.011148062000,
            2.011157096000,
            2.011166138000,
            2.011175187000,
            2.011184243000,
            2.011193307000,
            2.011202378000,
            2.011211457000,
            2.011220543000,
            2.011229636000,
            2.011238737000,
            2.011247845000,
            2.011256960000,
            2.011266083000,
            2.011275213000,
            2.011284350000,
            2.011293495000,
            2.011302648000,
            2.011311807000,
            2.011320975000,
            2.011330149000,
            2.011339331000,
            2.011348521000,
            2.011357718000,
            2.011366922000,
            2.011376134000,
            2.011385353000,
            2.011394580000,
            2.011403814000,
            2.011413056000,
            2.011422305000,
            2.011431562000,
            2.011440826000,
            2.011450098000,
            2.011459377000,
            2.011468664000,
            2.011477959000,
            2.011487260000,
            2.011496570000,
            2.011505887000,
            2.011515211000,
            2.011524543000,
            2.011533883000,
            2.011543230000,
            2.011552585000,
            2.011561947000,
            2.011571317000,
            2.011580694000,
            2.011590080000,
            2.011599472000,
            2.011608873000,
            2.011618280000,
            2.011627696000,
            2.011637119000,
            2.011646550000,
            2.011655989000,
            2.011665435000,
            2.011674888000,
            2.011684350000,
            2.011693819000,
            2.011703296000,
            2.011712780000,
            2.011722272000,
            2.011731772000,
            2.011741280000,
            2.011750795000,
            2.011760318000,
            2.011769849000,
            2.011779387000,
            2.011788933000,
            2.011798487000,
            2.011808049000,
            2.011817618000,
            2.011827195000,
            2.011836780000,
            2.011846373000,
            2.011855973000,
            2.011865581000,
            2.011875197000,
            2.011884821000,
            2.011894452000,
            2.011904092000,
            2.011913739000,
            2.011923394000,
            2.011933057000,
            2.011942727000,
            2.011952406000,
            2.011962092000,
            2.011971787000,
            2.011981489000,
            2.011991198000,
            2.012000916000,
            2.012010642000,
            2.012020375000,
            2.012030117000,
            2.012039866000,
            2.012049623000,
            2.012059389000,
            2.012069162000,
            2.012078943000,
            2.012088731000,
            2.012098528000,
            2.012108333000,
            2.012118146000,
            2.012127966000,
            2.012137795000,
            2.012147632000,
            2.012157476000,
            2.012167329000,
            2.012177189000,
            2.012187058000,
            2.012196934000,
            2.012206819000,
            2.012216711000,
            2.012226612000,
            2.012236520000,
            2.012246437000,
            2.012256361000,
            2.012266294000,
            2.012276235000,
            2.012286184000,
            2.012296140000,
            2.012306105000,
            2.012316078000,
            2.012326059000,
            2.012336049000,
            2.012346046000,
            2.012356051000,
            2.012366065000,
            2.012376086000,
            2.012386116000,
            2.012396154000,
            2.012406200000,
            2.012416254000,
            2.012426316000,
            2.012436386000,
            2.012446465000,
            2.012456552000,
            2.012466647000,
            2.012476750000,
            2.012486861000,
            2.012496980000,
            2.012507108000,
            2.012517244000,
            2.012527388000,
            2.012537540000,
            2.012547701000,
            2.012557870000,
            2.012568047000,
            2.012578232000,
            2.012588426000,
            2.012598627000,
            2.012608837000,
            2.012619056000,
            2.012629282000,
            2.012639517000,
            2.012649760000,
            2.012660012000,
            2.012670272000,
            2.012680540000,
            2.012690816000,
            2.012701101000,
            2.012711394000,
            2.012721695000,
            2.012732005000,
            2.012742323000,
            2.012752650000,
            2.012762985000,
            2.012773328000,
            2.012783680000,
            2.012794040000,
            2.012804408000,
            2.012814785000,
            2.012825170000,
            2.012835564000,
            2.012845966000,
            2.012856376000,
            2.012866795000,
            2.012877222000,
            2.012887658000,
            2.012898103000,
            2.012908555000,
            2.012919017000,
            2.012929486000,
            2.012939964000,
            2.012950451000,
            2.012960946000,
            2.012971450000,
            2.012981962000,
            2.012992483000,
            2.013003012000,
            2.013013550000,
            2.013024096000,
            2.013034651000,
            2.013045214000,
            2.013055786000,
            2.013066367000,
            2.013076956000,
            2.013087554000,
            2.013098160000,
            2.013108775000,
            2.013119398000,
            2.013130030000,
            2.013140671000,
            2.013151320000,
            2.013161978000,
            2.013172645000,
            2.013183320000,
            2.013194004000,
            2.013204696000,
            2.013215398000,
            2.013226108000,
            2.013236826000,
            2.013247553000,
            2.013258289000,
            2.013269034000,
            2.013279787000,
            2.013290549000,
            2.013301320000,
            2.013312100000,
            2.013322888000,
            2.013333685000,
            2.013344491000,
            2.013355305000,
            2.013366128000,
            2.013376960000,
            2.013387801000,
            2.013398651000,
            2.013409509000,
            2.013420376000,
            2.013431252000,
            2.013442137000,
            2.013453031000,
            2.013463933000,
            2.013474845000,
            2.013485765000,
            2.013496694000,
            2.013507632000,
            2.013518578000,
            2.013529534000,
            2.013540498000,
            2.013551472000,
            2.013562454000,
            2.013573445000,
            2.013584445000,
            2.013595454000,
            2.013606472000,
            2.013617499000,
            2.013628535000,
            2.013639579000,
            2.013650633000,
            2.013661695000,
            2.013672767000,
            2.013683848000,
            2.013694937000,
            2.013706036000,
            2.013717143000,
            2.013728260000,
            2.013739385000,
            2.013750520000,
            2.013761663000,
            2.013772816000,
            2.013783977000,
            2.013795148000,
            2.013806328000,
            2.013817516000,
            2.013828714000,
            2.013839921000,
            2.013851137000,
            2.013862362000,
            2.013873597000,
            2.013884840000,
            2.013896092000,
            2.013907354000,
            2.013918624000,
            2.013929904000,
            2.013941193000,
            2.013952491000,
            2.013963798000,
            2.013975115000,
            2.013986440000,
            2.013997775000,
            2.014009119000,
            2.014020472000,
            2.014031834000,
            2.014043206000,
            2.014054587000,
            2.014065977000,
            2.014077376000,
            2.014088784000,
            2.014100202000,
            2.014111629000,
            2.014123065000,
            2.014134511000,
            2.014145965000,
            2.014157429000,
            2.014168903000,
            2.014180385000,
            2.014191877000,
            2.014203378000,
            2.014214889000,
            2.014226409000,
            2.014237938000,
            2.014249477000,
            2.014261024000,
            2.014272582000,
            2.014284148000,
            2.014295724000,
            2.014307310000,
            2.014318905000,
            2.014330509000,
            2.014342122000,
            2.014353745000,
            2.014365378000,
            2.014377020000,
            2.014388671000,
            2.014400332000,
            2.014412002000,
            2.014423681000,
            2.014435370000,
            2.014447069000,
            2.014458777000,
            2.014470495000,
            2.014482222000,
            2.014493958000,
            2.014505704000,
            2.014517460000,
            2.014529225000,
            2.014540999000,
            2.014552784000,
            2.014564577000,
            2.014576380000,
            2.014588193000,
            2.014600016000,
            2.014611848000,
            2.014623689000,
            2.014635540000,
            2.014647401000,
            2.014659272000,
            2.014671152000,
            2.014683041000,
            2.014694941000,
            2.014706849000,
            2.014718768000,
            2.014730696000,
            2.014742634000,
            2.014754582000,
            2.014766539000,
            2.014778506000,
            2.014790483000,
            2.014802469000,
            2.014814465000,
            2.014826471000,
            2.014838486000,
            2.014850511000,
            2.014862546000,
            2.014874591000,
            2.014886646000,
            2.014898710000,
            2.014910784000,
            2.014922868000,
            2.014934962000,
            2.014947065000,
            2.014959178000,
            2.014971301000,
            2.014983434000,
            2.014995577000,
            2.015007729000,
            2.015019892000,
            2.015032064000,
            2.015044246000,
            2.015056438000,
            2.015068640000,
            2.015080852000,
            2.015093073000,
            2.015105305000,
            2.015117546000,
            2.015129798000,
            2.015142059000,
            2.015154330000,
            2.015166612000,
            2.015178903000,
            2.015191204000,
            2.015203515000,
            2.015215836000,
            2.015228167000,
            2.015240508000,
            2.015252859000,
            2.015265220000,
            2.015277591000,
            2.015289973000,
            2.015302364000,
            2.015314765000,
            2.015327176000,
            2.015339597000,
            2.015352029000,
            2.015364470000,
            2.015376922000,
            2.015389383000,
            2.015401855000,
            2.015414337000,
            2.015426829000,
            2.015439331000,
            2.015451843000,
            2.015464365000,
            2.015476898000,
            2.015489440000,
            2.015501993000,
            2.015514556000,
            2.015527129000,
            2.015539712000,
            2.015552306000,
            2.015564910000,
            2.015577524000,
            2.015590148000,
            2.015602782000,
            2.015615427000,
            2.015628082000,
            2.015640747000,
            2.015653422000,
            2.015666108000,
            2.015678804000,
            2.015691510000,
            2.015704227000,
            2.015716954000,
            2.015729691000,
            2.015742438000,
            2.015755196000,
            2.015767964000,
            2.015780743000,
            2.015793532000,
            2.015806331000,
            2.015819140000,
            2.015831960000,
            2.015844791000,
            2.015857632000,
            2.015870483000,
            2.015883344000,
            2.015896216000,
            2.015909099000,
            2.015921992000,
            2.015934895000,
            2.015947809000,
            2.015960733000,
            2.015973668000,
            2.015986613000,
            2.015999569000,
            2.016012535000,
            2.016025512000,
            2.016038499000,
            2.016051496000,
            2.016064505000,
            2.016077524000,
            2.016090553000,
            2.016103593000,
            2.016116643000,
            2.016129704000,
            2.016142776000,
            2.016155858000,
            2.016168951000,
            2.016182055000,
            2.016195169000,
            2.016208294000,
            2.016221429000,
            2.016234575000,
            2.016247731000,
            2.016260899000,
            2.016274077000,
            2.016287265000,
            2.016300465000,
            2.016313675000,
            2.016326896000,
            2.016340127000,
            2.016353369000,
            2.016366622000,
            2.016379886000,
            2.016393160000,
            2.016406445000,
            2.016419741000,
            2.016433048000,
            2.016446366000,
            2.016459694000,
            2.016473033000,
            2.016486383000,
            2.016499744000,
            2.016513115000,
            2.016526497000,
            2.016539891000,
            2.016553295000,
            2.016566710000,
            2.016580136000,
            2.016593572000,
            2.016607020000,
            2.016620478000,
            2.016633948000,
            2.016647428000,
            2.016660919000,
            2.016674421000,
            2.016687934000,
            2.016701459000,
            2.016714994000,
            2.016728540000,
            2.016742096000,
            2.016755664000,
            2.016769243000,
            2.016782833000,
            2.016796434000,
            2.016810046000,
            2.016823669000,
            2.016837303000,
            2.016850948000,
            2.016864605000,
            2.016878272000,
            2.016891950000,
            2.016905640000,
            2.016919340000,
            2.016933052000,
            2.016946774000,
            2.016960508000,
            2.016974253000,
            2.016988009000,
            2.017001776000,
            2.017015555000,
            2.017029344000,
            2.017043145000,
            2.017056957000,
            2.017070780000,
            2.017084614000,
            2.017098460000,
            2.017112317000,
            2.017126185000,
            2.017140064000,
            2.017153954000,
            2.017167856000,
            2.017181769000,
            2.017195693000,
            2.017209629000,
            2.017223576000,
            2.017237534000,
            2.017251503000,
            2.017265484000,
            2.017279476000,
            2.017293480000,
            2.017307495000,
            2.017321521000,
            2.017335558000,
            2.017349607000,
            2.017363667000,
            2.017377739000,
            2.017391822000,
            2.017405917000,
            2.017420023000,
            2.017434140000,
            2.017448269000,
            2.017462409000,
            2.017476561000,
            2.017490724000,
            2.017504898000,
            2.017519085000,
            2.017533282000,
            2.017547491000,
            2.017561712000,
            2.017575944000,
            2.017590188000,
            2.017604443000,
            2.017618710000,
            2.017632988000,
            2.017647278000,
            2.017661580000,
            2.017675893000,
            2.017690218000,
            2.017704554000,
            2.017718902000,
            2.017733261000,
            2.017747633000,
            2.017762015000,
            2.017776410000,
            2.017790816000,
            2.017805234000,
            2.017819663000,
            2.017834105000,
            2.017848558000,
            2.017863022000,
            2.017877499000,
            2.017891987000,
            2.017906486000,
            2.017920998000,
            2.017935521000,
            2.017950057000,
            2.017964603000,
            2.017979162000,
            2.017993733000,
            2.018008315000,
            2.018022909000,
            2.018037515000,
            2.018052133000,
            2.018066762000,
            2.018081404000,
            2.018096057000,
            2.018110722000,
            2.018125399000,
            2.018140088000,
            2.018154789000,
            2.018169502000,
            2.018184227000,
            2.018198963000,
            2.018213712000,
            2.018228473000,
            2.018243245000,
            2.018258030000,
            2.018272826000,
            2.018287635000,
            2.018302455000,
            2.018317288000,
            2.018332132000,
            2.018346989000,
            2.018361857000,
            2.018376738000,
            2.018391630000,
            2.018406535000,
            2.018421452000,
            2.018436381000,
            2.018451322000,
            2.018466275000,
            2.018481240000,
            2.018496218000,
            2.018511207000,
            2.018526209000,
            2.018541223000,
            2.018556249000,
            2.018571287000,
            2.018586337000,
            2.018601400000,
            2.018616474000,
            2.018631561000,
            2.018646661000,
            2.018661772000,
            2.018676896000,
            2.018692032000,
            2.018707180000,
            2.018722340000,
            2.018737513000,
            2.018752698000,
            2.018767895000,
            2.018783105000,
            2.018798327000,
            2.018813561000,
            2.018828808000,
            2.018844067000,
            2.018859339000,
            2.018874622000,
            2.018889918000,
            2.018905227000,
            2.018920548000,
            2.018935881000,
            2.018951227000,
            2.018966585000,
            2.018981956000,
            2.018997339000,
            2.019012735000,
            2.019028143000,
            2.019043564000,
            2.019058997000,
            2.019074442000,
            2.019089900000,
            2.019105371000,
            2.019120854000,
            2.019136350000,
            2.019151858000,
            2.019167379000,
            2.019182912000,
            2.019198458000,
            2.019214017000,
            2.019229588000,
            2.019245172000,
            2.019260769000,
            2.019276378000,
            2.019291999000,
            2.019307634000,
            2.019323281000,
            2.019338941000,
            2.019354613000,
            2.019370298000,
            2.019385996000,
            2.019401707000,
            2.019417430000,
            2.019433166000,
            2.019448915000,
            2.019464677000,
            2.019480451000,
            2.019496238000,
            2.019512038000,
            2.019527851000,
            2.019543676000,
            2.019559515000,
            2.019575366000,
            2.019591230000,
            2.019607107000,
            2.019622997000,
            2.019638899000,
            2.019654815000,
            2.019670743000,
            2.019686685000,
            2.019702639000,
            2.019718606000,
            2.019734586000,
            2.019750579000,
            2.019766585000,
            2.019782604000,
            2.019798636000,
            2.019814681000,
            2.019830739000,
            2.019846810000,
            2.019862894000,
            2.019878991000,
            2.019895102000,
            2.019911225000,
            2.019927361000,
            2.019943510000,
            2.019959673000,
            2.019975848000,
            2.019992037000,
            2.020008239000,
            2.020024453000,
            2.020040681000,
            2.020056923000,
            2.020073177000,
            2.020089444000,
            2.020105725000,
            2.020122019000,
            2.020138326000,
            2.020154646000,
            2.020170980000,
            2.020187327000,
            2.020203687000,
            2.020220060000,
            2.020236446000,
            2.020252846000,
            2.020269259000,
            2.020285686000,
            2.020302125000,
            2.020318578000,
            2.020335045000,
            2.020351524000,
            2.020368017000,
            2.020384524000,
            2.020401044000,
            2.020417577000,
            2.020434124000,
            2.020450684000,
            2.020467257000,
            2.020483844000,
            2.020500444000,
            2.020517058000,
            2.020533685000,
            2.020550326000,
            2.020566980000,
            2.020583648000,
            2.020600329000,
            2.020617023000,
            2.020633732000,
            2.020650453000,
            2.020667189000,
            2.020683938000,
            2.020700700000,
            2.020717476000,
            2.020734266000,
            2.020751069000,
            2.020767886000,
            2.020784716000,
            2.020801560000,
            2.020818418000,
            2.020835290000,
            2.020852175000,
            2.020869074000,
            2.020885986000,
            2.020902912000,
            2.020919852000,
            2.020936806000,
            2.020953773000,
            2.020970754000,
            2.020987749000,
            2.021004758000,
            2.021021780000,
            2.021038817000,
            2.021055867000,
            2.021072931000,
            2.021090008000,
            2.021107100000,
            2.021124205000,
            2.021141324000,
            2.021158458000,
            2.021175605000,
            2.021192765000,
            2.021209940000,
            2.021227129000,
            2.021244332000,
            2.021261548000,
            2.021278779000,
            2.021296023000,
            2.021313282000,
            2.021330554000,
            2.021347841000,
            2.021365141000,
            2.021382456000,
            2.021399784000,
            2.021417127000,
            2.021434483000,
            2.021451854000,
            2.021469239000,
            2.021486638000,
            2.021504051000,
            2.021521478000,
            2.021538919000,
            2.021556374000,
            2.021573844000,
            2.021591328000,
            2.021608825000,
            2.021626337000,
            2.021643864000,
            2.021661404000,
            2.021678959000,
            2.021696527000,
            2.021714110000,
            2.021731708000,
            2.021749319000,
            2.021766945000,
            2.021784585000,
            2.021802240000,
            2.021819908000,
            2.021837592000,
            2.021855289000,
            2.021873001000,
            2.021890727000,
            2.021908467000,
            2.021926222000,
            2.021943991000,
            2.021961775000,
            2.021979573000,
            2.021997385000,
            2.022015212000,
            2.022033054000,
            2.022050909000,
            2.022068780000,
            2.022086664000,
            2.022104564000,
            2.022122477000,
            2.022140406000,
            2.022158348000,
            2.022176306000,
            2.022194278000,
            2.022212264000,
            2.022230265000,
            2.022248281000,
            2.022266311000,
            2.022284356000,
            2.022302415000,
            2.022320489000,
            2.022338578000,
            2.022356681000,
            2.022374799000,
            2.022392932000,
            2.022411080000,
            2.022429242000,
            2.022447419000,
            2.022465610000,
            2.022483816000,
            2.022502038000,
            2.022520273000,
            2.022538524000,
            2.022556789000,
            2.022575070000,
            2.022593365000,
            2.022611675000,
            2.022629999000,
            2.022648339000,
            2.022666693000,
            2.022685063000,
            2.022703447000,
            2.022721846000,
            2.022740260000,
            2.022758689000,
            2.022777133000,
            2.022795591000,
            2.022814065000,
            2.022832554000,
            2.022851058000,
            2.022869576000,
            2.022888110000,
            2.022906659000,
            2.022925223000,
            2.022943801000,
            2.022962395000,
            2.022981004000,
            2.022999628000,
            2.023018267000,
            2.023036922000,
            2.023055591000,
            2.023074275000,
            2.023092975000,
            2.023111690000,
            2.023130420000,
            2.023149165000,
            2.023167925000,
            2.023186701000,
            2.023205491000,
            2.023224297000,
            2.023243118000,
            2.023261955000,
            2.023280807000,
            2.023299673000,
            2.023318556000,
            2.023337453000,
            2.023356366000,
            2.023375294000,
            2.023394238000,
            2.023413197000,
            2.023432171000,
            2.023451161000,
            2.023470166000,
            2.023489186000,
            2.023508222000,
            2.023527273000,
            2.023546340000,
            2.023565422000,
            2.023584520000,
            2.023603633000,
            2.023622762000,
            2.023641906000,
            2.023661065000,
            2.023680241000,
            2.023699431000,
            2.023718637000,
            2.023737859000,
            2.023757097000,
            2.023776350000,
            2.023795618000,
            2.023814902000,
            2.023834202000,
            2.023853518000,
            2.023872849000,
            2.023892196000,
            2.023911558000,
            2.023930936000,
            2.023950330000,
            2.023969740000,
            2.023989165000,
            2.024008606000,
            2.024028063000,
            2.024047535000,
            2.024067024000,
            2.024086528000,
            2.024106048000,
            2.024125583000,
            2.024145135000,
            2.024164702000,
            2.024184286000,
            2.024203885000,
            2.024223500000,
            2.024243131000,
            2.024262778000,
            2.024282441000,
            2.024302119000,
            2.024321814000,
            2.024341525000,
            2.024361251000,
            2.024380994000,
            2.024400752000,
            2.024420527000,
            2.024440318000,
            2.024460124000,
            2.024479947000,
            2.024499786000,
            2.024519641000,
            2.024539511000,
            2.024559399000,
            2.024579302000,
            2.024599221000,
            2.024619156000,
            2.024639108000,
            2.024659076000,
            2.024679060000,
            2.024699060000,
            2.024719076000,
            2.024739109000,
            2.024759158000,
            2.024779223000,
            2.024799304000,
            2.024819402000,
            2.024839515000,
            2.024859646000,
            2.024879792000,
            2.024899955000,
            2.024920134000,
            2.024940330000,
            2.024960541000,
            2.024980770000,
            2.025001014000,
            2.025021275000,
            2.025041553000,
            2.025061847000,
            2.025082157000,
            2.025102484000,
            2.025122827000,
            2.025143187000,
            2.025163563000,
            2.025183956000,
            2.025204365000,
            2.025224791000,
            2.025245234000,
            2.025265693000,
            2.025286168000,
            2.025306660000,
            2.025327169000,
            2.025347694000,
            2.025368236000,
            2.025388795000,
            2.025409370000,
            2.025429962000,
            2.025450571000,
            2.025471196000,
            2.025491838000,
            2.025512497000,
            2.025533173000,
            2.025553865000,
            2.025574574000,
            2.025595300000,
            2.025616043000,
            2.025636802000,
            2.025657579000,
            2.025678372000,
            2.025699182000,
            2.025720009000,
            2.025740852000,
            2.025761713000,
            2.025782590000,
            2.025803485000,
            2.025824396000,
            2.025845325000,
            2.025866270000,
            2.025887232000,
            2.025908211000,
            2.025929208000,
            2.025950221000,
            2.025971251000,
            2.025992299000,
            2.026013363000,
            2.026034444000,
            2.026055543000,
            2.026076659000,
            2.026097791000,
            2.026118941000,
            2.026140108000,
            2.026161292000,
            2.026182494000,
            2.026203712000,
            2.026224948000,
            2.026246201000,
            2.026267471000,
            2.026288759000,
            2.026310063000,
            2.026331385000,
            2.026352724000,
            2.026374081000,
            2.026395455000,
            2.026416846000,
            2.026438254000,
            2.026459680000,
            2.026481123000,
            2.026502584000,
            2.026524062000,
            2.026545557000,
            2.026567070000,
            2.026588600000,
            2.026610148000,
            2.026631713000,
            2.026653295000,
            2.026674895000,
            2.026696513000,
            2.026718148000,
            2.026739801000,
            2.026761471000,
            2.026783159000,
            2.026804864000,
            2.026826587000,
            2.026848327000,
            2.026870086000,
            2.026891861000,
            2.026913655000,
            2.026935466000,
            2.026957295000,
            2.026979141000,
            2.027001005000,
            2.027022887000,
            2.027044787000,
            2.027066704000,
            2.027088639000,
            2.027110592000,
            2.027132563000,
            2.027154551000,
            2.027176557000,
            2.027198581000,
            2.027220623000,
            2.027242683000,
            2.027264761000,
            2.027286857000,
            2.027308970000,
            2.027331102000,
            2.027353251000,
            2.027375418000,
            2.027397604000,
            2.027419807000,
            2.027442028000,
            2.027464267000,
            2.027486525000,
            2.027508800000,
            2.027531093000,
            2.027553405000,
            2.027575734000,
            2.027598082000,
            2.027620448000,
            2.027642832000,
            2.027665234000,
            2.027687654000,
            2.027710092000,
            2.027732549000,
            2.027755023000,
            2.027777516000,
            2.027800027000,
            2.027822557000,
            2.027845104000,
            2.027867670000,
            2.027890255000,
            2.027912857000,
            2.027935478000,
            2.027958117000,
            2.027980775000,
            2.028003451000,
            2.028026145000,
            2.028048857000,
            2.028071588000,
            2.028094338000,
            2.028117106000,
            2.028139892000,
            2.028162697000,
            2.028185520000,
            2.028208362000,
            2.028231222000,
            2.028254101000,
            2.028276999000,
            2.028299915000,
            2.028322849000,
            2.028345802000,
            2.028368774000,
            2.028391764000,
            2.028414773000,
            2.028437801000,
            2.028460847000,
            2.028483912000,
            2.028506996000,
            2.028530098000,
            2.028553219000,
            2.028576359000,
            2.028599517000,
            2.028622695000,
            2.028645891000,
            2.028669106000,
            2.028692339000,
            2.028715592000,
            2.028738863000,
            2.028762154000,
            2.028785463000,
            2.028808791000,
            2.028832138000,
            2.028855503000,
            2.028878888000,
            2.028902292000,
            2.028925715000,
            2.028949156000,
            2.028972617000,
            2.028996097000,
            2.029019595000,
            2.029043113000,
            2.029066650000,
            2.029090206000,
            2.029113781000,
            2.029137375000,
            2.029160988000,
            2.029184620000,
            2.029208272000,
            2.029231942000,
            2.029255632000,
            2.029279341000,
            2.029303070000,
            2.029326817000,
            2.029350584000,
            2.029374370000,
            2.029398175000,
            2.029422000000,
            2.029445843000,
            2.029469707000,
            2.029493589000,
            2.029517491000,
            2.029541412000,
            2.029565353000,
            2.029589313000,
            2.029613292000,
            2.029637291000,
            2.029661310000,
            2.029685347000,
            2.029709405000,
            2.029733481000,
            2.029757578000,
            2.029781694000,
            2.029805829000,
            2.029829984000,
            2.029854158000,
            2.029878352000,
            2.029902566000,
            2.029926799000,
            2.029951052000,
            2.029975325000,
            2.029999617000,
            2.030023929000,
            2.030048261000,
            2.030072612000,
            2.030096983000,
            2.030121374000,
            2.030145785000,
            2.030170215000,
            2.030194666000,
            2.030219136000,
            2.030243625000,
            2.030268135000,
            2.030292665000,
            2.030317214000,
            2.030341784000,
            2.030366373000,
            2.030390982000,
            2.030415611000,
            2.030440260000,
            2.030464929000,
            2.030489618000,
            2.030514327000,
            2.030539056000,
            2.030563806000,
            2.030588575000,
            2.030613364000,
            2.030638173000,
            2.030663003000,
            2.030687852000,
            2.030712722000,
            2.030737612000,
            2.030762522000,
            2.030787452000,
            2.030812403000,
            2.030837373000,
            2.030862364000,
            2.030887375000,
            2.030912407000,
            2.030937459000,
            2.030962531000,
            2.030987623000,
            2.031012736000,
            2.031037869000,
            2.031063022000,
            2.031088196000,
            2.031113390000,
            2.031138604000,
            2.031163839000,
            2.031189095000,
            2.031214371000,
            2.031239667000,
            2.031264984000,
            2.031290322000,
            2.031315680000,
            2.031341058000,
            2.031366457000,
            2.031391877000,
            2.031417317000,
            2.031442778000,
            2.031468259000,
            2.031493762000,
            2.031519284000,
            2.031544828000,
            2.031570392000,
            2.031595977000,
            2.031621583000,
            2.031647209000,
            2.031672856000,
            2.031698524000,
            2.031724213000,
            2.031749923000,
            2.031775653000,
            2.031801404000,
            2.031827177000,
            2.031852970000,
            2.031878784000,
            2.031904618000,
            2.031930474000,
            2.031956351000,
            2.031982249000,
            2.032008167000,
            2.032034107000,
            2.032060068000,
            2.032086050000,
            2.032112052000,
            2.032138076000,
            2.032164121000,
            2.032190187000,
            2.032216275000,
            2.032242383000,
            2.032268513000,
            2.032294663000,
            2.032320835000,
            2.032347028000,
            2.032373243000,
            2.032399478000,
            2.032425735000,
            2.032452013000,
            2.032478313000,
            2.032504633000,
            2.032530975000,
            2.032557339000,
            2.032583724000,
            2.032610130000,
            2.032636557000,
            2.032663006000,
            2.032689477000,
            2.032715968000,
            2.032742482000,
            2.032769017000,
            2.032795573000,
            2.032822151000,
            2.032848750000,
            2.032875371000,
            2.032902014000,
            2.032928678000,
            2.032955363000,
            2.032982071000,
            2.033008800000,
            2.033035550000,
            2.033062323000,
            2.033089117000,
            2.033115932000,
            2.033142770000,
            2.033169629000,
            2.033196510000,
            2.033223413000,
            2.033250337000,
            2.033277284000,
            2.033304252000,
            2.033331242000,
            2.033358254000,
            2.033385288000,
            2.033412343000,
            2.033439421000,
            2.033466521000,
            2.033493642000,
            2.033520786000,
            2.033547951000,
            2.033575139000,
            2.033602349000,
            2.033629580000,
            2.033656834000,
            2.033684110000,
            2.033711408000,
            2.033738728000,
            2.033766070000,
            2.033793434000,
            2.033820821000,
            2.033848229000,
            2.033875660000,
            2.033903114000,
            2.033930589000,
            2.033958087000,
            2.033985607000,
            2.034013149000,
            2.034040713000,
            2.034068300000,
            2.034095910000,
            2.034123541000,
            2.034151195000,
            2.034178872000,
            2.034206570000,
            2.034234292000,
            2.034262036000,
            2.034289802000,
            2.034317591000,
            2.034345402000,
            2.034373236000,
            2.034401092000,
            2.034428971000,
            2.034456873000,
            2.034484797000,
            2.034512744000,
            2.034540713000,
            2.034568705000,
            2.034596720000,
            2.034624757000,
            2.034652818000,
            2.034680901000,
            2.034709006000,
            2.034737135000,
            2.034765286000,
            2.034793460000,
            2.034821657000,
            2.034849877000,
            2.034878120000,
            2.034906385000,
            2.034934674000,
            2.034962985000,
            2.034991319000,
            2.035019677000,
            2.035048057000,
            2.035076460000,
            2.035104887000,
            2.035133336000,
            2.035161808000,
            2.035190304000,
            2.035218822000,
            2.035247364000,
            2.035275929000,
            2.035304517000,
            2.035333128000,
            2.035361762000,
            2.035390419000,
            2.035419100000,
            2.035447804000,
            2.035476531000,
            2.035505282000,
            2.035534056000,
            2.035562853000,
            2.035591673000,
            2.035620517000,
            2.035649384000,
            2.035678275000,
            2.035707189000,
            2.035736126000,
            2.035765087000,
            2.035794072000,
            2.035823079000,
            2.035852111000,
            2.035881166000,
            2.035910244000,
            2.035939346000,
            2.035968472000,
            2.035997621000,
            2.036026794000,
            2.036055990000,
            2.036085210000,
            2.036114454000,
            2.036143721000,
            2.036173013000,
            2.036202328000,
            2.036231666000,
            2.036261029000,
            2.036290415000,
            2.036319825000,
            2.036349259000,
            2.036378717000,
            2.036408199000,
            2.036437704000,
            2.036467233000,
            2.036496787000,
            2.036526364000,
            2.036555966000,
            2.036585591000,
            2.036615240000,
            2.036644913000,
            2.036674611000,
            2.036704332000,
            2.036734078000,
            2.036763847000,
            2.036793641000,
            2.036823459000,
            2.036853301000,
            2.036883167000,
            2.036913058000,
            2.036942973000,
            2.036972911000,
            2.037002875000,
            2.037032862000,
            2.037062874000,
            2.037092910000,
            2.037122970000,
            2.037153055000,
            2.037183164000,
            2.037213298000,
            2.037243456000,
            2.037273638000,
            2.037303845000,
            2.037334077000,
            2.037364333000,
            2.037394613000,
            2.037424918000,
            2.037455247000,
            2.037485601000,
            2.037515980000,
            2.037546383000,
            2.037576811000,
            2.037607264000,
            2.037637741000,
            2.037668243000,
            2.037698770000,
            2.037729321000,
            2.037759898000,
            2.037790499000,
            2.037821124000,
            2.037851775000,
            2.037882450000,
            2.037913151000,
            2.037943876000,
            2.037974626000,
            2.038005401000,
            2.038036201000,
            2.038067026000,
            2.038097875000,
            2.038128750000,
            2.038159650000,
            2.038190575000,
            2.038221525000,
            2.038252500000,
            2.038283500000,
            2.038314526000,
            2.038345576000,
            2.038376652000,
            2.038407753000,
            2.038438879000,
            2.038470030000,
            2.038501206000,
            2.038532408000,
            2.038563635000,
            2.038594887000,
            2.038626165000,
            2.038657468000,
            2.038688796000,
            2.038720150000,
            2.038751529000,
            2.038782934000,
            2.038814364000,
            2.038845819000,
            2.038877300000,
            2.038908807000,
            2.038940339000,
            2.038971897000,
            2.039003480000,
            2.039035089000,
            2.039066723000,
            2.039098383000,
            2.039130069000,
            2.039161780000,
            2.039193517000,
            2.039225280000,
            2.039257068000,
            2.039288883000,
            2.039320723000,
            2.039352589000,
            2.039384480000,
            2.039416398000,
            2.039448341000,
            2.039480311000,
            2.039512306000,
            2.039544327000,
            2.039576374000,
            2.039608447000,
            2.039640546000,
            2.039672671000,
            2.039704822000,
            2.039737000000,
            2.039769203000,
            2.039801432000,
            2.039833688000,
            2.039865969000,
            2.039898277000,
            2.039930611000,
            2.039962971000,
            2.039995357000,
            2.040027770000,
            2.040060209000,
            2.040092674000,
            2.040125165000,
            2.040157683000,
            2.040190227000,
            2.040222798000,
            2.040255395000,
            2.040288018000,
            2.040320668000,
            2.040353344000,
            2.040386047000,
            2.040418776000,
            2.040451532000,
            2.040484314000,
            2.040517123000,
            2.040549958000,
            2.040582821000,
            2.040615709000,
            2.040648625000,
            2.040681567000,
            2.040714535000,
            2.040747531000,
            2.040780553000,
            2.040813602000,
            2.040846678000,
            2.040879780000,
            2.040912909000,
            2.040946066000,
            2.040979249000,
            2.041012459000,
            2.041045696000,
            2.041078959000,
            2.041112250000,
            2.041145568000,
            2.041178913000,
            2.041212284000,
            2.041245683000,
            2.041279109000,
            2.041312562000,
            2.041346042000,
            2.041379549000,
            2.041413084000,
            2.041446645000,
            2.041480234000,
            2.041513850000,
            2.041547493000,
            2.041581164000,
            2.041614861000,
            2.041648586000,
            2.041682339000,
            2.041716119000,
            2.041749926000,
            2.041783760000,
            2.041817622000,
            2.041851512000,
            2.041885428000,
            2.041919373000,
            2.041953345000,
            2.041987344000,
            2.042021371000,
            2.042055425000,
            2.042089508000,
            2.042123617000,
            2.042157755000,
            2.042191920000,
            2.042226112000,
            2.042260333000,
            2.042294581000,
            2.042328857000,
            2.042363161000,
            2.042397492000,
            2.042431851000,
            2.042466239000,
            2.042500654000,
            2.042535097000,
            2.042569567000,
            2.042604066000,
            2.042638593000,
            2.042673148000,
            2.042707730000,
            2.042742341000,
            2.042776980000,
            2.042811647000,
            2.042846342000,
            2.042881065000,
            2.042915816000,
            2.042950595000,
            2.042985403000,
            2.043020239000,
            2.043055103000,
            2.043089995000,
            2.043124915000,
            2.043159864000,
            2.043194841000,
            2.043229847000,
            2.043264881000,
            2.043299943000,
            2.043335034000,
            2.043370153000,
            2.043405300000,
            2.043440476000,
            2.043475681000,
            2.043510914000,
            2.043546176000,
            2.043581466000,
            2.043616785000,
            2.043652132000,
            2.043687508000,
            2.043722913000,
            2.043758346000,
            2.043793809000,
            2.043829300000,
            2.043864819000,
            2.043900368000,
            2.043935945000,
            2.043971551000,
            2.044007186000,
            2.044042850000,
            2.044078543000,
            2.044114264000,
            2.044150015000,
            2.044185794000,
            2.044221603000,
            2.044257441000,
            2.044293307000,
            2.044329203000,
            2.044365128000,
            2.044401082000,
            2.044437065000,
            2.044473077000,
            2.044509118000,
            2.044545189000,
            2.044581289000,
            2.044617418000,
            2.044653576000,
            2.044689764000,
            2.044725981000,
            2.044762227000,
            2.044798503000,
            2.044834808000,
            2.044871143000,
            2.044907507000,
            2.044943900000,
            2.044980323000,
            2.045016775000,
            2.045053257000,
            2.045089769000,
            2.045126310000,
            2.045162881000,
            2.045199481000,
            2.045236111000,
            2.045272771000,
            2.045309461000,
            2.045346180000,
            2.045382929000,
            2.045419708000,
            2.045456516000,
            2.045493354000,
            2.045530223000,
            2.045567121000,
            2.045604049000,
            2.045641007000,
            2.045677995000,
            2.045715013000,
            2.045752060000,
            2.045789138000,
            2.045826246000,
            2.045863384000,
            2.045900552000,
            2.045937751000,
            2.045974979000,
            2.046012238000,
            2.046049526000,
            2.046086845000,
            2.046124194000,
            2.046161574000,
            2.046198984000,
            2.046236424000,
            2.046273894000,
            2.046311395000,
            2.046348926000,
            2.046386488000,
            2.046424080000,
            2.046461702000,
            2.046499355000,
            2.046537039000,
            2.046574753000,
            2.046612497000,
            2.046650273000,
            2.046688078000,
            2.046725915000,
            2.046763782000,
            2.046801680000,
            2.046839608000,
            2.046877568000,
            2.046915558000,
            2.046953578000,
            2.046991630000,
            2.047029712000,
            2.047067826000,
            2.047105970000,
            2.047144145000,
            2.047182351000,
            2.047220588000,
            2.047258856000,
            2.047297155000,
            2.047335485000,
            2.047373846000,
            2.047412238000,
            2.047450662000,
            2.047489116000,
            2.047527602000,
            2.047566119000,
            2.047604667000,
            2.047643246000,
            2.047681856000,
            2.047720498000,
            2.047759171000,
            2.047797876000,
            2.047836612000,
            2.047875379000,
            2.047914178000,
            2.047953008000,
            2.047991869000,
            2.048030762000,
            2.048069687000,
            2.048108643000,
            2.048147631000,
            2.048186650000,
            2.048225701000,
            2.048264783000,
            2.048303898000,
            2.048343044000,
            2.048382221000,
            2.048421431000,
            2.048460672000,
            2.048499945000,
            2.048539250000,
            2.048578586000,
            2.048617955000,
            2.048657355000,
            2.048696788000,
            2.048736252000,
            2.048775748000,
            2.048815277000,
            2.048854837000,
            2.048894429000,
            2.048934054000,
            2.048973710000,
            2.049013399000,
            2.049053120000,
            2.049092873000,
            2.049132658000,
            2.049172476000,
            2.049212326000,
            2.049252208000,
            2.049292122000,
            2.049332069000,
            2.049372048000,
            2.049412060000,
            2.049452104000,
            2.049492180000,
            2.049532289000,
            2.049572431000,
            2.049612605000,
            2.049652811000,
            2.049693050000,
            2.049733322000,
            2.049773626000,
            2.049813963000,
            2.049854333000,
            2.049894735000,
            2.049935171000,
            2.049975639000,
            2.050016139000,
            2.050056673000,
            2.050097239000,
            2.050137838000,
            2.050178471000,
            2.050219136000,
            2.050259834000,
            2.050300565000,
            2.050341329000,
            2.050382126000,
            2.050422956000,
            2.050463819000,
            2.050504716000,
            2.050545645000,
            2.050586608000,
            2.050627604000,
            2.050668633000,
            2.050709695000,
            2.050750791000,
            2.050791920000,
            2.050833082000,
            2.050874277000,
            2.050915506000,
            2.050956769000,
            2.050998065000,
            2.051039394000,
            2.051080757000,
            2.051122153000,
            2.051163583000,
            2.051205046000,
            2.051246543000,
            2.051288074000,
            2.051329638000,
            2.051371236000,
            2.051412868000,
            2.051454534000,
            2.051496233000,
            2.051537966000,
            2.051579733000,
            2.051621533000,
            2.051663368000,
            2.051705236000,
            2.051747139000,
            2.051789075000,
            2.051831045000,
            2.051873050000,
            2.051915088000,
            2.051957161000,
            2.051999267000,
            2.052041408000,
            2.052083583000,
            2.052125792000,
            2.052168035000,
            2.052210312000,
            2.052252624000,
            2.052294970000,
            2.052337350000,
            2.052379765000,
            2.052422214000,
            2.052464698000,
            2.052507216000,
            2.052549768000,
            2.052592355000,
            2.052634976000,
            2.052677632000,
            2.052720322000,
            2.052763047000,
            2.052805807000,
            2.052848601000,
            2.052891430000,
            2.052934294000,
            2.052977192000,
            2.053020126000,
            2.053063094000,
            2.053106096000,
            2.053149134000,
            2.053192207000,
            2.053235314000,
            2.053278457000,
            2.053321634000,
            2.053364846000,
            2.053408094000,
            2.053451376000,
            2.053494693000,
            2.053538046000,
            2.053581434000,
            2.053624857000,
            2.053668315000,
            2.053711808000,
            2.053755337000,
            2.053798900000,
            2.053842500000,
            2.053886134000,
            2.053929804000,
            2.053973509000,
            2.054017250000,
            2.054061026000,
            2.054104837000,
            2.054148684000,
            2.054192567000,
            2.054236485000,
            2.054280439000,
            2.054324428000,
            2.054368453000,
            2.054412514000,
            2.054456610000,
            2.054500742000,
            2.054544910000,
            2.054589114000,
            2.054633354000,
            2.054677629000,
            2.054721940000,
            2.054766287000,
            2.054810670000,
            2.054855090000,
            2.054899545000,
            2.054944036000,
            2.054988563000,
            2.055033126000,
            2.055077725000,
            2.055122361000,
            2.055167033000,
            2.055211741000,
            2.055256485000,
            2.055301265000,
            2.055346082000,
            2.055390935000,
            2.055435824000,
            2.055480750000,
            2.055525712000,
            2.055570710000,
            2.055615745000,
            2.055660817000,
            2.055705925000,
            2.055751069000,
            2.055796251000,
            2.055841468000,
            2.055886723000,
            2.055932014000,
            2.055977342000,
            2.056022706000,
            2.056068108000,
            2.056113546000,
            2.056159021000,
            2.056204533000,
            2.056250081000,
            2.056295667000,
            2.056341289000,
            2.056386949000,
            2.056432645000,
            2.056478379000,
            2.056524149000,
            2.056569957000,
            2.056615802000,
            2.056661684000,
            2.056707603000,
            2.056753559000,
            2.056799553000,
            2.056845584000,
            2.056891652000,
            2.056937758000,
            2.056983900000,
            2.057030081000,
            2.057076298000,
            2.057122554000,
            2.057168846000,
            2.057215176000,
            2.057261544000,
            2.057307949000,
            2.057354392000,
            2.057400873000,
            2.057447391000,
            2.057493947000,
            2.057540541000,
            2.057587172000,
            2.057633841000,
            2.057680548000,
            2.057727293000,
            2.057774076000,
            2.057820896000,
            2.057867755000,
            2.057914651000,
            2.057961586000,
            2.058008559000,
            2.058055569000,
            2.058102618000,
            2.058149705000,
            2.058196830000,
            2.058243993000,
            2.058291195000,
            2.058338434000,
            2.058385712000,
            2.058433029000,
            2.058480383000,
            2.058527777000,
            2.058575208000,
            2.058622678000,
            2.058670186000,
            2.058717733000,
            2.058765318000,
            2.058812942000,
            2.058860605000,
            2.058908306000,
            2.058956046000,
            2.059003824000,
            2.059051642000,
            2.059099498000,
            2.059147393000,
            2.059195326000,
            2.059243299000,
            2.059291310000,
            2.059339360000,
            2.059387449000,
            2.059435577000,
            2.059483745000,
            2.059531951000,
            2.059580196000,
            2.059628480000,
            2.059676804000,
            2.059725166000,
            2.059773568000,
            2.059822009000,
            2.059870490000,
            2.059919009000,
            2.059967568000,
            2.060016166000,
            2.060064804000,
            2.060113481000,
            2.060162198000,
            2.060210954000,
            2.060259749000,
            2.060308584000,
            2.060357459000,
            2.060406373000,
            2.060455327000,
            2.060504320000,
            2.060553354000,
            2.060602427000,
            2.060651539000,
            2.060700692000,
            2.060749884000,
            2.060799117000,
            2.060848389000,
            2.060897701000,
            2.060947053000,
            2.060996445000,
            2.061045877000,
            2.061095349000,
            2.061144862000,
            2.061194414000,
            2.061244006000,
            2.061293639000,
            2.061343312000,
            2.061393025000,
            2.061442779000,
            2.061492572000,
            2.061542407000,
            2.061592281000,
            2.061642196000,
            2.061692152000,
            2.061742147000,
            2.061792184000,
            2.061842261000,
            2.061892378000,
            2.061942536000,
            2.061992735000,
            2.062042975000,
            2.062093255000,
            2.062143576000,
            2.062193938000,
            2.062244340000,
            2.062294784000,
            2.062345268000,
            2.062395793000,
            2.062446359000,
            2.062496966000,
            2.062547614000,
            2.062598304000,
            2.062649034000,
            2.062699805000,
            2.062750618000,
            2.062801471000,
            2.062852366000,
            2.062903302000,
            2.062954280000,
            2.063005298000,
            2.063056359000,
            2.063107460000,
            2.063158603000,
            2.063209787000,
            2.063261013000,
            2.063312280000,
            2.063363589000,
            2.063414940000,
            2.063466332000,
            2.063517765000,
            2.063569241000,
            2.063620758000,
            2.063672317000,
            2.063723917000,
            2.063775560000,
            2.063827244000,
            2.063878970000,
            2.063930738000,
            2.063982548000,
            2.064034400000,
            2.064086294000,
            2.064138231000,
            2.064190209000,
            2.064242229000,
            2.064294292000,
            2.064346396000,
            2.064398543000,
            2.064450732000,
            2.064502964000,
            2.064555238000,
            2.064607554000,
            2.064659912000,
            2.064712313000,
            2.064764757000,
            2.064817243000,
            2.064869771000,
            2.064922342000,
            2.064974956000,
            2.065027612000,
            2.065080311000,
            2.065133053000,
            2.065185837000,
            2.065238665000,
            2.065291535000,
            2.065344447000,
            2.065397403000,
            2.065450402000,
            2.065503443000,
            2.065556528000,
            2.065609656000,
            2.065662826000,
            2.065716040000,
            2.065769297000,
            2.065822597000,
            2.065875940000,
            2.065929327000,
            2.065982757000,
            2.066036230000,
            2.066089746000,
            2.066143306000,
            2.066196909000,
            2.066250555000,
            2.066304245000,
            2.066357979000,
            2.066411756000,
            2.066465577000,
            2.066519441000,
            2.066573349000,
            2.066627301000,
            2.066681296000,
            2.066735335000,
            2.066789418000,
            2.066843545000,
            2.066897716000,
            2.066951930000,
            2.067006189000,
            2.067060491000,
            2.067114837000,
            2.067169228000,
            2.067223662000,
            2.067278141000,
            2.067332664000,
            2.067387231000,
            2.067441842000,
            2.067496498000,
            2.067551198000,
            2.067605942000,
            2.067660730000,
            2.067715563000,
            2.067770440000,
            2.067825362000,
            2.067880328000,
            2.067935339000,
            2.067990395000,
            2.068045495000,
            2.068100639000,
            2.068155829000,
            2.068211063000,
            2.068266342000,
            2.068321665000,
            2.068377034000,
            2.068432447000,
            2.068487906000,
            2.068543409000,
            2.068598957000,
            2.068654550000,
            2.068710189000,
            2.068765872000,
            2.068821600000,
            2.068877374000,
            2.068933193000,
            2.068989057000,
            2.069044966000,
            2.069100921000,
            2.069156921000,
            2.069212967000,
            2.069269057000,
            2.069325194000,
            2.069381375000,
            2.069437603000,
            2.069493876000,
            2.069550194000,
            2.069606558000,
            2.069662968000,
            2.069719423000,
            2.069775925000,
            2.069832472000,
            2.069889065000,
            2.069945703000,
            2.070002388000,
            2.070059119000,
            2.070115895000,
            2.070172718000,
            2.070229586000,
            2.070286501000,
            2.070343462000,
            2.070400469000,
            2.070457522000,
            2.070514621000,
            2.070571767000,
            2.070628959000,
            2.070686198000,
            2.070743482000,
            2.070800813000,
            2.070858191000,
            2.070915615000,
            2.070973086000,
            2.071030603000,
            2.071088167000,
            2.071145778000,
            2.071203435000,
            2.071261139000,
            2.071318889000,
            2.071376687000,
            2.071434531000,
            2.071492422000,
            2.071550360000,
            2.071608346000,
            2.071666378000,
            2.071724457000,
            2.071782583000,
            2.071840756000,
            2.071898977000,
            2.071957244000,
            2.072015559000,
            2.072073921000,
            2.072132330000,
            2.072190787000,
            2.072249291000,
            2.072307843000,
            2.072366442000,
            2.072425088000,
            2.072483782000,
            2.072542523000,
            2.072601313000,
            2.072660149000,
            2.072719034000,
            2.072777966000,
            2.072836946000,
            2.072895974000,
            2.072955049000,
            2.073014173000,
            2.073073344000,
            2.073132563000,
            2.073191831000,
            2.073251146000,
            2.073310509000,
            2.073369921000,
            2.073429381000,
            2.073488888000,
            2.073548444000,
            2.073608049000,
            2.073667701000,
            2.073727402000,
            2.073787152000,
            2.073846950000,
            2.073906796000,
            2.073966691000,
            2.074026634000,
            2.074086626000,
            2.074146666000,
            2.074206755000,
            2.074266893000,
            2.074327080000,
            2.074387315000,
            2.074447599000,
            2.074507932000,
            2.074568314000,
            2.074628745000,
            2.074689225000,
            2.074749754000,
            2.074810332000,
            2.074870959000,
            2.074931635000,
            2.074992360000,
            2.075053135000,
            2.075113958000,
            2.075174831000,
            2.075235754000,
            2.075296725000,
            2.075357747000,
            2.075418817000,
            2.075479937000,
            2.075541107000,
            2.075602326000,
            2.075663595000,
            2.075724913000,
            2.075786282000,
            2.075847700000,
            2.075909167000,
            2.075970685000,
            2.076032252000,
            2.076093869000,
            2.076155536000,
            2.076217254000,
            2.076279021000,
            2.076340838000,
            2.076402705000,
            2.076464623000,
            2.076526590000,
            2.076588608000,
            2.076650676000,
            2.076712795000,
            2.076774964000,
            2.076837183000,
            2.076899452000,
            2.076961772000,
            2.077024143000,
            2.077086564000,
            2.077149036000,
            2.077211558000,
            2.077274131000,
            2.077336754000,
            2.077399429000,
            2.077462154000,
            2.077524930000,
            2.077587757000,
            2.077650635000,
            2.077713564000,
            2.077776543000,
            2.077839574000,
            2.077902656000,
            2.077965789000,
            2.078028973000,
            2.078092209000,
            2.078155495000,
            2.078218833000,
            2.078282223000,
            2.078345663000,
            2.078409155000,
            2.078472699000,
            2.078536294000,
            2.078599940000,
            2.078663638000,
            2.078727388000,
            2.078791190000,
            2.078855043000,
            2.078918948000,
            2.078982904000,
            2.079046913000,
            2.079110973000,
            2.079175085000,
            2.079239250000,
            2.079303466000,
            2.079367734000,
            2.079432054000,
            2.079496427000,
            2.079560851000,
            2.079625328000,
            2.079689857000,
            2.079754439000,
            2.079819073000,
            2.079883759000,
            2.079948497000,
            2.080013288000,
            2.080078132000,
            2.080143028000,
            2.080207976000,
            2.080272978000,
            2.080338032000,
            2.080403138000,
            2.080468298000,
            2.080533510000,
            2.080598775000,
            2.080664093000,
            2.080729464000,
            2.080794888000,
            2.080860365000,
            2.080925895000,
            2.080991478000,
            2.081057114000,
            2.081122804000,
            2.081188546000,
            2.081254342000,
            2.081320191000,
            2.081386094000,
            2.081452050000,
            2.081518060000,
            2.081584123000,
            2.081650239000,
            2.081716409000,
            2.081782633000,
            2.081848910000,
            2.081915241000,
            2.081981626000,
            2.082048065000,
            2.082114557000,
            2.082181104000,
            2.082247704000,
            2.082314359000,
            2.082381067000,
            2.082447829000,
            2.082514646000,
            2.082581516000,
            2.082648441000,
            2.082715420000,
            2.082782454000,
            2.082849541000,
            2.082916683000,
            2.082983880000,
            2.083051131000,
            2.083118436000,
            2.083185796000,
            2.083253210000,
            2.083320680000,
            2.083388203000,
            2.083455782000,
            2.083523415000,
            2.083591104000,
            2.083658847000,
            2.083726644000,
            2.083794497000,
            2.083862405000,
            2.083930368000,
            2.083998386000,
            2.084066459000,
            2.084134587000,
            2.084202771000,
            2.084271009000,
            2.084339303000,
            2.084407653000,
            2.084476057000,
            2.084544518000,
            2.084613033000,
            2.084681604000,
            2.084750231000,
            2.084818914000,
            2.084887652000,
            2.084956445000,
            2.085025295000,
            2.085094200000,
            2.085163161000,
            2.085232178000,
            2.085301251000,
            2.085370380000,
            2.085439565000,
            2.085508806000,
            2.085578103000,
            2.085647456000,
            2.085716866000,
            2.085786332000,
            2.085855854000,
            2.085925432000,
            2.085995067000,
            2.086064758000,
            2.086134506000,
            2.086204310000,
            2.086274171000,
            2.086344088000,
            2.086414062000,
            2.086484093000,
            2.086554180000,
            2.086624325000,
            2.086694526000,
            2.086764784000,
            2.086835099000,
            2.086905471000,
            2.086975900000,
            2.087046386000,
            2.087116929000,
            2.087187529000,
            2.087258187000,
            2.087328902000,
            2.087399674000,
            2.087470503000,
            2.087541390000,
            2.087612335000,
            2.087683337000,
            2.087754396000,
            2.087825513000,
            2.087896688000,
            2.087967920000,
            2.088039210000,
            2.088110558000,
            2.088181963000,
            2.088253427000,
            2.088324948000,
            2.088396527000,
            2.088468165000,
            2.088539860000,
            2.088611614000,
            2.088683425000,
            2.088755295000,
            2.088827223000,
            2.088899210000,
            2.088971255000,
            2.089043358000,
            2.089115519000,
            2.089187739000,
            2.089260018000,
            2.089332355000,
            2.089404751000,
            2.089477205000,
            2.089549718000,
            2.089622290000,
            2.089694921000,
            2.089767611000,
            2.089840359000,
            2.089913166000,
            2.089986033000,
            2.090058958000,
            2.090131943000,
            2.090204987000,
            2.090278090000,
            2.090351252000,
            2.090424473000,
            2.090497754000,
            2.090571095000,
            2.090644494000,
            2.090717953000,
            2.090791472000,
            2.090865050000,
            2.090938688000,
            2.091012386000,
            2.091086143000,
            2.091159960000,
            2.091233837000,
            2.091307774000,
            2.091381770000,
            2.091455827000,
            2.091529943000,
            2.091604120000,
            2.091678357000,
            2.091752654000,
            2.091827011000,
            2.091901429000,
            2.091975906000,
            2.092050445000,
            2.092125043000,
            2.092199702000,
            2.092274422000,
            2.092349202000,
            2.092424042000,
            2.092498944000,
            2.092573906000,
            2.092648928000,
            2.092724012000,
            2.092799156000,
            2.092874362000,
            2.092949628000,
            2.093024955000,
            2.093100343000,
            2.093175793000,
            2.093251303000,
            2.093326875000,
            2.093402508000,
            2.093478202000,
            2.093553958000,
            2.093629775000,
            2.093705653000,
            2.093781593000,
            2.093857594000,
            2.093933658000,
            2.094009782000,
            2.094085969000,
            2.094162217000,
            2.094238527000,
            2.094314898000,
            2.094391332000,
            2.094467828000,
            2.094544385000,
            2.094621005000,
            2.094697687000,
            2.094774431000,
            2.094851237000,
            2.094928105000,
            2.095005036000,
            2.095082029000,
            2.095159084000,
            2.095236202000,
            2.095313382000,
            2.095390625000,
            2.095467930000,
            2.095545298000,
            2.095622729000,
            2.095700223000,
            2.095777779000,
            2.095855398000,
            2.095933080000,
            2.096010825000,
            2.096088633000,
            2.096166505000,
            2.096244439000,
            2.096322436000,
            2.096400497000,
            2.096478621000,
            2.096556808000,
            2.096635058000,
            2.096713372000,
            2.096791750000,
            2.096870191000,
            2.096948695000,
            2.097027263000,
            2.097105895000,
            2.097184590000,
            2.097263350000,
            2.097342173000,
            2.097421060000,
            2.097500011000,
            2.097579026000,
            2.097658105000,
            2.097737248000,
            2.097816455000,
            2.097895726000,
            2.097975062000,
            2.098054462000,
            2.098133926000,
            2.098213455000,
            2.098293048000,
            2.098372705000,
            2.098452427000,
            2.098532214000,
            2.098612066000,
            2.098691982000,
            2.098771963000,
            2.098852008000,
            2.098932119000,
            2.099012294000,
            2.099092535000,
            2.099172840000,
            2.099253211000,
            2.099333647000,
            2.099414148000,
            2.099494714000,
            2.099575345000,
            2.099656042000,
            2.099736804000,
            2.099817632000,
            2.099898525000,
            2.099979484000,
            2.100060508000,
            2.100141598000,
            2.100222753000,
            2.100303975000,
            2.100385262000,
            2.100466615000,
            2.100548034000,
            2.100629519000,
            2.100711070000,
            2.100792688000,
            2.100874371000,
            2.100956121000,
            2.101037936000,
            2.101119818000,
            2.101201767000,
            2.101283782000,
            2.101365863000,
            2.101448011000,
            2.101530225000,
            2.101612506000,
            2.101694854000,
            2.101777268000,
            2.101859750000,
            2.101942298000,
            2.102024913000,
            2.102107595000,
            2.102190344000,
            2.102273160000,
            2.102356043000,
            2.102438993000,
            2.102522010000,
            2.102605095000,
            2.102688247000,
            2.102771467000,
            2.102854754000,
            2.102938108000,
            2.103021530000,
            2.103105020000,
            2.103188577000,
            2.103272202000,
            2.103355895000,
            2.103439655000,
            2.103523484000,
            2.103607380000,
            2.103691345000,
            2.103775377000,
            2.103859477000,
            2.103943646000,
            2.104027883000,
            2.104112188000,
            2.104196562000,
            2.104281004000,
            2.104365514000,
            2.104450093000,
            2.104534740000,
            2.104619456000,
            2.104704240000,
            2.104789094000,
            2.104874016000,
            2.104959007000,
            2.105044066000,
            2.105129195000,
            2.105214393000,
            2.105299659000,
            2.105384995000,
            2.105470400000,
            2.105555874000,
            2.105641418000,
            2.105727031000,
            2.105812713000,
            2.105898464000,
            2.105984285000,
            2.106070176000,
            2.106156136000,
            2.106242166000,
            2.106328266000,
            2.106414435000,
            2.106500675000,
            2.106586984000,
            2.106673363000,
            2.106759812000,
            2.106846331000,
            2.106932920000,
            2.107019580000,
            2.107106309000,
            2.107193109000,
            2.107279979000,
            2.107366920000,
            2.107453931000,
            2.107541013000,
            2.107628165000,
            2.107715388000,
            2.107802682000,
            2.107890046000,
            2.107977481000,
            2.108064987000,
            2.108152564000,
            2.108240212000,
            2.108327930000,
            2.108415720000,
            2.108503582000,
            2.108591514000,
            2.108679517000,
            2.108767592000,
            2.108855739000,
            2.108943956000,
            2.109032245000,
            2.109120606000,
            2.109209038000,
            2.109297542000,
            2.109386118000,
            2.109474766000,
            2.109563485000,
            2.109652276000,
            2.109741140000,
            2.109830075000,
            2.109919082000,
            2.110008162000,
            2.110097313000,
            2.110186537000,
            2.110275833000,
            2.110365202000,
            2.110454643000,
            2.110544156000,
            2.110633742000,
            2.110723401000,
            2.110813132000,
            2.110902936000,
            2.110992813000,
            2.111082762000,
            2.111172785000,
            2.111262880000,
            2.111353049000,
            2.111443290000,
            2.111533605000,
            2.111623993000,
            2.111714454000,
            2.111804988000,
            2.111895596000,
            2.111986277000,
            2.112077032000,
            2.112167860000,
            2.112258762000,
            2.112349738000,
            2.112440787000,
            2.112531910000,
            2.112623107000,
            2.112714378000,
            2.112805723000,
            2.112897141000,
            2.112988634000,
            2.113080201000,
            2.113171843000,
            2.113263558000,
            2.113355348000,
            2.113447212000,
            2.113539151000,
            2.113631164000,
            2.113723252000,
            2.113815414000,
            2.113907651000,
            2.113999963000,
            2.114092350000,
            2.114184811000,
            2.114277347000,
            2.114369959000,
            2.114462645000,
            2.114555407000,
            2.114648244000,
            2.114741156000,
            2.114834143000,
            2.114927206000,
            2.115020344000,
            2.115113557000,
            2.115206846000,
            2.115300211000,
            2.115393651000,
            2.115487167000,
            2.115580759000,
            2.115674427000,
            2.115768171000,
            2.115861990000,
            2.115955886000,
            2.116049858000,
            2.116143905000,
            2.116238030000,
            2.116332230000,
            2.116426507000,
            2.116520860000,
            2.116615289000,
            2.116709795000,
            2.116804378000,
            2.116899037000,
            2.116993774000,
            2.117088586000,
            2.117183476000,
            2.117278443000,
            2.117373486000,
            2.117468607000,
            2.117563804000,
            2.117659079000,
            2.117754431000,
            2.117849860000,
            2.117945367000,
            2.118040951000,
            2.118136612000,
            2.118232351000,
            2.118328168000,
            2.118424062000,
            2.118520034000,
            2.118616084000,
            2.118712212000,
            2.118808417000,
            2.118904700000,
            2.119001062000,
            2.119097501000,
            2.119194019000,
            2.119290615000,
            2.119387289000,
            2.119484042000,
            2.119580873000,
            2.119677782000,
            2.119774770000,
            2.119871837000,
            2.119968982000,
            2.120066206000,
            2.120163509000,
            2.120260890000,
            2.120358351000,
            2.120455890000,
            2.120553509000,
            2.120651207000,
            2.120748984000,
            2.120846840000,
            2.120944775000,
            2.121042790000,
            2.121140884000,
            2.121239058000,
            2.121337311000,
            2.121435644000,
            2.121534056000,
            2.121632549000,
            2.121731121000,
            2.121829773000,
            2.121928505000,
            2.122027317000,
            2.122126209000,
            2.122225181000,
            2.122324233000,
            2.122423366000,
            2.122522579000,
            2.122621873000,
            2.122721247000,
            2.122820701000,
            2.122920236000,
            2.123019852000,
            2.123119548000,
            2.123219325000,
            2.123319183000,
            2.123419122000,
            2.123519142000,
            2.123619243000,
            2.123719426000,
            2.123819689000,
            2.123920034000,
            2.124020460000,
            2.124120967000,
            2.124221556000,
            2.124322226000,
            2.124422978000,
            2.124523811000,
            2.124624727000,
            2.124725724000,
            2.124826802000,
            2.124927963000,
            2.125029206000,
            2.125130531000,
            2.125231938000,
            2.125333427000,
            2.125434998000,
            2.125536652000,
            2.125638388000,
            2.125740207000,
            2.125842108000,
            2.125944091000,
            2.126046157000,
            2.126148306000,
            2.126250538000,
            2.126352853000,
            2.126455250000,
            2.126557731000,
            2.126660294000,
            2.126762941000,
            2.126865671000,
            2.126968484000,
            2.127071380000,
            2.127174360000,
            2.127277423000,
            2.127380570000,
            2.127483801000,
            2.127587115000,
            2.127690512000,
            2.127793994000,
            2.127897559000,
            2.128001209000,
            2.128104942000,
            2.128208760000,
            2.128312661000,
            2.128416647000,
            2.128520717000,
            2.128624871000,
            2.128729110000,
            2.128833433000,
            2.128937841000,
            2.129042334000,
            2.129146911000,
            2.129251572000,
            2.129356319000,
            2.129461151000,
            2.129566067000,
            2.129671069000,
            2.129776155000,
            2.129881327000,
            2.129986584000,
            2.130091927000,
            2.130197354000,
            2.130302867000,
            2.130408466000,
            2.130514150000,
            2.130619920000,
            2.130725776000,
            2.130831717000,
            2.130937744000,
            2.131043857000,
            2.131150057000,
            2.131256342000,
            2.131362713000,
            2.131469171000,
            2.131575715000,
            2.131682345000,
            2.131789061000,
            2.131895864000,
            2.132002754000,
            2.132109730000,
            2.132216793000,
            2.132323943000,
            2.132431179000,
            2.132538503000,
            2.132645913000,
            2.132753411000,
            2.132860995000,
            2.132968667000,
            2.133076426000,
            2.133184273000,
            2.133292206000,
            2.133400227000,
            2.133508336000,
            2.133616533000,
            2.133724817000,
            2.133833189000,
            2.133941648000,
            2.134050196000,
            2.134158831000,
            2.134267555000,
            2.134376366000,
            2.134485266000,
            2.134594254000,
            2.134703331000,
            2.134812496000,
            2.134921749000,
            2.135031091000,
            2.135140521000,
            2.135250040000,
            2.135359648000,
            2.135469345000,
            2.135579131000,
            2.135689005000,
            2.135798969000,
            2.135909021000,
            2.136019163000,
            2.136129395000,
            2.136239715000,
            2.136350125000,
            2.136460624000,
            2.136571213000,
            2.136681892000,
            2.136792660000,
            2.136903518000,
            2.137014466000,
            2.137125504000,
            2.137236632000,
            2.137347849000,
            2.137459157000,
            2.137570556000,
            2.137682044000,
            2.137793623000,
            2.137905292000,
            2.138017052000,
            2.138128902000,
            2.138240843000,
            2.138352875000,
            2.138464997000,
            2.138577210000,
            2.138689515000,
            2.138801910000,
            2.138914396000,
            2.139026974000,
            2.139139643000,
            2.139252403000,
            2.139365254000,
            2.139478197000,
            2.139591231000,
            2.139704357000,
            2.139817575000,
            2.139930884000,
            2.140044286000,
            2.140157779000,
            2.140271364000,
            2.140385041000,
            2.140498811000,
            2.140612672000,
            2.140726626000,
            2.140840672000,
            2.140954811000,
            2.141069042000,
            2.141183365000,
            2.141297782000,
            2.141412291000,
            2.141526893000,
            2.141641587000,
            2.141756375000,
            2.141871256000,
            2.141986229000,
            2.142101296000,
            2.142216456000,
            2.142331710000,
            2.142447057000,
            2.142562497000,
            2.142678031000,
            2.142793659000,
            2.142909380000,
            2.143025195000,
            2.143141104000,
            2.143257107000,
            2.143373204000,
            2.143489395000,
            2.143605680000,
            2.143722059000,
            2.143838533000,
            2.143955101000,
            2.144071764000,
            2.144188521000,
            2.144305373000,
            2.144422319000,
            2.144539360000,
            2.144656496000,
            2.144773727000,
            2.144891053000,
            2.145008474000,
            2.145125990000,
            2.145243602000,
            2.145361308000,
            2.145479111000,
            2.145597008000,
            2.145715001000,
            2.145833090000,
            2.145951275000,
            2.146069555000,
            2.146187931000,
            2.146306403000,
            2.146424971000,
            2.146543635000,
            2.146662396000,
            2.146781252000,
            2.146900205000,
            2.147019254000,
            2.147138400000,
            2.147257642000,
            2.147376981000,
            2.147496417000,
            2.147615949000,
            2.147735579000,
            2.147855305000,
            2.147975128000,
            2.148095049000,
            2.148215066000,
            2.148335181000,
            2.148455393000,
            2.148575703000,
            2.148696110000,
            2.148816615000,
            2.148937217000,
            2.149057917000,
            2.149178715000,
            2.149299611000,
            2.149420605000,
            2.149541697000,
            2.149662887000,
            2.149784175000,
            2.149905561000,
            2.150027046000,
            2.150148629000,
            2.150270311000,
            2.150392092000,
            2.150513971000,
            2.150635949000,
            2.150758025000,
            2.150880201000,
            2.151002476000,
            2.151124850000,
            2.151247323000,
            2.151369895000,
            2.151492566000,
            2.151615337000,
            2.151738208000,
            2.151861178000,
            2.151984248000,
            2.152107417000,
            2.152230686000,
            2.152354055000,
            2.152477525000,
            2.152601094000,
            2.152724763000,
            2.152848533000,
            2.152972402000,
            2.153096373000,
            2.153220443000,
            2.153344615000,
            2.153468887000,
            2.153593259000,
            2.153717733000,
            2.153842307000,
            2.153966982000,
            2.154091758000,
            2.154216636000,
            2.154341614000,
            2.154466694000,
            2.154591875000,
            2.154717158000,
            2.154842542000,
            2.154968028000,
            2.155093616000,
            2.155219305000,
            2.155345096000,
            2.155470989000,
            2.155596984000,
            2.155723082000,
            2.155849281000,
            2.155975583000,
            2.156101987000,
            2.156228493000,
            2.156355102000,
            2.156481814000,
            2.156608628000,
            2.156735545000,
            2.156862565000,
            2.156989688000,
            2.157116914000,
            2.157244243000,
            2.157371675000,
            2.157499210000,
            2.157626849000,
            2.157754592000,
            2.157882437000,
            2.158010387000,
            2.158138440000,
            2.158266597000,
            2.158394857000,
            2.158523222000,
            2.158651691000,
            2.158780263000,
            2.158908940000,
            2.159037722000,
            2.159166607000,
            2.159295597000,
            2.159424692000,
            2.159553891000,
            2.159683195000,
            2.159812604000,
            2.159942118000,
            2.160071736000,
            2.160201460000,
            2.160331288000,
            2.160461222000,
            2.160591262000,
            2.160721406000,
            2.160851656000,
            2.160982012000,
            2.161112473000,
            2.161243040000,
            2.161373713000,
            2.161504492000,
            2.161635377000,
            2.161766368000,
            2.161897465000,
            2.162028668000,
            2.162159977000,
            2.162291393000,
            2.162422916000,
            2.162554545000,
            2.162686280000,
            2.162818123000,
            2.162950072000,
            2.163082128000,
            2.163214292000,
            2.163346562000,
            2.163478940000,
            2.163611424000,
            2.163744017000,
            2.163876716000,
            2.164009523000,
            2.164142438000,
            2.164275461000,
            2.164408591000,
            2.164541829000,
            2.164675176000,
            2.164808630000,
            2.164942192000,
            2.165075863000,
            2.165209642000,
            2.165343529000,
            2.165477525000,
            2.165611630000,
            2.165745843000,
            2.165880165000,
            2.166014596000,
            2.166149136000,
            2.166283784000,
            2.166418542000,
            2.166553409000,
            2.166688386000,
            2.166823472000,
            2.166958667000,
            2.167093972000,
            2.167229386000,
            2.167364910000,
            2.167500545000,
            2.167636289000,
            2.167772142000,
            2.167908107000,
            2.168044181000,
            2.168180365000,
            2.168316660000,
            2.168453066000,
            2.168589582000,
            2.168726208000,
            2.168862945000,
            2.168999794000,
            2.169136753000,
            2.169273823000,
            2.169411004000,
            2.169548296000,
            2.169685699000,
            2.169823214000,
            2.169960840000,
            2.170098578000,
            2.170236428000,
            2.170374389000,
            2.170512462000,
            2.170650647000,
            2.170788944000,
            2.170927353000,
            2.171065874000,
            2.171204507000,
            2.171343253000,
            2.171482111000,
            2.171621082000,
            2.171760165000,
            2.171899361000,
            2.172038670000,
            2.172178091000,
            2.172317626000,
            2.172457274000,
            2.172597035000,
            2.172736909000,
            2.172876897000,
            2.173016998000,
            2.173157212000,
            2.173297540000,
            2.173437982000,
            2.173578538000,
            2.173719208000,
            2.173859991000,
            2.174000889000,
            2.174141901000,
            2.174283027000,
            2.174424268000,
            2.174565623000,
            2.174707093000,
            2.174848677000,
            2.174990376000,
            2.175132190000,
            2.175274118000,
            2.175416162000,
            2.175558321000,
            2.175700595000,
            2.175842984000,
            2.175985489000,
            2.176128109000,
            2.176270845000,
            2.176413697000,
            2.176556664000,
            2.176699747000,
            2.176842946000,
            2.176986261000,
            2.177129693000,
            2.177273240000,
            2.177416904000,
            2.177560684000,
            2.177704581000,
            2.177848595000,
            2.177992725000,
            2.178136972000,
            2.178281336000,
            2.178425816000,
            2.178570414000,
            2.178715129000,
            2.178859962000,
            2.179004912000,
            2.179149979000,
            2.179295164000,
            2.179440466000,
            2.179585886000,
            2.179731424000,
            2.179877080000,
            2.180022854000,
            2.180168747000,
            2.180314757000,
            2.180460886000,
            2.180607133000,
            2.180753499000,
            2.180899983000,
            2.181046586000,
            2.181193308000,
            2.181340148000,
            2.181487108000,
            2.181634187000,
            2.181781385000,
            2.181928702000,
            2.182076139000,
            2.182223695000,
            2.182371371000,
            2.182519166000,
            2.182667082000,
            2.182815117000,
            2.182963272000,
            2.183111547000,
            2.183259942000,
            2.183408458000,
            2.183557094000,
            2.183705850000,
            2.183854727000,
            2.184003724000,
            2.184152843000,
            2.184302082000,
            2.184451442000,
            2.184600923000,
            2.184750525000,
            2.184900249000,
            2.185050094000,
            2.185200060000,
            2.185350148000,
            2.185500357000,
            2.185650689000,
            2.185801142000,
            2.185951717000,
            2.186102414000,
            2.186253233000,
            2.186404174000,
            2.186555238000,
            2.186706424000,
            2.186857732000,
            2.187009164000,
            2.187160718000,
            2.187312394000,
            2.187464194000,
            2.187616117000,
            2.187768163000,
            2.187920332000,
            2.188072624000,
            2.188225040000,
            2.188377579000,
            2.188530242000,
            2.188683029000,
            2.188835939000,
            2.188988974000,
            2.189142132000,
            2.189295414000,
            2.189448821000,
            2.189602352000,
            2.189756008000,
            2.189909788000,
            2.190063692000,
            2.190217722000,
            2.190371876000,
            2.190526155000,
            2.190680559000,
            2.190835089000,
            2.190989743000,
            2.191144523000,
            2.191299428000,
            2.191454459000,
            2.191609615000,
            2.191764898000,
            2.191920306000,
            2.192075840000,
            2.192231500000,
            2.192387286000,
            2.192543198000,
            2.192699237000,
            2.192855402000,
            2.193011694000,
            2.193168113000,
            2.193324658000,
            2.193481330000,
            2.193638129000,
            2.193795055000,
            2.193952108000,
            2.194109289000,
            2.194266597000,
            2.194424032000,
            2.194581595000,
            2.194739286000,
            2.194897105000,
            2.195055051000,
            2.195213125000,
            2.195371328000,
            2.195529659000,
            2.195688118000,
            2.195846705000,
            2.196005421000,
            2.196164266000,
            2.196323239000,
            2.196482341000,
            2.196641572000,
            2.196800932000,
            2.196960422000,
            2.197120040000,
            2.197279788000,
            2.197439666000,
            2.197599672000,
            2.197759809000,
            2.197920075000,
            2.198080472000,
            2.198240998000,
            2.198401654000,
            2.198562441000,
            2.198723358000,
            2.198884405000,
            2.199045583000,
            2.199206891000,
            2.199368330000,
            2.199529900000,
            2.199691601000,
            2.199853433000,
            2.200015396000,
            2.200177490000,
            2.200339716000,
            2.200502073000,
            2.200664562000,
            2.200827182000,
            2.200989934000,
            2.201152818000,
            2.201315835000,
            2.201478983000,
            2.201642263000,
            2.201805676000,
            2.201969221000,
            2.202132899000,
            2.202296709000,
            2.202460652000,
            2.202624728000,
            2.202788937000,
            2.202953279000,
            2.203117754000,
            2.203282363000,
            2.203447105000,
            2.203611980000,
            2.203776989000,
            2.203942132000,
            2.204107409000,
            2.204272819000,
            2.204438364000,
            2.204604042000,
            2.204769855000,
            2.204935803000,
            2.205101885000,
            2.205268101000,
            2.205434452000,
            2.205600938000,
            2.205767559000,
            2.205934315000,
            2.206101206000,
            2.206268232000,
            2.206435394000,
            2.206602691000,
            2.206770124000,
            2.206937692000,
            2.207105397000,
            2.207273237000,
            2.207441213000,
            2.207609325000,
            2.207777574000,
            2.207945959000,
            2.208114480000,
            2.208283138000,
            2.208451932000,
            2.208620864000,
            2.208789932000,
            2.208959137000,
            2.209128480000,
            2.209297959000,
            2.209467576000,
            2.209637331000,
            2.209807223000,
            2.209977252000,
            2.210147420000,
            2.210317725000,
            2.210488169000,
            2.210658750000,
            2.210829470000,
            2.211000328000,
            2.211171325000,
            2.211342460000,
            2.211513734000,
            2.211685147000,
            2.211856698000,
            2.212028389000,
            2.212200219000,
            2.212372188000,
            2.212544296000,
            2.212716544000,
            2.212888931000,
            2.213061458000,
            2.213234125000,
            2.213406932000,
            2.213579879000,
            2.213752966000,
            2.213926194000,
            2.214099562000,
            2.214273070000,
            2.214446719000,
            2.214620508000,
            2.214794439000,
            2.214968510000,
            2.215142723000,
            2.215317076000,
            2.215491571000,
            2.215666207000,
            2.215840985000,
            2.216015905000,
            2.216190966000,
            2.216366169000,
            2.216541514000,
            2.216717002000,
            2.216892631000,
            2.217068403000,
            2.217244317000,
            2.217420374000,
            2.217596573000,
            2.217772916000,
            2.217949401000,
            2.218126029000,
            2.218302800000,
            2.218479715000,
            2.218656773000,
            2.218833974000,
            2.219011320000,
            2.219188808000,
            2.219366441000,
            2.219544218000,
            2.219722138000,
            2.219900203000,
            2.220078412000,
            2.220256766000,
            2.220435264000,
            2.220613907000,
            2.220792694000,
            2.220971627000,
            2.221150704000,
            2.221329927000,
            2.221509294000,
            2.221688808000,
            2.221868466000,
            2.222048271000,
            2.222228220000,
            2.222408316000,
            2.222588558000,
            2.222768946000,
            2.222949480000,
            2.223130160000,
            2.223310987000,
            2.223491960000,
            2.223673080000,
            2.223854347000,
            2.224035760000,
            2.224217321000,
            2.224399029000,
            2.224580884000,
            2.224762886000,
            2.224945036000,
            2.225127334000,
            2.225309779000,
            2.225492372000,
            2.225675113000,
            2.225858002000,
            2.226041040000,
            2.226224226000,
            2.226407560000,
            2.226591043000,
            2.226774674000,
            2.226958454000,
            2.227142384000,
            2.227326462000,
            2.227510689000,
            2.227695066000,
            2.227879592000,
            2.228064268000,
            2.228249093000,
            2.228434069000,
            2.228619194000,
            2.228804469000,
            2.228989894000,
            2.229175469000,
            2.229361195000,
            2.229547072000,
            2.229733099000,
            2.229919277000,
            2.230105605000,
            2.230292085000,
            2.230478716000,
            2.230665498000,
            2.230852431000,
            2.231039516000,
            2.231226753000,
            2.231414141000,
            2.231601681000,
            2.231789373000,
            2.231977218000,
            2.232165214000,
            2.232353363000,
            2.232541664000,
            2.232730118000,
            2.232918725000,
            2.233107484000,
            2.233296397000,
            2.233485462000,
            2.233674681000,
            2.233864053000,
            2.234053579000,
            2.234243258000,
            2.234433091000,
            2.234623078000,
            2.234813218000,
            2.235003513000,
            2.235193962000,
            2.235384565000,
            2.235575323000,
            2.235766236000,
            2.235957303000,
            2.236148525000,
            2.236339902000,
            2.236531434000,
            2.236723121000,
            2.236914964000,
            2.237106962000,
            2.237299115000,
            2.237491425000,
            2.237683890000,
            2.237876511000,
            2.238069289000,
            2.238262222000,
            2.238455312000,
            2.238648558000,
            2.238841961000,
            2.239035521000,
            2.239229238000,
            2.239423111000,
            2.239617142000,
            2.239811330000,
            2.240005675000,
            2.240200178000,
            2.240394838000,
            2.240589657000,
            2.240784633000,
            2.240979767000,
            2.241175059000,
            2.241370510000,
            2.241566118000,
            2.241761886000,
            2.241957812000,
            2.242153897000,
            2.242350140000,
            2.242546543000,
            2.242743105000,
            2.242939826000,
            2.243136707000,
            2.243333747000,
            2.243530947000,
            2.243728307000,
            2.243925827000,
            2.244123506000,
            2.244321346000,
            2.244519347000,
            2.244717507000,
            2.244915829000,
            2.245114311000,
            2.245312954000,
            2.245511757000,
            2.245710722000,
            2.245909849000,
            2.246109136000,
            2.246308585000,
            2.246508196000,
            2.246707969000,
            2.246907903000,
            2.247107999000,
            2.247308258000,
            2.247508679000,
            2.247709262000,
            2.247910008000,
            2.248110917000,
            2.248311988000,
            2.248513222000,
            2.248714620000,
            2.248916180000,
            2.249117904000,
            2.249319792000,
            2.249521843000,
            2.249724058000,
            2.249926436000,
            2.250128979000,
            2.250331686000,
            2.250534557000,
            2.250737593000,
            2.250940793000,
            2.251144157000,
            2.251347687000,
            2.251551381000,
            2.251755241000,
            2.251959266000,
            2.252163456000,
            2.252367811000,
            2.252572333000,
            2.252777019000,
            2.252981872000,
            2.253186891000,
            2.253392076000,
            2.253597427000,
            2.253802945000,
            2.254008629000,
            2.254214480000,
            2.254420498000,
            2.254626683000,
            2.254833035000,
            2.255039554000,
            2.255246240000,
            2.255453094000,
            2.255660115000,
            2.255867305000,
            2.256074662000,
            2.256282187000,
            2.256489881000,
            2.256697742000,
            2.256905773000,
            2.257113971000,
            2.257322339000,
            2.257530875000,
            2.257739581000,
            2.257948455000,
            2.258157499000,
            2.258366712000,
            2.258576095000,
            2.258785648000,
            2.258995370000,
            2.259205262000,
            2.259415324000,
            2.259625557000,
            2.259835960000,
            2.260046533000,
            2.260257277000,
            2.260468192000,
            2.260679278000,
            2.260890535000,
            2.261101963000,
            2.261313563000,
            2.261525334000,
            2.261737276000,
            2.261949390000,
            2.262161677000,
            2.262374135000,
            2.262586765000,
            2.262799568000,
            2.263012543000,
            2.263225691000,
            2.263439011000,
            2.263652505000,
            2.263866171000,
            2.264080011000,
            2.264294024000,
            2.264508210000,
            2.264722570000,
            2.264937104000,
            2.265151811000,
            2.265366692000,
            2.265581748000,
            2.265796978000,
            2.266012382000,
            2.266227961000,
            2.266443715000,
            2.266659643000,
            2.266875747000,
            2.267092025000,
            2.267308479000,
            2.267525108000,
            2.267741913000,
            2.267958894000,
            2.268176050000,
            2.268393382000,
            2.268610891000,
            2.268828576000,
            2.269046437000,
            2.269264474000,
            2.269482689000,
            2.269701080000,
            2.269919648000,
            2.270138394000,
            2.270357316000,
            2.270576416000,
            2.270795694000,
            2.271015149000,
            2.271234783000,
            2.271454594000,
            2.271674583000,
            2.271894751000,
            2.272115097000,
            2.272335621000,
            2.272556324000,
            2.272777207000,
            2.272998268000,
            2.273219508000,
            2.273440928000,
            2.273662527000,
            2.273884305000,
            2.274106264000,
            2.274328402000,
            2.274550720000,
            2.274773219000,
            2.274995897000,
            2.275218757000,
            2.275441796000,
            2.275665017000,
            2.275888418000,
            2.276112001000,
            2.276335765000,
            2.276559710000,
            2.276783836000,
            2.277008144000,
            2.277232634000,
            2.277457306000,
            2.277682160000,
            2.277907196000,
            2.278132415000,
            2.278357816000,
            2.278583400000,
            2.278809166000,
            2.279035116000,
            2.279261248000,
            2.279487564000,
            2.279714064000,
            2.279940747000,
            2.280167613000,
            2.280394664000,
            2.280621898000,
            2.280849316000,
            2.281076919000,
            2.281304707000,
            2.281532679000,
            2.281760835000,
            2.281989177000,
            2.282217704000,
            2.282446415000,
            2.282675313000,
            2.282904395000,
            2.283133664000,
            2.283363118000,
            2.283592758000,
            2.283822584000,
            2.284052596000,
            2.284282795000,
            2.284513181000,
            2.284743753000,
            2.284974512000,
            2.285205458000,
            2.285436591000,
            2.285667911000,
            2.285899419000,
            2.286131115000,
            2.286362998000,
            2.286595069000,
            2.286827328000,
            2.287059776000,
            2.287292412000,
            2.287525236000,
            2.287758249000,
            2.287991451000,
            2.288224842000,
            2.288458422000,
            2.288692192000,
            2.288926150000,
            2.289160299000,
            2.289394637000,
            2.289629165000,
            2.289863883000,
            2.290098792000,
            2.290333890000,
            2.290569180000,
            2.290804660000,
            2.291040330000,
            2.291276192000,
            2.291512245000,
            2.291748489000,
            2.291984925000,
            2.292221552000,
            2.292458371000,
            2.292695382000,
            2.292932585000,
            2.293169980000,
            2.293407568000,
            2.293645348000,
            2.293883321000,
            2.294121487000,
            2.294359846000,
            2.294598398000,
            2.294837143000,
            2.295076082000,
            2.295315214000,
            2.295554540000,
            2.295794060000,
            2.296033774000,
            2.296273683000,
            2.296513786000,
            2.296754083000,
            2.296994576000,
            2.297235263000,
            2.297476145000,
            2.297717222000,
            2.297958495000,
            2.298199963000,
            2.298441627000,
            2.298683487000,
            2.298925543000,
            2.299167795000,
            2.299410244000,
            2.299652888000,
            2.299895730000,
            2.300138768000,
            2.300382003000,
            2.300625436000,
            2.300869065000,
            2.301112892000,
            2.301356917000,
            2.301601139000,
            2.301845560000,
            2.302090178000,
            2.302334995000,
            2.302580010000,
            2.302825224000,
            2.303070636000,
            2.303316247000,
            2.303562057000,
            2.303808067000,
            2.304054276000,
            2.304300684000,
            2.304547292000,
            2.304794100000,
            2.305041108000,
            2.305288316000,
            2.305535725000,
            2.305783334000,
            2.306031143000,
            2.306279154000,
            2.306527365000,
            2.306775778000,
            2.307024392000,
            2.307273207000,
            2.307522224000,
            2.307771443000,
            2.308020864000,
            2.308270487000,
            2.308520312000,
            2.308770340000,
            2.309020570000,
            2.309271003000,
            2.309521639000,
            2.309772478000,
            2.310023521000,
            2.310274767000,
            2.310526216000,
            2.310777870000,
            2.311029727000,
            2.311281788000,
            2.311534054000,
            2.311786524000,
            2.312039199000,
            2.312292078000,
            2.312545162000,
            2.312798452000,
            2.313051947000,
            2.313305647000,
            2.313559553000,
            2.313813664000,
            2.314067982000,
            2.314322505000,
            2.314577235000,
            2.314832171000,
            2.315087314000,
            2.315342664000,
            2.315598220000,
            2.315853984000,
            2.316109955000,
            2.316366134000,
            2.316622520000,
            2.316879113000,
            2.317135915000,
            2.317392925000,
            2.317650143000,
            2.317907570000,
            2.318165205000,
            2.318423049000,
            2.318681102000,
            2.318939364000,
            2.319197836000,
            2.319456516000,
            2.319715407000,
            2.319974507000,
            2.320233817000,
            2.320493338000,
            2.320753069000,
            2.321013010000,
            2.321273162000,
            2.321533525000,
            2.321794098000,
            2.322054883000,
            2.322315879000,
            2.322577087000,
            2.322838507000,
            2.323100138000,
            2.323361981000,
            2.323624037000,
            2.323886305000,
            2.324148785000,
            2.324411478000,
            2.324674384000,
            2.324937503000,
            2.325200836000,
            2.325464382000,
            2.325728141000,
            2.325992114000,
            2.326256301000,
            2.326520702000,
            2.326785317000,
            2.327050147000,
            2.327315192000,
            2.327580451000,
            2.327845925000,
            2.328111615000,
            2.328377519000,
            2.328643639000,
            2.328909975000,
            2.329176527000,
            2.329443295000,
            2.329710278000,
            2.329977479000,
            2.330244896000,
            2.330512529000,
            2.330780379000,
            2.331048447000,
            2.331316732000,
            2.331585234000,
            2.331853953000,
            2.332122891000,
            2.332392046000,
            2.332661420000,
            2.332931012000,
            2.333200822000,
            2.333470851000,
            2.333741099000,
            2.334011566000,
            2.334282252000,
            2.334553157000,
            2.334824282000,
            2.335095627000,
            2.335367192000,
            2.335638976000,
            2.335910981000,
            2.336183207000,
            2.336455653000,
            2.336728319000,
            2.337001207000,
            2.337274316000,
            2.337547646000,
            2.337821198000,
            2.338094971000,
            2.338368967000,
            2.338643184000,
            2.338917623000,
            2.339192285000,
            2.339467170000,
            2.339742277000,
            2.340017608000,
            2.340293161000,
            2.340568938000,
            2.340844938000,
            2.341121162000,
            2.341397609000,
            2.341674281000,
            2.341951177000,
            2.342228298000,
            2.342505643000,
            2.342783212000,
            2.343061007000,
            2.343339027000,
            2.343617272000,
            2.343895742000,
            2.344174439000,
            2.344453361000,
            2.344732509000,
            2.345011883000,
            2.345291484000,
            2.345571312000,
            2.345851366000,
            2.346131647000,
            2.346412155000,
            2.346692891000,
            2.346973854000,
            2.347255045000,
            2.347536463000,
            2.347818110000,
            2.348099985000,
            2.348382089000,
            2.348664421000,
            2.348946982000,
            2.349229771000,
            2.349512790000,
            2.349796039000,
            2.350079517000,
            2.350363224000,
            2.350647162000,
            2.350931330000,
            2.351215728000,
            2.351500356000,
            2.351785215000,
            2.352070305000,
            2.352355626000,
            2.352641179000,
            2.352926962000,
            2.353212977000,
            2.353499225000,
            2.353785704000,
            2.354072415000,
            2.354359358000,
            2.354646534000,
            2.354933943000,
            2.355221585000,
            2.355509460000,
            2.355797568000,
            2.356085910000,
            2.356374485000,
            2.356663294000,
            2.356952337000,
            2.357241615000,
            2.357531127000,
            2.357820873000,
            2.358110854000,
            2.358401071000,
            2.358691522000,
            2.358982209000,
            2.359273132000,
            2.359564290000,
            2.359855684000,
            2.360147315000,
            2.360439181000,
            2.360731284000,
            2.361023624000,
            2.361316201000,
            2.361609015000,
            2.361902067000,
            2.362195355000,
            2.362488882000,
            2.362782646000,
            2.363076648000,
            2.363370889000,
            2.363665368000,
            2.363960086000,
            2.364255043000,
            2.364550238000,
            2.364845673000,
            2.365141347000,
            2.365437261000,
            2.365733415000,
            2.366029809000,
            2.366326443000,
            2.366623317000,
            2.366920432000,
            2.367217788000,
            2.367515384000,
            2.367813222000,
            2.368111301000,
            2.368409622000,
            2.368708185000,
            2.369006989000,
            2.369306036000,
            2.369605325000,
            2.369904857000,
            2.370204631000,
            2.370504648000,
            2.370804908000,
            2.371105412000,
            2.371406159000,
            2.371707150000,
            2.372008385000,
            2.372309864000,
            2.372611588000,
            2.372913556000,
            2.373215768000,
            2.373518226000,
            2.373820928000,
            2.374123876000,
            2.374427070000,
            2.374730509000,
            2.375034194000,
            2.375338125000,
            2.375642302000,
            2.375946726000,
            2.376251397000,
            2.376556315000,
            2.376861479000,
            2.377166891000,
            2.377472551000,
            2.377778458000,
            2.378084613000,
            2.378391017000,
            2.378697668000,
            2.379004568000,
            2.379311717000,
            2.379619115000,
            2.379926762000,
            2.380234658000,
            2.380542803000,
            2.380851199000,
            2.381159844000,
            2.381468739000,
            2.381777885000,
            2.382087282000,
            2.382396929000,
            2.382706827000,
            2.383016976000,
            2.383327376000,
            2.383638028000,
            2.383948932000,
            2.384260088000,
            2.384571496000,
            2.384883156000,
            2.385195069000,
            2.385507235000,
            2.385819653000,
            2.386132325000,
            2.386445250000,
            2.386758429000,
            2.387071862000,
            2.387385548000,
            2.387699489000,
            2.388013684000,
            2.388328134000,
            2.388642839000,
            2.388957798000,
            2.389273013000,
            2.389588484000,
            2.389904210000,
            2.390220192000,
            2.390536430000,
            2.390852924000,
            2.391169675000,
            2.391486683000,
            2.391803947000,
            2.392121469000,
            2.392439247000,
            2.392757284000,
            2.393075578000,
            2.393394130000,
            2.393712940000,
            2.394032009000,
            2.394351336000,
            2.394670922000,
            2.394990767000,
            2.395310871000,
            2.395631235000,
            2.395951858000,
            2.396272741000,
            2.396593884000,
            2.396915287000,
            2.397236951000,
            2.397558876000,
            2.397881061000,
            2.398203507000,
            2.398526215000,
            2.398849185000,
            2.399172416000,
            2.399495909000,
            2.399819664000,
            2.400143681000,
            2.400467961000,
            2.400792504000,
            2.401117310000,
            2.401442379000,
            2.401767712000,
            2.402093308000,
            2.402419168000,
            2.402745293000,
            2.403071681000,
            2.403398334000,
            2.403725252000,
            2.404052435000,
            2.404379882000,
            2.404707596000,
            2.405035574000,
            2.405363819000,
            2.405692329000,
            2.406021106000,
            2.406350149000,
            2.406679459000,
            2.407009036000,
            2.407338880000,
            2.407668991000,
            2.407999370000,
            2.408330016000,
            2.408660931000,
            2.408992113000,
            2.409323564000,
            2.409655284000,
            2.409987272000,
            2.410319530000,
            2.410652056000,
            2.410984853000,
            2.411317919000,
            2.411651254000,
            2.411984860000,
            2.412318737000,
            2.412652884000,
            2.412987301000,
            2.413321990000,
            2.413656950000,
            2.413992181000,
            2.414327684000,
            2.414663459000,
            2.414999507000,
            2.415335826000,
            2.415672418000,
            2.416009283000,
            2.416346420000,
            2.416683831000,
            2.417021516000,
            2.417359474000,
            2.417697706000,
            2.418036212000,
            2.418374992000,
            2.418714047000,
            2.419053377000,
            2.419392982000,
            2.419732862000,
            2.420073017000,
            2.420413448000,
            2.420754155000,
            2.421095138000,
            2.421436397000,
            2.421777933000,
            2.422119746000,
            2.422461836000,
            2.422804203000,
            2.423146847000,
            2.423489769000,
            2.423832969000,
            2.424176447000,
            2.424520204000,
            2.424864239000,
            2.425208553000,
            2.425553146000,
            2.425898018000,
            2.426243170000,
            2.426588601000,
            2.426934312000,
            2.427280304000,
            2.427626576000,
            2.427973128000,
            2.428319962000,
            2.428667076000,
            2.429014472000,
            2.429362149000,
            2.429710108000,
            2.430058349000,
            2.430406873000,
            2.430755678000,
            2.431104767000,
            2.431454138000,
            2.431803792000,
            2.432153730000,
            2.432503951000,
            2.432854457000,
            2.433205246000,
            2.433556319000,
            2.433907677000,
            2.434259320000,
            2.434611248000,
            2.434963461000,
            2.435315959000,
            2.435668743000,
            2.436021813000,
            2.436375169000,
            2.436728812000,
            2.437082741000,
            2.437436957000,
            2.437791460000,
            2.438146250000,
            2.438501328000,
            2.438856693000,
            2.439212347000,
            2.439568289000,
            2.439924519000,
            2.440281038000,
            2.440637845000,
            2.440994942000,
            2.441352329000,
            2.441710005000,
            2.442067971000,
            2.442426227000,
            2.442784773000,
            2.443143610000,
            2.443502737000,
            2.443862156000,
            2.444221866000,
            2.444581868000,
            2.444942161000,
            2.445302746000,
            2.445663623000,
            2.446024793000,
            2.446386256000,
            2.446748011000,
            2.447110060000,
            2.447472402000,
            2.447835038000,
            2.448197968000,
            2.448561191000,
            2.448924710000,
            2.449288522000,
            2.449652630000,
            2.450017032000,
            2.450381730000,
            2.450746724000,
            2.451112013000,
            2.451477599000,
            2.451843480000,
            2.452209658000,
            2.452576133000,
            2.452942905000,
            2.453309974000,
            2.453677341000,
            2.454045005000,
            2.454412967000,
            2.454781228000,
            2.455149787000,
            2.455518644000,
            2.455887801000,
            2.456257256000,
            2.456627011000,
            2.456997066000,
            2.457367421000,
            2.457738076000,
            2.458109031000,
            2.458480287000,
            2.458851843000,
            2.459223701000,
            2.459595860000,
            2.459968321000,
            2.460341083000,
            2.460714148000,
            2.461087515000,
            2.461461185000,
            2.461835157000,
            2.462209432000,
            2.462584011000,
            2.462958894000,
            2.463334080000,
            2.463709570000,
            2.464085364000,
            2.464461463000,
            2.464837867000,
            2.465214576000,
            2.465591590000,
            2.465968910000,
            2.466346536000,
            2.466724467000,
            2.467102705000,
            2.467481249000,
            2.467860100000,
            2.468239259000,
            2.468618724000,
            2.468998497000,
            2.469378578000,
            2.469758966000,
            2.470139663000,
            2.470520669000,
            2.470901983000,
            2.471283606000,
            2.471665539000,
            2.472047781000,
            2.472430333000,
            2.472813195000,
            2.473196367000,
            2.473579850000,
            2.473963643000,
            2.474347748000,
            2.474732163000,
            2.475116891000,
            2.475501930000,
            2.475887281000,
            2.476272944000,
            2.476658920000,
            2.477045209000,
            2.477431811000,
            2.477818726000,
            2.478205955000,
            2.478593497000,
            2.478981354000,
            2.479369525000,
            2.479758010000,
            2.480146811000,
            2.480535926000,
            2.480925357000,
            2.481315103000,
            2.481705165000,
            2.482095544000,
            2.482486238000,
            2.482877250000,
            2.483268578000,
            2.483660223000,
            2.484052186000,
            2.484444466000,
            2.484837064000,
            2.485229981000,
            2.485623216000,
            2.486016769000,
            2.486410642000,
            2.486804833000,
            2.487199344000,
            2.487594175000,
            2.487989326000,
            2.488384797000,
            2.488780589000,
            2.489176701000,
            2.489573134000,
            2.489969889000,
            2.490366965000,
            2.490764363000,
            2.491162083000,
            2.491560125000,
            2.491958490000,
            2.492357178000,
            2.492756188000,
            2.493155523000,
            2.493555180000,
            2.493955162000,
            2.494355468000,
            2.494756098000,
            2.495157053000,
            2.495558333000,
            2.495959938000,
            2.496361868000,
            2.496764125000,
            2.497166707000,
            2.497569615000,
            2.497972850000,
            2.498376412000,
            2.498780301000,
            2.499184517000,
            2.499589061000,
            2.499993932000,
            2.500399132000,
            2.500804660000,
            2.501210517000,
            2.501616702000,
            2.502023217000,
            2.502430061000,
            2.502837235000,
            2.503244739000,
            2.503652574000,
            2.504060738000,
            2.504469234000,
            2.504878060000,
            2.505287218000,
            2.505696707000,
            2.506106529000,
            2.506516682000,
            2.506927168000,
            2.507337986000,
            2.507749138000,
            2.508160622000,
            2.508572440000,
            2.508984592000,
            2.509397078000,
            2.509809898000,
            2.510223053000,
            2.510636542000,
            2.511050367000,
            2.511464527000,
            2.511879022000,
            2.512293854000,
            2.512709021000,
            2.513124525000,
            2.513540366000,
            2.513956544000,
            2.514373059000,
            2.514789912000,
            2.515207102000,
            2.515624631000,
            2.516042498000,
            2.516460703000,
            2.516879248000,
            2.517298132000,
            2.517717355000,
            2.518136918000,
            2.518556821000,
            2.518977064000,
            2.519397648000,
            2.519818572000,
            2.520239838000,
            2.520661445000,
            2.521083394000,
            2.521505685000,
            2.521928318000,
            2.522351293000,
            2.522774612000,
            2.523198273000,
            2.523622278000,
            2.524046626000,
            2.524471318000,
            2.524896355000,
            2.525321736000,
            2.525747461000,
            2.526173532000,
            2.526599948000,
            2.527026709000,
            2.527453816000,
            2.527881270000,
            2.528309070000,
            2.528737216000,
            2.529165710000,
            2.529594550000,
            2.530023739000,
            2.530453275000,
            2.530883159000,
            2.531313392000,
            2.531743973000,
            2.532174903000,
            2.532606183000,
            2.533037812000,
            2.533469790000,
            2.533902119000,
            2.534334798000,
            2.534767828000,
            2.535201209000,
            2.535634941000,
            2.536069024000,
            2.536503460000,
            2.536938247000,
            2.537373387000,
            2.537808879000,
            2.538244724000,
            2.538680923000,
            2.539117475000,
            2.539554381000,
            2.539991640000,
            2.540429255000,
            2.540867224000,
            2.541305547000,
            2.541744226000,
            2.542183261000,
            2.542622651000,
            2.543062398000,
            2.543502500000,
            2.543942960000,
            2.544383776000,
            2.544824950000,
            2.545266481000,
            2.545708370000,
            2.546150617000,
            2.546593222000,
            2.547036187000,
            2.547479510000,
            2.547923192000,
            2.548367234000,
            2.548811636000,
            2.549256398000,
            2.549701521000,
            2.550147004000,
            2.550592848000,
            2.551039053000,
            2.551485621000,
            2.551932550000,
            2.552379841000,
            2.552827495000,
            2.553275511000,
            2.553723891000,
            2.554172634000,
            2.554621740000,
            2.555071211000,
            2.555521046000,
            2.555971245000,
            2.556421809000,
            2.556872738000,
            2.557324033000,
            2.557775694000,
            2.558227720000,
            2.558680113000,
            2.559132873000,
            2.559585999000,
            2.560039493000,
            2.560493354000,
            2.560947583000,
            2.561402180000,
            2.561857146000,
            2.562312480000,
            2.562768183000,
            2.563224256000,
            2.563680698000,
            2.564137510000,
            2.564594692000,
            2.565052245000,
            2.565510168000,
            2.565968463000,
            2.566427129000,
            2.566886167000,
            2.567345576000,
            2.567805359000,
            2.568265513000,
            2.568726041000,
            2.569186942000,
            2.569648216000,
            2.570109864000,
            2.570571886000,
            2.571034283000,
            2.571497055000,
            2.571960201000,
            2.572423723000,
            2.572887620000,
            2.573351894000,
            2.573816543000,
            2.574281570000,
            2.574746973000,
            2.575212753000,
            2.575678911000,
            2.576145446000,
            2.576612360000,
            2.577079652000,
            2.577547322000,
            2.578015372000,
            2.578483801000,
            2.578952610000,
            2.579421798000,
            2.579891367000,
            2.580361316000,
            2.580831646000,
            2.581302358000,
            2.581773450000,
            2.582244925000,
            2.582716782000,
            2.583189021000,
            2.583661642000,
            2.584134647000,
            2.584608035000,
            2.585081807000,
            2.585555963000,
            2.586030503000,
            2.586505427000,
            2.586980737000,
            2.587456431000,
            2.587932511000,
            2.588408977000,
            2.588885829000,
            2.589363068000,
            2.589840693000,
            2.590318705000,
            2.590797105000,
            2.591275893000,
            2.591755068000,
            2.592234632000,
            2.592714584000,
            2.593194925000,
            2.593675656000,
            2.594156776000,
            2.594638286000,
            2.595120187000,
            2.595602478000,
            2.596085159000,
            2.596568232000,
            2.597051697000,
            2.597535553000,
            2.598019801000,
            2.598504442000,
            2.598989476000,
            2.599474902000,
            2.599960722000,
            2.600446936000,
            2.600933544000,
            2.601420546000,
            2.601907942000,
            2.602395734000,
            2.602883921000,
            2.603372504000,
            2.603861482000,
            2.604350857000,
            2.604840629000,
            2.605330797000,
            2.605821363000,
            2.606312326000,
            2.606803687000,
            2.607295447000,
            2.607787604000,
            2.608280161000,
            2.608773117000,
            2.609266472000,
            2.609760227000,
            2.610254383000,
            2.610748938000,
            2.611243895000,
            2.611739253000,
            2.612235012000,
            2.612731173000,
            2.613227736000,
            2.613724701000,
            2.614222069000,
            2.614719841000,
            2.615218015000,
            2.615716593000,
            2.616215576000,
            2.616714963000,
            2.617214754000,
            2.617714951000,
            2.618215553000,
            2.618716560000,
            2.619217974000,
            2.619719794000,
            2.620222020000,
            2.620724654000,
            2.621227695000,
            2.621731144000,
            2.622235000000,
            2.622739265000,
            2.623243939000,
            2.623749021000,
            2.624254513000,
            2.624760415000,
            2.625266727000,
            2.625773449000,
            2.626280581000,
            2.626788125000,
            2.627296080000,
            2.627804446000,
            2.628313225000,
            2.628822415000,
            2.629332019000,
            2.629842035000,
            2.630352465000,
            2.630863309000,
            2.631374566000,
            2.631886238000,
            2.632398324000,
            2.632910826000,
            2.633423742000,
            2.633937075000,
            2.634450823000,
            2.634964988000,
            2.635479570000,
            2.635994568000,
            2.636509984000,
            2.637025817000,
            2.637542069000,
            2.638058739000,
            2.638575828000,
            2.639093335000,
            2.639611263000,
            2.640129609000,
            2.640648376000,
            2.641167564000,
            2.641687172000,
            2.642207201000,
            2.642727652000,
            2.643248524000,
            2.643769819000,
            2.644291536000,
            2.644813675000,
            2.645336238000,
            2.645859225000,
            2.646382635000,
            2.646906469000,
            2.647430728000,
            2.647955412000,
            2.648480521000,
            2.649006056000,
            2.649532016000,
            2.650058403000,
            2.650585216000,
            2.651112457000,
            2.651640124000,
            2.652168219000,
            2.652696742000,
            2.653225694000,
            2.653755074000,
            2.654284883000,
            2.654815122000,
            2.655345790000,
            2.655876888000,
            2.656408417000,
            2.656940376000,
            2.657472767000,
            2.658005589000,
            2.658538843000,
            2.659072528000,
            2.659606647000,
            2.660141198000,
            2.660676183000,
            2.661211601000,
            2.661747453000,
            2.662283739000,
            2.662820460000,
            2.663357616000,
            2.663895207000,
            2.664433234000,
            2.664971696000,
            2.665510596000,
            2.666049931000,
            2.666589704000,
            2.667129915000,
            2.667670563000,
            2.668211650000,
            2.668753174000,
            2.669295138000,
            2.669837541000,
            2.670380384000,
            2.670923666000,
            2.671467389000,
            2.672011552000,
            2.672556156000,
            2.673101202000,
            2.673646690000,
            2.674192619000,
            2.674738991000,
            2.675285806000,
            2.675833064000,
            2.676380765000,
            2.676928910000,
            2.677477499000,
            2.678026533000,
            2.678576012000,
            2.679125937000,
            2.679676307000,
            2.680227123000,
            2.680778385000,
            2.681330094000,
            2.681882250000,
            2.682434854000,
            2.682987905000,
            2.683541405000,
            2.684095353000,
            2.684649750000,
            2.685204597000,
            2.685759893000,
            2.686315639000,
            2.686871836000,
            2.687428483000,
            2.687985581000,
            2.688543131000,
            2.689101133000,
            2.689659587000,
            2.690218493000,
            2.690777853000,
            2.691337665000,
            2.691897932000,
            2.692458652000,
            2.693019827000,
            2.693581457000,
            2.694143542000,
            2.694706082000,
            2.695269078000,
            2.695832531000,
            2.696396440000,
            2.696960806000,
            2.697525629000,
            2.698090910000,
            2.698656650000,
            2.699222847000,
            2.699789504000,
            2.700356620000,
            2.700924195000,
            2.701492231000,
            2.702060727000,
            2.702629683000,
            2.703199101000,
            2.703768980000,
            2.704339321000,
            2.704910124000,
            2.705481389000,
            2.706053118000,
            2.706625310000,
            2.707197966000,
            2.707771085000,
            2.708344669000,
            2.708918719000,
            2.709493233000,
            2.710068213000,
            2.710643658000,
            2.711219571000,
            2.711795950000,
            2.712372796000,
            2.712950109000,
            2.713527890000,
            2.714106140000,
            2.714684858000,
            2.715264045000,
            2.715843702000,
            2.716423828000,
            2.717004425000,
            2.717585492000,
            2.718167030000,
            2.718749039000,
            2.719331520000,
            2.719914472000,
            2.720497898000,
            2.721081796000,
            2.721666167000,
            2.722251012000,
            2.722836331000,
            2.723422124000,
            2.724008392000,
            2.724595135000,
            2.725182354000,
            2.725770048000,
            2.726358219000,
            2.726946866000,
            2.727535991000,
            2.728125593000,
            2.728715672000,
            2.729306230000,
            2.729897267000,
            2.730488782000,
            2.731080777000,
            2.731673252000,
            2.732266206000,
            2.732859642000,
            2.733453558000,
            2.734047955000,
            2.734642835000,
            2.735238196000,
            2.735834040000,
            2.736430366000,
            2.737027176000,
            2.737624470000,
            2.738222248000,
            2.738820510000,
            2.739419257000,
            2.740018489000,
            2.740618207000,
            2.741218411000,
            2.741819101000,
            2.742420278000,
            2.743021942000,
            2.743624094000,
            2.744226734000,
            2.744829862000,
            2.745433479000,
            2.746037585000,
            2.746642181000,
            2.747247266000,
            2.747852843000,
            2.748458909000,
            2.749065467000,
            2.749672517000,
            2.750280058000,
            2.750888092000,
            2.751496619000,
            2.752105639000,
            2.752715152000,
            2.753325159000,
            2.753935661000,
            2.754546657000,
            2.755158149000,
            2.755770136000,
            2.756382619000,
            2.756995599000,
            2.757609075000,
            2.758223048000,
            2.758837519000,
            2.759452488000,
            2.760067955000,
            2.760683921000,
            2.761300387000,
            2.761917352000,
            2.762534816000,
            2.763152782000,
            2.763771248000,
            2.764390215000,
            2.765009684000,
            2.765629655000,
            2.766250128000,
            2.766871104000,
            2.767492584000,
            2.768114567000,
            2.768737054000,
            2.769360045000,
            2.769983542000,
            2.770607544000,
            2.771232051000,
            2.771857065000,
            2.772482585000,
            2.773108612000,
            2.773735146000,
            2.774362188000,
            2.774989738000,
            2.775617797000,
            2.776246365000,
            2.776875442000,
            2.777505029000,
            2.778135126000,
            2.778765734000,
            2.779396853000,
            2.780028484000,
            2.780660626000,
            2.781293280000,
            2.781926448000,
            2.782560128000,
            2.783194322000,
            2.783829030000,
            2.784464252000,
            2.785099989000,
            2.785736242000,
            2.786373009000,
            2.787010293000,
            2.787648094000,
            2.788286411000,
            2.788925246000,
            2.789564598000,
            2.790204468000,
            2.790844857000,
            2.791485765000,
            2.792127193000,
            2.792769140000,
            2.793411607000,
            2.794054595000,
            2.794698104000,
            2.795342135000,
            2.795986688000,
            2.796631763000,
            2.797277360000,
            2.797923481000,
            2.798570126000,
            2.799217294000,
            2.799864987000,
            2.800513205000,
            2.801161949000,
            2.801811218000,
            2.802461013000,
            2.803111335000,
            2.803762184000,
            2.804413560000,
            2.805065464000,
            2.805717896000,
            2.806370858000,
            2.807024348000,
            2.807678368000,
            2.808332918000,
            2.808987998000,
            2.809643610000,
            2.810299752000,
            2.810956427000,
            2.811613633000,
            2.812271372000,
            2.812929645000,
            2.813588450000,
            2.814247790000,
            2.814907664000,
            2.815568073000,
            2.816229016000,
            2.816890496000,
            2.817552512000,
            2.818215064000,
            2.818878153000,
            2.819541779000,
            2.820205943000,
            2.820870646000,
            2.821535887000,
            2.822201667000,
            2.822867987000,
            2.823534847000,
            2.824202247000,
            2.824870188000,
            2.825538670000,
            2.826207695000,
            2.826877261000,
            2.827547370000,
            2.828218022000,
            2.828889217000,
            2.829560957000,
            2.830233241000,
            2.830906069000,
            2.831579443000,
            2.832253363000,
            2.832927829000,
            2.833602841000,
            2.834278400000,
            2.834954507000,
            2.835631162000,
            2.836308365000,
            2.836986117000,
            2.837664419000,
            2.838343270000,
            2.839022671000,
            2.839702622000,
            2.840383125000,
            2.841064179000,
            2.841745786000,
            2.842427944000,
            2.843110655000,
            2.843793920000,
            2.844477738000,
            2.845162111000,
            2.845847038000,
            2.846532520000,
            2.847218558000,
            2.847905152000,
            2.848592302000,
            2.849280009000,
            2.849968273000,
            2.850657096000,
            2.851346476000,
            2.852036415000,
            2.852726913000,
            2.853417971000,
            2.854109589000,
            2.854801767000,
            2.855494506000,
            2.856187807000,
            2.856881669000,
            2.857576094000,
            2.858271082000,
            2.858966632000,
            2.859662747000,
            2.860359425000,
            2.861056669000,
            2.861754477000,
            2.862452851000,
            2.863151790000,
            2.863851297000,
            2.864551370000,
            2.865252010000,
            2.865953218000,
            2.866654995000,
            2.867357340000,
            2.868060254000,
            2.868763738000,
            2.869467792000,
            2.870172417000,
            2.870877613000,
            2.871583380000,
            2.872289719000,
            2.872996631000,
            2.873704115000,
            2.874412173000,
            2.875120805000,
            2.875830011000,
            2.876539792000,
            2.877250148000,
            2.877961079000,
            2.878672587000,
            2.879384671000,
            2.880097333000,
            2.880810572000,
            2.881524389000,
            2.882238784000,
            2.882953759000,
            2.883669312000,
            2.884385446000,
            2.885102160000,
            2.885819455000,
            2.886537332000,
            2.887255790000,
            2.887974830000,
            2.888694453000,
            2.889414659000,
            2.890135449000,
            2.890856823000,
            2.891578781000,
            2.892301325000,
            2.893024454000,
            2.893748169000,
            2.894472471000,
            2.895197360000,
            2.895922836000,
            2.896648900000,
            2.897375553000,
            2.898102794000,
            2.898830625000,
            2.899559046000,
            2.900288057000,
            2.901017658000,
            2.901747851000,
            2.902478636000,
            2.903210013000,
            2.903941983000,
            2.904674546000,
            2.905407702000,
            2.906141453000,
            2.906875798000,
            2.907610739000,
            2.908346275000,
            2.909082407000,
            2.909819136000,
            2.910556462000,
            2.911294385000,
            2.912032906000,
            2.912772026000,
            2.913511745000,
            2.914252064000,
            2.914992982000,
            2.915734501000,
            2.916476620000,
            2.917219341000,
            2.917962664000,
            2.918706590000,
            2.919451118000,
            2.920196250000,
            2.920941985000,
            2.921688325000,
            2.922435270000,
            2.923182820000,
            2.923930976000,
            2.924679738000,
            2.925429107000,
            2.926179083000,
            2.926929667000,
            2.927680859000,
            2.928432661000,
            2.929185071000,
            2.929938091000,
            2.930691722000,
            2.931445963000,
            2.932200815000,
            2.932956279000,
            2.933712356000,
            2.934469045000,
            2.935226347000,
            2.935984263000,
            2.936742793000,
            2.937501938000,
            2.938261698000,
            2.939022074000,
            2.939783067000,
            2.940544675000,
            2.941306901000,
            2.942069745000,
            2.942833207000,
            2.943597288000,
            2.944361988000,
            2.945127308000,
            2.945893247000,
            2.946659808000,
            2.947426990000,
            2.948194793000,
            2.948963219000,
            2.949732268000,
            2.950501940000,
            2.951272235000,
            2.952043155000,
            2.952814699000,
            2.953586869000,
            2.954359665000,
            2.955133087000,
            2.955907135000,
            2.956681811000,
            2.957457115000,
            2.958233047000,
            2.959009608000,
            2.959786798000,
            2.960564618000,
            2.961343069000,
            2.962122150000,
            2.962901863000,
            2.963682207000,
            2.964463184000,
            2.965244794000,
            2.966027037000,
            2.966809914000,
            2.967593426000,
            2.968377573000,
            2.969162355000,
            2.969947773000,
            2.970733828000,
            2.971520519000,
            2.972307848000,
            2.973095816000,
            2.973884421000,
            2.974673666000,
            2.975463551000,
            2.976254075000,
            2.977045241000,
            2.977837047000,
            2.978629495000,
            2.979422586000,
            2.980216319000,
            2.981010695000,
            2.981805715000,
            2.982601380000,
            2.983397689000,
            2.984194643000,
            2.984992244000,
            2.985790491000,
            2.986589384000,
            2.987388925000,
            2.988189114000,
            2.988989952000,
            2.989791439000,
            2.990593575000,
            2.991396361000,
            2.992199798000,
            2.993003885000,
            2.993808625000,
            2.994614017000,
            2.995420061000,
            2.996226759000,
            2.997034110000,
            2.997842116000,
            2.998650776000,
            2.999460092000,
            3.000270063000,
            3.001080692000,
            3.001891977000,
            3.002703919000,
            3.003516520000,
            3.004329779000,
            3.005143697000,
            3.005958274000,
            3.006773512000,
            3.007589411000,
            3.008405971000,
            3.009223192000,
            3.010041076000,
            3.010859622000,
            3.011678832000,
            3.012498706000,
            3.013319244000,
            3.014140448000,
            3.014962316000,
            3.015784851000,
            3.016608053000,
            3.017431921000,
            3.018256457000,
            3.019081662000,
            3.019907535000,
            3.020734077000,
            3.021561290000,
            3.022389172000,
            3.023217726000,
            3.024046951000,
            3.024876848000,
            3.025707418000,
            3.026538661000,
            3.027370577000,
            3.028203168000,
            3.029036433000,
            3.029870373000,
            3.030704990000,
            3.031540283000,
            3.032376252000,
            3.033212900000,
            3.034050225000,
            3.034888229000,
            3.035726912000,
            3.036566274000,
            3.037406317000,
            3.038247041000,
            3.039088446000,
            3.039930533000,
            3.040773302000,
            3.041616754000,
            3.042460890000,
            3.043305710000,
            3.044151214000,
            3.044997404000,
            3.045844280000,
            3.046691842000,
            3.047540090000,
            3.048389026000,
            3.049238651000,
            3.050088963000,
            3.050939965000,
            3.051791656000,
            3.052644038000,
            3.053497111000,
            3.054350874000,
            3.055205330000,
            3.056060478000,
            3.056916319000,
            3.057772854000,
            3.058630083000,
            3.059488006000,
            3.060346625000,
            3.061205940000,
            3.062065951000,
            3.062926659000,
            3.063788065000,
            3.064650168000,
            3.065512970000,
            3.066376472000,
            3.067240673000,
            3.068105575000,
            3.068971178000,
            3.069837482000,
            3.070704488000,
            3.071572197000,
            3.072440609000,
            3.073309724000,
            3.074179544000,
            3.075050069000,
            3.075921300000,
            3.076793236000,
            3.077665880000,
            3.078539230000,
            3.079413288000,
            3.080288055000,
            3.081163530000,
            3.082039715000,
            3.082916610000,
            3.083794215000,
            3.084672532000,
            3.085551561000,
            3.086431302000,
            3.087311756000,
            3.088192923000,
            3.089074805000,
            3.089957401000,
            3.090840713000,
            3.091724740000,
            3.092609484000,
            3.093494944000,
            3.094381123000,
            3.095268019000,
            3.096155635000,
            3.097043969000,
            3.097933024000,
            3.098822799000,
            3.099713295000,
            3.100604513000,
            3.101496453000,
            3.102389116000,
            3.103282502000,
            3.104176612000,
            3.105071447000,
            3.105967007000,
            3.106863293000,
            3.107760305000,
            3.108658045000,
            3.109556511000,
            3.110455706000,
            3.111355630000,
            3.112256282000,
            3.113157665000,
            3.114059778000,
            3.114962623000,
            3.115866199000,
            3.116770507000,
            3.117675548000,
            3.118581323000,
            3.119487831000,
            3.120395074000,
            3.121303053000,
            3.122211767000,
            3.123121218000,
            3.124031406000,
            3.124942331000,
            3.125853995000,
            3.126766397000,
            3.127679539000,
            3.128593421000,
            3.129508044000,
            3.130423407000,
            3.131339513000,
            3.132256361000,
            3.133173952000,
            3.134092286000,
            3.135011365000,
            3.135931189000,
            3.136851758000,
            3.137773073000,
            3.138695135000,
            3.139617944000,
            3.140541501000,
            3.141465806000,
            3.142390861000,
            3.143316665000,
            3.144243219000,
            3.145170524000,
            3.146098581000,
            3.147027390000,
            3.147956951000,
            3.148887266000,
            3.149818335000,
            3.150750158000,
            3.151682737000,
            3.152616071000,
            3.153550162000,
            3.154485010000,
            3.155420615000,
            3.156356978000,
            3.157294101000,
            3.158231983000,
            3.159170624000,
            3.160110027000,
            3.161050191000,
            3.161991117000,
            3.162932805000,
            3.163875256000,
            3.164818472000,
            3.165762451000,
            3.166707196000,
            3.167652706000,
            3.168598983000,
            3.169546026000,
            3.170493837000,
            3.171442416000,
            3.172391764000,
            3.173341881000,
            3.174292768000,
            3.175244425000,
            3.176196854000,
            3.177150055000,
            3.178104028000,
            3.179058775000,
            3.180014295000,
            3.180970589000,
            3.181927659000,
            3.182885504000,
            3.183844125000,
            3.184803523000,
            3.185763699000,
            3.186724653000,
            3.187686385000,
            3.188648897000,
            3.189612189000,
            3.190576262000,
            3.191541116000,
            3.192506752000,
            3.193473170000,
            3.194440372000,
            3.195408358000,
            3.196377127000,
            3.197346683000,
            3.198317023000,
            3.199288150000,
            3.200260065000,
            3.201232766000,
            3.202206257000,
            3.203180536000,
            3.204155604000,
            3.205131463000,
            3.206108113000,
            3.207085554000,
            3.208063787000,
            3.209042813000,
            3.210022632000,
            3.211003246000,
            3.211984654000,
            3.212966858000,
            3.213949857000,
            3.214933653000,
            3.215918247000,
            3.216903638000,
            3.217889828000,
            3.218876817000,
            3.219864606000,
            3.220853196000,
            3.221842586000,
            3.222832779000,
            3.223823774000,
            3.224815572000,
            3.225808174000,
            3.226801580000,
            3.227795791000,
            3.228790808000,
            3.229786632000,
            3.230783262000,
            3.231780700000,
            3.232778947000,
            3.233778002000,
            3.234777867000,
            3.235778542000,
            3.236780029000,
            3.237782327000,
            3.238785437000,
            3.239789360000,
            3.240794097000,
            3.241799648000,
            3.242806013000,
            3.243813195000,
            3.244821193000,
            3.245830007000,
            3.246839639000,
            3.247850090000,
            3.248861359000,
            3.249873448000,
            3.250886357000,
            3.251900086000,
            3.252914638000,
            3.253930011000,
            3.254946208000,
            3.255963228000,
            3.256981072000,
            3.257999741000,
            3.259019235000,
            3.260039556000,
            3.261060704000,
            3.262082679000,
            3.263105483000,
            3.264129115000,
            3.265153577000,
            3.266178869000,
            3.267204992000,
            3.268231946000,
            3.269259733000,
            3.270288353000,
            3.271317806000,
            3.272348094000,
            3.273379217000,
            3.274411175000,
            3.275443970000,
            3.276477601000,
            3.277512070000,
            3.278547378000,
            3.279583524000,
            3.280620511000,
            3.281658337000,
            3.282697005000,
            3.283736515000,
            3.284776866000,
            3.285818061000,
            3.286860100000,
            3.287902984000,
            3.288946712000,
            3.289991286000,
            3.291036707000,
            3.292082975000,
            3.293130091000,
            3.294178056000,
            3.295226869000,
            3.296276533000,
            3.297327048000,
            3.298378413000,
            3.299430631000,
            3.300483702000,
            3.301537626000,
            3.302592404000,
            3.303648037000,
            3.304704525000,
            3.305761870000,
            3.306820071000,
            3.307879130000,
            3.308939048000,
            3.309999824000,
            3.311061460000,
            3.312123956000,
            3.313187313000,
            3.314251532000,
            3.315316614000,
            3.316382559000,
            3.317449367000,
            3.318517040000,
            3.319585579000,
            3.320654983000,
            3.321725254000,
            3.322796392000,
            3.323868399000,
            3.324941274000,
            3.326015018000,
            3.327089633000,
            3.328165119000,
            3.329241476000,
            3.330318706000,
            3.331396808000,
            3.332475784000,
            3.333555635000,
            3.334636361000,
            3.335717962000,
            3.336800441000,
            3.337883796000,
            3.338968029000,
            3.340053141000,
            3.341139133000,
            3.342226004000,
            3.343313757000,
            3.344402390000,
            3.345491907000,
            3.346582306000,
            3.347673588000,
            3.348765755000,
            3.349858808000,
            3.350952746000,
            3.352047570000,
            3.353143282000,
            3.354239882000,
            3.355337370000,
            3.356435748000,
            3.357535016000,
            3.358635175000,
            3.359736225000,
            3.360838168000,
            3.361941004000,
            3.363044734000,
            3.364149358000,
            3.365254877000,
            3.366361292000,
            3.367468604000,
            3.368576813000,
            3.369685920000,
            3.370795926000,
            3.371906832000,
            3.373018638000,
            3.374131345000,
            3.375244953000,
            3.376359465000,
            3.377474879000,
            3.378591197000,
            3.379708420000,
            3.380826549000,
            3.381945583000,
            3.383065525000,
            3.384186374000,
            3.385308131000,
            3.386430798000,
            3.387554374000,
            3.388678861000,
            3.389804259000,
            3.390930569000,
            3.392057792000,
            3.393185928000,
            3.394314979000,
            3.395444945000,
            3.396575826000,
            3.397707624000,
            3.398840339000,
            3.399973972000,
            3.401108524000,
            3.402243996000,
            3.403380387000,
            3.404517699000,
            3.405655933000,
            3.406795090000,
            3.407935170000,
            3.409076173000,
            3.410218102000,
            3.411360955000,
            3.412504735000,
            3.413649442000,
            3.414795077000,
            3.415941640000,
            3.417089132000,
            3.418237554000,
            3.419386907000,
            3.420537191000,
            3.421688407000,
            3.422840557000,
            3.423993640000,
            3.425147657000,
            3.426302610000,
            3.427458499000,
            3.428615324000,
            3.429773087000,
            3.430931789000,
            3.432091429000,
            3.433252009000,
            3.434413530000,
            3.435575992000,
            3.436739396000,
            3.437903743000,
            3.439069033000,
            3.440235268000,
            3.441402448000,
            3.442570574000,
            3.443739646000,
            3.444909666000,
            3.446080634000,
            3.447252551000,
            3.448425418000,
            3.449599235000,
            3.450774004000,
            3.451949724000,
            3.453126398000,
            3.454304025000,
            3.455482606000,
            3.456662143000,
            3.457842635000,
            3.459024084000,
            3.460206491000,
            3.461389856000,
            3.462574179000,
            3.463759463000,
            3.464945707000,
            3.466132913000,
            3.467321080000,
            3.468510211000,
            3.469700305000,
            3.470891364000,
            3.472083388000,
            3.473276378000,
            3.474470334000,
            3.475665259000,
            3.476861151000,
            3.478058013000,
            3.479255845000,
            3.480454648000,
            3.481654422000,
            3.482855168000,
            3.484056888000,
            3.485259581000,
            3.486463249000,
            3.487667892000,
            3.488873512000,
            3.490080109000,
            3.491287684000,
            3.492496237000,
            3.493705770000,
            3.494916283000,
            3.496127777000,
            3.497340252000,
            3.498553711000,
            3.499768152000,
            3.500983578000,
            3.502199989000,
            3.503417386000,
            3.504635769000,
            3.505855140000,
            3.507075499000,
            3.508296847000,
            3.509519184000,
            3.510742513000,
            3.511966832000,
            3.513192144000,
            3.514418449000,
            3.515645748000,
            3.516874041000,
            3.518103330000,
            3.519333614000,
            3.520564896000,
            3.521797176000,
            3.523030455000,
            3.524264733000,
            3.525500011000,
            3.526736290000,
            3.527973571000,
            3.529211855000,
            3.530451142000,
            3.531691434000,
            3.532932731000,
            3.534175034000,
            3.535418343000,
            3.536662661000,
            3.537907986000,
            3.539154321000,
            3.540401666000,
            3.541650021000,
            3.542899389000,
            3.544149769000,
            3.545401162000,
            3.546653569000,
            3.547906992000,
            3.549161430000,
            3.550416884000,
            3.551673356000,
            3.552930847000,
            3.554189356000,
            3.555448886000,
            3.556709436000,
            3.557971007000,
            3.559233601000,
            3.560497219000,
            3.561761860000,
            3.563027526000,
            3.564294218000,
            3.565561937000,
            3.566830682000,
            3.568100456000,
            3.569371260000,
            3.570643092000,
            3.571915956000,
            3.573189851000,
            3.574464779000,
            3.575740740000,
            3.577017734000,
            3.578295764000,
            3.579574829000,
            3.580854931000,
            3.582136071000,
            3.583418249000,
            3.584701465000,
            3.585985722000,
            3.587271019000,
            3.588557358000,
            3.589844740000,
            3.591133165000,
            3.592422634000,
            3.593713148000,
            3.595004708000,
            3.596297314000,
            3.597590968000,
            3.598885671000,
            3.600181422000,
            3.601478224000,
            3.602776077000,
            3.604074981000,
            3.605374938000,
            3.606675949000,
            3.607978014000,
            3.609281134000,
            3.610585310000,
            3.611890544000,
            3.613196835000,
            3.614504184000,
            3.615812593000,
            3.617122063000,
            3.618432593000,
            3.619744186000,
            3.621056841000,
            3.622370561000,
            3.623685345000,
            3.625001194000,
            3.626318110000,
            3.627636094000,
            3.628955145000,
            3.630275265000,
            3.631596455000,
            3.632918716000,
            3.634242048000,
            3.635566453000,
            3.636891931000,
            3.638218484000,
            3.639546111000,
            3.640874814000,
            3.642204594000,
            3.643535452000,
            3.644867388000,
            3.646200404000,
            3.647534500000,
            3.648869677000,
            3.650205936000,
            3.651543278000,
            3.652881704000,
            3.654221215000,
            3.655561811000,
            3.656903494000,
            3.658246263000,
            3.659590121000,
            3.660935069000,
            3.662281106000,
            3.663628234000,
            3.664976453000,
            3.666325765000,
            3.667676171000,
            3.669027671000,
            3.670380267000,
            3.671733958000,
            3.673088747000,
            3.674444633000,
            3.675801619000,
            3.677159704000,
            3.678518890000,
            3.679879177000,
            3.681240566000,
            3.682603059000,
            3.683966656000,
            3.685331358000,
            3.686697166000,
            3.688064081000,
            3.689432104000,
            3.690801235000,
            3.692171476000,
            3.693542827000,
            3.694915290000,
            3.696288865000,
            3.697663553000,
            3.699039355000,
            3.700416273000,
            3.701794306000,
            3.703173455000,
            3.704553723000,
            3.705935109000,
            3.707317614000,
            3.708701240000,
            3.710085988000,
            3.711471857000,
            3.712858850000,
            3.714246966000,
            3.715636208000,
            3.717026575000,
            3.718418069000,
            3.719810691000,
            3.721204441000,
            3.722599321000,
            3.723995332000,
            3.725392473000,
            3.726790747000,
            3.728190155000,
            3.729590696000,
            3.730992372000,
            3.732395184000,
            3.733799133000,
            3.735204220000,
            3.736610445000,
            3.738017811000,
            3.739426316000,
            3.740835963000,
            3.742246753000,
            3.743658686000,
            3.745071763000,
            3.746485985000,
            3.747901353000,
            3.749317869000,
            3.750735532000,
            3.752154344000,
            3.753574306000,
            3.754995419000,
            3.756417683000,
            3.757841100000,
            3.759265671000,
            3.760691396000,
            3.762118277000,
            3.763546314000,
            3.764975508000,
            3.766405860000,
            3.767837372000,
            3.769270043000,
            3.770703876000,
            3.772138871000,
            3.773575029000,
            3.775012350000,
            3.776450837000,
            3.777890489000,
            3.779331307000,
            3.780773294000,
            3.782216449000,
            3.783660774000,
            3.785106269000,
            3.786552935000,
            3.788000774000,
            3.789449787000,
            3.790899973000,
            3.792351335000,
            3.793803873000,
            3.795257588000,
            3.796712482000,
            3.798168554000,
            3.799625806000,
            3.801084240000,
            3.802543855000,
            3.804004653000,
            3.805466635000,
            3.806929802000,
            3.808394154000,
            3.809859694000,
            3.811326421000,
            3.812794336000,
            3.814263441000,
            3.815733737000,
            3.817205225000,
            3.818677904000,
            3.820151778000,
            3.821626846000,
            3.823103109000,
            3.824580568000,
            3.826059225000,
            3.827539080000,
            3.829020135000,
            3.830502390000,
            3.831985846000,
            3.833470504000,
            3.834956365000,
            3.836443431000,
            3.837931701000,
            3.839421178000,
            3.840911862000,
            3.842403754000,
            3.843896855000,
            3.845391166000,
            3.846886688000,
            3.848383422000,
            3.849881369000,
            3.851380530000,
            3.852880906000,
            3.854382497000,
            3.855885306000,
            3.857389333000,
            3.858894578000,
            3.860401043000,
            3.861908730000,
            3.863417638000,
            3.864927768000,
            3.866439123000,
            3.867951702000,
            3.869465508000,
            3.870980540000,
            3.872496800000,
            3.874014288000,
            3.875533007000,
            3.877052956000,
            3.878574137000,
            3.880096551000,
            3.881620198000,
            3.883145081000,
            3.884671199000,
            3.886198554000,
            3.887727146000,
            3.889256978000,
            3.890788049000,
            3.892320361000,
            3.893853915000,
            3.895388712000,
            3.896924752000,
            3.898462037000,
            3.900000569000,
            3.901540347000,
            3.903081372000,
            3.904623647000,
            3.906167172000,
            3.907711947000,
            3.909257974000,
            3.910805255000,
            3.912353789000,
            3.913903578000,
            3.915454623000,
            3.917006925000,
            3.918560485000,
            3.920115304000,
            3.921671383000,
            3.923228724000,
            3.924787326000,
            3.926347191000,
            3.927908321000,
            3.929470715000,
            3.931034376000,
            3.932599304000,
            3.934165501000,
            3.935732966000,
            3.937301702000,
            3.938871709000,
            3.940442989000,
            3.942015541000,
            3.943589369000,
            3.945164471000,
            3.946740851000,
            3.948318507000,
            3.949897443000,
            3.951477657000,
            3.953059153000,
            3.954641930000,
            3.956225990000,
            3.957811333000,
            3.959397962000,
            3.960985876000,
            3.962575077000,
            3.964165566000,
            3.965757344000,
            3.967350412000,
            3.968944771000,
            3.970540422000,
            3.972137366000,
            3.973735604000,
            3.975335137000,
            3.976935967000,
            3.978538094000,
            3.980141520000,
            3.981746245000,
            3.983352270000,
            3.984959597000,
            3.986568227000,
            3.988178160000,
            3.989789398000,
            3.991401941000,
            3.993015792000,
            3.994630950000,
            3.996247418000,
            3.997865195000,
            3.999484283000,
            4.001104684000,
            4.002726397000,
            4.004349425000,
            4.005973769000,
            4.007599428000,
            4.009226405000,
            4.010854701000,
            4.012484316000,
            4.014115252000,
            4.015747509000,
            4.017381090000,
            4.019015994000,
            4.020652223000,
            4.022289778000,
            4.023928661000,
            4.025568871000,
            4.027210411000,
            4.028853281000,
            4.030497482000,
            4.032143016000,
            4.033789883000,
            4.035438085000,
            4.037087623000,
            4.038738498000,
            4.040390710000,
            4.042044262000,
            4.043699153000,
            4.045355386000,
            4.047012961000,
            4.048671879000,
            4.050332141000,
            4.051993749000,
            4.053656704000,
            4.055321006000,
            4.056986657000,
            4.058653658000,
            4.060322010000,
            4.061991714000,
            4.063662771000,
            4.065335183000,
            4.067008949000,
            4.068684072000,
            4.070360553000,
            4.072038392000,
            4.073717591000,
            4.075398151000,
            4.077080073000,
            4.078763358000,
            4.080448007000,
            4.082134021000,
            4.083821401000,
            4.085510150000,
            4.087200266000,
            4.088891752000,
            4.090584610000,
            4.092278839000,
            4.093974441000,
            4.095671417000,
            4.097369768000,
            4.099069496000,
            4.100770601000,
            4.102473085000,
            4.104176949000,
            4.105882193000,
            4.107588819000,
            4.109296829000,
            4.111006222000,
            4.112717001000,
            4.114429167000,
            4.116142719000,
            4.117857661000,
            4.119573992000,
            4.121291715000,
            4.123010829000,
            4.124731337000,
            4.126453238000,
            4.128176536000,
            4.129901230000,
            4.131627321000,
            4.133354812000,
            4.135083702000,
            4.136813993000,
            4.138545687000,
            4.140278784000,
            4.142013286000,
            4.143749193000,
            4.145486507000,
            4.147225229000,
            4.148965361000,
            4.150706902000,
            4.152449855000,
            4.154194220000,
            4.155939999000,
            4.157687192000,
            4.159435802000,
            4.161185828000,
            4.162937273000,
            4.164690138000,
            4.166444422000,
            4.168200129000,
            4.169957258000,
            4.171715812000,
            4.173475790000,
            4.175237195000,
            4.177000027000,
            4.178764288000,
            4.180529979000,
            4.182297100000,
            4.184065654000,
            4.185835641000,
            4.187607062000,
            4.189379919000,
            4.191154213000,
            4.192929944000,
            4.194707115000,
            4.196485726000,
            4.198265778000,
            4.200047273000,
            4.201830212000,
            4.203614595000,
            4.205400425000,
            4.207187702000,
            4.208976427000,
            4.210766602000,
            4.212558227000,
            4.214351305000,
            4.216145835000,
            4.217941820000,
            4.219739261000,
            4.221538158000,
            4.223338513000,
            4.225140327000,
            4.226943601000,
            4.228748337000,
            4.230554535000,
            4.232362197000,
            4.234171324000,
            4.235981917000,
            4.237793977000,
            4.239607506000,
            4.241422505000,
            4.243238974000,
            4.245056916000,
            4.246876331000,
            4.248697220000,
            4.250519585000,
            4.252343427000,
            4.254168746000,
            4.255995546000,
            4.257823825000,
            4.259653586000,
            4.261484830000,
            4.263317559000,
            4.265151772000,
            4.266987472000,
            4.268824659000,
            4.270663336000,
            4.272503502000,
            4.274345160000,
            4.276188310000,
            4.278032954000,
            4.279879093000,
            4.281726728000,
            4.283575861000,
            4.285426491000,
            4.287278622000,
            4.289132254000,
            4.290987388000,
            4.292844025000,
            4.294702167000,
            4.296561815000,
            4.298422969000,
            4.300285633000,
            4.302149805000,
            4.304015489000,
            4.305882684000,
            4.307751393000,
            4.309621616000,
            4.311493354000,
            4.313366610000,
            4.315241383000,
            4.317117676000,
            4.318995490000,
            4.320874825000,
            4.322755684000,
            4.324638066000,
            4.326521974000,
            4.328407409000,
            4.330294372000,
            4.332182864000,
            4.334072886000,
            4.335964441000,
            4.337857528000,
            4.339752149000,
            4.341648306000,
            4.343545999000,
            4.345445230000,
            4.347346001000,
            4.349248312000,
            4.351152164000,
            4.353057559000,
            4.354964499000,
            4.356872984000,
            4.358783015000,
            4.360694595000,
            4.362607724000,
            4.364522403000,
            4.366438633000,
            4.368356417000,
            4.370275755000,
            4.372196648000,
            4.374119098000,
            4.376043106000,
            4.377968673000,
            4.379895801000,
            4.381824491000,
            4.383754743000,
            4.385686560000,
            4.387619942000,
            4.389554891000,
            4.391491409000,
            4.393429495000,
            4.395369153000,
            4.397310382000,
            4.399253184000,
            4.401197561000,
            4.403143514000,
            4.405091044000,
            4.407040151000,
            4.408990839000,
            4.410943107000,
            4.412896958000,
            4.414852392000,
            4.416809410000,
            4.418768015000,
            4.420728207000,
            4.422689987000,
            4.424653358000,
            4.426618319000,
            4.428584873000,
            4.430553020000,
            4.432522763000,
            4.434494102000,
            4.436467038000,
            4.438441574000,
            4.440417709000,
            4.442395446000,
            4.444374786000,
            4.446355730000,
            4.448338279000,
            4.450322435000,
            4.452308199000,
            4.454295572000,
            4.456284556000,
            4.458275151000,
            4.460267360000,
            4.462261183000,
            4.464256623000,
            4.466253679000,
            4.468252354000,
            4.470252648000,
            4.472254563000,
            4.474258101000,
            4.476263263000,
            4.478270049000,
            4.480278462000,
            4.482288503000,
            4.484300172000,
            4.486313472000,
            4.488328403000,
            4.490344968000,
            4.492363166000,
            4.494383000000,
            4.496404471000,
            4.498427580000,
            4.500452329000,
            4.502478719000,
            4.504506751000,
            4.506536426000,
            4.508567746000,
            4.510600713000,
            4.512635326000,
            4.514671589000,
            4.516709502000,
            4.518749067000,
            4.520790284000,
            4.522833156000,
            4.524877683000,
            4.526923867000,
            4.528971710000,
            4.531021212000,
            4.533072375000,
            4.535125200000,
            4.537179689000,
            4.539235842000,
            4.541293663000,
            4.543353150000,
            4.545414307000,
            4.547477134000,
            4.549541633000,
            4.551607805000,
            4.553675652000,
            4.555745174000,
            4.557816373000,
            4.559889251000,
            4.561963809000,
            4.564040048000,
            4.566117970000,
            4.568197576000,
            4.570278867000,
            4.572361844000,
            4.574446510000,
            4.576532865000,
            4.578620911000,
            4.580710649000,
            4.582802081000,
            4.584895208000,
            4.586990031000,
            4.589086551000,
            4.591184771000,
            4.593284691000,
            4.595386312000,
            4.597489637000,
            4.599594667000,
            4.601701402000,
            4.603809845000,
            4.605919997000,
            4.608031858000,
            4.610145431000,
            4.612260717000,
            4.614377717000,
            4.616496433000,
            4.618616866000,
            4.620739017000,
            4.622862888000,
            4.624988480000,
            4.627115795000,
            4.629244834000,
            4.631375598000,
            4.633508089000,
            4.635642309000,
            4.637778257000,
            4.639915937000,
            4.642055349000,
            4.644196495000,
            4.646339377000,
            4.648483994000,
            4.650630350000,
            4.652778446000,
            4.654928282000,
            4.657079860000,
            4.659233182000,
            4.661388249000,
            4.663545063000,
            4.665703624000,
            4.667863935000,
            4.670025996000,
            4.672189810000,
            4.674355377000,
            4.676522699000,
            4.678691778000,
            4.680862615000,
            4.683035210000,
            4.685209567000,
            4.687385685000,
            4.689563568000,
            4.691743215000,
            4.693924628000,
            4.696107809000,
            4.698292760000,
            4.700479481000,
            4.702667975000,
            4.704858242000,
            4.707050284000,
            4.709244102000,
            4.711439699000,
            4.713637074000,
            4.715836231000,
            4.718037170000,
            4.720239892000,
            4.722444399000,
            4.724650693000,
            4.726858776000,
            4.729068647000,
            4.731280309000,
            4.733493764000,
            4.735709013000,
            4.737926056000,
            4.740144897000,
            4.742365536000,
            4.744587974000,
            4.746812213000,
            4.749038255000,
            4.751266101000,
            4.753495752000,
            4.755727211000,
            4.757960478000,
            4.760195554000,
            4.762432442000,
            4.764671143000,
            4.766911658000,
            4.769153988000,
            4.771398136000,
            4.773644103000,
            4.775891890000,
            4.778141498000,
            4.780392929000,
            4.782646185000,
            4.784901268000,
            4.787158177000,
            4.789416916000,
            4.791677485000,
            4.793939886000,
            4.796204121000,
            4.798470190000,
            4.800738096000,
            4.803007840000,
            4.805279424000,
            4.807552848000,
            4.809828115000,
            4.812105225000,
            4.814384181000,
            4.816664984000,
            4.818947635000,
            4.821232137000,
            4.823518489000,
            4.825806694000,
            4.828096754000,
            4.830388670000,
            4.832682443000,
            4.834978075000,
            4.837275567000,
            4.839574921000,
            4.841876139000,
            4.844179222000,
            4.846484171000,
            4.848790988000,
            4.851099674000,
            4.853410232000,
            4.855722662000,
            4.858036966000,
            4.860353145000,
            4.862671202000,
            4.864991137000,
            4.867312952000,
            4.869636649000,
            4.871962229000,
            4.874289693000,
            4.876619044000,
            4.878950283000,
            4.881283411000,
            4.883618429000,
            4.885955340000,
            4.888294145000,
            4.890634845000,
            4.892977442000,
            4.895321938000,
            4.897668333000,
            4.900016631000,
            4.902366831000,
            4.904718936000,
            4.907072947000,
            4.909428865000,
            4.911786693000,
            4.914146432000,
            4.916508083000,
            4.918871648000,
            4.921237129000,
            4.923604526000,
            4.925973842000,
            4.928345078000,
            4.930718236000,
            4.933093317000,
            4.935470323000,
            4.937849255000,
            4.940230115000,
            4.942612905000,
            4.944997625000,
            4.947384279000,
            4.949772866000,
            4.952163389000,
            4.954555850000,
            4.956950249000,
            4.959346589000,
            4.961744870000,
            4.964145096000,
            4.966547266000,
            4.968951383000,
            4.971357449000,
            4.973765464000,
            4.976175431000,
            4.978587351000,
            4.981001226000,
            4.983417057000,
            4.985834845000,
            4.988254593000,
            4.990676303000,
            4.993099974000,
            4.995525610000,
            4.997953211000,
            5.000382780000,
            5.002814318000,
            5.005247827000,
            5.007683307000,
            5.010120761000,
            5.012560191000,
            5.015001598000,
            5.017444983000,
            5.019890348000,
            5.022337695000,
            5.024787025000,
            5.027238340000,
            5.029691642000,
            5.032146932000,
            5.034604212000,
            5.037063483000,
            5.039524747000,
            5.041988006000,
            5.044453261000,
            5.046920514000,
            5.049389767000,
            5.051861020000,
            5.054334277000,
            5.056809537000,
            5.059286804000,
            5.061766078000,
            5.064247362000,
            5.066730656000,
            5.069215963000,
            5.071703284000,
            5.074192620000,
            5.076683974000,
            5.079177347000,
            5.081672741000,
            5.084170157000,
            5.086669597000,
            5.089171062000,
            5.091674555000,
            5.094180076000,
            5.096687629000,
            5.099197213000,
            5.101708831000,
            5.104222484000,
            5.106738175000,
            5.109255904000,
            5.111775673000,
            5.114297485000,
            5.116821340000,
            5.119347241000,
            5.121875189000,
            5.124405185000,
            5.126937232000,
            5.129471331000,
            5.132007483000,
            5.134545691000,
            5.137085956000,
            5.139628279000,
            5.142172663000,
            5.144719108000,
            5.147267618000,
            5.149818192000,
            5.152370834000,
            5.154925544000,
            5.157482325000,
            5.160041178000,
            5.162602104000,
            5.165165106000,
            5.167730185000,
            5.170297343000,
            5.172866581000,
            5.175437901000,
            5.178011306000,
            5.180586795000,
            5.183164372000,
            5.185744038000,
            5.188325794000,
            5.190909643000,
            5.193495585000,
            5.196083624000,
            5.198673759000,
            5.201265994000,
            5.203860329000,
            5.206456767000,
            5.209055309000,
            5.211655957000,
            5.214258713000,
            5.216863578000,
            5.219470554000,
            5.222079642000,
            5.224690845000,
            5.227304164000,
            5.229919601000,
            5.232537158000,
            5.235156836000,
            5.237778637000,
            5.240402562000,
            5.243028615000,
            5.245656795000,
            5.248287105000,
            5.250919547000,
            5.253554122000,
            5.256190832000,
            5.258829679000,
            5.261470665000,
            5.264113791000,
            5.266759059000,
            5.269406470000,
            5.272056027000,
            5.274707732000,
            5.277361585000,
            5.280017589000,
            5.282675745000,
            5.285336056000,
            5.287998523000,
            5.290663147000,
            5.293329931000,
            5.295998876000,
            5.298669984000,
            5.301343256000,
            5.304018695000,
            5.306696302000,
            5.309376079000,
            5.312058028000,
            5.314742151000,
            5.317428448000,
            5.320116923000,
            5.322807576000,
            5.325500410000,
            5.328195426000,
            5.330892626000,
            5.333592012000,
            5.336293586000,
            5.338997349000,
            5.341703303000,
            5.344411451000,
            5.347121792000,
            5.349834331000,
            5.352549067000,
            5.355266004000,
            5.357985142000,
            5.360706485000,
            5.363430032000,
            5.366155787000,
            5.368883750000,
            5.371613925000,
            5.374346312000,
            5.377080913000,
            5.379817731000,
            5.382556766000,
            5.385298021000,
            5.388041498000,
            5.390787198000,
            5.393535123000,
            5.396285275000,
            5.399037656000,
            5.401792268000,
            5.404549111000,
            5.407308189000,
            5.410069503000,
            5.412833055000,
            5.415598846000,
            5.418366879000,
            5.421137155000,
            5.423909676000,
            5.426684444000,
            5.429461461000,
            5.432240728000,
            5.435022247000,
            5.437806021000,
            5.440592051000,
            5.443380338000,
            5.446170885000,
            5.448963694000,
            5.451758766000,
            5.454556103000,
            5.457355707000,
            5.460157580000,
            5.462961724000,
            5.465768140000,
            5.468576830000,
            5.471387797000,
            5.474201041000,
            5.477016566000,
            5.479834372000,
            5.482654462000,
            5.485476837000,
            5.488301500000,
            5.491128452000,
            5.493957694000,
            5.496789230000,
            5.499623060000,
            5.502459187000,
            5.505297612000,
            5.508138337000,
            5.510981365000,
            5.513826697000,
            5.516674334000,
            5.519524279000,
            5.522376534000,
            5.525231101000,
            5.528087980000,
            5.530947175000,
            5.533808688000,
            5.536672519000,
            5.539538671000,
            5.542407145000,
            5.545277945000,
            5.548151071000,
            5.551026525000,
            5.553904310000,
            5.556784426000,
            5.559666877000,
            5.562551664000,
            5.565438789000,
            5.568328253000,
            5.571220059000,
            5.574114209000,
            5.577010704000,
            5.579909547000,
            5.582810738000,
            5.585714281000,
            5.588620177000,
            5.591528428000,
            5.594439035000,
            5.597352002000,
            5.600267329000,
            5.603185019000,
            5.606105073000,
            5.609027494000,
            5.611952283000,
            5.614879443000,
            5.617808974000,
            5.620740880000,
            5.623675162000,
            5.626611821000,
            5.629550861000,
            5.632492283000,
            5.635436088000,
            5.638382279000,
            5.641330857000,
            5.644281825000,
            5.647235185000,
            5.650190938000,
            5.653149086000,
            5.656109632000,
            5.659072577000,
            5.662037923000,
            5.665005672000,
            5.667975827000,
            5.670948388000,
            5.673923358000,
            5.676900740000,
            5.679880534000,
            5.682862743000,
            5.685847369000,
            5.688834414000,
            5.691823879000,
            5.694815767000,
            5.697810080000,
            5.700806819000,
            5.703805987000,
            5.706807585000,
            5.709811617000,
            5.712818082000,
            5.715826984000,
            5.718838324000,
            5.721852105000,
            5.724868328000,
            5.727886996000,
            5.730908110000,
            5.733931672000,
            5.736957685000,
            5.739986150000,
            5.743017069000,
            5.746050445000,
            5.749086278000,
            5.752124573000,
            5.755165329000,
            5.758208549000,
            5.761254236000,
            5.764302391000,
            5.767353017000,
            5.770406114000,
            5.773461686000,
            5.776519734000,
            5.779580261000,
            5.782643267000,
            5.785708756000,
            5.788776729000,
            5.791847189000,
            5.794920137000,
            5.797995575000,
            5.801073506000,
            5.804153931000,
            5.807236852000,
            5.810322272000,
            5.813410192000,
            5.816500615000,
            5.819593542000,
            5.822688976000,
            5.825786918000,
            5.828887371000,
            5.831990337000,
            5.835095817000,
            5.838203814000,
            5.841314330000,
            5.844427366000,
            5.847542926000,
            5.850661010000,
            5.853781621000,
            5.856904761000,
            5.860030432000,
            5.863158637000,
            5.866289376000,
            5.869422653000,
            5.872558468000,
            5.875696825000,
            5.878837726000,
            5.881981172000,
            5.885127165000,
            5.888275708000,
            5.891426802000,
            5.894580450000,
            5.897736654000,
            5.900895416000,
            5.904056738000,
            5.907220621000,
            5.910387069000,
            5.913556082000,
            5.916727664000,
            5.919901816000,
            5.923078541000,
            5.926257840000,
            5.929439715000,
            5.932624170000,
            5.935811204000,
            5.939000822000,
            5.942193025000,
            5.945387814000,
            5.948585193000,
            5.951785163000,
            5.954987726000,
            5.958192884000,
            5.961400640000,
            5.964610996000,
            5.967823953000,
            5.971039514000,
            5.974257681000,
            5.977478456000,
            5.980701841000,
            5.983927839000,
            5.987156451000,
            5.990387679000,
            5.993621526000,
            5.996857994000,
            6.000097084000,
            6.003338800000,
            6.006583142000,
            6.009830114000,
            6.013079717000,
            6.016331954000,
            6.019586827000,
            6.022844337000,
            6.026104487000,
            6.029367279000,
            6.032632715000,
            6.035900798000,
            6.039171529000,
            6.042444911000,
            6.045720946000,
            6.048999635000,
            6.052280982000,
            6.055564988000,
            6.058851655000,
            6.062140986000,
            6.065432982000,
            6.068727647000,
            6.072024981000,
            6.075324988000,
            6.078627668000,
            6.081933026000,
            6.085241062000,
            6.088551779000,
            6.091865179000,
            6.095181264000,
            6.098500037000,
            6.101821499000,
            6.105145653000,
            6.108472501000,
            6.111802045000,
            6.115134287000,
            6.118469230000,
            6.121806875000,
            6.125147225000,
            6.128490283000,
            6.131836049000,
            6.135184527000,
            6.138535719000,
            6.141889626000,
            6.145246252000,
            6.148605598000,
            6.151967666000,
            6.155332459000,
            6.158699978000,
            6.162070227000,
            6.165443207000,
            6.168818921000,
            6.172197370000,
            6.175578557000,
            6.178962485000,
            6.182349154000,
            6.185738569000,
            6.189130730000,
            6.192525640000,
            6.195923301000,
            6.199323716000,
            6.202726887000,
            6.206132815000,
            6.209541504000,
            6.212952955000,
            6.216367171000,
            6.219784154000,
            6.223203906000,
            6.226626429000,
            6.230051726000,
            6.233479799000,
            6.236910650000,
            6.240344282000,
            6.243780696000,
            6.247219895000,
            6.250661881000,
            6.254106656000,
            6.257554224000,
            6.261004585000,
            6.264457742000,
            6.267913698000,
            6.271372455000,
            6.274834014000,
            6.278298379000,
            6.281765551000,
            6.285235534000,
            6.288708328000,
            6.292183937000,
            6.295662362000,
            6.299143606000,
            6.302627672000,
            6.306114561000,
            6.309604276000,
            6.313096819000,
            6.316592192000,
            6.320090399000,
            6.323591440000,
            6.327095318000,
            6.330602036000,
            6.334111596000,
            6.337624000000,
            6.341139250000,
            6.344657349000,
            6.348178300000,
            6.351702103000,
            6.355228763000,
            6.358758280000,
            6.362290658000,
            6.365825899000,
            6.369364004000,
            6.372904977000,
            6.376448820000,
            6.379995534000,
            6.383545123000,
            6.387097588000,
            6.390652932000,
            6.394211158000,
            6.397772267000,
            6.401336262000,
            6.404903146000,
            6.408472920000,
            6.412045587000,
            6.415621149000,
            6.419199609000,
            6.422780970000,
            6.426365232000,
            6.429952399000,
            6.433542473000,
            6.437135457000,
            6.440731352000,
            6.444330162000,
            6.447931888000,
            6.451536533000,
            6.455144099000,
            6.458754589000,
            6.462368005000,
            6.465984349000,
            6.469603624000,
            6.473225832000,
            6.476850975000,
            6.480479057000,
            6.484110078000,
            6.487744042000,
            6.491380951000,
            6.495020808000,
            6.498663614000,
            6.502309373000,
            6.505958086000,
            6.509609756000,
            6.513264385000,
            6.516921976000,
            6.520582531000,
            6.524246053000,
            6.527912543000,
            6.531582005000,
            6.535254441000,
            6.538929853000,
            6.542608244000,
            6.546289615000,
            6.549973970000,
            6.553661311000,
            6.557351640000,
            6.561044960000,
            6.564741273000,
            6.568440581000,
            6.572142888000,
            6.575848194000,
            6.579556504000,
            6.583267819000,
            6.586982141000,
            6.590699474000,
            6.594419819000,
            6.598143179000,
            6.601869557000,
            6.605598954000,
            6.609331374000,
            6.613066818000,
            6.616805290000,
            6.620546792000,
            6.624291326000,
            6.628038894000,
            6.631789499000,
            6.635543144000,
            6.639299831000,
            6.643059562000,
            6.646822340000,
            6.650588168000,
            6.654357048000,
            6.658128981000,
            6.661903972000,
            6.665682022000,
            6.669463134000,
            6.673247310000,
            6.677034552000,
            6.680824864000,
            6.684618248000,
            6.688414706000,
            6.692214240000,
            6.696016854000,
            6.699822549000,
            6.703631329000,
            6.707443195000,
            6.711258150000,
            6.715076197000,
            6.718897338000,
            6.722721576000,
            6.726548913000,
            6.730379352000,
            6.734212895000,
            6.738049545000,
            6.741889304000,
            6.745732174000,
            6.749578160000,
            6.753427261000,
            6.757279483000,
            6.761134826000,
            6.764993293000,
            6.768854888000,
            6.772719612000,
            6.776587468000,
            6.780458458000,
            6.784332586000,
            6.788209853000,
            6.792090262000,
            6.795973816000,
            6.799860518000,
            6.803750369000,
            6.807643372000,
            6.811539531000,
            6.815438847000,
            6.819341323000,
            6.823246962000,
            6.827155765000,
            6.831067737000,
            6.834982879000,
            6.838901193000,
            6.842822683000,
            6.846747351000,
            6.850675200000,
            6.854606232000,
            6.858540450000,
            6.862477856000,
            6.866418452000,
            6.870362243000,
            6.874309229000,
            6.878259414000,
            6.882212801000,
            6.886169391000,
            6.890129188000,
            6.894092193000,
            6.898058411000,
            6.902027842000,
            6.906000491000,
            6.909976359000,
            6.913955449000,
            6.917937764000,
            6.921923306000,
            6.925912078000,
            6.929904082000,
            6.933899322000,
            6.937897800000,
            6.941899517000,
            6.945904478000,
            6.949912685000,
            6.953924140000,
            6.957938845000,
            6.961956805000,
            6.965978020000,
            6.970002495000,
            6.974030230000,
            6.978061230000,
            6.982095497000,
            6.986133033000,
            6.990173841000,
            6.994217924000,
            6.998265284000,
            7.002315925000,
            7.006369847000,
            7.010427056000,
            7.014487552000,
            7.018551339000,
            7.022618419000,
            7.026688795000,
            7.030762470000,
            7.034839446000,
            7.038919727000,
            7.043003314000,
            7.047090210000,
            7.051180418000,
            7.055273942000,
            7.059370782000,
            7.063470943000,
            7.067574426000,
            7.071681235000,
            7.075791373000,
            7.079904841000,
            7.084021642000,
            7.088141780000,
            7.092265257000,
            7.096392076000,
            7.100522239000,
            7.104655749000,
            7.108792609000,
            7.112932822000,
            7.117076390000,
            7.121223316000,
            7.125373602000,
            7.129527252000,
            7.133684268000,
            7.137844653000,
            7.142008410000,
            7.146175541000,
            7.150346049000,
            7.154519937000,
            7.158697207000,
            7.162877863000,
            7.167061907000,
            7.171249341000,
            7.175440169000,
            7.179634394000,
            7.183832017000,
            7.188033043000,
            7.192237472000,
            7.196445309000,
            7.200656557000,
            7.204871217000,
            7.209089292000,
            7.213310786000,
            7.217535701000,
            7.221764040000,
            7.225995806000,
            7.230231001000,
            7.234469628000,
            7.238711691000,
            7.242957191000,
            7.247206132000,
            7.251458516000,
            7.255714346000,
            7.259973626000,
            7.264236357000,
            7.268502542000,
            7.272772185000,
            7.277045289000,
            7.281321855000,
            7.285601887000,
            7.289885387000,
            7.294172359000,
            7.298462805000,
            7.302756728000,
            7.307054131000,
            7.311355016000,
            7.315659387000,
            7.319967247000,
            7.324278597000,
            7.328593442000,
            7.332911783000,
            7.337233624000,
            7.341558967000,
            7.345887816000,
            7.350220172000,
            7.354556040000,
            7.358895422000,
            7.363238320000,
            7.367584738000,
            7.371934678000,
            7.376288143000,
            7.380645136000,
            7.385005661000,
            7.389369719000,
            7.393737314000,
            7.398108448000,
            7.402483125000,
            7.406861347000,
            7.411243117000,
            7.415628439000,
            7.420017314000,
            7.424409746000,
            7.428805738000,
            7.433205292000,
            7.437608411000,
            7.442015099000,
            7.446425358000,
            7.450839192000,
            7.455256602000,
            7.459677592000,
            7.464102165000,
            7.468530324000,
            7.472962071000,
            7.477397410000,
            7.481836344000,
            7.486278874000,
            7.490725005000,
            7.495174739000,
            7.499628080000,
            7.504085029000,
            7.508545590000,
            7.513009766000,
            7.517477560000,
            7.521948975000,
            7.526424013000,
            7.530902678000,
            7.535384972000,
            7.539870899000,
            7.544360462000,
            7.548853663000,
            7.553350505000,
            7.557850991000,
            7.562355125000,
            7.566862909000,
            7.571374346000,
            7.575889439000,
            7.580408191000,
            7.584930605000,
            7.589456684000,
            7.593986431000,
            7.598519850000,
            7.603056942000,
            7.607597711000,
            7.612142159000,
            7.616690291000,
            7.621242109000,
            7.625797615000,
            7.630356813000,
            7.634919706000,
            7.639486297000,
            7.644056589000,
            7.648630584000,
            7.653208287000,
            7.657789699000,
            7.662374823000,
            7.666963664000,
            7.671556224000,
            7.676152505000,
            7.680752511000,
            7.685356246000,
            7.689963711000,
            7.694574910000,
            7.699189846000,
            7.703808522000,
            7.708430941000,
            7.713057106000,
            7.717687020000,
            7.722320686000,
            7.726958107000,
            7.731599287000,
            7.736244228000,
            7.740892933000,
            7.745545406000,
            7.750201648000,
            7.754861665000,
            7.759525458000,
            7.764193030000,
            7.768864385000,
            7.773539526000,
            7.778218456000,
            7.782901177000,
            7.787587694000,
            7.792278008000,
            7.796972124000,
            7.801670043000,
            7.806371770000,
            7.811077307000,
            7.815786658000,
            7.820499825000,
            7.825216812000,
            7.829937621000,
            7.834662256000,
            7.839390720000,
            7.844123016000,
            7.848859147000,
            7.853599117000,
            7.858342927000,
            7.863090582000,
            7.867842085000,
            7.872597438000,
            7.877356645000,
            7.882119709000,
            7.886886633000,
            7.891657420000,
            7.896432074000,
            7.901210597000,
            7.905992992000,
            7.910779263000,
            7.915569413000,
            7.920363445000,
            7.925161362000,
            7.929963168000,
            7.934768864000,
            7.939578456000,
            7.944391945000,
            7.949209335000,
            7.954030629000,
            7.958855830000,
            7.963684942000,
            7.968517967000,
            7.973354909000,
            7.978195771000,
            7.983040556000,
            7.987889267000,
            7.992741908000,
            7.997598481000,
            8.002458990000,
            8.007323438000,
            8.012191828000,
            8.017064164000,
            8.021940448000,
            8.026820684000,
            8.031704875000,
            8.036593024000,
            8.041485135000,
            8.046381210000,
            8.051281253000,
            8.056185267000,
            8.061093256000,
            8.066005221000,
            8.070921168000,
            8.075841098000,
            8.080765016000,
            8.085692924000,
            8.090624826000,
            8.095560724000,
            8.100500623000,
            8.105444524000,
            8.110392433000,
            8.115344351000,
            8.120300283000,
            8.125260230000,
            8.130224198000,
            8.135192188000,
            8.140164204000,
            8.145140250000,
            8.150120328000,
            8.155104442000,
            8.160092596000,
            8.165084791000,
            8.170081033000,
            8.175081323000,
            8.180085666000,
            8.185094065000,
            8.190106522000,
            8.195123041000,
            8.200143626000,
            8.205168279000,
            8.210197005000,
            8.215229806000,
            8.220266685000,
            8.225307647000,
            8.230352693000,
            8.235401829000,
            8.240455056000,
            8.245512378000,
            8.250573799000,
            8.255639321000,
            8.260708949000,
            8.265782685000,
            8.270860533000,
            8.275942496000,
            8.281028578000,
            8.286118781000,
            8.291213110000,
            8.296311567000,
            8.301414156000,
            8.306520880000,
            8.311631743000,
            8.316746747000,
            8.321865897000,
            8.326989195000,
            8.332116646000,
            8.337248251000,
            8.342384016000,
            8.347523942000,
            8.352668034000,
            8.357816295000,
            8.362968728000,
            8.368125336000,
            8.373286123000,
            8.378451093000,
            8.383620249000,
            8.388793593000,
            8.393971131000,
            8.399152864000,
            8.404338796000,
            8.409528931000,
            8.414723273000,
            8.419921823000,
            8.425124587000,
            8.430331567000,
            8.435542767000,
            8.440758190000,
            8.445977840000,
            8.451201720000,
            8.456429833000,
            8.461662184000,
            8.466898774000,
            8.472139608000,
            8.477384690000,
            8.482634022000,
            8.487887609000,
            8.493145452000,
            8.498407557000,
            8.503673927000,
            8.508944564000,
            8.514219473000,
            8.519498656000,
            8.524782118000,
            8.530069861000,
            8.535361890000,
            8.540658208000,
            8.545958817000,
            8.551263723000,
            8.556572927000,
            8.561886434000,
            8.567204247000,
            8.572526370000,
            8.577852806000,
            8.583183559000,
            8.588518631000,
            8.593858028000,
            8.599201751000,
            8.604549805000,
            8.609902193000,
            8.615258918000,
            8.620619985000,
            8.625985397000,
            8.631355156000,
            8.636729267000,
            8.642107734000,
            8.647490559000,
            8.652877747000,
            8.658269300000,
            8.663665223000,
            8.669065519000,
            8.674470191000,
            8.679879243000,
            8.685292679000,
            8.690710501000,
            8.696132715000,
            8.701559323000,
            8.706990328000,
            8.712425735000,
            8.717865546000,
            8.723309766000,
            8.728758399000,
            8.734211446000,
            8.739668913000,
            8.745130803000,
            8.750597119000,
            8.756067865000,
            8.761543045000,
            8.767022662000,
            8.772506719000,
            8.777995221000,
            8.783488171000,
            8.788985572000,
            8.794487429000,
            8.799993744000,
            8.805504521000,
            8.811019765000,
            8.816539478000,
            8.822063665000,
            8.827592328000,
            8.833125472000,
            8.838663099000,
            8.844205215000,
            8.849751822000,
            8.855302924000,
            8.860858525000,
            8.866418628000,
            8.871983236000,
            8.877552355000,
            8.883125987000,
            8.888704135000,
            8.894286805000,
            8.899873998000,
            8.905465720000,
            8.911061973000,
            8.916662761000,
            8.922268088000,
            8.927877958000,
            8.933492374000,
            8.939111340000,
            8.944734860000,
            8.950362937000,
            8.955995575000,
            8.961632778000,
            8.967274550000,
            8.972920893000,
            8.978571812000,
            8.984227311000,
            8.989887393000,
            8.995552063000,
            9.001221322000,
            9.006895177000,
            9.012573629000,
            9.018256683000,
            9.023944343000,
            9.029636612000,
            9.035333495000,
            9.041034994000,
            9.046741113000,
            9.052451857000,
            9.058167229000,
            9.063887233000,
            9.069611872000,
            9.075341151000,
            9.081075072000,
            9.086813641000,
            9.092556860000,
            9.098304733000,
            9.104057265000,
            9.109814458000,
            9.115576318000,
            9.121342846000,
            9.127114048000,
            9.132889927000,
            9.138670487000,
            9.144455731000,
            9.150245664000,
            9.156040289000,
            9.161839610000,
            9.167643630000,
            9.173452355000,
            9.179265787000,
            9.185083930000,
            9.190906788000,
            9.196734365000,
            9.202566665000,
            9.208403691000,
            9.214245448000,
            9.220091939000,
            9.225943168000,
            9.231799139000,
            9.237659856000,
            9.243525322000,
            9.249395542000,
            9.255270518000,
            9.261150257000,
            9.267034760000,
            9.272924032000,
            9.278818076000,
            9.284716897000,
            9.290620499000,
            9.296528885000,
            9.302442059000,
            9.308360026000,
            9.314282788000,
            9.320210350000,
            9.326142716000,
            9.332079890000,
            9.338021875000,
            9.343968675000,
            9.349920295000,
            9.355876738000,
            9.361838008000,
            9.367804110000,
            9.373775046000,
            9.379750821000,
            9.385731439000,
            9.391716904000,
            9.397707220000,
            9.403702390000,
            9.409702418000,
            9.415707309000,
            9.421717067000,
            9.427731695000,
            9.433751197000,
            9.439775577000,
            9.445804840000,
            9.451838989000,
            9.457878028000,
            9.463921961000,
            9.469970792000,
            9.476024525000,
            9.482083164000,
            9.488146714000,
            9.494215177000,
            9.500288558000,
            9.506366861000,
            9.512450089000,
            9.518538248000,
            9.524631341000,
            9.530729371000,
            9.536832344000,
            9.542940262000,
            9.549053130000,
            9.555170953000,
            9.561293733000,
            9.567421475000,
            9.573554183000,
            9.579691861000,
            9.585834513000,
            9.591982143000,
            9.598134756000,
            9.604292354000,
            9.610454943000,
            9.616622525000,
            9.622795106000,
            9.628972690000,
            9.635155280000,
            9.641342880000,
            9.647535494000,
            9.653733128000,
            9.659935783000,
            9.666143466000,
            9.672356179000,
            9.678573927000,
            9.684796714000,
            9.691024545000,
            9.697257422000,
            9.703495350000,
            9.709738334000,
            9.715986377000,
            9.722239483000,
            9.728497657000,
            9.734760903000,
            9.741029224000,
            9.747302626000,
            9.753581111000,
            9.759864685000,
            9.766153350000,
            9.772447113000,
            9.778745975000,
            9.785049943000,
            9.791359019000,
            9.797673208000,
            9.803992514000,
            9.810316942000,
            9.816646495000,
            9.822981177000,
            9.829320993000,
            9.835665947000,
            9.842016043000,
            9.848371285000,
            9.854731677000,
            9.861097224000,
            9.867467930000,
            9.873843798000,
            9.880224834000,
            9.886611040000,
            9.893002423000,
            9.899398985000,
            9.905800730000,
            9.912207664000,
            9.918619790000,
            9.925037112000,
            9.931459635000,
            9.937887363000,
            9.944320300000,
            9.950758451000,
            9.957201819000,
            9.963650408000,
            9.970104224000,
            9.976563270000,
            9.983027550000,
            9.989497069000,
            9.995971831000,
            10.002451840000,
            10.008937100000,
            10.015427620000,
            10.021923390000,
            10.028424430000,
            10.034930740000,
            10.041442330000,
            10.047959180000,
            10.054481320000,
            10.061008750000,
            10.067541470000,
            10.074079480000,
            10.080622780000,
            10.087171400000,
            10.093725310000,
            10.100284540000,
            10.106849090000,
            10.113418950000,
            10.119994140000,
            10.126574660000,
            10.133160510000,
            10.139751700000,
            10.146348230000,
            10.152950110000,
            10.159557330000,
            10.166169910000)

        yy = c(
            2.318956313000,
            2.318561288000,
            2.318166270000,
            2.317771260000,
            2.317376257000,
            2.316981260000,
            2.316586271000,
            2.316191290000,
            2.315796315000,
            2.315401348000,
            2.315006387000,
            2.314611434000,
            2.314216489000,
            2.313821550000,
            2.313426619000,
            2.313031694000,
            2.312636777000,
            2.312241868000,
            2.311846965000,
            2.311452070000,
            2.311057182000,
            2.310662301000,
            2.310267428000,
            2.309872562000,
            2.309477703000,
            2.309082851000,
            2.308688007000,
            2.308293170000,
            2.307898340000,
            2.307503517000,
            2.307108702000,
            2.306713894000,
            2.306319094000,
            2.305924300000,
            2.305529514000,
            2.305134736000,
            2.304739964000,
            2.304345200000,
            2.303950444000,
            2.303555694000,
            2.303160952000,
            2.302766218000,
            2.302371490000,
            2.301976771000,
            2.301582058000,
            2.301187353000,
            2.300792655000,
            2.300397965000,
            2.300003282000,
            2.299608606000,
            2.299213938000,
            2.298819277000,
            2.298424624000,
            2.298029978000,
            2.297635339000,
            2.297240708000,
            2.296846084000,
            2.296451468000,
            2.296056859000,
            2.295662258000,
            2.295267664000,
            2.294873077000,
            2.294478498000,
            2.294083927000,
            2.293689363000,
            2.293294806000,
            2.292900257000,
            2.292505715000,
            2.292111181000,
            2.291716654000,
            2.291322135000,
            2.290927623000,
            2.290533119000,
            2.290138623000,
            2.289744134000,
            2.289349652000,
            2.288955178000,
            2.288560711000,
            2.288166252000,
            2.287771801000,
            2.287377357000,
            2.286982921000,
            2.286588492000,
            2.286194071000,
            2.285799657000,
            2.285405251000,
            2.285010853000,
            2.284616462000,
            2.284222079000,
            2.283827703000,
            2.283433335000,
            2.283038975000,
            2.282644622000,
            2.282250276000,
            2.281855939000,
            2.281461609000,
            2.281067287000,
            2.280672972000,
            2.280278665000,
            2.279884366000,
            2.279490074000,
            2.279095790000,
            2.278701513000,
            2.278307245000,
            2.277912984000,
            2.277518730000,
            2.277124485000,
            2.276730247000,
            2.276336016000,
            2.275941794000,
            2.275547579000,
            2.275153372000,
            2.274759172000,
            2.274364981000,
            2.273970797000,
            2.273576620000,
            2.273182452000,
            2.272788291000,
            2.272394138000,
            2.271999993000,
            2.271605855000,
            2.271211726000,
            2.270817604000,
            2.270423490000,
            2.270029383000,
            2.269635285000,
            2.269241194000,
            2.268847111000,
            2.268453036000,
            2.268058968000,
            2.267664909000,
            2.267270857000,
            2.266876813000,
            2.266482777000,
            2.266088749000,
            2.265694729000,
            2.265300716000,
            2.264906711000,
            2.264512715000,
            2.264118726000,
            2.263724745000,
            2.263330771000,
            2.262936806000,
            2.262542849000,
            2.262148899000,
            2.261754957000,
            2.261361024000,
            2.260967098000,
            2.260573180000,
            2.260179270000,
            2.259785368000,
            2.259391474000,
            2.258997587000,
            2.258603709000,
            2.258209839000,
            2.257815976000,
            2.257422122000,
            2.257028275000,
            2.256634437000,
            2.256240606000,
            2.255846784000,
            2.255452969000,
            2.255059163000,
            2.254665364000,
            2.254271574000,
            2.253877791000,
            2.253484016000,
            2.253090250000,
            2.252696491000,
            2.252302741000,
            2.251908998000,
            2.251515264000,
            2.251121538000,
            2.250727819000,
            2.250334109000,
            2.249940407000,
            2.249546713000,
            2.249153027000,
            2.248759349000,
            2.248365679000,
            2.247972017000,
            2.247578363000,
            2.247184718000,
            2.246791080000,
            2.246397451000,
            2.246003829000,
            2.245610216000,
            2.245216611000,
            2.244823014000,
            2.244429425000,
            2.244035845000,
            2.243642272000,
            2.243248708000,
            2.242855152000,
            2.242461604000,
            2.242068064000,
            2.241674532000,
            2.241281009000,
            2.240887494000,
            2.240493987000,
            2.240100488000,
            2.239706997000,
            2.239313515000,
            2.238920040000,
            2.238526574000,
            2.238133116000,
            2.237739667000,
            2.237346226000,
            2.236952793000,
            2.236559368000,
            2.236165951000,
            2.235772543000,
            2.235379143000,
            2.234985751000,
            2.234592367000,
            2.234198992000,
            2.233805625000,
            2.233412267000,
            2.233018916000,
            2.232625574000,
            2.232232241000,
            2.231838915000,
            2.231445598000,
            2.231052290000,
            2.230658989000,
            2.230265697000,
            2.229872413000,
            2.229479138000,
            2.229085871000,
            2.228692612000,
            2.228299362000,
            2.227906120000,
            2.227512887000,
            2.227119662000,
            2.226726445000,
            2.226333237000,
            2.225940037000,
            2.225546845000,
            2.225153662000,
            2.224760487000,
            2.224367321000,
            2.223974163000,
            2.223581014000,
            2.223187873000,
            2.222794740000,
            2.222401616000,
            2.222008501000,
            2.221615394000,
            2.221222295000,
            2.220829205000,
            2.220436123000,
            2.220043050000,
            2.219649985000,
            2.219256929000,
            2.218863882000,
            2.218470842000,
            2.218077812000,
            2.217684790000,
            2.217291776000,
            2.216898771000,
            2.216505774000,
            2.216112787000,
            2.215719807000,
            2.215326836000,
            2.214933874000,
            2.214540920000,
            2.214147975000,
            2.213755039000,
            2.213362111000,
            2.212969191000,
            2.212576281000,
            2.212183378000,
            2.211790485000,
            2.211397600000,
            2.211004724000,
            2.210611856000,
            2.210218997000,
            2.209826147000,
            2.209433305000,
            2.209040472000,
            2.208647647000,
            2.208254831000,
            2.207862024000,
            2.207469226000,
            2.207076436000,
            2.206683655000,
            2.206290883000,
            2.205898119000,
            2.205505364000,
            2.205112618000,
            2.204719880000,
            2.204327152000,
            2.203934432000,
            2.203541720000,
            2.203149018000,
            2.202756324000,
            2.202363639000,
            2.201970963000,
            2.201578295000,
            2.201185636000,
            2.200792986000,
            2.200400345000,
            2.200007713000,
            2.199615089000,
            2.199222474000,
            2.198829868000,
            2.198437271000,
            2.198044682000,
            2.197652103000,
            2.197259532000,
            2.196866970000,
            2.196474417000,
            2.196081873000,
            2.195689338000,
            2.195296811000,
            2.194904294000,
            2.194511785000,
            2.194119285000,
            2.193726794000,
            2.193334312000,
            2.192941839000,
            2.192549374000,
            2.192156919000,
            2.191764473000,
            2.191372035000,
            2.190979606000,
            2.190587187000,
            2.190194776000,
            2.189802374000,
            2.189409981000,
            2.189017598000,
            2.188625223000,
            2.188232857000,
            2.187840500000,
            2.187448152000,
            2.187055813000,
            2.186663483000,
            2.186271162000,
            2.185878850000,
            2.185486547000,
            2.185094253000,
            2.184701968000,
            2.184309692000,
            2.183917425000,
            2.183525167000,
            2.183132919000,
            2.182740679000,
            2.182348448000,
            2.181956227000,
            2.181564014000,
            2.181171811000,
            2.180779617000,
            2.180387431000,
            2.179995255000,
            2.179603088000,
            2.179210930000,
            2.178818781000,
            2.178426642000,
            2.178034511000,
            2.177642390000,
            2.177250278000,
            2.176858174000,
            2.176466080000,
            2.176073996000,
            2.175681920000,
            2.175289854000,
            2.174897796000,
            2.174505748000,
            2.174113709000,
            2.173721680000,
            2.173329659000,
            2.172937648000,
            2.172545646000,
            2.172153653000,
            2.171761669000,
            2.171369695000,
            2.170977730000,
            2.170585774000,
            2.170193827000,
            2.169801890000,
            2.169409962000,
            2.169018043000,
            2.168626133000,
            2.168234233000,
            2.167842342000,
            2.167450460000,
            2.167058588000,
            2.166666725000,
            2.166274871000,
            2.165883027000,
            2.165491192000,
            2.165099366000,
            2.164707549000,
            2.164315742000,
            2.163923945000,
            2.163532156000,
            2.163140377000,
            2.162748608000,
            2.162356847000,
            2.161965097000,
            2.161573355000,
            2.161181623000,
            2.160789900000,
            2.160398187000,
            2.160006483000,
            2.159614789000,
            2.159223104000,
            2.158831429000,
            2.158439763000,
            2.158048106000,
            2.157656459000,
            2.157264821000,
            2.156873193000,
            2.156481574000,
            2.156089965000,
            2.155698365000,
            2.155306775000,
            2.154915194000,
            2.154523623000,
            2.154132061000,
            2.153740509000,
            2.153348966000,
            2.152957433000,
            2.152565909000,
            2.152174395000,
            2.151782891000,
            2.151391396000,
            2.150999910000,
            2.150608434000,
            2.150216968000,
            2.149825511000,
            2.149434064000,
            2.149042627000,
            2.148651199000,
            2.148259781000,
            2.147868372000,
            2.147476973000,
            2.147085584000,
            2.146694204000,
            2.146302834000,
            2.145911473000,
            2.145520122000,
            2.145128781000,
            2.144737450000,
            2.144346128000,
            2.143954816000,
            2.143563513000,
            2.143172221000,
            2.142780938000,
            2.142389664000,
            2.141998401000,
            2.141607147000,
            2.141215903000,
            2.140824668000,
            2.140433444000,
            2.140042229000,
            2.139651024000,
            2.139259828000,
            2.138868642000,
            2.138477467000,
            2.138086301000,
            2.137695144000,
            2.137303998000,
            2.136912861000,
            2.136521734000,
            2.136130617000,
            2.135739510000,
            2.135348412000,
            2.134957325000,
            2.134566247000,
            2.134175179000,
            2.133784121000,
            2.133393073000,
            2.133002035000,
            2.132611006000,
            2.132219987000,
            2.131828979000,
            2.131437980000,
            2.131046991000,
            2.130656012000,
            2.130265043000,
            2.129874084000,
            2.129483135000,
            2.129092195000,
            2.128701266000,
            2.128310347000,
            2.127919437000,
            2.127528538000,
            2.127137648000,
            2.126746769000,
            2.126355899000,
            2.125965039000,
            2.125574190000,
            2.125183350000,
            2.124792521000,
            2.124401701000,
            2.124010892000,
            2.123620092000,
            2.123229303000,
            2.122838523000,
            2.122447754000,
            2.122056994000,
            2.121666245000,
            2.121275506000,
            2.120884777000,
            2.120494058000,
            2.120103349000,
            2.119712650000,
            2.119321961000,
            2.118931283000,
            2.118540614000,
            2.118149956000,
            2.117759307000,
            2.117368669000,
            2.116978041000,
            2.116587423000,
            2.116196816000,
            2.115806218000,
            2.115415631000,
            2.115025054000,
            2.114634487000,
            2.114243930000,
            2.113853383000,
            2.113462847000,
            2.113072320000,
            2.112681804000,
            2.112291299000,
            2.111900803000,
            2.111510318000,
            2.111119843000,
            2.110729378000,
            2.110338924000,
            2.109948479000,
            2.109558045000,
            2.109167622000,
            2.108777208000,
            2.108386805000,
            2.107996412000,
            2.107606030000,
            2.107215657000,
            2.106825295000,
            2.106434944000,
            2.106044603000,
            2.105654272000,
            2.105263951000,
            2.104873641000,
            2.104483341000,
            2.104093052000,
            2.103702773000,
            2.103312504000,
            2.102922246000,
            2.102531998000,
            2.102141760000,
            2.101751533000,
            2.101361317000,
            2.100971110000,
            2.100580915000,
            2.100190729000,
            2.099800554000,
            2.099410390000,
            2.099020236000,
            2.098630092000,
            2.098239959000,
            2.097849837000,
            2.097459724000,
            2.097069623000,
            2.096679532000,
            2.096289451000,
            2.095899381000,
            2.095509322000,
            2.095119272000,
            2.094729234000,
            2.094339206000,
            2.093949189000,
            2.093559182000,
            2.093169186000,
            2.092779200000,
            2.092389225000,
            2.091999260000,
            2.091609306000,
            2.091219363000,
            2.090829430000,
            2.090439508000,
            2.090049597000,
            2.089659696000,
            2.089269806000,
            2.088879926000,
            2.088490057000,
            2.088100199000,
            2.087710351000,
            2.087320514000,
            2.086930688000,
            2.086540872000,
            2.086151068000,
            2.085761273000,
            2.085371490000,
            2.084981717000,
            2.084591955000,
            2.084202204000,
            2.083812463000,
            2.083422734000,
            2.083033014000,
            2.082643306000,
            2.082253609000,
            2.081863922000,
            2.081474246000,
            2.081084581000,
            2.080694926000,
            2.080305283000,
            2.079915650000,
            2.079526028000,
            2.079136417000,
            2.078746816000,
            2.078357227000,
            2.077967648000,
            2.077578080000,
            2.077188524000,
            2.076798977000,
            2.076409442000,
            2.076019918000,
            2.075630405000,
            2.075240902000,
            2.074851410000,
            2.074461930000,
            2.074072460000,
            2.073683001000,
            2.073293553000,
            2.072904116000,
            2.072514690000,
            2.072125275000,
            2.071735871000,
            2.071346478000,
            2.070957095000,
            2.070567724000,
            2.070178364000,
            2.069789015000,
            2.069399676000,
            2.069010349000,
            2.068621033000,
            2.068231728000,
            2.067842434000,
            2.067453151000,
            2.067063878000,
            2.066674618000,
            2.066285368000,
            2.065896129000,
            2.065506901000,
            2.065117684000,
            2.064728479000,
            2.064339284000,
            2.063950101000,
            2.063560928000,
            2.063171767000,
            2.062782617000,
            2.062393478000,
            2.062004351000,
            2.061615234000,
            2.061226129000,
            2.060837034000,
            2.060447951000,
            2.060058879000,
            2.059669819000,
            2.059280769000,
            2.058891731000,
            2.058502704000,
            2.058113688000,
            2.057724683000,
            2.057335690000,
            2.056946707000,
            2.056557737000,
            2.056168777000,
            2.055779828000,
            2.055390891000,
            2.055001965000,
            2.054613051000,
            2.054224147000,
            2.053835256000,
            2.053446375000,
            2.053057505000,
            2.052668647000,
            2.052279801000,
            2.051890965000,
            2.051502141000,
            2.051113329000,
            2.050724527000,
            2.050335737000,
            2.049946959000,
            2.049558192000,
            2.049169436000,
            2.048780691000,
            2.048391958000,
            2.048003237000,
            2.047614527000,
            2.047225828000,
            2.046837141000,
            2.046448465000,
            2.046059801000,
            2.045671148000,
            2.045282506000,
            2.044893876000,
            2.044505258000,
            2.044116651000,
            2.043728055000,
            2.043339471000,
            2.042950899000,
            2.042562338000,
            2.042173788000,
            2.041785250000,
            2.041396724000,
            2.041008209000,
            2.040619706000,
            2.040231214000,
            2.039842734000,
            2.039454266000,
            2.039065809000,
            2.038677363000,
            2.038288929000,
            2.037900507000,
            2.037512097000,
            2.037123698000,
            2.036735311000,
            2.036346935000,
            2.035958571000,
            2.035570219000,
            2.035181878000,
            2.034793549000,
            2.034405232000,
            2.034016926000,
            2.033628633000,
            2.033240350000,
            2.032852080000,
            2.032463821000,
            2.032075574000,
            2.031687339000,
            2.031299115000,
            2.030910904000,
            2.030522704000,
            2.030134515000,
            2.029746339000,
            2.029358174000,
            2.028970021000,
            2.028581880000,
            2.028193751000,
            2.027805633000,
            2.027417528000,
            2.027029434000,
            2.026641352000,
            2.026253282000,
            2.025865223000,
            2.025477177000,
            2.025089142000,
            2.024701120000,
            2.024313109000,
            2.023925110000,
            2.023537123000,
            2.023149148000,
            2.022761185000,
            2.022373233000,
            2.021985294000,
            2.021597366000,
            2.021209451000,
            2.020821548000,
            2.020433656000,
            2.020045776000,
            2.019657909000,
            2.019270053000,
            2.018882210000,
            2.018494378000,
            2.018106558000,
            2.017718751000,
            2.017330955000,
            2.016943172000,
            2.016555400000,
            2.016167641000,
            2.015779894000,
            2.015392158000,
            2.015004435000,
            2.014616724000,
            2.014229025000,
            2.013841338000,
            2.013453663000,
            2.013066000000,
            2.012678350000,
            2.012290711000,
            2.011903085000,
            2.011515471000,
            2.011127869000,
            2.010740279000,
            2.010352701000,
            2.009965136000,
            2.009577582000,
            2.009190041000,
            2.008802512000,
            2.008414995000,
            2.008027491000,
            2.007639999000,
            2.007252518000,
            2.006865051000,
            2.006477595000,
            2.006090152000,
            2.005702721000,
            2.005315302000,
            2.004927895000,
            2.004540501000,
            2.004153119000,
            2.003765750000,
            2.003378393000,
            2.002991048000,
            2.002603715000,
            2.002216395000,
            2.001829087000,
            2.001441791000,
            2.001054508000,
            2.000667237000,
            2.000279979000,
            1.999892733000,
            1.999505499000,
            1.999118278000,
            1.998731069000,
            1.998343872000,
            1.997956688000,
            1.997569517000,
            1.997182358000,
            1.996795211000,
            1.996408077000,
            1.996020955000,
            1.995633846000,
            1.995246749000,
            1.994859665000,
            1.994472593000,
            1.994085534000,
            1.993698487000,
            1.993311453000,
            1.992924431000,
            1.992537422000,
            1.992150425000,
            1.991763441000,
            1.991376470000,
            1.990989511000,
            1.990602564000,
            1.990215631000,
            1.989828710000,
            1.989441801000,
            1.989054905000,
            1.988668022000,
            1.988281151000,
            1.987894293000,
            1.987507448000,
            1.987120615000,
            1.986733795000,
            1.986346988000,
            1.985960193000,
            1.985573411000,
            1.985186642000,
            1.984799886000,
            1.984413142000,
            1.984026411000,
            1.983639692000,
            1.983252987000,
            1.982866294000,
            1.982479614000,
            1.982092946000,
            1.981706292000,
            1.981319650000,
            1.980933021000,
            1.980546405000,
            1.980159802000,
            1.979773211000,
            1.979386633000,
            1.979000068000,
            1.978613516000,
            1.978226977000,
            1.977840451000,
            1.977453937000,
            1.977067437000,
            1.976680949000,
            1.976294474000,
            1.975908012000,
            1.975521563000,
            1.975135127000,
            1.974748704000,
            1.974362294000,
            1.973975896000,
            1.973589512000,
            1.973203141000,
            1.972816782000,
            1.972430437000,
            1.972044104000,
            1.971657785000,
            1.971271479000,
            1.970885185000,
            1.970498905000,
            1.970112637000,
            1.969726383000,
            1.969340142000,
            1.968953914000,
            1.968567698000,
            1.968181496000,
            1.967795307000,
            1.967409131000,
            1.967022968000,
            1.966636819000,
            1.966250682000,
            1.965864559000,
            1.965478448000,
            1.965092351000,
            1.964706267000,
            1.964320196000,
            1.963934138000,
            1.963548094000,
            1.963162062000,
            1.962776044000,
            1.962390039000,
            1.962004047000,
            1.961618069000,
            1.961232104000,
            1.960846151000,
            1.960460213000,
            1.960074287000,
            1.959688375000,
            1.959302476000,
            1.958916590000,
            1.958530717000,
            1.958144858000,
            1.957759012000,
            1.957373179000,
            1.956987360000,
            1.956601554000,
            1.956215762000,
            1.955829982000,
            1.955444216000,
            1.955058464000,
            1.954672725000,
            1.954286999000,
            1.953901287000,
            1.953515588000,
            1.953129902000,
            1.952744230000,
            1.952358571000,
            1.951972926000,
            1.951587294000,
            1.951201675000,
            1.950816070000,
            1.950430479000,
            1.950044901000,
            1.949659336000,
            1.949273785000,
            1.948888248000,
            1.948502724000,
            1.948117213000,
            1.947731716000,
            1.947346233000,
            1.946960763000,
            1.946575307000,
            1.946189864000,
            1.945804435000,
            1.945419019000,
            1.945033617000,
            1.944648229000,
            1.944262854000,
            1.943877493000,
            1.943492146000,
            1.943106812000,
            1.942721491000,
            1.942336185000,
            1.941950892000,
            1.941565613000,
            1.941180347000,
            1.940795095000,
            1.940409857000,
            1.940024633000,
            1.939639422000,
            1.939254225000,
            1.938869041000,
            1.938483872000,
            1.938098716000,
            1.937713574000,
            1.937328446000,
            1.936943331000,
            1.936558231000,
            1.936173144000,
            1.935788071000,
            1.935403011000,
            1.935017966000,
            1.934632934000,
            1.934247916000,
            1.933862912000,
            1.933477922000,
            1.933092946000,
            1.932707984000,
            1.932323035000,
            1.931938101000,
            1.931553180000,
            1.931168274000,
            1.930783381000,
            1.930398502000,
            1.930013637000,
            1.929628786000,
            1.929243949000,
            1.928859126000,
            1.928474317000,
            1.928089522000,
            1.927704741000,
            1.927319974000,
            1.926935221000,
            1.926550481000,
            1.926165756000,
            1.925781045000,
            1.925396349000,
            1.925011666000,
            1.924626997000,
            1.924242342000,
            1.923857702000,
            1.923473075000,
            1.923088463000,
            1.922703864000,
            1.922319280000,
            1.921934710000,
            1.921550154000,
            1.921165612000,
            1.920781085000,
            1.920396571000,
            1.920012072000,
            1.919627587000,
            1.919243116000,
            1.918858659000,
            1.918474217000,
            1.918089789000,
            1.917705375000,
            1.917320975000,
            1.916936589000,
            1.916552218000,
            1.916167861000,
            1.915783518000,
            1.915399190000,
            1.915014876000,
            1.914630576000,
            1.914246290000,
            1.913862019000,
            1.913477762000,
            1.913093520000,
            1.912709292000,
            1.912325078000,
            1.911940878000,
            1.911556693000,
            1.911172523000,
            1.910788367000,
            1.910404225000,
            1.910020097000,
            1.909635984000,
            1.909251886000,
            1.908867802000,
            1.908483732000,
            1.908099677000,
            1.907715636000,
            1.907331610000,
            1.906947598000,
            1.906563601000,
            1.906179618000,
            1.905795650000,
            1.905411696000,
            1.905027757000,
            1.904643832000,
            1.904259922000,
            1.903876027000,
            1.903492146000,
            1.903108280000,
            1.902724428000,
            1.902340591000,
            1.901956768000,
            1.901572961000,
            1.901189167000,
            1.900805389000,
            1.900421625000,
            1.900037875000,
            1.899654141000,
            1.899270421000,
            1.898886716000,
            1.898503025000,
            1.898119349000,
            1.897735688000,
            1.897352042000,
            1.896968410000,
            1.896584793000,
            1.896201191000,
            1.895817604000,
            1.895434031000,
            1.895050473000,
            1.894666930000,
            1.894283402000,
            1.893899888000,
            1.893516390000,
            1.893132906000,
            1.892749437000,
            1.892365983000,
            1.891982544000,
            1.891599119000,
            1.891215710000,
            1.890832315000,
            1.890448936000,
            1.890065571000,
            1.889682221000,
            1.889298886000,
            1.888915566000,
            1.888532261000,
            1.888148971000,
            1.887765696000,
            1.887382436000,
            1.886999191000,
            1.886615960000,
            1.886232745000,
            1.885849545000,
            1.885466360000,
            1.885083190000,
            1.884700035000,
            1.884316895000,
            1.883933770000,
            1.883550660000,
            1.883167565000,
            1.882784485000,
            1.882401421000,
            1.882018371000,
            1.881635337000,
            1.881252318000,
            1.880869314000,
            1.880486325000,
            1.880103351000,
            1.879720392000,
            1.879337449000,
            1.878954521000,
            1.878571607000,
            1.878188710000,
            1.877805827000,
            1.877422960000,
            1.877040107000,
            1.876657270000,
            1.876274449000,
            1.875891642000,
            1.875508851000,
            1.875126075000,
            1.874743315000,
            1.874360570000,
            1.873977840000,
            1.873595125000,
            1.873212426000,
            1.872829742000,
            1.872447073000,
            1.872064420000,
            1.871681782000,
            1.871299160000,
            1.870916553000,
            1.870533961000,
            1.870151385000,
            1.869768824000,
            1.869386278000,
            1.869003748000,
            1.868621234000,
            1.868238735000,
            1.867856251000,
            1.867473783000,
            1.867091331000,
            1.866708894000,
            1.866326472000,
            1.865944066000,
            1.865561675000,
            1.865179300000,
            1.864796941000,
            1.864414597000,
            1.864032269000,
            1.863649956000,
            1.863267659000,
            1.862885377000,
            1.862503111000,
            1.862120861000,
            1.861738626000,
            1.861356407000,
            1.860974204000,
            1.860592016000,
            1.860209844000,
            1.859827688000,
            1.859445547000,
            1.859063422000,
            1.858681313000,
            1.858299219000,
            1.857917141000,
            1.857535079000,
            1.857153033000,
            1.856771002000,
            1.856388987000,
            1.856006988000,
            1.855625005000,
            1.855243038000,
            1.854861086000,
            1.854479150000,
            1.854097230000,
            1.853715326000,
            1.853333438000,
            1.852951565000,
            1.852569709000,
            1.852187868000,
            1.851806043000,
            1.851424235000,
            1.851042442000,
            1.850660665000,
            1.850278903000,
            1.849897158000,
            1.849515429000,
            1.849133716000,
            1.848752018000,
            1.848370337000,
            1.847988672000,
            1.847607023000,
            1.847225389000,
            1.846843772000,
            1.846462171000,
            1.846080585000,
            1.845699016000,
            1.845317463000,
            1.844935926000,
            1.844554405000,
            1.844172900000,
            1.843791412000,
            1.843409939000,
            1.843028483000,
            1.842647042000,
            1.842265618000,
            1.841884210000,
            1.841502818000,
            1.841121442000,
            1.840740083000,
            1.840358740000,
            1.839977412000,
            1.839596101000,
            1.839214807000,
            1.838833528000,
            1.838452266000,
            1.838071020000,
            1.837689791000,
            1.837308577000,
            1.836927380000,
            1.836546199000,
            1.836165035000,
            1.835783887000,
            1.835402755000,
            1.835021639000,
            1.834640540000,
            1.834259457000,
            1.833878391000,
            1.833497341000,
            1.833116307000,
            1.832735290000,
            1.832354289000,
            1.831973305000,
            1.831592337000,
            1.831211385000,
            1.830830450000,
            1.830449531000,
            1.830068629000,
            1.829687744000,
            1.829306875000,
            1.828926022000,
            1.828545186000,
            1.828164366000,
            1.827783563000,
            1.827402777000,
            1.827022007000,
            1.826641253000,
            1.826260516000,
            1.825879796000,
            1.825499093000,
            1.825118406000,
            1.824737735000,
            1.824357081000,
            1.823976444000,
            1.823595824000,
            1.823215220000,
            1.822834633000,
            1.822454063000,
            1.822073509000,
            1.821692972000,
            1.821312451000,
            1.820931948000,
            1.820551461000,
            1.820170991000,
            1.819790538000,
            1.819410101000,
            1.819029681000,
            1.818649278000,
            1.818268892000,
            1.817888523000,
            1.817508170000,
            1.817127834000,
            1.816747515000,
            1.816367213000,
            1.815986928000,
            1.815606660000,
            1.815226408000,
            1.814846174000,
            1.814465956000,
            1.814085756000,
            1.813705572000,
            1.813325405000,
            1.812945255000,
            1.812565122000,
            1.812185006000,
            1.811804907000,
            1.811424825000,
            1.811044760000,
            1.810664712000,
            1.810284681000,
            1.809904668000,
            1.809524671000,
            1.809144691000,
            1.808764728000,
            1.808384783000,
            1.808004854000,
            1.807624942000,
            1.807245048000,
            1.806865171000,
            1.806485311000,
            1.806105468000,
            1.805725642000,
            1.805345833000,
            1.804966042000,
            1.804586268000,
            1.804206511000,
            1.803826771000,
            1.803447048000,
            1.803067343000,
            1.802687654000,
            1.802307983000,
            1.801928330000,
            1.801548693000,
            1.801169074000,
            1.800789472000,
            1.800409888000,
            1.800030321000,
            1.799650771000,
            1.799271238000,
            1.798891723000,
            1.798512225000,
            1.798132745000,
            1.797753281000,
            1.797373836000,
            1.796994407000,
            1.796614997000,
            1.796235603000,
            1.795856227000,
            1.795476868000,
            1.795097527000,
            1.794718204000,
            1.794338897000,
            1.793959609000,
            1.793580338000,
            1.793201084000,
            1.792821848000,
            1.792442629000,
            1.792063428000,
            1.791684244000,
            1.791305078000,
            1.790925930000,
            1.790546799000,
            1.790167686000,
            1.789788590000,
            1.789409512000,
            1.789030452000,
            1.788651409000,
            1.788272384000,
            1.787893377000,
            1.787514387000,
            1.787135415000,
            1.786756461000,
            1.786377524000,
            1.785998605000,
            1.785619704000,
            1.785240821000,
            1.784861955000,
            1.784483107000,
            1.784104277000,
            1.783725465000,
            1.783346670000,
            1.782967894000,
            1.782589135000,
            1.782210394000,
            1.781831670000,
            1.781452965000,
            1.781074277000,
            1.780695608000,
            1.780316956000,
            1.779938322000,
            1.779559706000,
            1.779181108000,
            1.778802528000,
            1.778423966000,
            1.778045422000,
            1.777666895000,
            1.777288387000,
            1.776909897000,
            1.776531425000,
            1.776152970000,
            1.775774534000,
            1.775396116000,
            1.775017716000,
            1.774639334000,
            1.774260970000,
            1.773882624000,
            1.773504296000,
            1.773125986000,
            1.772747694000,
            1.772369421000,
            1.771991165000,
            1.771612928000,
            1.771234709000,
            1.770856508000,
            1.770478325000,
            1.770100161000,
            1.769722014000,
            1.769343886000,
            1.768965776000,
            1.768587684000,
            1.768209611000,
            1.767831556000,
            1.767453519000,
            1.767075500000,
            1.766697500000,
            1.766319518000,
            1.765941554000,
            1.765563608000,
            1.765185681000,
            1.764807773000,
            1.764429882000,
            1.764052010000,
            1.763674157000,
            1.763296321000,
            1.762918505000,
            1.762540706000,
            1.762162926000,
            1.761785165000,
            1.761407421000,
            1.761029697000,
            1.760651991000,
            1.760274303000,
            1.759896634000,
            1.759518983000,
            1.759141351000,
            1.758763737000,
            1.758386142000,
            1.758008566000,
            1.757631008000,
            1.757253468000,
            1.756875948000,
            1.756498445000,
            1.756120962000,
            1.755743497000,
            1.755366051000,
            1.754988623000,
            1.754611214000,
            1.754233823000,
            1.753856452000,
            1.753479099000,
            1.753101765000,
            1.752724449000,
            1.752347152000,
            1.751969874000,
            1.751592615000,
            1.751215374000,
            1.750838152000,
            1.750460949000,
            1.750083765000,
            1.749706600000,
            1.749329453000,
            1.748952325000,
            1.748575216000,
            1.748198126000,
            1.747821055000,
            1.747444003000,
            1.747066969000,
            1.746689955000,
            1.746312959000,
            1.745935982000,
            1.745559024000,
            1.745182086000,
            1.744805166000,
            1.744428265000,
            1.744051383000,
            1.743674520000,
            1.743297676000,
            1.742920851000,
            1.742544045000,
            1.742167259000,
            1.741790491000,
            1.741413742000,
            1.741037012000,
            1.740660302000,
            1.740283610000,
            1.739906938000,
            1.739530285000,
            1.739153651000,
            1.738777036000,
            1.738400440000,
            1.738023863000,
            1.737647306000,
            1.737270768000,
            1.736894249000,
            1.736517749000,
            1.736141268000,
            1.735764807000,
            1.735388365000,
            1.735011942000,
            1.734635539000,
            1.734259154000,
            1.733882789000,
            1.733506444000,
            1.733130117000,
            1.732753810000,
            1.732377523000,
            1.732001255000,
            1.731625006000,
            1.731248776000,
            1.730872566000,
            1.730496375000,
            1.730120204000,
            1.729744052000,
            1.729367920000,
            1.728991807000,
            1.728615713000,
            1.728239639000,
            1.727863585000,
            1.727487550000,
            1.727111534000,
            1.726735538000,
            1.726359562000,
            1.725983605000,
            1.725607667000,
            1.725231750000,
            1.724855851000,
            1.724479973000,
            1.724104114000,
            1.723728274000,
            1.723352455000,
            1.722976655000,
            1.722600874000,
            1.722225114000,
            1.721849372000,
            1.721473651000,
            1.721097949000,
            1.720722267000,
            1.720346605000,
            1.719970963000,
            1.719595340000,
            1.719219737000,
            1.718844154000,
            1.718468591000,
            1.718093047000,
            1.717717523000,
            1.717342019000,
            1.716966535000,
            1.716591071000,
            1.716215627000,
            1.715840202000,
            1.715464797000,
            1.715089413000,
            1.714714048000,
            1.714338703000,
            1.713963378000,
            1.713588073000,
            1.713212788000,
            1.712837523000,
            1.712462278000,
            1.712087053000,
            1.711711848000,
            1.711336663000,
            1.710961498000,
            1.710586353000,
            1.710211228000,
            1.709836123000,
            1.709461038000,
            1.709085973000,
            1.708710929000,
            1.708335904000,
            1.707960900000,
            1.707585916000,
            1.707210952000,
            1.706836008000,
            1.706461084000,
            1.706086181000,
            1.705711297000,
            1.705336434000,
            1.704961592000,
            1.704586769000,
            1.704211967000,
            1.703837185000,
            1.703462423000,
            1.703087681000,
            1.702712960000,
            1.702338259000,
            1.701963579000,
            1.701588918000,
            1.701214279000,
            1.700839659000,
            1.700465060000,
            1.700090481000,
            1.699715923000,
            1.699341385000,
            1.698966867000,
            1.698592370000,
            1.698217894000,
            1.697843438000,
            1.697469002000,
            1.697094587000,
            1.696720192000,
            1.696345818000,
            1.695971464000,
            1.695597131000,
            1.695222819000,
            1.694848527000,
            1.694474255000,
            1.694100005000,
            1.693725774000,
            1.693351565000,
            1.692977376000,
            1.692603207000,
            1.692229060000,
            1.691854933000,
            1.691480826000,
            1.691106741000,
            1.690732676000,
            1.690358632000,
            1.689984608000,
            1.689610605000,
            1.689236623000,
            1.688862662000,
            1.688488721000,
            1.688114802000,
            1.687740903000,
            1.687367025000,
            1.686993167000,
            1.686619331000,
            1.686245515000,
            1.685871721000,
            1.685497947000,
            1.685124194000,
            1.684750462000,
            1.684376751000,
            1.684003061000,
            1.683629391000,
            1.683255743000,
            1.682882116000,
            1.682508509000,
            1.682134924000,
            1.681761360000,
            1.681387816000,
            1.681014294000,
            1.680640793000,
            1.680267312000,
            1.679893853000,
            1.679520415000,
            1.679146998000,
            1.678773602000,
            1.678400227000,
            1.678026874000,
            1.677653541000,
            1.677280230000,
            1.676906940000,
            1.676533671000,
            1.676160423000,
            1.675787196000,
            1.675413991000,
            1.675040807000,
            1.674667644000,
            1.674294502000,
            1.673921382000,
            1.673548283000,
            1.673175205000,
            1.672802148000,
            1.672429113000,
            1.672056099000,
            1.671683107000,
            1.671310136000,
            1.670937186000,
            1.670564257000,
            1.670191350000,
            1.669818465000,
            1.669445601000,
            1.669072758000,
            1.668699937000,
            1.668327137000,
            1.667954358000,
            1.667581602000,
            1.667208866000,
            1.666836152000,
            1.666463460000,
            1.666090789000,
            1.665718140000,
            1.665345512000,
            1.664972906000,
            1.664600322000,
            1.664227759000,
            1.663855218000,
            1.663482698000,
            1.663110200000,
            1.662737724000,
            1.662365269000,
            1.661992836000,
            1.661620425000,
            1.661248035000,
            1.660875667000,
            1.660503321000,
            1.660130997000,
            1.659758694000,
            1.659386413000,
            1.659014154000,
            1.658641917000,
            1.658269702000,
            1.657897508000,
            1.657525336000,
            1.657153186000,
            1.656781058000,
            1.656408952000,
            1.656036868000,
            1.655664805000,
            1.655292765000,
            1.654920746000,
            1.654548749000,
            1.654176775000,
            1.653804822000,
            1.653432891000,
            1.653060983000,
            1.652689096000,
            1.652317231000,
            1.651945388000,
            1.651573568000,
            1.651201769000,
            1.650829993000,
            1.650458238000,
            1.650086506000,
            1.649714796000,
            1.649343108000,
            1.648971442000,
            1.648599798000,
            1.648228177000,
            1.647856577000,
            1.647485000000,
            1.647113445000,
            1.646741912000,
            1.646370401000,
            1.645998913000,
            1.645627447000,
            1.645256003000,
            1.644884582000,
            1.644513182000,
            1.644141805000,
            1.643770451000,
            1.643399119000,
            1.643027809000,
            1.642656521000,
            1.642285256000,
            1.641914013000,
            1.641542793000,
            1.641171595000,
            1.640800419000,
            1.640429266000,
            1.640058135000,
            1.639687027000,
            1.639315942000,
            1.638944878000,
            1.638573838000,
            1.638202820000,
            1.637831824000,
            1.637460851000,
            1.637089900000,
            1.636718972000,
            1.636348067000,
            1.635977184000,
            1.635606324000,
            1.635235487000,
            1.634864672000,
            1.634493880000,
            1.634123110000,
            1.633752363000,
            1.633381639000,
            1.633010938000,
            1.632640259000,
            1.632269603000,
            1.631898970000,
            1.631528359000,
            1.631157772000,
            1.630787207000,
            1.630416665000,
            1.630046146000,
            1.629675649000,
            1.629305176000,
            1.628934725000,
            1.628564297000,
            1.628193892000,
            1.627823510000,
            1.627453151000,
            1.627082815000,
            1.626712501000,
            1.626342211000,
            1.625971944000,
            1.625601699000,
            1.625231478000,
            1.624861279000,
            1.624491104000,
            1.624120952000,
            1.623750822000,
            1.623380716000,
            1.623010633000,
            1.622640573000,
            1.622270536000,
            1.621900522000,
            1.621530531000,
            1.621160564000,
            1.620790619000,
            1.620420698000,
            1.620050800000,
            1.619680925000,
            1.619311073000,
            1.618941245000,
            1.618571440000,
            1.618201658000,
            1.617831899000,
            1.617462164000,
            1.617092452000,
            1.616722763000,
            1.616353097000,
            1.615983455000,
            1.615613836000,
            1.615244241000,
            1.614874669000,
            1.614505120000,
            1.614135595000,
            1.613766093000,
            1.613396615000,
            1.613027160000,
            1.612657728000,
            1.612288320000,
            1.611918936000,
            1.611549574000,
            1.611180237000,
            1.610810923000,
            1.610441632000,
            1.610072365000,
            1.609703122000,
            1.609333902000,
            1.608964706000,
            1.608595534000,
            1.608226385000,
            1.607857259000,
            1.607488158000,
            1.607119080000,
            1.606750025000,
            1.606380995000,
            1.606011988000,
            1.605643004000,
            1.605274045000,
            1.604905109000,
            1.604536197000,
            1.604167309000,
            1.603798445000,
            1.603429604000,
            1.603060787000,
            1.602691994000,
            1.602323225000,
            1.601954480000,
            1.601585758000,
            1.601217061000,
            1.600848387000,
            1.600479738000,
            1.600111112000,
            1.599742510000,
            1.599373932000,
            1.599005378000,
            1.598636848000,
            1.598268342000,
            1.597899861000,
            1.597531403000,
            1.597162969000,
            1.596794559000,
            1.596426173000,
            1.596057812000,
            1.595689474000,
            1.595321161000,
            1.594952871000,
            1.594584606000,
            1.594216365000,
            1.593848148000,
            1.593479956000,
            1.593111787000,
            1.592743643000,
            1.592375523000,
            1.592007427000,
            1.591639356000,
            1.591271308000,
            1.590903285000,
            1.590535286000,
            1.590167312000,
            1.589799362000,
            1.589431436000,
            1.589063535000,
            1.588695658000,
            1.588327805000,
            1.587959977000,
            1.587592173000,
            1.587224393000,
            1.586856638000,
            1.586488908000,
            1.586121202000,
            1.585753520000,
            1.585385863000,
            1.585018230000,
            1.584650622000,
            1.584283038000,
            1.583915479000,
            1.583547945000,
            1.583180435000,
            1.582812950000,
            1.582445489000,
            1.582078053000,
            1.581710641000,
            1.581343255000,
            1.580975892000,
            1.580608555000,
            1.580241242000,
            1.579873954000,
            1.579506691000,
            1.579139452000,
            1.578772238000,
            1.578405049000,
            1.578037885000,
            1.577670745000,
            1.577303630000,
            1.576936540000,
            1.576569475000,
            1.576202435000,
            1.575835419000,
            1.575468429000,
            1.575101463000,
            1.574734522000,
            1.574367607000,
            1.574000716000,
            1.573633850000,
            1.573267009000,
            1.572900193000,
            1.572533402000,
            1.572166636000,
            1.571799895000,
            1.571433179000,
            1.571066488000,
            1.570699822000,
            1.570333181000,
            1.569966565000,
            1.569599975000,
            1.569233409000,
            1.568866869000,
            1.568500354000,
            1.568133864000,
            1.567767399000,
            1.567400959000,
            1.567034545000,
            1.566668156000,
            1.566301792000,
            1.565935453000,
            1.565569139000,
            1.565202851000,
            1.564836588000,
            1.564470351000,
            1.564104138000,
            1.563737951000,
            1.563371790000,
            1.563005653000,
            1.562639543000,
            1.562273457000,
            1.561907397000,
            1.561541362000,
            1.561175353000,
            1.560809369000,
            1.560443411000,
            1.560077478000,
            1.559711571000,
            1.559345689000,
            1.558979833000,
            1.558614002000,
            1.558248197000,
            1.557882418000,
            1.557516663000,
            1.557150935000,
            1.556785232000,
            1.556419555000,
            1.556053904000,
            1.555688278000,
            1.555322677000,
            1.554957103000,
            1.554591554000,
            1.554226031000,
            1.553860534000,
            1.553495062000,
            1.553129616000,
            1.552764196000,
            1.552398802000,
            1.552033433000,
            1.551668090000,
            1.551302774000,
            1.550937483000,
            1.550572217000,
            1.550206978000,
            1.549841765000,
            1.549476577000,
            1.549111416000,
            1.548746280000,
            1.548381170000,
            1.548016087000,
            1.547651029000,
            1.547285997000,
            1.546920992000,
            1.546556012000,
            1.546191058000,
            1.545826131000,
            1.545461229000,
            1.545096354000,
            1.544731504000,
            1.544366681000,
            1.544001884000,
            1.543637113000,
            1.543272368000,
            1.542907650000,
            1.542542957000,
            1.542178291000,
            1.541813651000,
            1.541449037000,
            1.541084449000,
            1.540719888000,
            1.540355353000,
            1.539990844000,
            1.539626362000,
            1.539261906000,
            1.538897476000,
            1.538533073000,
            1.538168696000,
            1.537804345000,
            1.537440021000,
            1.537075723000,
            1.536711451000,
            1.536347206000,
            1.535982988000,
            1.535618796000,
            1.535254630000,
            1.534890491000,
            1.534526378000,
            1.534162292000,
            1.533798233000,
            1.533434200000,
            1.533070194000,
            1.532706214000,
            1.532342261000,
            1.531978334000,
            1.531614434000,
            1.531250561000,
            1.530886714000,
            1.530522894000,
            1.530159101000,
            1.529795335000,
            1.529431595000,
            1.529067882000,
            1.528704195000,
            1.528340536000,
            1.527976903000,
            1.527613297000,
            1.527249718000,
            1.526886166000,
            1.526522640000,
            1.526159142000,
            1.525795670000,
            1.525432225000,
            1.525068807000,
            1.524705416000,
            1.524342052000,
            1.523978715000,
            1.523615405000,
            1.523252122000,
            1.522888866000,
            1.522525636000,
            1.522162434000,
            1.521799259000,
            1.521436111000,
            1.521072990000,
            1.520709896000,
            1.520346830000,
            1.519983790000,
            1.519620777000,
            1.519257792000,
            1.518894834000,
            1.518531903000,
            1.518168999000,
            1.517806122000,
            1.517443273000,
            1.517080451000,
            1.516717656000,
            1.516354888000,
            1.515992148000,
            1.515629435000,
            1.515266749000,
            1.514904091000,
            1.514541459000,
            1.514178856000,
            1.513816279000,
            1.513453730000,
            1.513091209000,
            1.512728715000,
            1.512366248000,
            1.512003809000,
            1.511641397000,
            1.511279013000,
            1.510916656000,
            1.510554327000,
            1.510192025000,
            1.509829751000,
            1.509467504000,
            1.509105285000,
            1.508743094000,
            1.508380930000,
            1.508018794000,
            1.507656685000,
            1.507294604000,
            1.506932551000,
            1.506570525000,
            1.506208527000,
            1.505846557000,
            1.505484615000,
            1.505122700000,
            1.504760813000,
            1.504398954000,
            1.504037123000,
            1.503675319000,
            1.503313543000,
            1.502951795000,
            1.502590075000,
            1.502228383000,
            1.501866719000,
            1.501505082000,
            1.501143474000,
            1.500781893000,
            1.500420341000,
            1.500058816000,
            1.499697319000,
            1.499335851000,
            1.498974410000,
            1.498612997000,
            1.498251613000,
            1.497890256000,
            1.497528927000,
            1.497167627000,
            1.496806355000,
            1.496445110000,
            1.496083894000,
            1.495722706000,
            1.495361547000,
            1.495000415000,
            1.494639312000,
            1.494278236000,
            1.493917189000,
            1.493556171000,
            1.493195180000,
            1.492834218000,
            1.492473284000,
            1.492112379000,
            1.491751501000,
            1.491390652000,
            1.491029832000,
            1.490669039000,
            1.490308276000,
            1.489947540000,
            1.489586833000,
            1.489226154000,
            1.488865504000,
            1.488504882000,
            1.488144289000,
            1.487783724000,
            1.487423188000,
            1.487062680000,
            1.486702201000,
            1.486341751000,
            1.485981328000,
            1.485620935000,
            1.485260570000,
            1.484900234000,
            1.484539926000,
            1.484179647000,
            1.483819397000,
            1.483459175000,
            1.483098982000,
            1.482738818000,
            1.482378682000,
            1.482018575000,
            1.481658497000,
            1.481298448000,
            1.480938428000,
            1.480578436000,
            1.480218473000,
            1.479858539000,
            1.479498634000,
            1.479138758000,
            1.478778910000,
            1.478419092000,
            1.478059302000,
            1.477699541000,
            1.477339809000,
            1.476980107000,
            1.476620433000,
            1.476260788000,
            1.475901172000,
            1.475541586000,
            1.475182028000,
            1.474822499000,
            1.474462999000,
            1.474103529000,
            1.473744088000,
            1.473384675000,
            1.473025292000,
            1.472665938000,
            1.472306613000,
            1.471947318000,
            1.471588051000,
            1.471228814000,
            1.470869606000,
            1.470510427000,
            1.470151278000,
            1.469792157000,
            1.469433066000,
            1.469074005000,
            1.468714973000,
            1.468355970000,
            1.467996996000,
            1.467638052000,
            1.467279137000,
            1.466920252000,
            1.466561396000,
            1.466202569000,
            1.465843772000,
            1.465485004000,
            1.465126266000,
            1.464767557000,
            1.464408878000,
            1.464050229000,
            1.463691609000,
            1.463333018000,
            1.462974457000,
            1.462615926000,
            1.462257424000,
            1.461898952000,
            1.461540510000,
            1.461182097000,
            1.460823714000,
            1.460465361000,
            1.460107037000,
            1.459748743000,
            1.459390479000,
            1.459032244000,
            1.458674040000,
            1.458315865000,
            1.457957720000,
            1.457599605000,
            1.457241519000,
            1.456883464000,
            1.456525438000,
            1.456167442000,
            1.455809476000,
            1.455451540000,
            1.455093634000,
            1.454735758000,
            1.454377912000,
            1.454020096000,
            1.453662310000,
            1.453304554000,
            1.452946828000,
            1.452589131000,
            1.452231466000,
            1.451873830000,
            1.451516224000,
            1.451158648000,
            1.450801103000,
            1.450443587000,
            1.450086102000,
            1.449728647000,
            1.449371222000,
            1.449013827000,
            1.448656463000,
            1.448299129000,
            1.447941825000,
            1.447584551000,
            1.447227308000,
            1.446870095000,
            1.446512912000,
            1.446155759000,
            1.445798637000,
            1.445441546000,
            1.445084484000,
            1.444727454000,
            1.444370453000,
            1.444013483000,
            1.443656544000,
            1.443299634000,
            1.442942756000,
            1.442585908000,
            1.442229090000,
            1.441872303000,
            1.441515547000,
            1.441158821000,
            1.440802125000,
            1.440445460000,
            1.440088826000,
            1.439732223000,
            1.439375650000,
            1.439019108000,
            1.438662596000,
            1.438306115000,
            1.437949665000,
            1.437593246000,
            1.437236857000,
            1.436880499000,
            1.436524172000,
            1.436167876000,
            1.435811611000,
            1.435455376000,
            1.435099172000,
            1.434742999000,
            1.434386857000,
            1.434030746000,
            1.433674666000,
            1.433318616000,
            1.432962598000,
            1.432606611000,
            1.432250654000,
            1.431894729000,
            1.431538834000,
            1.431182971000,
            1.430827139000,
            1.430471337000,
            1.430115567000,
            1.429759828000,
            1.429404120000,
            1.429048443000,
            1.428692797000,
            1.428337182000,
            1.427981599000,
            1.427626047000,
            1.427270526000,
            1.426915036000,
            1.426559577000,
            1.426204150000,
            1.425848754000,
            1.425493389000,
            1.425138056000,
            1.424782754000,
            1.424427483000,
            1.424072243000,
            1.423717035000,
            1.423361859000,
            1.423006713000,
            1.422651599000,
            1.422296517000,
            1.421941466000,
            1.421586447000,
            1.421231459000,
            1.420876502000,
            1.420521577000,
            1.420166684000,
            1.419811822000,
            1.419456991000,
            1.419102193000,
            1.418747426000,
            1.418392690000,
            1.418037986000,
            1.417683314000,
            1.417328673000,
            1.416974065000,
            1.416619487000,
            1.416264942000,
            1.415910428000,
            1.415555946000,
            1.415201496000,
            1.414847078000,
            1.414492691000,
            1.414138336000,
            1.413784014000,
            1.413429722000,
            1.413075463000,
            1.412721236000,
            1.412367040000,
            1.412012877000,
            1.411658745000,
            1.411304646000,
            1.410950578000,
            1.410596543000,
            1.410242539000,
            1.409888567000,
            1.409534628000,
            1.409180720000,
            1.408826845000,
            1.408473001000,
            1.408119190000,
            1.407765411000,
            1.407411664000,
            1.407057949000,
            1.406704266000,
            1.406350616000,
            1.405996997000,
            1.405643411000,
            1.405289858000,
            1.404936336000,
            1.404582847000,
            1.404229390000,
            1.403875965000,
            1.403522572000,
            1.403169212000,
            1.402815885000,
            1.402462589000,
            1.402109326000,
            1.401756096000,
            1.401402898000,
            1.401049732000,
            1.400696599000,
            1.400343498000,
            1.399990430000,
            1.399637394000,
            1.399284391000,
            1.398931420000,
            1.398578482000,
            1.398225576000,
            1.397872703000,
            1.397519863000,
            1.397167055000,
            1.396814280000,
            1.396461538000,
            1.396108828000,
            1.395756151000,
            1.395403506000,
            1.395050895000,
            1.394698316000,
            1.394345770000,
            1.393993256000,
            1.393640776000,
            1.393288328000,
            1.392935913000,
            1.392583531000,
            1.392231182000,
            1.391878865000,
            1.391526582000,
            1.391174331000,
            1.390822114000,
            1.390469929000,
            1.390117777000,
            1.389765659000,
            1.389413573000,
            1.389061520000,
            1.388709500000,
            1.388357514000,
            1.388005560000,
            1.387653640000,
            1.387301752000,
            1.386949898000,
            1.386598077000,
            1.386246289000,
            1.385894534000,
            1.385542812000,
            1.385191124000,
            1.384839468000,
            1.384487846000,
            1.384136258000,
            1.383784702000,
            1.383433180000,
            1.383081691000,
            1.382730235000,
            1.382378813000,
            1.382027424000,
            1.381676069000,
            1.381324746000,
            1.380973458000,
            1.380622202000,
            1.380270980000,
            1.379919792000,
            1.379568637000,
            1.379217516000,
            1.378866428000,
            1.378515373000,
            1.378164352000,
            1.377813365000,
            1.377462411000,
            1.377111491000,
            1.376760604000,
            1.376409751000,
            1.376058932000,
            1.375708146000,
            1.375357394000,
            1.375006676000,
            1.374655992000,
            1.374305341000,
            1.373954724000,
            1.373604140000,
            1.373253591000,
            1.372903075000,
            1.372552593000,
            1.372202145000,
            1.371851731000,
            1.371501350000,
            1.371151004000,
            1.370800691000,
            1.370450412000,
            1.370100168000,
            1.369749957000,
            1.369399780000,
            1.369049637000,
            1.368699528000,
            1.368349453000,
            1.367999413000,
            1.367649406000,
            1.367299433000,
            1.366949495000,
            1.366599590000,
            1.366249720000,
            1.365899884000,
            1.365550081000,
            1.365200314000,
            1.364850580000,
            1.364500880000,
            1.364151215000,
            1.363801584000,
            1.363451987000,
            1.363102425000,
            1.362752897000,
            1.362403403000,
            1.362053943000,
            1.361704518000,
            1.361355127000,
            1.361005771000,
            1.360656449000,
            1.360307161000,
            1.359957908000,
            1.359608689000,
            1.359259505000,
            1.358910355000,
            1.358561240000,
            1.358212159000,
            1.357863113000,
            1.357514101000,
            1.357165124000,
            1.356816181000,
            1.356467273000,
            1.356118400000,
            1.355769561000,
            1.355420757000,
            1.355071988000,
            1.354723253000,
            1.354374553000,
            1.354025888000,
            1.353677258000,
            1.353328662000,
            1.352980101000,
            1.352631575000,
            1.352283084000,
            1.351934627000,
            1.351586206000,
            1.351237819000,
            1.350889467000,
            1.350541150000,
            1.350192868000,
            1.349844621000,
            1.349496409000,
            1.349148231000,
            1.348800089000,
            1.348451982000,
            1.348103910000,
            1.347755873000,
            1.347407870000,
            1.347059903000,
            1.346711971000,
            1.346364075000,
            1.346016213000,
            1.345668386000,
            1.345320595000,
            1.344972839000,
            1.344625118000,
            1.344277432000,
            1.343929781000,
            1.343582166000,
            1.343234586000,
            1.342887041000,
            1.342539532000,
            1.342192057000,
            1.341844619000,
            1.341497215000,
            1.341149847000,
            1.340802514000,
            1.340455217000,
            1.340107955000,
            1.339760729000,
            1.339413538000,
            1.339066382000,
            1.338719262000,
            1.338372177000,
            1.338025128000,
            1.337678115000,
            1.337331137000,
            1.336984195000,
            1.336637288000,
            1.336290417000,
            1.335943581000,
            1.335596782000,
            1.335250017000,
            1.334903289000,
            1.334556596000,
            1.334209939000,
            1.333863318000,
            1.333516732000,
            1.333170182000,
            1.332823668000,
            1.332477190000,
            1.332130748000,
            1.331784341000,
            1.331437971000,
            1.331091636000,
            1.330745337000,
            1.330399074000,
            1.330052847000,
            1.329706656000,
            1.329360501000,
            1.329014382000,
            1.328668298000,
            1.328322251000,
            1.327976240000,
            1.327630265000,
            1.327284326000,
            1.326938423000,
            1.326592556000,
            1.326246726000,
            1.325900931000,
            1.325555173000,
            1.325209451000,
            1.324863764000,
            1.324518115000,
            1.324172501000,
            1.323826924000,
            1.323481383000,
            1.323135878000,
            1.322790409000,
            1.322444977000,
            1.322099581000,
            1.321754222000,
            1.321408899000,
            1.321063612000,
            1.320718362000,
            1.320373148000,
            1.320027970000,
            1.319682829000,
            1.319337725000,
            1.318992657000,
            1.318647625000,
            1.318302630000,
            1.317957672000,
            1.317612750000,
            1.317267864000,
            1.316923016000,
            1.316578204000,
            1.316233428000,
            1.315888689000,
            1.315543987000,
            1.315199322000,
            1.314854693000,
            1.314510101000,
            1.314165546000,
            1.313821027000,
            1.313476545000,
            1.313132100000,
            1.312787692000,
            1.312443321000,
            1.312098986000,
            1.311754688000,
            1.311410428000,
            1.311066204000,
            1.310722017000,
            1.310377867000,
            1.310033754000,
            1.309689678000,
            1.309345639000,
            1.309001636000,
            1.308657671000,
            1.308313743000,
            1.307969852000,
            1.307625998000,
            1.307282181000,
            1.306938402000,
            1.306594659000,
            1.306250954000,
            1.305907285000,
            1.305563654000,
            1.305220060000,
            1.304876504000,
            1.304532984000,
            1.304189502000,
            1.303846057000,
            1.303502649000,
            1.303159279000,
            1.302815946000,
            1.302472650000,
            1.302129392000,
            1.301786171000,
            1.301442988000,
            1.301099841000,
            1.300756733000,
            1.300413661000,
            1.300070628000,
            1.299727631000,
            1.299384672000,
            1.299041751000,
            1.298698867000,
            1.298356021000,
            1.298013213000,
            1.297670441000,
            1.297327708000,
            1.296985012000,
            1.296642354000,
            1.296299733000,
            1.295957151000,
            1.295614605000,
            1.295272098000,
            1.294929628000,
            1.294587196000,
            1.294244802000,
            1.293902446000,
            1.293560127000,
            1.293217846000,
            1.292875603000,
            1.292533398000,
            1.292191231000,
            1.291849102000,
            1.291507010000,
            1.291164957000,
            1.290822941000,
            1.290480964000,
            1.290139024000,
            1.289797122000,
            1.289455259000,
            1.289113433000,
            1.288771646000,
            1.288429896000,
            1.288088185000,
            1.287746512000,
            1.287404877000,
            1.287063280000,
            1.286721721000,
            1.286380200000,
            1.286038718000,
            1.285697273000,
            1.285355867000,
            1.285014500000,
            1.284673170000,
            1.284331879000,
            1.283990626000,
            1.283649411000,
            1.283308235000,
            1.282967097000,
            1.282625998000,
            1.282284936000,
            1.281943914000,
            1.281602929000,
            1.281261983000,
            1.280921076000,
            1.280580207000,
            1.280239377000,
            1.279898585000,
            1.279557831000,
            1.279217116000,
            1.278876440000,
            1.278535803000,
            1.278195203000,
            1.277854643000,
            1.277514121000,
            1.277173638000,
            1.276833193000,
            1.276492788000,
            1.276152421000,
            1.275812092000,
            1.275471803000,
            1.275131552000,
            1.274791340000,
            1.274451166000,
            1.274111032000,
            1.273770936000,
            1.273430880000,
            1.273090862000,
            1.272750883000,
            1.272410943000,
            1.272071041000,
            1.271731179000,
            1.271391356000,
            1.271051572000,
            1.270711826000,
            1.270372120000,
            1.270032453000,
            1.269692825000,
            1.269353236000,
            1.269013686000,
            1.268674175000,
            1.268334703000,
            1.267995270000,
            1.267655877000,
            1.267316522000,
            1.266977207000,
            1.266637931000,
            1.266298695000,
            1.265959497000,
            1.265620339000,
            1.265281220000,
            1.264942141000,
            1.264603100000,
            1.264264099000,
            1.263925138000,
            1.263586216000,
            1.263247333000,
            1.262908489000,
            1.262569685000,
            1.262230921000,
            1.261892196000,
            1.261553510000,
            1.261214864000,
            1.260876258000,
            1.260537691000,
            1.260199163000,
            1.259860675000,
            1.259522227000,
            1.259183818000,
            1.258845449000,
            1.258507120000,
            1.258168830000,
            1.257830580000,
            1.257492369000,
            1.257154199000,
            1.256816068000,
            1.256477976000,
            1.256139925000,
            1.255801913000,
            1.255463941000,
            1.255126009000,
            1.254788117000,
            1.254450265000,
            1.254112452000,
            1.253774680000,
            1.253436947000,
            1.253099254000,
            1.252761601000,
            1.252423989000,
            1.252086416000,
            1.251748883000,
            1.251411390000,
            1.251073937000,
            1.250736525000,
            1.250399152000,
            1.250061819000,
            1.249724527000,
            1.249387274000,
            1.249050062000,
            1.248712890000,
            1.248375758000,
            1.248038667000,
            1.247701615000,
            1.247364604000,
            1.247027633000,
            1.246690702000,
            1.246353812000,
            1.246016962000,
            1.245680152000,
            1.245343383000,
            1.245006654000,
            1.244669965000,
            1.244333317000,
            1.243996709000,
            1.243660141000,
            1.243323614000,
            1.242987128000,
            1.242650682000,
            1.242314276000,
            1.241977911000,
            1.241641587000,
            1.241305303000,
            1.240969059000,
            1.240632857000,
            1.240296695000,
            1.239960573000,
            1.239624492000,
            1.239288452000,
            1.238952452000,
            1.238616494000,
            1.238280575000,
            1.237944698000,
            1.237608861000,
            1.237273066000,
            1.236937311000,
            1.236601596000,
            1.236265923000,
            1.235930290000,
            1.235594699000,
            1.235259148000,
            1.234923638000,
            1.234588169000,
            1.234252741000,
            1.233917354000,
            1.233582008000,
            1.233246702000,
            1.232911438000,
            1.232576215000,
            1.232241033000,
            1.231905892000,
            1.231570792000,
            1.231235733000,
            1.230900715000,
            1.230565739000,
            1.230230803000,
            1.229895909000,
            1.229561056000,
            1.229226244000,
            1.228891473000,
            1.228556744000,
            1.228222056000,
            1.227887409000,
            1.227552803000,
            1.227218239000,
            1.226883716000,
            1.226549234000,
            1.226214794000,
            1.225880395000,
            1.225546037000,
            1.225211721000,
            1.224877447000,
            1.224543214000,
            1.224209022000,
            1.223874872000,
            1.223540763000,
            1.223206696000,
            1.222872670000,
            1.222538686000,
            1.222204744000,
            1.221870843000,
            1.221536983000,
            1.221203166000,
            1.220869390000,
            1.220535655000,
            1.220201963000,
            1.219868312000,
            1.219534703000,
            1.219201135000,
            1.218867610000,
            1.218534126000,
            1.218200684000,
            1.217867283000,
            1.217533925000,
            1.217200608000,
            1.216867333000,
            1.216534100000,
            1.216200910000,
            1.215867760000,
            1.215534653000,
            1.215201588000,
            1.214868565000,
            1.214535584000,
            1.214202645000,
            1.213869748000,
            1.213536892000,
            1.213204079000,
            1.212871308000,
            1.212538580000,
            1.212205893000,
            1.211873248000,
            1.211540646000,
            1.211208086000,
            1.210875568000,
            1.210543092000,
            1.210210658000,
            1.209878267000,
            1.209545917000,
            1.209213611000,
            1.208881346000,
            1.208549124000,
            1.208216944000,
            1.207884806000,
            1.207552711000,
            1.207220658000,
            1.206888648000,
            1.206556680000,
            1.206224755000,
            1.205892871000,
            1.205561031000,
            1.205229233000,
            1.204897477000,
            1.204565764000,
            1.204234094000,
            1.203902466000,
            1.203570880000,
            1.203239338000,
            1.202907838000,
            1.202576380000,
            1.202244965000,
            1.201913593000,
            1.201582264000,
            1.201250977000,
            1.200919733000,
            1.200588532000,
            1.200257373000,
            1.199926257000,
            1.199595184000,
            1.199264154000,
            1.198933167000,
            1.198602223000,
            1.198271321000,
            1.197940462000,
            1.197609647000,
            1.197278874000,
            1.196948144000,
            1.196617457000,
            1.196286813000,
            1.195956212000,
            1.195625654000,
            1.195295139000,
            1.194964667000,
            1.194634238000,
            1.194303853000,
            1.193973510000,
            1.193643211000,
            1.193312954000,
            1.192982741000,
            1.192652571000,
            1.192322444000,
            1.191992361000,
            1.191662320000,
            1.191332323000,
            1.191002369000,
            1.190672459000,
            1.190342591000,
            1.190012767000,
            1.189682987000,
            1.189353249000,
            1.189023555000,
            1.188693905000,
            1.188364298000,
            1.188034734000,
            1.187705214000,
            1.187375737000,
            1.187046304000,
            1.186716914000,
            1.186387568000,
            1.186058265000,
            1.185729006000,
            1.185399790000,
            1.185070618000,
            1.184741489000,
            1.184412405000,
            1.184083363000,
            1.183754366000,
            1.183425412000,
            1.183096502000,
            1.182767635000,
            1.182438813000,
            1.182110034000,
            1.181781298000,
            1.181452607000,
            1.181123959000,
            1.180795355000,
            1.180466795000,
            1.180138279000,
            1.179809807000,
            1.179481378000,
            1.179152994000,
            1.178824653000,
            1.178496357000,
            1.178168104000,
            1.177839895000,
            1.177511731000,
            1.177183610000,
            1.176855533000,
            1.176527501000,
            1.176199512000,
            1.175871568000,
            1.175543667000,
            1.175215811000,
            1.174887999000,
            1.174560231000,
            1.174232507000,
            1.173904828000,
            1.173577192000,
            1.173249601000,
            1.172922054000,
            1.172594551000,
            1.172267093000,
            1.171939679000,
            1.171612309000,
            1.171284984000,
            1.170957703000,
            1.170630466000,
            1.170303274000,
            1.169976126000,
            1.169649022000,
            1.169321963000,
            1.168994948000,
            1.168667978000,
            1.168341053000,
            1.168014171000,
            1.167687335000,
            1.167360543000,
            1.167033795000,
            1.166707092000,
            1.166380434000,
            1.166053820000,
            1.165727251000,
            1.165400727000,
            1.165074247000,
            1.164747812000,
            1.164421421000,
            1.164095076000,
            1.163768775000,
            1.163442519000,
            1.163116307000,
            1.162790141000,
            1.162464019000,
            1.162137942000,
            1.161811910000,
            1.161485922000,
            1.161159980000,
            1.160834082000,
            1.160508230000,
            1.160182422000,
            1.159856659000,
            1.159530942000,
            1.159205269000,
            1.158879641000,
            1.158554059000,
            1.158228521000,
            1.157903028000,
            1.157577581000,
            1.157252178000,
            1.156926821000,
            1.156601509000,
            1.156276241000,
            1.155951020000,
            1.155625843000,
            1.155300711000,
            1.154975625000,
            1.154650584000,
            1.154325588000,
            1.154000637000,
            1.153675732000,
            1.153350872000,
            1.153026057000,
            1.152701288000,
            1.152376564000,
            1.152051885000,
            1.151727252000,
            1.151402664000,
            1.151078122000,
            1.150753625000,
            1.150429173000,
            1.150104767000,
            1.149780407000,
            1.149456092000,
            1.149131822000,
            1.148807598000,
            1.148483420000,
            1.148159287000,
            1.147835200000,
            1.147511158000,
            1.147187162000,
            1.146863212000,
            1.146539307000,
            1.146215448000,
            1.145891635000,
            1.145567867000,
            1.145244146000,
            1.144920470000,
            1.144596839000,
            1.144273255000,
            1.143949716000,
            1.143626223000,
            1.143302776000,
            1.142979375000,
            1.142656020000,
            1.142332711000,
            1.142009447000,
            1.141686230000,
            1.141363058000,
            1.141039933000,
            1.140716853000,
            1.140393819000,
            1.140070832000,
            1.139747890000,
            1.139424995000,
            1.139102145000,
            1.138779342000,
            1.138456585000,
            1.138133873000,
            1.137811208000,
            1.137488590000,
            1.137166017000,
            1.136843490000,
            1.136521010000,
            1.136198576000,
            1.135876188000,
            1.135553847000,
            1.135231552000,
            1.134909303000,
            1.134587100000,
            1.134264944000,
            1.133942834000,
            1.133620770000,
            1.133298753000,
            1.132976782000,
            1.132654858000,
            1.132332980000,
            1.132011148000,
            1.131689363000,
            1.131367625000,
            1.131045933000,
            1.130724287000,
            1.130402688000,
            1.130081136000,
            1.129759630000,
            1.129438170000,
            1.129116758000,
            1.128795392000,
            1.128474072000,
            1.128152800000,
            1.127831573000,
            1.127510394000,
            1.127189261000,
            1.126868175000,
            1.126547136000,
            1.126226144000,
            1.125905198000,
            1.125584299000,
            1.125263447000,
            1.124942642000,
            1.124621884000,
            1.124301172000,
            1.123980507000,
            1.123659890000,
            1.123339319000,
            1.123018795000,
            1.122698318000,
            1.122377888000,
            1.122057505000,
            1.121737169000,
            1.121416880000,
            1.121096638000,
            1.120776443000,
            1.120456295000,
            1.120136195000,
            1.119816141000,
            1.119496135000,
            1.119176175000,
            1.118856263000,
            1.118536398000,
            1.118216580000,
            1.117896810000,
            1.117577086000,
            1.117257410000,
            1.116937781000,
            1.116618199000,
            1.116298665000,
            1.115979178000,
            1.115659738000,
            1.115340346000,
            1.115021001000,
            1.114701703000,
            1.114382453000,
            1.114063250000,
            1.113744095000,
            1.113424987000,
            1.113105926000,
            1.112786913000,
            1.112467948000,
            1.112149030000,
            1.111830159000,
            1.111511337000,
            1.111192561000,
            1.110873833000,
            1.110555153000,
            1.110236521000,
            1.109917936000,
            1.109599398000,
            1.109280909000,
            1.108962467000,
            1.108644073000,
            1.108325726000,
            1.108007427000,
            1.107689176000,
            1.107370973000,
            1.107052817000,
            1.106734710000,
            1.106416650000,
            1.106098638000,
            1.105780674000,
            1.105462757000,
            1.105144889000,
            1.104827068000,
            1.104509296000,
            1.104191571000,
            1.103873894000,
            1.103556266000,
            1.103238685000,
            1.102921152000,
            1.102603667000,
            1.102286231000,
            1.101968842000,
            1.101651501000,
            1.101334209000,
            1.101016964000,
            1.100699768000,
            1.100382620000,
            1.100065520000,
            1.099748468000,
            1.099431464000,
            1.099114509000,
            1.098797602000,
            1.098480743000,
            1.098163932000,
            1.097847170000,
            1.097530455000,
            1.097213789000,
            1.096897172000,
            1.096580603000,
            1.096264082000,
            1.095947609000,
            1.095631185000,
            1.095314810000,
            1.094998482000,
            1.094682203000,
            1.094365973000,
            1.094049791000,
            1.093733658000,
            1.093417573000,
            1.093101536000,
            1.092785548000,
            1.092469609000,
            1.092153718000,
            1.091837876000,
            1.091522083000,
            1.091206338000,
            1.090890641000,
            1.090574994000,
            1.090259395000,
            1.089943844000,
            1.089628343000,
            1.089312890000,
            1.088997486000,
            1.088682130000,
            1.088366824000,
            1.088051566000,
            1.087736357000,
            1.087421196000,
            1.087106085000,
            1.086791022000,
            1.086476009000,
            1.086161044000,
            1.085846128000,
            1.085531261000,
            1.085216443000,
            1.084901674000,
            1.084586954000,
            1.084272282000,
            1.083957660000,
            1.083643087000,
            1.083328563000,
            1.083014088000,
            1.082699662000,
            1.082385285000,
            1.082070957000,
            1.081756678000,
            1.081442449000,
            1.081128268000,
            1.080814137000,
            1.080500055000,
            1.080186022000,
            1.079872038000,
            1.079558104000,
            1.079244218000,
            1.078930382000,
            1.078616596000,
            1.078302858000,
            1.077989170000,
            1.077675531000,
            1.077361942000,
            1.077048402000,
            1.076734911000,
            1.076421469000,
            1.076108077000,
            1.075794735000,
            1.075481442000,
            1.075168198000,
            1.074855004000,
            1.074541859000,
            1.074228764000,
            1.073915718000,
            1.073602722000,
            1.073289776000,
            1.072976879000,
            1.072664031000,
            1.072351233000,
            1.072038485000,
            1.071725787000,
            1.071413138000,
            1.071100538000,
            1.070787989000,
            1.070475489000,
            1.070163039000,
            1.069850638000,
            1.069538287000,
            1.069225986000,
            1.068913735000,
            1.068601534000,
            1.068289382000,
            1.067977280000,
            1.067665228000,
            1.067353226000,
            1.067041274000,
            1.066729372000,
            1.066417519000,
            1.066105717000,
            1.065793964000,
            1.065482261000,
            1.065170609000,
            1.064859006000,
            1.064547453000,
            1.064235950000,
            1.063924498000,
            1.063613095000,
            1.063301743000,
            1.062990440000,
            1.062679188000,
            1.062367985000,
            1.062056833000,
            1.061745731000,
            1.061434679000,
            1.061123678000,
            1.060812726000,
            1.060501825000,
            1.060190974000,
            1.059880173000,
            1.059569422000,
            1.059258722000,
            1.058948072000,
            1.058637472000,
            1.058326923000,
            1.058016423000,
            1.057705975000,
            1.057395576000,
            1.057085228000,
            1.056774930000,
            1.056464683000,
            1.056154486000,
            1.055844340000,
            1.055534244000,
            1.055224199000,
            1.054914204000,
            1.054604259000,
            1.054294365000,
            1.053984522000,
            1.053674729000,
            1.053364986000,
            1.053055295000,
            1.052745653000,
            1.052436063000,
            1.052126523000,
            1.051817034000,
            1.051507595000,
            1.051198207000,
            1.050888870000,
            1.050579583000,
            1.050270347000,
            1.049961162000,
            1.049652028000,
            1.049342944000,
            1.049033911000,
            1.048724929000,
            1.048415998000,
            1.048107118000,
            1.047798288000,
            1.047489509000,
            1.047180781000,
            1.046872105000,
            1.046563478000,
            1.046254903000,
            1.045946379000,
            1.045637906000,
            1.045329484000,
            1.045021112000,
            1.044712792000,
            1.044404523000,
            1.044096304000,
            1.043788137000,
            1.043480021000,
            1.043171956000,
            1.042863942000,
            1.042555979000,
            1.042248067000,
            1.041940206000,
            1.041632396000,
            1.041324638000,
            1.041016931000,
            1.040709275000,
            1.040401670000,
            1.040094116000,
            1.039786614000,
            1.039479163000,
            1.039171763000,
            1.038864414000,
            1.038557117000,
            1.038249871000,
            1.037942677000,
            1.037635533000,
            1.037328441000,
            1.037021401000,
            1.036714412000,
            1.036407474000,
            1.036100587000,
            1.035793752000,
            1.035486969000,
            1.035180237000,
            1.034873556000,
            1.034566927000,
            1.034260350000,
            1.033953824000,
            1.033647349000,
            1.033340926000,
            1.033034555000,
            1.032728235000,
            1.032421967000,
            1.032115750000,
            1.031809585000,
            1.031503472000,
            1.031197410000,
            1.030891400000,
            1.030585442000,
            1.030279535000,
            1.029973680000,
            1.029667877000,
            1.029362126000,
            1.029056426000,
            1.028750778000,
            1.028445182000,
            1.028139638000,
            1.027834145000,
            1.027528704000,
            1.027223316000,
            1.026917979000,
            1.026612693000,
            1.026307460000,
            1.026002279000,
            1.025697150000,
            1.025392072000,
            1.025087047000,
            1.024782073000,
            1.024477151000,
            1.024172282000,
            1.023867464000,
            1.023562699000,
            1.023257985000,
            1.022953324000,
            1.022648714000,
            1.022344157000,
            1.022039652000,
            1.021735199000,
            1.021430798000,
            1.021126449000,
            1.020822152000,
            1.020517908000,
            1.020213715000,
            1.019909575000,
            1.019605487000,
            1.019301451000,
            1.018997468000,
            1.018693536000,
            1.018389658000,
            1.018085831000,
            1.017782056000,
            1.017478334000,
            1.017174664000,
            1.016871047000,
            1.016567482000,
            1.016263969000,
            1.015960509000,
            1.015657101000,
            1.015353745000,
            1.015050442000,
            1.014747191000,
            1.014443993000,
            1.014140847000,
            1.013837754000,
            1.013534713000,
            1.013231725000,
            1.012928789000,
            1.012625906000,
            1.012323075000,
            1.012020297000,
            1.011717571000,
            1.011414899000,
            1.011112278000,
            1.010809710000,
            1.010507195000,
            1.010204733000,
            1.009902323000,
            1.009599966000,
            1.009297661000,
            1.008995410000,
            1.008693211000,
            1.008391064000,
            1.008088971000,
            1.007786930000,
            1.007484942000,
            1.007183007000,
            1.006881124000,
            1.006579295000,
            1.006277518000,
            1.005975794000,
            1.005674123000,
            1.005372505000,
            1.005070939000,
            1.004769427000,
            1.004467967000,
            1.004166561000,
            1.003865207000,
            1.003563906000,
            1.003262658000,
            1.002961464000,
            1.002660322000,
            1.002359233000,
            1.002058197000,
            1.001757215000,
            1.001456285000,
            1.001155408000,
            1.000854585000,
            1.000553814000,
            1.000253097000,
            0.999952432500,
            0.999651821400,
            0.999351263400,
            0.999050758600,
            0.998750306900,
            0.998449908400,
            0.998149563100,
            0.997849271000,
            0.997549032200,
            0.997248846500,
            0.996948714200,
            0.996648635000,
            0.996348609200,
            0.996048636600,
            0.995748717400,
            0.995448851500,
            0.995149038800,
            0.994849279600,
            0.994549573700,
            0.994249921100,
            0.993950322000,
            0.993650776200,
            0.993351283800,
            0.993051844900,
            0.992752459400,
            0.992453127300,
            0.992153848700,
            0.991854623600,
            0.991555452000,
            0.991256333800,
            0.990957269200,
            0.990658258100,
            0.990359300600,
            0.990060396600,
            0.989761546100,
            0.989462749300,
            0.989164006000,
            0.988865316300,
            0.988566680300,
            0.988268097900,
            0.987969569100,
            0.987671094000,
            0.987372672500,
            0.987074304800,
            0.986775990700,
            0.986477730300,
            0.986179523700,
            0.985881370800,
            0.985583271600,
            0.985285226200,
            0.984987234600,
            0.984689296700,
            0.984391412700,
            0.984093582400,
            0.983795806000,
            0.983498083400,
            0.983200414700,
            0.982902799900,
            0.982605238900,
            0.982307731800,
            0.982010278500,
            0.981712879200,
            0.981415533900,
            0.981118242400,
            0.980821005000,
            0.980523821400,
            0.980226691900,
            0.979929616300,
            0.979632594800,
            0.979335627200,
            0.979038713700,
            0.978741854200,
            0.978445048800,
            0.978148297400,
            0.977851600100,
            0.977554956900,
            0.977258367800,
            0.976961832800,
            0.976665351900,
            0.976368925200,
            0.976072552600,
            0.975776234200,
            0.975479969900,
            0.975183759900,
            0.974887604000,
            0.974591502400,
            0.974295454900,
            0.973999461700,
            0.973703522800,
            0.973407638100,
            0.973111807700,
            0.972816031600,
            0.972520309700,
            0.972224642200,
            0.971929029000,
            0.971633470100,
            0.971337965600,
            0.971042515400,
            0.970747119600,
            0.970451778200,
            0.970156491200,
            0.969861258500,
            0.969566080300,
            0.969270956600,
            0.968975887200,
            0.968680872400,
            0.968385911900,
            0.968091006000,
            0.967796154500,
            0.967501357600,
            0.967206615200,
            0.966911927200,
            0.966617293900,
            0.966322715000,
            0.966028190800,
            0.965733721100,
            0.965439306000,
            0.965144945400,
            0.964850639500,
            0.964556388200,
            0.964262191600,
            0.963968049600,
            0.963673962200,
            0.963379929500,
            0.963085951500,
            0.962792028100,
            0.962498159500,
            0.962204345600,
            0.961910586400,
            0.961616881900,
            0.961323232200,
            0.961029637200,
            0.960736097000,
            0.960442611600,
            0.960149181000,
            0.959855805200,
            0.959562484200,
            0.959269218000,
            0.958976006700,
            0.958682850200,
            0.958389748600,
            0.958096701900,
            0.957803710000,
            0.957510773000,
            0.957217891000,
            0.956925063800,
            0.956632291600,
            0.956339574300,
            0.956046912000,
            0.955754304700,
            0.955461752300,
            0.955169254900,
            0.954876812500,
            0.954584425100,
            0.954292092700,
            0.953999815300,
            0.953707593000,
            0.953415425800,
            0.953123313600,
            0.952831256500,
            0.952539254400,
            0.952247307500,
            0.951955415600,
            0.951663578900,
            0.951371797300,
            0.951080070900,
            0.950788399600,
            0.950496783500,
            0.950205222500,
            0.949913716700,
            0.949622266100,
            0.949330870800,
            0.949039530600,
            0.948748245700,
            0.948457016000,
            0.948165841500,
            0.947874722300,
            0.947583658400,
            0.947292649800,
            0.947001696400,
            0.946710798400,
            0.946419955600,
            0.946129168200,
            0.945838436100,
            0.945547759400,
            0.945257138000,
            0.944966572000,
            0.944676061400,
            0.944385606100,
            0.944095206200,
            0.943804861800,
            0.943514572800,
            0.943224339200,
            0.942934161000,
            0.942644038300,
            0.942353971000,
            0.942063959200,
            0.941774002900,
            0.941484102100,
            0.941194256800,
            0.940904467000,
            0.940614732700,
            0.940325054000,
            0.940035430800,
            0.939745863100,
            0.939456351000,
            0.939166894500,
            0.938877493600,
            0.938588148200,
            0.938298858500,
            0.938009624300,
            0.937720445800,
            0.937431323000,
            0.937142255700,
            0.936853244200,
            0.936564288200,
            0.936275388000,
            0.935986543400,
            0.935697754600,
            0.935409021400,
            0.935120344000,
            0.934831722300,
            0.934543156300,
            0.934254646000,
            0.933966191500,
            0.933677792800,
            0.933389449800,
            0.933101162700,
            0.932812931300,
            0.932524755700,
            0.932236635900,
            0.931948572000,
            0.931660563800,
            0.931372611600,
            0.931084715100,
            0.930796874600,
            0.930509089900,
            0.930221361000,
            0.929933688100,
            0.929646071100,
            0.929358509900,
            0.929071004700,
            0.928783555400,
            0.928496162100,
            0.928208824700,
            0.927921543300,
            0.927634317800,
            0.927347148300,
            0.927060034700,
            0.926772977200,
            0.926485975700,
            0.926199030100,
            0.925912140600,
            0.925625307200,
            0.925338529700,
            0.925051808400,
            0.924765143000,
            0.924478533800,
            0.924191980600,
            0.923905483500,
            0.923619042500,
            0.923332657600,
            0.923046328800,
            0.922760056100,
            0.922473839600,
            0.922187679200,
            0.921901574900,
            0.921615526800,
            0.921329534900,
            0.921043599200,
            0.920757719600,
            0.920471896200,
            0.920186129000,
            0.919900418100,
            0.919614763300,
            0.919329164800,
            0.919043622500,
            0.918758136500,
            0.918472706700,
            0.918187333200,
            0.917902016000,
            0.917616755000,
            0.917331550400,
            0.917046402000,
            0.916761309900,
            0.916476274200,
            0.916191294800,
            0.915906371700,
            0.915621504900,
            0.915336694500,
            0.915051940500,
            0.914767242800,
            0.914482601500,
            0.914198016600,
            0.913913488100,
            0.913629015900,
            0.913344600200,
            0.913060240900,
            0.912775938100,
            0.912491691600,
            0.912207501600,
            0.911923368100,
            0.911639291000,
            0.911355270400,
            0.911071306300,
            0.910787398600,
            0.910503547400,
            0.910219752800,
            0.909936014600,
            0.909652333000,
            0.909368707900,
            0.909085139300,
            0.908801627200,
            0.908518171700,
            0.908234772800,
            0.907951430400,
            0.907668144600,
            0.907384915400,
            0.907101742800,
            0.906818626700,
            0.906535567300,
            0.906252564500,
            0.905969618300,
            0.905686728700,
            0.905403895700,
            0.905121119400,
            0.904838399800,
            0.904555736800,
            0.904273130500,
            0.903990580800,
            0.903708087900,
            0.903425651600,
            0.903143272000,
            0.902860949100,
            0.902578683000,
            0.902296473500,
            0.902014320800,
            0.901732224800,
            0.901450185600,
            0.901168203100,
            0.900886277300,
            0.900604408400,
            0.900322596200,
            0.900040840700,
            0.899759142100,
            0.899477500300,
            0.899195915200,
            0.898914387000,
            0.898632915600,
            0.898351501000,
            0.898070143200,
            0.897788842300,
            0.897507598200,
            0.897226411000,
            0.896945280600,
            0.896664207100,
            0.896383190400,
            0.896102230700,
            0.895821327800,
            0.895540481800,
            0.895259692700,
            0.894978960600,
            0.894698285300,
            0.894417667000,
            0.894137105600,
            0.893856601100,
            0.893576153600,
            0.893295763000,
            0.893015429400,
            0.892735152700,
            0.892454933000,
            0.892174770300,
            0.891894664600,
            0.891614615800,
            0.891334624100,
            0.891054689300,
            0.890774811600,
            0.890494990900,
            0.890215227200,
            0.889935520500,
            0.889655870800,
            0.889376278300,
            0.889096742700,
            0.888817264200,
            0.888537842800,
            0.888258478400,
            0.887979171100,
            0.887699920900,
            0.887420727800,
            0.887141591800,
            0.886862512800,
            0.886583491000,
            0.886304526300,
            0.886025618700,
            0.885746768200,
            0.885467974900,
            0.885189238700,
            0.884910559600,
            0.884631937700,
            0.884353372900,
            0.884074865300,
            0.883796414900,
            0.883518021600,
            0.883239685600,
            0.882961406700,
            0.882683185000,
            0.882405020400,
            0.882126913100,
            0.881848863000,
            0.881570870100,
            0.881292934500,
            0.881015056000,
            0.880737234800,
            0.880459470800,
            0.880181764100,
            0.879904114600,
            0.879626522400,
            0.879348987400,
            0.879071509700,
            0.878794089300,
            0.878516726100,
            0.878239420300,
            0.877962171700,
            0.877684980400,
            0.877407846400,
            0.877130769700,
            0.876853750300,
            0.876576788200,
            0.876299883500,
            0.876023036100,
            0.875746246000,
            0.875469513200,
            0.875192837800,
            0.874916219700,
            0.874639659000,
            0.874363155600,
            0.874086709700,
            0.873810321000,
            0.873533989800,
            0.873257715900,
            0.872981499400,
            0.872705340300,
            0.872429238500,
            0.872153194200,
            0.871877207300,
            0.871601277800,
            0.871325405700,
            0.871049591000,
            0.870773833700,
            0.870498133900,
            0.870222491500,
            0.869946906500,
            0.869671379000,
            0.869395908900,
            0.869120496300,
            0.868845141100,
            0.868569843400,
            0.868294603100,
            0.868019420400,
            0.867744295100,
            0.867469227200,
            0.867194216900,
            0.866919264000,
            0.866644368700,
            0.866369530800,
            0.866094750400,
            0.865820027500,
            0.865545362200,
            0.865270754400,
            0.864996204000,
            0.864721711200,
            0.864447276000,
            0.864172898200,
            0.863898578000,
            0.863624315300,
            0.863350110200,
            0.863075962600,
            0.862801872600,
            0.862527840100,
            0.862253865200,
            0.861979947900,
            0.861706088100,
            0.861432285900,
            0.861158541300,
            0.860884854200,
            0.860611224800,
            0.860337652900,
            0.860064138600,
            0.859790681900,
            0.859517282800,
            0.859243941400,
            0.858970657500,
            0.858697431200,
            0.858424262600,
            0.858151151500,
            0.857878098100,
            0.857605102300,
            0.857332164200,
            0.857059283600,
            0.856786460800,
            0.856513695500,
            0.856240987900,
            0.855968337900,
            0.855695745600,
            0.855423211000,
            0.855150734000,
            0.854878314600,
            0.854605953000,
            0.854333648900,
            0.854061402600,
            0.853789213900,
            0.853517082900,
            0.853245009600,
            0.852972994000,
            0.852701036100,
            0.852429135800,
            0.852157293300,
            0.851885508400,
            0.851613781200,
            0.851342111800,
            0.851070500000,
            0.850798946000,
            0.850527449600,
            0.850256011000,
            0.849984630100,
            0.849713306900,
            0.849442041400,
            0.849170833700,
            0.848899683700,
            0.848628591400,
            0.848357556800,
            0.848086580000,
            0.847815660900,
            0.847544799600,
            0.847273996000,
            0.847003250100,
            0.846732562000,
            0.846461931700,
            0.846191359100,
            0.845920844200,
            0.845650387100,
            0.845379987800,
            0.845109646300,
            0.844839362500,
            0.844569136400,
            0.844298968200,
            0.844028857700,
            0.843758805000,
            0.843488810100,
            0.843218872900,
            0.842948993600,
            0.842679172000,
            0.842409408200,
            0.842139702200,
            0.841870053900,
            0.841600463500,
            0.841330930900,
            0.841061456000,
            0.840792039000,
            0.840522679800,
            0.840253378300,
            0.839984134700,
            0.839714948800,
            0.839445820800,
            0.839176750600,
            0.838907738200,
            0.838638783600,
            0.838369886800,
            0.838101047900,
            0.837832266700,
            0.837563543400,
            0.837294877900,
            0.837026270200,
            0.836757720300,
            0.836489228300,
            0.836220794100,
            0.835952417700,
            0.835684099200,
            0.835415838500,
            0.835147635600,
            0.834879490500,
            0.834611403300,
            0.834343373900,
            0.834075402400,
            0.833807488700,
            0.833539632800,
            0.833271834800,
            0.833004094600,
            0.832736412300,
            0.832468787800,
            0.832201221100,
            0.831933712300,
            0.831666261400,
            0.831398868300,
            0.831131533000,
            0.830864255600,
            0.830597036000,
            0.830329874300,
            0.830062770500,
            0.829795724500,
            0.829528736300,
            0.829261806000,
            0.828994933600,
            0.828728119000,
            0.828461362300,
            0.828194663400,
            0.827928022400,
            0.827661439300,
            0.827394914000,
            0.827128446600,
            0.826862037000,
            0.826595685300,
            0.826329391400,
            0.826063155500,
            0.825796977300,
            0.825530857100,
            0.825264794700,
            0.824998790100,
            0.824732843500,
            0.824466954700,
            0.824201123700,
            0.823935350600,
            0.823669635400,
            0.823403978100,
            0.823138378600,
            0.822872836900,
            0.822607353200,
            0.822341927300,
            0.822076559200,
            0.821811249100,
            0.821545996700,
            0.821280802300,
            0.821015665700,
            0.820750587000,
            0.820485566100,
            0.820220603100,
            0.819955698000,
            0.819690850700,
            0.819426061300,
            0.819161329800,
            0.818896656100,
            0.818632040200,
            0.818367482300,
            0.818102982200,
            0.817838539900,
            0.817574155500,
            0.817309829000,
            0.817045560300,
            0.816781349500,
            0.816517196500,
            0.816253101400,
            0.815989064100,
            0.815725084700,
            0.815461163200,
            0.815197299500,
            0.814933493600,
            0.814669745600,
            0.814406055500,
            0.814142423100,
            0.813878848700,
            0.813615332100,
            0.813351873300,
            0.813088472400,
            0.812825129300,
            0.812561844100,
            0.812298616700,
            0.812035447100,
            0.811772335400,
            0.811509281500,
            0.811246285400,
            0.810983347200,
            0.810720466900,
            0.810457644300,
            0.810194879600,
            0.809932172700,
            0.809669523600,
            0.809406932400,
            0.809144399000,
            0.808881923400,
            0.808619505600,
            0.808357145700,
            0.808094843500,
            0.807832599200,
            0.807570412700,
            0.807308284000,
            0.807046213100,
            0.806784200000,
            0.806522244800,
            0.806260347300,
            0.805998507700,
            0.805736725800,
            0.805475001800,
            0.805213335500,
            0.804951727000,
            0.804690176400,
            0.804428683500,
            0.804167248400,
            0.803905871100,
            0.803644551600,
            0.803383289800,
            0.803122085900,
            0.802860939700,
            0.802599851300,
            0.802338820700,
            0.802077847800,
            0.801816932700,
            0.801556075400,
            0.801295275900,
            0.801034534100,
            0.800773850000,
            0.800513223800,
            0.800252655200,
            0.799992144500,
            0.799731691400,
            0.799471296200,
            0.799210958600,
            0.798950678800,
            0.798690456800,
            0.798430292400,
            0.798170185800,
            0.797910137000,
            0.797650145800,
            0.797390212400,
            0.797130336700,
            0.796870518800,
            0.796610758500,
            0.796351055900,
            0.796091411100,
            0.795831824000,
            0.795572294500,
            0.795312822800,
            0.795053408800,
            0.794794052400,
            0.794534753700,
            0.794275512800,
            0.794016329500,
            0.793757203900,
            0.793498135900,
            0.793239125700,
            0.792980173100,
            0.792721278100,
            0.792462440900,
            0.792203661300,
            0.791944939300,
            0.791686275000,
            0.791427668400,
            0.791169119300,
            0.790910628000,
            0.790652194200,
            0.790393818100,
            0.790135499600,
            0.789877238800,
            0.789619035600,
            0.789360890000,
            0.789102802000,
            0.788844771600,
            0.788586798800,
            0.788328883600,
            0.788071026000,
            0.787813226000,
            0.787555483600,
            0.787297798800,
            0.787040171500,
            0.786782601900,
            0.786525089800,
            0.786267635300,
            0.786010238300,
            0.785752898900,
            0.785495617000,
            0.785238392700,
            0.784981226000,
            0.784724116800,
            0.784467065100,
            0.784210070900,
            0.783953134300,
            0.783696255200,
            0.783439433700,
            0.783182669600,
            0.782925963000,
            0.782669314000,
            0.782412722400,
            0.782156188400,
            0.781899711800,
            0.781643292700,
            0.781386931100,
            0.781130627000,
            0.780874380400,
            0.780618191200,
            0.780362059400,
            0.780105985200,
            0.779849968300,
            0.779594009000,
            0.779338107000,
            0.779082262500,
            0.778826475400,
            0.778570745800,
            0.778315073500,
            0.778059458700,
            0.777803901300,
            0.777548401300,
            0.777292958700,
            0.777037573400,
            0.776782245600,
            0.776526975100,
            0.776271762000,
            0.776016606300,
            0.775761508000,
            0.775506467000,
            0.775251483300,
            0.774996557100,
            0.774741688100,
            0.774486876500,
            0.774232122200,
            0.773977425200,
            0.773722785600,
            0.773468203200,
            0.773213678200,
            0.772959210500,
            0.772704800000,
            0.772450446900,
            0.772196151000,
            0.771941912400,
            0.771687731100,
            0.771433607000,
            0.771179540200,
            0.770925530700,
            0.770671578300,
            0.770417683300,
            0.770163845400,
            0.769910064800,
            0.769656341400,
            0.769402675200,
            0.769149066200,
            0.768895514500,
            0.768642019900,
            0.768388582500,
            0.768135202200,
            0.767881879200,
            0.767628613300,
            0.767375404600,
            0.767122253000,
            0.766869158600,
            0.766616121300,
            0.766363141100,
            0.766110218100,
            0.765857352200,
            0.765604543400,
            0.765351791700,
            0.765099097100,
            0.764846459600,
            0.764593879100,
            0.764341355800,
            0.764088889500,
            0.763836480300,
            0.763584128100,
            0.763331833000,
            0.763079594900,
            0.762827413900,
            0.762575289900,
            0.762323222900,
            0.762071212900,
            0.761819259900,
            0.761567363900,
            0.761315524900,
            0.761063742800,
            0.760812017800,
            0.760560349700,
            0.760308738600,
            0.760057184400,
            0.759805687200,
            0.759554246800,
            0.759302863500,
            0.759051537000,
            0.758800267500,
            0.758549054800,
            0.758297899100,
            0.758046800200,
            0.757795758200,
            0.757544773100,
            0.757293844800,
            0.757042973400,
            0.756792158900,
            0.756541401200,
            0.756290700300,
            0.756040056200,
            0.755789469000,
            0.755538938600,
            0.755288464900,
            0.755038048100,
            0.754787688000,
            0.754537384700,
            0.754287138200,
            0.754036948400,
            0.753786815300,
            0.753536739000,
            0.753286719500,
            0.753036756600,
            0.752786850500,
            0.752537001000,
            0.752287208300,
            0.752037472200,
            0.751787792900,
            0.751538170200,
            0.751288604100,
            0.751039094700,
            0.750789641900,
            0.750540245800,
            0.750290906300,
            0.750041623400,
            0.749792397100,
            0.749543227400,
            0.749294114300,
            0.749045057800,
            0.748796057900,
            0.748547114500,
            0.748298227600,
            0.748049397300,
            0.747800623500,
            0.747551906300,
            0.747303245500,
            0.747054641300,
            0.746806093500,
            0.746557602300,
            0.746309167500,
            0.746060789100,
            0.745812467300,
            0.745564201800,
            0.745315992900,
            0.745067840300,
            0.744819744100,
            0.744571704400,
            0.744323721100,
            0.744075794100,
            0.743827923500,
            0.743580109300,
            0.743332351400,
            0.743084649900,
            0.742837004700,
            0.742589415900,
            0.742341883400,
            0.742094407100,
            0.741846987200,
            0.741599623500,
            0.741352316200,
            0.741105065100,
            0.740857870200,
            0.740610731600,
            0.740363649200,
            0.740116623100,
            0.739869653100,
            0.739622739400,
            0.739375881900,
            0.739129080500,
            0.738882335300,
            0.738635646300,
            0.738389013400,
            0.738142436700,
            0.737895916000,
            0.737649451500,
            0.737403043100,
            0.737156690900,
            0.736910394600,
            0.736664154500,
            0.736417970400,
            0.736171842400,
            0.735925770400,
            0.735679754500,
            0.735433794500,
            0.735187890600,
            0.734942042700,
            0.734696250700,
            0.734450514800,
            0.734204834800,
            0.733959210700,
            0.733713642600,
            0.733468130400,
            0.733222674100,
            0.732977273800,
            0.732731929300,
            0.732486640700,
            0.732241408000,
            0.731996231200,
            0.731751110100,
            0.731506045000,
            0.731261035600,
            0.731016082100,
            0.730771184400,
            0.730526342400,
            0.730281556300,
            0.730036825900,
            0.729792151200,
            0.729547532300,
            0.729302969100,
            0.729058461700,
            0.728814009900,
            0.728569613900,
            0.728325273500,
            0.728080988800,
            0.727836759700,
            0.727592586300,
            0.727348468600,
            0.727104406400,
            0.726860399900,
            0.726616448900,
            0.726372553600,
            0.726128713800,
            0.725884929600,
            0.725641200900,
            0.725397527700,
            0.725153910100,
            0.724910348000,
            0.724666841400,
            0.724423390200,
            0.724179994500,
            0.723936654300,
            0.723693369600,
            0.723450140200,
            0.723206966300,
            0.722963847800,
            0.722720784700,
            0.722477776900,
            0.722234824600,
            0.721991927600,
            0.721749085900,
            0.721506299600,
            0.721263568500,
            0.721020892800,
            0.720778272400,
            0.720535707200,
            0.720293197300,
            0.720050742700,
            0.719808343300,
            0.719565999100,
            0.719323710100,
            0.719081476300,
            0.718839297700,
            0.718597174300,
            0.718355106000,
            0.718113092900,
            0.717871134900,
            0.717629232000,
            0.717387384200,
            0.717145591500,
            0.716903853800,
            0.716662171300,
            0.716420543700,
            0.716178971200,
            0.715937453800,
            0.715695991300,
            0.715454583800,
            0.715213231300,
            0.714971933800,
            0.714730691200,
            0.714489503500,
            0.714248370800,
            0.714007292900,
            0.713766270000,
            0.713525301900,
            0.713284388700,
            0.713043530300,
            0.712802726800,
            0.712561978100,
            0.712321284200,
            0.712080645100,
            0.711840060800,
            0.711599531200,
            0.711359056400,
            0.711118636300,
            0.710878270900,
            0.710637960300,
            0.710397704300,
            0.710157503000,
            0.709917356300,
            0.709677264300,
            0.709437227000,
            0.709197244200,
            0.708957316000,
            0.708717442500,
            0.708477623500,
            0.708237859000,
            0.707998149100,
            0.707758493700,
            0.707518892900,
            0.707279346500,
            0.707039854600,
            0.706800417100,
            0.706561034200,
            0.706321705600,
            0.706082431500,
            0.705843211700,
            0.705604046400,
            0.705364935400,
            0.705125878800,
            0.704886876500,
            0.704647928600,
            0.704409034900,
            0.704170195600,
            0.703931410500,
            0.703692679700,
            0.703454003200,
            0.703215380800,
            0.702976812700,
            0.702738298800,
            0.702499839100,
            0.702261433500,
            0.702023082100,
            0.701784784900,
            0.701546541700,
            0.701308352700,
            0.701070217700,
            0.700832136800,
            0.700594110000,
            0.700356137200,
            0.700118218400,
            0.699880353700,
            0.699642542900,
            0.699404786100,
            0.699167083300,
            0.698929434400,
            0.698691839400,
            0.698454298400,
            0.698216811200,
            0.697979377900,
            0.697741998500,
            0.697504672900,
            0.697267401100,
            0.697030183200,
            0.696793019000,
            0.696555908600,
            0.696318852000,
            0.696081849100,
            0.695844900000,
            0.695608004500,
            0.695371162800,
            0.695134374700,
            0.694897640300,
            0.694660959500,
            0.694424332400,
            0.694187758800,
            0.693951238800,
            0.693714772500,
            0.693478359600,
            0.693242000300,
            0.693005694600,
            0.692769442300,
            0.692533243500,
            0.692297098200,
            0.692061006400,
            0.691824967900,
            0.691588982900,
            0.691353051300,
            0.691117173100,
            0.690881348200,
            0.690645576700,
            0.690409858500,
            0.690174193600,
            0.689938582100,
            0.689703023800,
            0.689467518700,
            0.689232066900,
            0.688996668300,
            0.688761322900,
            0.688526030700,
            0.688290791700,
            0.688055605800,
            0.687820473100,
            0.687585393500,
            0.687350366900,
            0.687115393500,
            0.686880473100,
            0.686645605800,
            0.686410791400,
            0.686176030100,
            0.685941321800,
            0.685706666400,
            0.685472064000,
            0.685237514500,
            0.685003017900,
            0.684768574300,
            0.684534183500,
            0.684299845500,
            0.684065560400,
            0.683831328200,
            0.683597148700,
            0.683363022000,
            0.683128948100,
            0.682894926900,
            0.682660958400,
            0.682427042700,
            0.682193179700,
            0.681959369300,
            0.681725611500,
            0.681491906400,
            0.681258254000,
            0.681024654100,
            0.680791106800,
            0.680557612000,
            0.680324169800,
            0.680090780100,
            0.679857442900,
            0.679624158200,
            0.679390925900,
            0.679157746100,
            0.678924618700,
            0.678691543700,
            0.678458521100,
            0.678225550900,
            0.677992633000,
            0.677759767400,
            0.677526954200,
            0.677294193200,
            0.677061484500,
            0.676828828000,
            0.676596223800,
            0.676363671700,
            0.676131171900,
            0.675898724200,
            0.675666328700,
            0.675433985300,
            0.675201694000,
            0.674969454800,
            0.674737267700,
            0.674505132600,
            0.674273049500,
            0.674041018500,
            0.673809039400,
            0.673577112400,
            0.673345237200,
            0.673113414000,
            0.672881642700,
            0.672649923300,
            0.672418255700,
            0.672186640000,
            0.671955076200,
            0.671723564100,
            0.671492103800,
            0.671260695300,
            0.671029338500,
            0.670798033500,
            0.670566780100,
            0.670335578500,
            0.670104428500,
            0.669873330100,
            0.669642283400,
            0.669411288300,
            0.669180344700,
            0.668949452700,
            0.668718612300,
            0.668487823300,
            0.668257085900,
            0.668026399900,
            0.667795765400,
            0.667565182300,
            0.667334650700,
            0.667104170400,
            0.666873741500,
            0.666643363900,
            0.666413037700,
            0.666182762800,
            0.665952539200,
            0.665722366800,
            0.665492245700,
            0.665262175800,
            0.665032157100,
            0.664802189600,
            0.664572273200,
            0.664342408000,
            0.664112593900,
            0.663882830800,
            0.663653118900,
            0.663423458000,
            0.663193848100,
            0.662964289300,
            0.662734781400,
            0.662505324500,
            0.662275918500,
            0.662046563500,
            0.661817259300,
            0.661588006000,
            0.661358803600,
            0.661129652000,
            0.660900551300,
            0.660671501300,
            0.660442502000,
            0.660213553600,
            0.659984655800,
            0.659755808800,
            0.659527012400,
            0.659298266700,
            0.659069571600,
            0.658840927100,
            0.658612333200,
            0.658383789900,
            0.658155297100,
            0.657926854900,
            0.657698463100,
            0.657470121800,
            0.657241831000,
            0.657013590600,
            0.656785400700,
            0.656557261100,
            0.656329171800,
            0.656101133000,
            0.655873144400,
            0.655645206100,
            0.655417318100,
            0.655189480400,
            0.654961692900,
            0.654733955600,
            0.654506268400,
            0.654278631500,
            0.654051044600,
            0.653823507900,
            0.653596021300,
            0.653368584800,
            0.653141198200,
            0.652913861800,
            0.652686575300,
            0.652459338700,
            0.652232152200,
            0.652005015500,
            0.651777928800,
            0.651550892000,
            0.651323905000,
            0.651096967800,
            0.650870080500,
            0.650643242900,
            0.650416455100,
            0.650189717100,
            0.649963028800,
            0.649736390200,
            0.649509801200,
            0.649283261900,
            0.649056772200,
            0.648830332100,
            0.648603941600,
            0.648377600600,
            0.648151309200,
            0.647925067300,
            0.647698874900,
            0.647472731900,
            0.647246638300,
            0.647020594200,
            0.646794599400,
            0.646568654000,
            0.646342758000,
            0.646116911300,
            0.645891113800,
            0.645665365600,
            0.645439666700,
            0.645214017000,
            0.644988416400,
            0.644762865100,
            0.644537362900,
            0.644311909800,
            0.644086505800,
            0.643861150800,
            0.643635845000,
            0.643410588100,
            0.643185380300,
            0.642960221400,
            0.642735111400,
            0.642510050400,
            0.642285038300,
            0.642060075100,
            0.641835160700,
            0.641610295100,
            0.641385478400,
            0.641160710400,
            0.640935991200,
            0.640711320700,
            0.640486698900,
            0.640262125800,
            0.640037601300,
            0.639813125500,
            0.639588698300,
            0.639364319600,
            0.639139989500,
            0.638915707900,
            0.638691474900,
            0.638467290300,
            0.638243154100,
            0.638019066400,
            0.637795027100,
            0.637571036200,
            0.637347093600,
            0.637123199300,
            0.636899353400,
            0.636675555700,
            0.636451806300,
            0.636228105100,
            0.636004452100,
            0.635780847300,
            0.635557290600,
            0.635333782000,
            0.635110321600,
            0.634886909200,
            0.634663544900,
            0.634440228600,
            0.634216960200,
            0.633993739900,
            0.633770567500,
            0.633547443000,
            0.633324366400,
            0.633101337700,
            0.632878356800,
            0.632655423700,
            0.632432538400,
            0.632209700900,
            0.631986911100,
            0.631764169000,
            0.631541474600,
            0.631318827900,
            0.631096228800,
            0.630873677300,
            0.630651173400,
            0.630428717000,
            0.630206308200,
            0.629983946900,
            0.629761633000,
            0.629539366600,
            0.629317147600,
            0.629094976100,
            0.628872851900,
            0.628650775000,
            0.628428745400,
            0.628206763200,
            0.627984828200,
            0.627762940400,
            0.627541099900,
            0.627319306500,
            0.627097560300,
            0.626875861200,
            0.626654209300,
            0.626432604400,
            0.626211046500,
            0.625989535700,
            0.625768071900,
            0.625546655100,
            0.625325285200,
            0.625103962200,
            0.624882686100,
            0.624661456900,
            0.624440274500,
            0.624219138900,
            0.623998050100,
            0.623777008100,
            0.623556012800,
            0.623335064100,
            0.623114162200,
            0.622893306900,
            0.622672498200,
            0.622451736200,
            0.622231020700,
            0.622010351700,
            0.621789729200,
            0.621569153200,
            0.621348623700,
            0.621128140600,
            0.620907703900,
            0.620687313600,
            0.620466969700,
            0.620246672000,
            0.620026420600,
            0.619806215500,
            0.619586056700,
            0.619365944000,
            0.619145877600,
            0.618925857300,
            0.618705883100,
            0.618485955000,
            0.618266073000,
            0.618046237000,
            0.617826447000,
            0.617606703100,
            0.617387005100,
            0.617167353000,
            0.616947746800,
            0.616728186500,
            0.616508672000,
            0.616289203400,
            0.616069780600,
            0.615850403500,
            0.615631072200,
            0.615411786500,
            0.615192546600,
            0.614973352300,
            0.614754203600,
            0.614535100500,
            0.614316043000,
            0.614097031000,
            0.613878064600,
            0.613659143600,
            0.613440268100,
            0.613221438000,
            0.613002653300,
            0.612783913900,
            0.612565219900,
            0.612346571200,
            0.612127967800,
            0.611909409700,
            0.611690896800,
            0.611472429100,
            0.611254006500,
            0.611035629100,
            0.610817296800,
            0.610599009600,
            0.610380767400,
            0.610162570300,
            0.609944418200,
            0.609726311000,
            0.609508248800,
            0.609290231500,
            0.609072259000,
            0.608854331500,
            0.608636448700,
            0.608418610800,
            0.608200817600,
            0.607983069100,
            0.607765365400,
            0.607547706300,
            0.607330091900,
            0.607112522100,
            0.606894996900,
            0.606677516300,
            0.606460080200,
            0.606242688600,
            0.606025341500,
            0.605808038800,
            0.605590780600,
            0.605373566700,
            0.605156397200,
            0.604939272000,
            0.604722191200,
            0.604505154600,
            0.604288162200,
            0.604071214100,
            0.603854310100,
            0.603637450300,
            0.603420634600,
            0.603203863000,
            0.602987135500,
            0.602770452000,
            0.602553812500,
            0.602337217000,
            0.602120665500,
            0.601904157800,
            0.601687694100,
            0.601471274200,
            0.601254898100,
            0.601038565900,
            0.600822277400,
            0.600606032600,
            0.600389831600,
            0.600173674200,
            0.599957560500,
            0.599741490400,
            0.599525463900,
            0.599309480900,
            0.599093541500,
            0.598877645600,
            0.598661793100,
            0.598445984100,
            0.598230218500,
            0.598014496300,
            0.597798817400,
            0.597583181900,
            0.597367589600,
            0.597152040600,
            0.596936534900,
            0.596721072300,
            0.596505652900,
            0.596290276600,
            0.596074943500,
            0.595859653400,
            0.595644406400,
            0.595429202400,
            0.595214041400,
            0.594998923300,
            0.594783848200,
            0.594568815900,
            0.594353826600,
            0.594138880000,
            0.593923976300,
            0.593709115300,
            0.593494297100,
            0.593279521600,
            0.593064788800,
            0.592850098600,
            0.592635451100,
            0.592420846100,
            0.592206283800,
            0.591991763900,
            0.591777286500,
            0.591562851600,
            0.591348459200,
            0.591134109100,
            0.590919801500,
            0.590705536200,
            0.590491313100,
            0.590277132400,
            0.590062993900,
            0.589848897700,
            0.589634843600,
            0.589420831700,
            0.589206862000,
            0.588992934300,
            0.588779048700,
            0.588565205100,
            0.588351403600,
            0.588137644000,
            0.587923926300,
            0.587710250600,
            0.587496616800,
            0.587283024800,
            0.587069474600,
            0.586855966200,
            0.586642499600,
            0.586429074700,
            0.586215691400,
            0.586002349900,
            0.585789050000,
            0.585575791700,
            0.585362574900,
            0.585149399700,
            0.584936266000,
            0.584723173800,
            0.584510123000,
            0.584297113600,
            0.584084145600,
            0.583871219000,
            0.583658333700,
            0.583445489600,
            0.583232686900,
            0.583019925300,
            0.582807204900,
            0.582594525700,
            0.582381887700,
            0.582169290700,
            0.581956734800,
            0.581744219900,
            0.581531746100,
            0.581319313200,
            0.581106921200,
            0.580894570200,
            0.580682260000,
            0.580469990700,
            0.580257762200,
            0.580045574400,
            0.579833427400,
            0.579621321200,
            0.579409255600,
            0.579197230700,
            0.578985246400,
            0.578773302700,
            0.578561399500,
            0.578349536900,
            0.578137714800,
            0.577925933100,
            0.577714191800,
            0.577502491000,
            0.577290830500,
            0.577079210400,
            0.576867630600,
            0.576656091000,
            0.576444591700,
            0.576233132600,
            0.576021713600,
            0.575810334800,
            0.575598996200,
            0.575387697500,
            0.575176439000,
            0.574965220400,
            0.574754041900,
            0.574542903300,
            0.574331804600,
            0.574120745800,
            0.573909726800,
            0.573698747700,
            0.573487808300,
            0.573276908700,
            0.573066048900,
            0.572855228700,
            0.572644448200,
            0.572433707300,
            0.572223006000,
            0.572012344300,
            0.571801722100,
            0.571591139400,
            0.571380596100,
            0.571170092300,
            0.570959627900,
            0.570749202900,
            0.570538817200,
            0.570328470800,
            0.570118163700,
            0.569907895800,
            0.569697667100,
            0.569487477600,
            0.569277327200,
            0.569067216000,
            0.568857143800,
            0.568647110700,
            0.568437116500,
            0.568227161400,
            0.568017245200,
            0.567807367900,
            0.567597529500,
            0.567387729900,
            0.567177969200,
            0.566968247200,
            0.566758564000,
            0.566548919500,
            0.566339313600,
            0.566129746500,
            0.565920217900,
            0.565710727900,
            0.565501276500,
            0.565291863600,
            0.565082489200,
            0.564873153200,
            0.564663855700,
            0.564454596600,
            0.564245375800,
            0.564036193300,
            0.563827049100,
            0.563617943200,
            0.563408875500,
            0.563199846000,
            0.562990854600,
            0.562781901400,
            0.562572986300,
            0.562364109200,
            0.562155270100,
            0.561946469100,
            0.561737706000,
            0.561528980800,
            0.561320293500,
            0.561111644100,
            0.560903032500,
            0.560694458700,
            0.560485922700,
            0.560277424400,
            0.560068963700,
            0.559860540800,
            0.559652155500,
            0.559443807800,
            0.559235497600,
            0.559027225000,
            0.558818989800,
            0.558610792100,
            0.558402631900,
            0.558194509000,
            0.557986423600,
            0.557778375400,
            0.557570364600,
            0.557362391000,
            0.557154454600,
            0.556946555400,
            0.556738693400,
            0.556530868600,
            0.556323080800,
            0.556115330100,
            0.555907616400,
            0.555699939700,
            0.555492300000,
            0.555284697200,
            0.555077131300,
            0.554869602300,
            0.554662110100,
            0.554454654700,
            0.554247236100,
            0.554039854200,
            0.553832509000,
            0.553625200400,
            0.553417928500,
            0.553210693200,
            0.553003494400,
            0.552796332200,
            0.552589206500,
            0.552382117200,
            0.552175064400,
            0.551968048000,
            0.551761067900,
            0.551554124100,
            0.551347216700,
            0.551140345500,
            0.550933510600,
            0.550726711800,
            0.550519949200,
            0.550313222700,
            0.550106532300,
            0.549899878000,
            0.549693259700,
            0.549486677400,
            0.549280131100,
            0.549073620700,
            0.548867146200,
            0.548660707500,
            0.548454304700,
            0.548247937600,
            0.548041606400,
            0.547835310800,
            0.547629050900,
            0.547422826700,
            0.547216638200,
            0.547010485200,
            0.546804367700,
            0.546598285800,
            0.546392239400,
            0.546186228400,
            0.545980252900,
            0.545774312700,
            0.545568407900,
            0.545362538400,
            0.545156704300,
            0.544950905300,
            0.544745141600,
            0.544539413100,
            0.544333719700,
            0.544128061400,
            0.543922438300,
            0.543716850100,
            0.543511297000,
            0.543305778900,
            0.543100295700,
            0.542894847500,
            0.542689434100,
            0.542484055600,
            0.542278711900,
            0.542073403000,
            0.541868128800,
            0.541662889300,
            0.541457684500,
            0.541252514400,
            0.541047378900,
            0.540842277900,
            0.540637211500,
            0.540432179600,
            0.540227182200,
            0.540022219200,
            0.539817290700,
            0.539612396500,
            0.539407536700,
            0.539202711100,
            0.538997919900,
            0.538793162900,
            0.538588440100,
            0.538383751400,
            0.538179096900,
            0.537974476500,
            0.537769890200,
            0.537565337900,
            0.537360819700,
            0.537156335400,
            0.536951885000,
            0.536747468500,
            0.536543085900,
            0.536338737200,
            0.536134422200,
            0.535930141000,
            0.535725893600,
            0.535521679800,
            0.535317499700,
            0.535113353200,
            0.534909240400,
            0.534705161100,
            0.534501115300,
            0.534297103000,
            0.534093124200,
            0.533889178800,
            0.533685266900,
            0.533481388200,
            0.533277542900,
            0.533073730900,
            0.532869952200,
            0.532666206700,
            0.532462494400,
            0.532258815200,
            0.532055169200,
            0.531851556200,
            0.531647976300,
            0.531444429400,
            0.531240915600,
            0.531037434600,
            0.530833986600,
            0.530630571500,
            0.530427189200,
            0.530223839800,
            0.530020523100,
            0.529817239200,
            0.529613988100,
            0.529410769600,
            0.529207583700,
            0.529004430500,
            0.528801309800,
            0.528598221700,
            0.528395166100,
            0.528192143000,
            0.527989152400,
            0.527786194100,
            0.527583268300,
            0.527380374800,
            0.527177513600,
            0.526974684600,
            0.526771888000,
            0.526569123500,
            0.526366391200,
            0.526163691100,
            0.525961023000,
            0.525758387100,
            0.525555783100,
            0.525353211200,
            0.525150671300,
            0.524948163300,
            0.524745687200,
            0.524543243000,
            0.524340830700,
            0.524138450100,
            0.523936101300,
            0.523733784300,
            0.523531498900,
            0.523329245200,
            0.523127023200,
            0.522924832800,
            0.522722673900,
            0.522520546600,
            0.522318450700,
            0.522116386400,
            0.521914353500,
            0.521712351900,
            0.521510381800,
            0.521308443000,
            0.521106535500,
            0.520904659200,
            0.520702814200,
            0.520501000400,
            0.520299217700,
            0.520097466200,
            0.519895745800,
            0.519694056400,
            0.519492398100,
            0.519290770800,
            0.519089174400,
            0.518887609000,
            0.518686074500,
            0.518484570800,
            0.518283098000,
            0.518081655900,
            0.517880244600,
            0.517678864100,
            0.517477514200,
            0.517276195000,
            0.517074906500,
            0.516873648500,
            0.516672421100,
            0.516471224200,
            0.516270057800,
            0.516068921900,
            0.515867816400,
            0.515666741300,
            0.515465696600,
            0.515264682200,
            0.515063698000,
            0.514862744200,
            0.514661820600,
            0.514460927100,
            0.514260063800,
            0.514059230700,
            0.513858427600,
            0.513657654600,
            0.513456911600,
            0.513256198700,
            0.513055515600,
            0.512854862600,
            0.512654239400,
            0.512453646000,
            0.512253082500,
            0.512052548800,
            0.511852044800,
            0.511651570600,
            0.511451126000,
            0.511250711100,
            0.511050325900,
            0.510849970200,
            0.510649644100,
            0.510449347600,
            0.510249080500,
            0.510048842800,
            0.509848634700,
            0.509648455900,
            0.509448306400,
            0.509248186300,
            0.509048095500,
            0.508848033900,
            0.508648001600,
            0.508447998500,
            0.508248024500,
            0.508048079700,
            0.507848163900,
            0.507648277300,
            0.507448419600,
            0.507248591000,
            0.507048791300,
            0.506849020500,
            0.506649278600,
            0.506449565700,
            0.506249881500,
            0.506050226100,
            0.505850599500,
            0.505651001700,
            0.505451432500,
            0.505251892000,
            0.505052380100,
            0.504852896900,
            0.504653442200,
            0.504454016000,
            0.504254618400,
            0.504055249200,
            0.503855908500,
            0.503656596100,
            0.503457312100,
            0.503258056500,
            0.503058829200,
            0.502859630100,
            0.502660459300,
            0.502461316700,
            0.502262202300,
            0.502063116000,
            0.501864057900,
            0.501665027800,
            0.501466025700,
            0.501267051700,
            0.501068105600,
            0.500869187500,
            0.500670297300,
            0.500471435000,
            0.500272600600,
            0.500073793900,
            0.499875015100,
            0.499676264000,
            0.499477540600,
            0.499278844900,
            0.499080176800,
            0.498881536400,
            0.498682923600,
            0.498484338300,
            0.498285780500,
            0.498087250300,
            0.497888747500,
            0.497690272100,
            0.497491824100,
            0.497293403500,
            0.497095010300,
            0.496896644300,
            0.496698305600,
            0.496499994100,
            0.496301709800,
            0.496103452700,
            0.495905222800,
            0.495707019900,
            0.495508844100,
            0.495310695400,
            0.495112573700,
            0.494914478900,
            0.494716411100,
            0.494518370200,
            0.494320356200,
            0.494122369100,
            0.493924408700,
            0.493726475200,
            0.493528568400,
            0.493330688300,
            0.493132834900,
            0.492935008200,
            0.492737208100,
            0.492539434600,
            0.492341687600,
            0.492143967200,
            0.491946273300,
            0.491748605900,
            0.491550964900,
            0.491353350300,
            0.491155762100,
            0.490958200200,
            0.490760664600,
            0.490563155300,
            0.490365672300,
            0.490168215400,
            0.489970784800,
            0.489773380300,
            0.489576001900,
            0.489378649600,
            0.489181323400,
            0.488984023200,
            0.488786749000,
            0.488589500700,
            0.488392278400,
            0.488195082000,
            0.487997911500,
            0.487800766800,
            0.487603647900,
            0.487406554800,
            0.487209487400,
            0.487012445800,
            0.486815429800,
            0.486618439500,
            0.486421474800,
            0.486224535600,
            0.486027622100,
            0.485830734100,
            0.485633871500,
            0.485437034500,
            0.485240222800,
            0.485043436600,
            0.484846675700,
            0.484649940200,
            0.484453230000,
            0.484256545100,
            0.484059885400,
            0.483863251000,
            0.483666641700,
            0.483470057600,
            0.483273498600,
            0.483076964700,
            0.482880455900,
            0.482683972100,
            0.482487513300,
            0.482291079500,
            0.482094670600,
            0.481898286600,
            0.481701927600,
            0.481505593300,
            0.481309283900,
            0.481112999300,
            0.480916739500,
            0.480720504300,
            0.480524293900,
            0.480328108100,
            0.480131947000,
            0.479935810500,
            0.479739698600,
            0.479543611200,
            0.479347548300,
            0.479151509900,
            0.478955496000,
            0.478759506500,
            0.478563541400,
            0.478367600700,
            0.478171684300,
            0.477975792200,
            0.477779924400,
            0.477584080800,
            0.477388261500,
            0.477192466300,
            0.476996695300,
            0.476800948400,
            0.476605225700,
            0.476409526900,
            0.476213852300,
            0.476018201600,
            0.475822574900,
            0.475626972200,
            0.475431393400,
            0.475235838500,
            0.475040307400,
            0.474844800200,
            0.474649316800,
            0.474453857200,
            0.474258421300,
            0.474063009100,
            0.473867620600,
            0.473672255700,
            0.473476914500,
            0.473281596900,
            0.473086302800,
            0.472891032300,
            0.472695785300,
            0.472500561800,
            0.472305361700,
            0.472110185000,
            0.471915031800,
            0.471719901900,
            0.471524795300,
            0.471329712100,
            0.471134652100,
            0.470939615400,
            0.470744601900,
            0.470549611600,
            0.470354644400,
            0.470159700400,
            0.469964779500,
            0.469769881600,
            0.469575006900,
            0.469380155100,
            0.469185326300,
            0.468990520500,
            0.468795737600,
            0.468600977600,
            0.468406240500,
            0.468211526300,
            0.468016834900,
            0.467822166200,
            0.467627520300,
            0.467432897200,
            0.467238296800,
            0.467043719000,
            0.466849163900,
            0.466654631400,
            0.466460121600,
            0.466265634200,
            0.466071169500,
            0.465876727200,
            0.465682307400,
            0.465487910100,
            0.465293535200,
            0.465099182700,
            0.464904852600,
            0.464710544800,
            0.464516259300,
            0.464321996100,
            0.464127755200,
            0.463933536500,
            0.463739340000,
            0.463545165700,
            0.463351013600,
            0.463156883600,
            0.462962775600,
            0.462768689800,
            0.462574625900,
            0.462380584100,
            0.462186564300,
            0.461992566400,
            0.461798590500,
            0.461604636500,
            0.461410704400,
            0.461216794100,
            0.461022905600,
            0.460829038900,
            0.460635194000,
            0.460441370900,
            0.460247569400,
            0.460053789700,
            0.459860031600,
            0.459666295100,
            0.459472580300,
            0.459278887000,
            0.459085215300,
            0.458891565200,
            0.458697936500,
            0.458504329300,
            0.458310743500,
            0.458117179200,
            0.457923636300,
            0.457730114800,
            0.457536614600,
            0.457343135700,
            0.457149678100,
            0.456956241700,
            0.456762826700,
            0.456569432800,
            0.456376060100,
            0.456182708600,
            0.455989378200,
            0.455796068900,
            0.455602780700,
            0.455409513600,
            0.455216267500,
            0.455023042400,
            0.454829838300,
            0.454636655100,
            0.454443492900,
            0.454250351500,
            0.454057231100,
            0.453864131500,
            0.453671052700,
            0.453477994800,
            0.453284957600,
            0.453091941200,
            0.452898945500,
            0.452705970400,
            0.452513016100,
            0.452320082400,
            0.452127169400,
            0.451934276900,
            0.451741405100,
            0.451548553700,
            0.451355722900,
            0.451162912600,
            0.450970122800,
            0.450777353400,
            0.450584604500,
            0.450391875900,
            0.450199167800,
            0.450006480000,
            0.449813812500,
            0.449621165300,
            0.449428538400,
            0.449235931700,
            0.449043345300,
            0.448850779100,
            0.448658233100,
            0.448465707200,
            0.448273201500,
            0.448080715800,
            0.447888250300,
            0.447695804800,
            0.447503379400,
            0.447310973900,
            0.447118588500,
            0.446926223000,
            0.446733877500,
            0.446541551800,
            0.446349246100,
            0.446156960300,
            0.445964694200,
            0.445772448100,
            0.445580221700,
            0.445388015000,
            0.445195828200,
            0.445003661100,
            0.444811513600,
            0.444619385900,
            0.444427277800,
            0.444235189400,
            0.444043120500,
            0.443851071300,
            0.443659041600,
            0.443467031500,
            0.443275040900,
            0.443083069700,
            0.442891118100,
            0.442699185900,
            0.442507273200,
            0.442315379800,
            0.442123505800,
            0.441931651200,
            0.441739816000,
            0.441548000000,
            0.441356203400,
            0.441164426000,
            0.440972667800,
            0.440780928900,
            0.440589209200,
            0.440397508700,
            0.440205827400,
            0.440014165100,
            0.439822522000,
            0.439630898000,
            0.439439293100,
            0.439247707200,
            0.439056140300,
            0.438864592500,
            0.438673063600,
            0.438481553700,
            0.438290062800,
            0.438098590700,
            0.437907137600,
            0.437715703300,
            0.437524287900,
            0.437332891300,
            0.437141513600,
            0.436950154600,
            0.436758814400,
            0.436567493000,
            0.436376190200,
            0.436184906200,
            0.435993640900,
            0.435802394200,
            0.435611166200,
            0.435419956800,
            0.435228766100,
            0.435037593800,
            0.434846440200,
            0.434655305100,
            0.434464188500,
            0.434273090400,
            0.434082010800,
            0.433890949700,
            0.433699907000,
            0.433508882700,
            0.433317876800,
            0.433126889300,
            0.432935920200,
            0.432744969300,
            0.432554036800,
            0.432363122700,
            0.432172226700,
            0.431981349100,
            0.431790489600,
            0.431599648400,
            0.431408825400,
            0.431218020600,
            0.431027234000,
            0.430836465400,
            0.430645715000,
            0.430454982700,
            0.430264268500,
            0.430073572300,
            0.429882894200,
            0.429692234100,
            0.429501592100,
            0.429310968000,
            0.429120361800,
            0.428929773700,
            0.428739203400,
            0.428548651100,
            0.428358116600,
            0.428167600000,
            0.427977101300,
            0.427786620400,
            0.427596157400,
            0.427405712100,
            0.427215284600,
            0.427024874900,
            0.426834482900,
            0.426644108700,
            0.426453752100,
            0.426263413300,
            0.426073092100,
            0.425882788600,
            0.425692502700,
            0.425502234400,
            0.425311983700,
            0.425121750600,
            0.424931535100,
            0.424741337100,
            0.424551156600,
            0.424360993700,
            0.424170848300,
            0.423980720300,
            0.423790609800,
            0.423600516700,
            0.423410441100,
            0.423220382800,
            0.423030342000,
            0.422840318500,
            0.422650312400,
            0.422460323600,
            0.422270352200,
            0.422080398000,
            0.421890461200,
            0.421700541600,
            0.421510639200,
            0.421320754200,
            0.421130886300,
            0.420941035600,
            0.420751202200,
            0.420561385900,
            0.420371586700,
            0.420181804700,
            0.419992039900,
            0.419802292100,
            0.419612561500,
            0.419422847900,
            0.419233151300,
            0.419043471900,
            0.418853809400,
            0.418664164000,
            0.418474535500,
            0.418284924100,
            0.418095329600,
            0.417905752100,
            0.417716191500,
            0.417526647800,
            0.417337121100,
            0.417147611200,
            0.416958118200,
            0.416768642100,
            0.416579182800,
            0.416389740300,
            0.416200314700,
            0.416010905800,
            0.415821513800,
            0.415632138500,
            0.415442780000,
            0.415253438200,
            0.415064113200,
            0.414874804800,
            0.414685513200,
            0.414496238300,
            0.414306980000,
            0.414117738400,
            0.413928513400,
            0.413739305100,
            0.413550113300,
            0.413360938200,
            0.413171779700,
            0.412982637700,
            0.412793512300,
            0.412604403500,
            0.412415311100,
            0.412226235300,
            0.412037176100,
            0.411848133300,
            0.411659106900,
            0.411470097100,
            0.411281103700,
            0.411092126700,
            0.410903166200,
            0.410714222100,
            0.410525294400,
            0.410336383100,
            0.410147488100,
            0.409958609600,
            0.409769747300,
            0.409580901400,
            0.409392071900,
            0.409203258600,
            0.409014461700,
            0.408825681000,
            0.408636916700,
            0.408448168500,
            0.408259436700,
            0.408070721100,
            0.407882021700,
            0.407693338500,
            0.407504671500,
            0.407316020800,
            0.407127386200,
            0.406938767800,
            0.406750165500,
            0.406561579400,
            0.406373009400,
            0.406184455600,
            0.405995917900,
            0.405807396200,
            0.405618890700,
            0.405430401200,
            0.405241927800,
            0.405053470500,
            0.404865029200,
            0.404676604000,
            0.404488194800,
            0.404299801600,
            0.404111424400,
            0.403923063200,
            0.403734718000,
            0.403546388800,
            0.403358075500,
            0.403169778200,
            0.402981496800,
            0.402793231400,
            0.402604981900,
            0.402416748300,
            0.402228530600,
            0.402040328800,
            0.401852142900,
            0.401663972800,
            0.401475818700,
            0.401287680400,
            0.401099557900,
            0.400911451300,
            0.400723360500,
            0.400535285500,
            0.400347226400,
            0.400159183000,
            0.399971155400,
            0.399783143600,
            0.399595147600,
            0.399407167400,
            0.399219202900,
            0.399031254200,
            0.398843321200,
            0.398655403900,
            0.398467502400,
            0.398279616600,
            0.398091746500,
            0.397903892000,
            0.397716053300,
            0.397528230300,
            0.397340422900,
            0.397152631200,
            0.396964855200,
            0.396777094800,
            0.396589350100,
            0.396401621000,
            0.396213907500,
            0.396026209700,
            0.395838527400,
            0.395650860800,
            0.395463209800,
            0.395275574400,
            0.395087954500,
            0.394900350300,
            0.394712761600,
            0.394525188500,
            0.394337630900,
            0.394150088900,
            0.393962562400,
            0.393775051500,
            0.393587556100,
            0.393400076300,
            0.393212611900,
            0.393025163100,
            0.392837729800,
            0.392650312000,
            0.392462909600,
            0.392275522800,
            0.392088151500,
            0.391900795600,
            0.391713455200,
            0.391526130300,
            0.391338820800,
            0.391151526800,
            0.390964248300,
            0.390776985200,
            0.390589737500,
            0.390402505300,
            0.390215288500,
            0.390028087100,
            0.389840901200,
            0.389653730600,
            0.389466575500,
            0.389279435800,
            0.389092311500,
            0.388905202600,
            0.388718109100,
            0.388531030900,
            0.388343968200,
            0.388156920800,
            0.387969888800,
            0.387782872200,
            0.387595871000,
            0.387408885100,
            0.387221914600,
            0.387034959400,
            0.386848019600,
            0.386661095100,
            0.386474186000,
            0.386287292300,
            0.386100413800,
            0.385913550700,
            0.385726703000,
            0.385539870500,
            0.385353053400,
            0.385166251700,
            0.384979465200,
            0.384792694100,
            0.384605938200,
            0.384419197700,
            0.384232472500,
            0.384045762700,
            0.383859068100,
            0.383672388800,
            0.383485724800,
            0.383299076100,
            0.383112442800,
            0.382925824700,
            0.382739221900,
            0.382552634400,
            0.382366062200,
            0.382179505300,
            0.381992963600,
            0.381806437300,
            0.381619926200,
            0.381433430400,
            0.381246949900,
            0.381060484700,
            0.380874034800,
            0.380687600100,
            0.380501180700,
            0.380314776600,
            0.380128387800,
            0.379942014200,
            0.379755655900,
            0.379569312900,
            0.379382985100,
            0.379196672700,
            0.379010375500,
            0.378824093600,
            0.378637826900,
            0.378451575500,
            0.378265339400,
            0.378079118600,
            0.377892913000,
            0.377706722700,
            0.377520547700,
            0.377334388000,
            0.377148243500,
            0.376962114300,
            0.376776000400,
            0.376589901700,
            0.376403818300,
            0.376217750200,
            0.376031697400,
            0.375845659900,
            0.375659637600,
            0.375473630700,
            0.375287639000,
            0.375101662600,
            0.374915701500,
            0.374729755600,
            0.374543825100,
            0.374357909900,
            0.374172009900,
            0.373986125200,
            0.373800255900,
            0.373614401800,
            0.373428563100,
            0.373242739600,
            0.373056931400,
            0.372871138600,
            0.372685361100,
            0.372499598900,
            0.372313851900,
            0.372128120400,
            0.371942404100,
            0.371756703200,
            0.371571017600,
            0.371385347300,
            0.371199692300,
            0.371014052700,
            0.370828428500,
            0.370642819500,
            0.370457226000,
            0.370271647700,
            0.370086084900,
            0.369900537400,
            0.369715005200,
            0.369529488400,
            0.369343987000,
            0.369158501000,
            0.368973030300,
            0.368787575000,
            0.368602135100,
            0.368416710600,
            0.368231301500,
            0.368045907800,
            0.367860529500,
            0.367675166600,
            0.367489819200,
            0.367304487100,
            0.367119170500,
            0.366933869300,
            0.366748583500,
            0.366563313200,
            0.366378058300,
            0.366192818900,
            0.366007594900,
            0.365822386400,
            0.365637193300,
            0.365452015800,
            0.365266853700,
            0.365081707100,
            0.364896576000,
            0.364711460400,
            0.364526360200,
            0.364341275600,
            0.364156206600,
            0.363971153000,
            0.363786115000,
            0.363601092500,
            0.363416085500,
            0.363231094100,
            0.363046118200,
            0.362861158000,
            0.362676213200,
            0.362491284100,
            0.362306370600,
            0.362121472600,
            0.361936590200,
            0.361751723500,
            0.361566872300,
            0.361382036800,
            0.361197216900,
            0.361012412700,
            0.360827624100,
            0.360642851100,
            0.360458093800,
            0.360273352200,
            0.360088626300,
            0.359903916000,
            0.359719221400,
            0.359534542600,
            0.359349879400,
            0.359165232000,
            0.358980600300,
            0.358795984400,
            0.358611384100,
            0.358426799700,
            0.358242231000,
            0.358057678100,
            0.357873141000,
            0.357688619600,
            0.357504114100,
            0.357319624400,
            0.357135150500,
            0.356950692400,
            0.356766250100,
            0.356581823800,
            0.356397413300,
            0.356213018600,
            0.356028639800,
            0.355844277000,
            0.355659930000,
            0.355475598900,
            0.355291283800,
            0.355106984600,
            0.354922701300,
            0.354738434000,
            0.354554182700,
            0.354369947300,
            0.354185728000,
            0.354001524600,
            0.353817337200,
            0.353633165900,
            0.353449010600,
            0.353264871300,
            0.353080748100,
            0.352896641000,
            0.352712549900,
            0.352528474900,
            0.352344416000,
            0.352160373300,
            0.351976346700,
            0.351792336200,
            0.351608341800,
            0.351424363600,
            0.351240401600,
            0.351056455800,
            0.350872526200,
            0.350688612800,
            0.350504715700,
            0.350320834700,
            0.350136970000,
            0.349953121600,
            0.349769289500,
            0.349585473600,
            0.349401674100,
            0.349217890900,
            0.349034124000,
            0.348850373400,
            0.348666639300,
            0.348482921400,
            0.348299220000,
            0.348115535000,
            0.347931866400,
            0.347748214200,
            0.347564578400,
            0.347380959200,
            0.347197356300,
            0.347013770000,
            0.346830200200,
            0.346646646900,
            0.346463110100,
            0.346279589800,
            0.346096086200,
            0.345912599000,
            0.345729128500,
            0.345545674600,
            0.345362237300,
            0.345178816700,
            0.344995412600,
            0.344812025300,
            0.344628654600,
            0.344445300700,
            0.344261963400,
            0.344078642900,
            0.343895339100,
            0.343712052100,
            0.343528781800,
            0.343345528400,
            0.343162291700,
            0.342979071900,
            0.342795868900,
            0.342612682800,
            0.342429513500,
            0.342246361200,
            0.342063225700,
            0.341880107200,
            0.341697005600,
            0.341513921000,
            0.341330853400,
            0.341147802700,
            0.340964769100,
            0.340781752500,
            0.340598752900,
            0.340415770400,
            0.340232805000,
            0.340049856700,
            0.339866925400,
            0.339684011400,
            0.339501114500,
            0.339318234700,
            0.339135372100,
            0.338952526800,
            0.338769698700,
            0.338586887800,
            0.338404094200,
            0.338221317800,
            0.338038558800,
            0.337855817000,
            0.337673092700,
            0.337490385600,
            0.337307696000,
            0.337125023700,
            0.336942368900,
            0.336759731500,
            0.336577111500,
            0.336394509000,
            0.336211924000,
            0.336029356600,
            0.335846806600,
            0.335664274200,
            0.335481759400,
            0.335299262200,
            0.335116782500,
            0.334934320500,
            0.334751876200,
            0.334569449500,
            0.334387040600,
            0.334204649300,
            0.334022275800,
            0.333839920000,
            0.333657582000,
            0.333475261800,
            0.333292959400,
            0.333110674900,
            0.332928408200,
            0.332746159400,
            0.332563928500,
            0.332381715500,
            0.332199520500,
            0.332017343400,
            0.331835184400,
            0.331653043300,
            0.331470920300,
            0.331288815300,
            0.331106728400,
            0.330924659600,
            0.330742608900,
            0.330560576400,
            0.330378562000,
            0.330196565800,
            0.330014587900,
            0.329832628100,
            0.329650686600,
            0.329468763400,
            0.329286858500,
            0.329104972000,
            0.328923103700,
            0.328741253900,
            0.328559422400,
            0.328377609400,
            0.328195814800,
            0.328014038600,
            0.327832281000,
            0.327650541900,
            0.327468821300,
            0.327287119200,
            0.327105435800,
            0.326923770900,
            0.326742124700,
            0.326560497100,
            0.326378888300,
            0.326197298100,
            0.326015726600,
            0.325834174000,
            0.325652640000,
            0.325471124900,
            0.325289628700,
            0.325108151200,
            0.324926692700,
            0.324745253000,
            0.324563832300,
            0.324382430600,
            0.324201047800,
            0.324019684000,
            0.323838339300,
            0.323657013600,
            0.323475707000,
            0.323294419400,
            0.323113151100,
            0.322931901900,
            0.322750671800,
            0.322569461000,
            0.322388269500,
            0.322207097100,
            0.322025944100,
            0.321844810400,
            0.321663696100,
            0.321482601100,
            0.321301525500,
            0.321120469300,
            0.320939432600,
            0.320758415300,
            0.320577417600,
            0.320396439400,
            0.320215480700,
            0.320034541700,
            0.319853622200,
            0.319672722400,
            0.319491842300,
            0.319310981800,
            0.319130141100,
            0.318949320200,
            0.318768519000,
            0.318587737600,
            0.318406976100,
            0.318226234400,
            0.318045512600,
            0.317864810700,
            0.317684128800,
            0.317503466900,
            0.317322825000,
            0.317142203100,
            0.316961601200,
            0.316781019500,
            0.316600457900,
            0.316419916400,
            0.316239395100,
            0.316058894000,
            0.315878413200,
            0.315697952600,
            0.315517512400,
            0.315337092400,
            0.315156692800,
            0.314976313600,
            0.314795954800,
            0.314615616500,
            0.314435298600,
            0.314255001300,
            0.314074724500,
            0.313894468200,
            0.313714232500,
            0.313534017500,
            0.313353823100,
            0.313173649400,
            0.312993496500,
            0.312813364200,
            0.312633252800,
            0.312453162200,
            0.312273092400,
            0.312093043500,
            0.311913015500,
            0.311733008400,
            0.311553022300,
            0.311373057200,
            0.311193113100,
            0.311013190000,
            0.310833288100,
            0.310653407300,
            0.310473547700,
            0.310293709200,
            0.310113892000,
            0.309934096000,
            0.309754321300,
            0.309574567900,
            0.309394835800,
            0.309215125200,
            0.309035435900,
            0.308855768100,
            0.308676121800,
            0.308496497000,
            0.308316893700,
            0.308137312000,
            0.307957751900,
            0.307778213500,
            0.307598696700,
            0.307419201700,
            0.307239728400,
            0.307060276800,
            0.306880847100,
            0.306701439200,
            0.306522053200,
            0.306342689100,
            0.306163347000,
            0.305984026800,
            0.305804728600,
            0.305625452500,
            0.305446198500,
            0.305266966500,
            0.305087756700,
            0.304908569200,
            0.304729403800,
            0.304550260600,
            0.304371139800,
            0.304192041300,
            0.304012965100,
            0.303833911300,
            0.303654880000,
            0.303475871100,
            0.303296884700,
            0.303117920800,
            0.302938979500,
            0.302760060800,
            0.302581164700,
            0.302402291300,
            0.302223440600,
            0.302044612700,
            0.301865807500,
            0.301687025200,
            0.301508265600,
            0.301329529000,
            0.301150815300,
            0.300972124600,
            0.300793456800,
            0.300614812100,
            0.300436190400,
            0.300257591900,
            0.300079016500,
            0.299900464200,
            0.299721935200,
            0.299543429400,
            0.299364946900,
            0.299186487800,
            0.299008052000,
            0.298829639600,
            0.298651250600,
            0.298472885100,
            0.298294543100,
            0.298116224600,
            0.297937929700,
            0.297759658500,
            0.297581410900,
            0.297403187000,
            0.297224986800,
            0.297046810400,
            0.296868657800,
            0.296690529100,
            0.296512424200,
            0.296334343300,
            0.296156286300,
            0.295978253300,
            0.295800244400,
            0.295622259500,
            0.295444298800,
            0.295266362200,
            0.295088449800,
            0.294910561600,
            0.294732697700,
            0.294554858100,
            0.294377042900,
            0.294199252000,
            0.294021485600,
            0.293843743600,
            0.293666026100,
            0.293488333200,
            0.293310664800,
            0.293133021100,
            0.292955402100,
            0.292777807700,
            0.292600238100,
            0.292422693200,
            0.292245173200,
            0.292067678000,
            0.291890207800,
            0.291712762400,
            0.291535342100,
            0.291357946700,
            0.291180576500,
            0.291003231300,
            0.290825911300,
            0.290648616400,
            0.290471346800,
            0.290294102400,
            0.290116883400,
            0.289939689700,
            0.289762521300,
            0.289585378400,
            0.289408261000,
            0.289231169100,
            0.289054102700,
            0.288877061900,
            0.288700046700,
            0.288523057200,
            0.288346093500,
            0.288169155500,
            0.287992243200,
            0.287815356900,
            0.287638496400,
            0.287461661800,
            0.287284853200,
            0.287108070600,
            0.286931314000,
            0.286754583500,
            0.286577879200,
            0.286401201000,
            0.286224549100,
            0.286047923400,
            0.285871324000,
            0.285694751000,
            0.285518204300,
            0.285341684100,
            0.285165190300,
            0.284988723100,
            0.284812282400,
            0.284635868300,
            0.284459480900,
            0.284283120100,
            0.284106786100,
            0.283930478900,
            0.283754198400,
            0.283577944800,
            0.283401718200,
            0.283225518500,
            0.283049345700,
            0.282873200000,
            0.282697081400,
            0.282520989900,
            0.282344925500,
            0.282168888400,
            0.281992878500,
            0.281816895900,
            0.281640940700,
            0.281465012800,
            0.281289112400,
            0.281113239500,
            0.280937394000,
            0.280761576100,
            0.280585785900,
            0.280410023300,
            0.280234288300,
            0.280058581100,
            0.279882901700,
            0.279707250200,
            0.279531626500,
            0.279356030700,
            0.279180462900,
            0.279004923100,
            0.278829411300,
            0.278653927700,
            0.278478472200,
            0.278303044800,
            0.278127645800,
            0.277952275000,
            0.277776932500,
            0.277601618400,
            0.277426332700,
            0.277251075500,
            0.277075846800,
            0.276900646600,
            0.276725475100,
            0.276550332200,
            0.276375218000,
            0.276200132500,
            0.276025075800,
            0.275850047900,
            0.275675049000,
            0.275500078900,
            0.275325137800,
            0.275150225700,
            0.274975342700,
            0.274800488800,
            0.274625664100,
            0.274450868600,
            0.274276102300,
            0.274101365300,
            0.273926657700,
            0.273751979400,
            0.273577330600,
            0.273402711300,
            0.273228121500,
            0.273053561200,
            0.272879030600,
            0.272704529700,
            0.272530058500,
            0.272355617100,
            0.272181205500,
            0.272006823700,
            0.271832471900,
            0.271658150000,
            0.271483858100,
            0.271309596300,
            0.271135364600,
            0.270961163100,
            0.270786991700,
            0.270612850600,
            0.270438739700,
            0.270264659300,
            0.270090609200,
            0.269916589500,
            0.269742600400,
            0.269568641700,
            0.269394713700,
            0.269220816300,
            0.269046949500,
            0.268873113500,
            0.268699308300,
            0.268525533900,
            0.268351790400,
            0.268178077800,
            0.268004396200,
            0.267830745600,
            0.267657126100,
            0.267483537700,
            0.267309980400,
            0.267136454400,
            0.266962959700,
            0.266789496200,
            0.266616064200,
            0.266442663500,
            0.266269294400,
            0.266095956700,
            0.265922650600,
            0.265749376100,
            0.265576133300,
            0.265402922200,
            0.265229742800,
            0.265056595300,
            0.264883479700,
            0.264710395900,
            0.264537344100,
            0.264364324300,
            0.264191336600,
            0.264018381000,
            0.263845457600,
            0.263672566400,
            0.263499707400,
            0.263326880800,
            0.263154086500,
            0.262981324700,
            0.262808595300,
            0.262635898400,
            0.262463234100,
            0.262290602400,
            0.262118003400,
            0.261945437100,
            0.261772903500,
            0.261600402800,
            0.261427935000,
            0.261255500100,
            0.261083098100,
            0.260910729200,
            0.260738393400,
            0.260566090700,
            0.260393821100,
            0.260221584800,
            0.260049381800,
            0.259877212100,
            0.259705075800,
            0.259532973000,
            0.259360903600,
            0.259188867700,
            0.259016865500,
            0.258844896900,
            0.258672962000,
            0.258501060800,
            0.258329193400,
            0.258157359900,
            0.257985560300,
            0.257813794600,
            0.257642062900,
            0.257470365300,
            0.257298701800,
            0.257127072500,
            0.256955477400,
            0.256783916500,
            0.256612390000,
            0.256440897800,
            0.256269440100,
            0.256098016800,
            0.255926628000,
            0.255755273900,
            0.255583954300,
            0.255412669500,
            0.255241419400,
            0.255070204100,
            0.254899023600,
            0.254727878000,
            0.254556767400,
            0.254385691700,
            0.254214651100,
            0.254043645700,
            0.253872675400,
            0.253701740300,
            0.253530840400,
            0.253359975900,
            0.253189146800,
            0.253018353100,
            0.252847594800,
            0.252676872100,
            0.252506185000,
            0.252335533500,
            0.252164917700,
            0.251994337700,
            0.251823793400,
            0.251653285100,
            0.251482812600,
            0.251312376000,
            0.251141975500,
            0.250971611100,
            0.250801282800,
            0.250630990600,
            0.250460734700,
            0.250290515000,
            0.250120331700,
            0.249950184800,
            0.249780074300,
            0.249610000400,
            0.249439962900,
            0.249269962100,
            0.249099998000,
            0.248930070500,
            0.248760179800,
            0.248590326000,
            0.248420509000,
            0.248250729000,
            0.248080985900,
            0.247911279900,
            0.247741611000,
            0.247571979200,
            0.247402384600,
            0.247232827300,
            0.247063307300,
            0.246893824600,
            0.246724379400,
            0.246554971700,
            0.246385601400,
            0.246216268800,
            0.246046973800,
            0.245877716500,
            0.245708497000,
            0.245539315200,
            0.245370171300,
            0.245201065400,
            0.245031997400,
            0.244862967400,
            0.244693975500,
            0.244525021700,
            0.244356106100,
            0.244187228800,
            0.244018389800,
            0.243849589100,
            0.243680826800,
            0.243512103000,
            0.243343417700,
            0.243174771000,
            0.243006162900,
            0.242837593500,
            0.242669062900,
            0.242500571000,
            0.242332118000,
            0.242163703900,
            0.241995328800,
            0.241826992700,
            0.241658695600,
            0.241490437700,
            0.241322219000,
            0.241154039500,
            0.240985899300,
            0.240817798500,
            0.240649737000,
            0.240481715100,
            0.240313732600,
            0.240145789700,
            0.239977886500,
            0.239810022900,
            0.239642199100,
            0.239474415100,
            0.239306671000,
            0.239138966700,
            0.238971302400,
            0.238803678200,
            0.238636094000,
            0.238468549900,
            0.238301046100,
            0.238133582500,
            0.237966159200,
            0.237798776200,
            0.237631433700,
            0.237464131600,
            0.237296870100,
            0.237129649200,
            0.236962468900,
            0.236795329300,
            0.236628230400,
            0.236461172400,
            0.236294155200,
            0.236127178900,
            0.235960243600,
            0.235793349400,
            0.235626496200,
            0.235459684200,
            0.235292913400,
            0.235126183900,
            0.234959495700,
            0.234792848800,
            0.234626243400,
            0.234459679500,
            0.234293157100,
            0.234126676300,
            0.233960237200,
            0.233793839800,
            0.233627484200,
            0.233461170400,
            0.233294898400,
            0.233128668400,
            0.232962480500,
            0.232796334500,
            0.232630230700,
            0.232464169100,
            0.232298149600,
            0.232132172500,
            0.231966237700,
            0.231800345300,
            0.231634495300,
            0.231468687900,
            0.231302923000,
            0.231137200700,
            0.230971521200,
            0.230805884300,
            0.230640290300,
            0.230474739100,
            0.230309230800,
            0.230143765500,
            0.229978343200,
            0.229812964000,
            0.229647627900,
            0.229482335000,
            0.229317085400,
            0.229151879100,
            0.228986716200,
            0.228821596600,
            0.228656520600,
            0.228491488100,
            0.228326499200,
            0.228161553900,
            0.227996652300,
            0.227831794600,
            0.227666980600,
            0.227502210500,
            0.227337484400,
            0.227172802200,
            0.227008164100,
            0.226843570100,
            0.226679020300,
            0.226514514700,
            0.226350053400,
            0.226185636500,
            0.226021263900,
            0.225856935800,
            0.225692652200,
            0.225528413100,
            0.225364218700,
            0.225200069000,
            0.225035964000,
            0.224871903900,
            0.224707888500,
            0.224543918100,
            0.224379992700,
            0.224216112300,
            0.224052277000,
            0.223888486800,
            0.223724741800,
            0.223561042100,
            0.223397387700,
            0.223233778700,
            0.223070215100,
            0.222906697000,
            0.222743224400,
            0.222579797500,
            0.222416416200,
            0.222253080600,
            0.222089790800,
            0.221926546900,
            0.221763348800,
            0.221600196700,
            0.221437090600,
            0.221274030500,
            0.221111016600,
            0.220948048900,
            0.220785127300,
            0.220622252100,
            0.220459423300,
            0.220296640800,
            0.220133904900,
            0.219971215400,
            0.219808572500,
            0.219645976300,
            0.219483426800,
            0.219320924000,
            0.219158468000,
            0.218996059000,
            0.218833696800,
            0.218671381600,
            0.218509113500,
            0.218346892500,
            0.218184718600,
            0.218022591900,
            0.217860512600,
            0.217698480500,
            0.217536495900,
            0.217374558700,
            0.217212669000,
            0.217050826800,
            0.216889032300,
            0.216727285400,
            0.216565586300,
            0.216403935000,
            0.216242331600,
            0.216080776000,
            0.215919268400,
            0.215757808800,
            0.215596397400,
            0.215435034000,
            0.215273718900,
            0.215112452000,
            0.214951233400,
            0.214790063100,
            0.214628941400,
            0.214467868000,
            0.214306843300,
            0.214145867100,
            0.213984939600,
            0.213824060800,
            0.213663230800,
            0.213502449600,
            0.213341717200,
            0.213181033900,
            0.213020399500,
            0.212859814200,
            0.212699278000,
            0.212538791000,
            0.212378353200,
            0.212217964700,
            0.212057625500,
            0.211897335700,
            0.211737095500,
            0.211576904700,
            0.211416763500,
            0.211256671900,
            0.211096630000,
            0.210936637900,
            0.210776695600,
            0.210616803100,
            0.210456960600,
            0.210297168000,
            0.210137425400,
            0.209977733000,
            0.209818090700,
            0.209658498600,
            0.209498956800,
            0.209339465300,
            0.209180024200,
            0.209020633500,
            0.208861293300,
            0.208702003600,
            0.208542764600,
            0.208383576200,
            0.208224438500,
            0.208065351600,
            0.207906315600,
            0.207747330400,
            0.207588396200,
            0.207429513000,
            0.207270680900,
            0.207111899800,
            0.206953170000,
            0.206794491400,
            0.206635864100,
            0.206477288100,
            0.206318763500,
            0.206160290400,
            0.206001868900,
            0.205843498900,
            0.205685180500,
            0.205526913800,
            0.205368698900,
            0.205210535700,
            0.205052424400,
            0.204894365100,
            0.204736357700,
            0.204578402400,
            0.204420499100,
            0.204262648000,
            0.204104849000,
            0.203947102400,
            0.203789408000,
            0.203631766100,
            0.203474176500,
            0.203316639400,
            0.203159154900,
            0.203001723000,
            0.202844343700,
            0.202687017100,
            0.202529743300,
            0.202372522300,
            0.202215354300,
            0.202058239100,
            0.201901176900,
            0.201744167800,
            0.201587211800,
            0.201430308900,
            0.201273459300,
            0.201116662900,
            0.200959919900,
            0.200803230200,
            0.200646594000,
            0.200490011300,
            0.200333482200,
            0.200177006600,
            0.200020584800,
            0.199864216600,
            0.199707902300,
            0.199551641700,
            0.199395435100,
            0.199239282400,
            0.199083183700,
            0.198927139100,
            0.198771148500,
            0.198615212200,
            0.198459330100,
            0.198303502200,
            0.198147728700,
            0.197992009600,
            0.197836345000,
            0.197680734800,
            0.197525179200,
            0.197369678300,
            0.197214232000,
            0.197058840400,
            0.196903503600,
            0.196748221700,
            0.196592994600,
            0.196437822500,
            0.196282705400,
            0.196127643400,
            0.195972636500,
            0.195817684700,
            0.195662788200,
            0.195507947000,
            0.195353161100,
            0.195198430600,
            0.195043755500,
            0.194889136000,
            0.194734572000,
            0.194580063600,
            0.194425610900,
            0.194271213900,
            0.194116872700,
            0.193962587300,
            0.193808357800,
            0.193654184300,
            0.193500066700,
            0.193346005200,
            0.193191999800,
            0.193038050600,
            0.192884157600,
            0.192730320900,
            0.192576540400,
            0.192422816400,
            0.192269148800,
            0.192115537700,
            0.191961983200,
            0.191808485200,
            0.191655043900,
            0.191501659300,
            0.191348331500,
            0.191195060400,
            0.191041846300,
            0.190888689100,
            0.190735588800,
            0.190582545600,
            0.190429559500,
            0.190276630500,
            0.190123758700,
            0.189970944200,
            0.189818187000,
            0.189665487100,
            0.189512844600,
            0.189360259600,
            0.189207732100,
            0.189055262200,
            0.188902850000,
            0.188750495400,
            0.188598198500,
            0.188445959400,
            0.188293778200,
            0.188141654800,
            0.187989589400,
            0.187837582000,
            0.187685632700,
            0.187533741500,
            0.187381908400,
            0.187230133500,
            0.187078417000,
            0.186926758700,
            0.186775158800,
            0.186623617300,
            0.186472134300,
            0.186320709900,
            0.186169344000,
            0.186018036800,
            0.185866788300,
            0.185715598500,
            0.185564467500,
            0.185413395400,
            0.185262382100,
            0.185111427800,
            0.184960532600,
            0.184809696400,
            0.184658919300,
            0.184508201300,
            0.184357542600,
            0.184206943200,
            0.184056403000,
            0.183905922300,
            0.183755501000,
            0.183605139100,
            0.183454836800,
            0.183304594100,
            0.183154411000,
            0.183004287600,
            0.182854224000,
            0.182704220100,
            0.182554276100,
            0.182404391900,
            0.182254567700,
            0.182104803600,
            0.181955099400,
            0.181805455400,
            0.181655871500,
            0.181506347800,
            0.181356884400,
            0.181207481300,
            0.181058138600,
            0.180908856200,
            0.180759634300,
            0.180610473000,
            0.180461372200,
            0.180312332000,
            0.180163352400,
            0.180014433600,
            0.179865575600,
            0.179716778400,
            0.179568042000,
            0.179419366600,
            0.179270752100,
            0.179122198700,
            0.178973706300,
            0.178825275100,
            0.178676905000,
            0.178528596100,
            0.178380348600,
            0.178232162300,
            0.178084037400,
            0.177935974000,
            0.177787972000,
            0.177640031500,
            0.177492152600,
            0.177344335400,
            0.177196579800,
            0.177048886000,
            0.176901253900,
            0.176753683600,
            0.176606175200,
            0.176458728800,
            0.176311344300,
            0.176164021800,
            0.176016761400,
            0.175869563200,
            0.175722427100,
            0.175575353200,
            0.175428341600,
            0.175281392300,
            0.175134505300,
            0.174987680800,
            0.174840918800,
            0.174694219300,
            0.174547582300,
            0.174401008000,
            0.174254496300,
            0.174108047300,
            0.173961661100,
            0.173815337600,
            0.173669077100,
            0.173522879400,
            0.173376744700,
            0.173230673000,
            0.173084664400,
            0.172938718800,
            0.172792836400,
            0.172647017200,
            0.172501261200,
            0.172355568500,
            0.172209939200,
            0.172064373200,
            0.171918870700,
            0.171773431600,
            0.171628056100,
            0.171482744200,
            0.171337495800,
            0.171192311200,
            0.171047190300,
            0.170902133100,
            0.170757139700,
            0.170612210200,
            0.170467344700,
            0.170322543000,
            0.170177805400,
            0.170033131800,
            0.169888522300,
            0.169743977000,
            0.169599495800,
            0.169455078900,
            0.169310726300,
            0.169166438000,
            0.169022214000,
            0.168878054500,
            0.168733959500,
            0.168589928900,
            0.168445963000,
            0.168302061600,
            0.168158224900,
            0.168014452900,
            0.167870745600,
            0.167727103200,
            0.167583525500,
            0.167440012800,
            0.167296564900,
            0.167153182100,
            0.167009864200,
            0.166866611500,
            0.166723423800,
            0.166580301300,
            0.166437244000,
            0.166294251900,
            0.166151325200,
            0.166008463700,
            0.165865667700,
            0.165722937000,
            0.165580271900,
            0.165437672200,
            0.165295138200,
            0.165152669700,
            0.165010266800,
            0.164867929700,
            0.164725658300,
            0.164583452700,
            0.164441312900,
            0.164299239000,
            0.164157231000,
            0.164015289000,
            0.163873412900,
            0.163731602900,
            0.163589859000,
            0.163448181300,
            0.163306569700,
            0.163165024300,
            0.163023545200,
            0.162882132400,
            0.162740786000,
            0.162599506000,
            0.162458292300,
            0.162317145200,
            0.162176064600,
            0.162035050600,
            0.161894103200,
            0.161753222400,
            0.161612408400,
            0.161471661000,
            0.161330980500,
            0.161190366800,
            0.161049819900,
            0.160909340000,
            0.160768927000,
            0.160628581000,
            0.160488302100,
            0.160348090200,
            0.160207945400,
            0.160067867900,
            0.159927857500,
            0.159787914300,
            0.159648038500,
            0.159508230000,
            0.159368488800,
            0.159228815100,
            0.159089208800,
            0.158949670000,
            0.158810198800,
            0.158670795100,
            0.158531459000,
            0.158392190700,
            0.158252990000,
            0.158113857000,
            0.157974791900,
            0.157835794500,
            0.157696865100,
            0.157558003500,
            0.157419209900,
            0.157280484200,
            0.157141826600,
            0.157003237100,
            0.156864715700,
            0.156726262400,
            0.156587877300,
            0.156449560400,
            0.156311311800,
            0.156173131500,
            0.156035019600,
            0.155896976000,
            0.155759000900,
            0.155621094200,
            0.155483256000,
            0.155345486400,
            0.155207785400,
            0.155070152900,
            0.154932589200,
            0.154795094100,
            0.154657667800,
            0.154520310300,
            0.154383021500,
            0.154245801700,
            0.154108650700,
            0.153971568700,
            0.153834555600,
            0.153697611500,
            0.153560736500,
            0.153423930600,
            0.153287193800,
            0.153150526100,
            0.153013927700,
            0.152877398500,
            0.152740938600,
            0.152604547900,
            0.152468226700,
            0.152331974800,
            0.152195792300,
            0.152059679300,
            0.151923635800,
            0.151787661900,
            0.151651757500,
            0.151515922700,
            0.151380157600,
            0.151244462100,
            0.151108836400,
            0.150973280500,
            0.150837794300,
            0.150702378000,
            0.150567031500,
            0.150431754900,
            0.150296548300,
            0.150161411600,
            0.150026345000,
            0.149891348400,
            0.149756421900,
            0.149621565500,
            0.149486779300,
            0.149352063200,
            0.149217417400,
            0.149082841800,
            0.148948336600,
            0.148813901700,
            0.148679537100,
            0.148545242900,
            0.148411019200,
            0.148276866000,
            0.148142783200,
            0.148008771000,
            0.147874829400,
            0.147740958400,
            0.147607158000,
            0.147473428300,
            0.147339769400,
            0.147206181100,
            0.147072663700,
            0.146939217100,
            0.146805841300,
            0.146672536400,
            0.146539302400,
            0.146406139400,
            0.146273047300,
            0.146140026300,
            0.146007076400,
            0.145874197500,
            0.145741389700,
            0.145608653100,
            0.145475987700,
            0.145343393500,
            0.145210870500,
            0.145078418800,
            0.144946038500,
            0.144813729400,
            0.144681491800,
            0.144549325600,
            0.144417230800,
            0.144285207500,
            0.144153255700,
            0.144021375500,
            0.143889566800,
            0.143757829800,
            0.143626164300,
            0.143494570600,
            0.143363048500,
            0.143231598200,
            0.143100219600,
            0.142968912900,
            0.142837677900,
            0.142706514800,
            0.142575423700,
            0.142444404400,
            0.142313457100,
            0.142182581700,
            0.142051778400,
            0.141921047100,
            0.141790387900,
            0.141659800800,
            0.141529285800,
            0.141398843000,
            0.141268472300,
            0.141138173900,
            0.141007947800,
            0.140877793900,
            0.140747712400,
            0.140617703200,
            0.140487766300,
            0.140357901900,
            0.140228109900,
            0.140098390400,
            0.139968743300,
            0.139839168800,
            0.139709666800,
            0.139580237400,
            0.139450880600,
            0.139321596400,
            0.139192384900,
            0.139063246100,
            0.138934180000,
            0.138805186600,
            0.138676266000,
            0.138547418300,
            0.138418643300,
            0.138289941300,
            0.138161312100,
            0.138032755800,
            0.137904272500,
            0.137775862100,
            0.137647524700,
            0.137519260400,
            0.137391069100,
            0.137262950900,
            0.137134905800,
            0.137006933900,
            0.136879035100,
            0.136751209500,
            0.136623457100,
            0.136495777900,
            0.136368172000,
            0.136240639400,
            0.136113180200,
            0.135985794200,
            0.135858481700,
            0.135731242500,
            0.135604076800,
            0.135476984500,
            0.135349965700,
            0.135223020400,
            0.135096148700,
            0.134969350400,
            0.134842625800,
            0.134715974800,
            0.134589397400,
            0.134462893600,
            0.134336463500,
            0.134210107200,
            0.134083824500,
            0.133957615700,
            0.133831480500,
            0.133705419200,
            0.133579431800,
            0.133453518100,
            0.133327678400,
            0.133201912500,
            0.133076220600,
            0.132950602600,
            0.132825058600,
            0.132699588600,
            0.132574192600,
            0.132448870600,
            0.132323622700,
            0.132198448900,
            0.132073349300,
            0.131948323700,
            0.131823372300,
            0.131698495100,
            0.131573692100,
            0.131448963300,
            0.131324308800,
            0.131199728500,
            0.131075222500,
            0.130950790900,
            0.130826433600,
            0.130702150600,
            0.130577942000,
            0.130453807900,
            0.130329748100,
            0.130205762800,
            0.130081852000,
            0.129958015700,
            0.129834253900,
            0.129710566600,
            0.129586953900,
            0.129463415700,
            0.129339952200,
            0.129216563200,
            0.129093249000,
            0.128970009300,
            0.128846844400,
            0.128723754100,
            0.128600738600,
            0.128477797800,
            0.128354931800,
            0.128232140600,
            0.128109424100,
            0.127986782500,
            0.127864215800,
            0.127741723800,
            0.127619306800,
            0.127496964700,
            0.127374697500,
            0.127252505200,
            0.127130388000,
            0.127008345600,
            0.126886378300,
            0.126764486000,
            0.126642668700,
            0.126520926500,
            0.126399259400,
            0.126277667300,
            0.126156150400,
            0.126034708600,
            0.125913341900,
            0.125792050400,
            0.125670834100,
            0.125549693000,
            0.125428627100,
            0.125307636500,
            0.125186721100,
            0.125065881000,
            0.124945116100,
            0.124824426600,
            0.124703812400,
            0.124583273500,
            0.124462810000,
            0.124342421900,
            0.124222109200,
            0.124101871800,
            0.123981709900,
            0.123861623500,
            0.123741612500,
            0.123621677000,
            0.123501816900,
            0.123382032400,
            0.123262323400,
            0.123142690000,
            0.123023132100,
            0.122903649700,
            0.122784243000,
            0.122664911800,
            0.122545656300,
            0.122426476400,
            0.122307372200,
            0.122188343600,
            0.122069390700,
            0.121950513500,
            0.121831712000,
            0.121712986300,
            0.121594336200,
            0.121475762000,
            0.121357263500,
            0.121238840700,
            0.121120493800,
            0.121002222700,
            0.120884027400,
            0.120765907900,
            0.120647864300,
            0.120529896600,
            0.120412004700,
            0.120294188800,
            0.120176448700,
            0.120058784600,
            0.119941196400,
            0.119823684100,
            0.119706247800,
            0.119588887500,
            0.119471603200,
            0.119354394800,
            0.119237262500,
            0.119120206200,
            0.119003225900,
            0.118886321700,
            0.118769493500,
            0.118652741400,
            0.118536065400,
            0.118419465500,
            0.118302941700,
            0.118186494100,
            0.118070122500,
            0.117953827100,
            0.117837607900,
            0.117721464800,
            0.117605397900,
            0.117489407200,
            0.117373492600,
            0.117257654300,
            0.117141892300,
            0.117026206400,
            0.116910596800,
            0.116795063500,
            0.116679606400,
            0.116564225600,
            0.116448921000,
            0.116333692800,
            0.116218540900,
            0.116103465300,
            0.115988466000,
            0.115873543000,
            0.115758696400,
            0.115643926200,
            0.115529232300,
            0.115414614800,
            0.115300073600,
            0.115185608900,
            0.115071220500,
            0.114956908600,
            0.114842673100,
            0.114728514000,
            0.114614431300,
            0.114500425100,
            0.114386495400,
            0.114272642100,
            0.114158865200,
            0.114045164900,
            0.113931541000,
            0.113817993600,
            0.113704522800,
            0.113591128400,
            0.113477810500,
            0.113364569200,
            0.113251404400,
            0.113138316200,
            0.113025304500,
            0.112912369300,
            0.112799510700,
            0.112686728700,
            0.112574023200,
            0.112461394400,
            0.112348842100,
            0.112236366400,
            0.112123967300,
            0.112011644800,
            0.111899399000,
            0.111787229700,
            0.111675137100,
            0.111563121100,
            0.111451181700,
            0.111339319000,
            0.111227533000,
            0.111115823600,
            0.111004190800,
            0.110892634700,
            0.110781155300,
            0.110669752600,
            0.110558426500,
            0.110447177100,
            0.110336004500,
            0.110224908500,
            0.110113889200,
            0.110002946600,
            0.109892080700,
            0.109781291600,
            0.109670579100,
            0.109559943400,
            0.109449384400,
            0.109338902200,
            0.109228496700,
            0.109118167900,
            0.109007915800,
            0.108897740500,
            0.108787642000,
            0.108677620200,
            0.108567675100,
            0.108457806800,
            0.108348015300,
            0.108238300500,
            0.108128662500,
            0.108019101300,
            0.107909616900,
            0.107800209200,
            0.107690878300,
            0.107581624200,
            0.107472446800,
            0.107363346300,
            0.107254322500,
            0.107145375600,
            0.107036505400,
            0.106927712000,
            0.106818995400,
            0.106710355600,
            0.106601792600,
            0.106493306400,
            0.106384897000,
            0.106276564400,
            0.106168308600,
            0.106060129600,
            0.105952027500,
            0.105844002100,
            0.105736053500,
            0.105628181800,
            0.105520386800,
            0.105412668700,
            0.105305027300,
            0.105197462800,
            0.105089975100,
            0.104982564200,
            0.104875230100,
            0.104767972800,
            0.104660792300,
            0.104553688700,
            0.104446661800,
            0.104339711800,
            0.104232838500,
            0.104126042100,
            0.104019322400,
            0.103912679600,
            0.103806113600,
            0.103699624400,
            0.103593212000,
            0.103486876400,
            0.103380617600,
            0.103274435500,
            0.103168330300,
            0.103062301900,
            0.102956350300,
            0.102850475400,
            0.102744677400,
            0.102638956100,
            0.102533311700,
            0.102427744000,
            0.102322253100,
            0.102216838900,
            0.102111501600,
            0.102006241000,
            0.101901057200,
            0.101795950200,
            0.101690919900,
            0.101585966400,
            0.101481089600,
            0.101376289600,
            0.101271566400,
            0.101166919900,
            0.101062350100,
            0.100957857100,
            0.100853440900,
            0.100749101300,
            0.100644838500,
            0.100540652500,
            0.100436543100,
            0.100332510500,
            0.100228554600,
            0.100124675400,
            0.100020872900,
            0.099917147100,
            0.099813498010,
            0.099709925610,
            0.099606429900,
            0.099503010880,
            0.099399668530,
            0.099296402860,
            0.099193213850,
            0.099090101510,
            0.098987065830,
            0.098884106800,
            0.098781224420,
            0.098678418680,
            0.098575689570,
            0.098473037100,
            0.098370461250,
            0.098267962020,
            0.098165539400,
            0.098063193390,
            0.097960923980,
            0.097858731170,
            0.097756614940,
            0.097654575300,
            0.097552612220,
            0.097450725720,
            0.097348915780,
            0.097247182390,
            0.097145525550,
            0.097043945250,
            0.096942441490,
            0.096841014250,
            0.096739663530,
            0.096638389320,
            0.096537191610,
            0.096436070410,
            0.096335025690,
            0.096234057450,
            0.096133165690,
            0.096032350390,
            0.095931611550,
            0.095830949150,
            0.095730363200,
            0.095629853690,
            0.095529420590,
            0.095429063910,
            0.095328783640,
            0.095228579770,
            0.095128452290,
            0.095028401190,
            0.094928426470,
            0.094828528100,
            0.094728706090,
            0.094628960430,
            0.094529291100,
            0.094429698100,
            0.094330181420,
            0.094230741040,
            0.094131376960,
            0.094032089170,
            0.093932877660,
            0.093833742420,
            0.093734683430,
            0.093635700700,
            0.093536794200,
            0.093437963930,
            0.093339209880,
            0.093240532040,
            0.093141930390,
            0.093043404940,
            0.092944955650,
            0.092846582530,
            0.092748285570,
            0.092650064750,
            0.092551920060,
            0.092453851500,
            0.092355859040,
            0.092257942680,
            0.092160102410,
            0.092062338220,
            0.091964650090,
            0.091867038020,
            0.091769501980,
            0.091672041980,
            0.091574657990,
            0.091477350010,
            0.091380118020,
            0.091282962010,
            0.091185881980,
            0.091088877900,
            0.090991949760,
            0.090895097560,
            0.090798321280,
            0.090701620900,
            0.090604996420,
            0.090508447820,
            0.090411975090,
            0.090315578210,
            0.090219257180,
            0.090123011980,
            0.090026842590,
            0.089930749010,
            0.089834731210,
            0.089738789200,
            0.089642922940,
            0.089547132440,
            0.089451417670,
            0.089355778620,
            0.089260215280,
            0.089164727630,
            0.089069315660,
            0.088973979360,
            0.088878718710,
            0.088783533690,
            0.088688424300,
            0.088593390520,
            0.088498432330,
            0.088403549720,
            0.088308742680,
            0.088214011180,
            0.088119355220,
            0.088024774780,
            0.087930269840,
            0.087835840390,
            0.087741486420,
            0.087647207910,
            0.087553004840,
            0.087458877200,
            0.087364824970,
            0.087270848140,
            0.087176946690,
            0.087083120610,
            0.086989369870,
            0.086895694470,
            0.086802094390,
            0.086708569620,
            0.086615120120,
            0.086521745900,
            0.086428446930,
            0.086335223200,
            0.086242074690,
            0.086149001380,
            0.086056003260,
            0.085963080310,
            0.085870232510,
            0.085777459860,
            0.085684762320,
            0.085592139880,
            0.085499592530,
            0.085407120250,
            0.085314723020,
            0.085222400830,
            0.085130153650,
            0.085037981470,
            0.084945884270,
            0.084853862040,
            0.084761914760,
            0.084670042400,
            0.084578244950,
            0.084486522400,
            0.084394874720,
            0.084303301900,
            0.084211803910,
            0.084120380750,
            0.084029032390,
            0.083937758810,
            0.083846560000,
            0.083755435930,
            0.083664386590,
            0.083573411970,
            0.083482512030,
            0.083391686760,
            0.083300936140,
            0.083210260160,
            0.083119658800,
            0.083029132030,
            0.082938679830,
            0.082848302190,
            0.082757999090,
            0.082667770510,
            0.082577616430,
            0.082487536820,
            0.082397531670,
            0.082307600970,
            0.082217744680,
            0.082127962790,
            0.082038255280,
            0.081948622140,
            0.081859063330,
            0.081769578840,
            0.081680168650,
            0.081590832740,
            0.081501571080,
            0.081412383670,
            0.081323270470,
            0.081234231470,
            0.081145266640,
            0.081056375970,
            0.080967559440,
            0.080878817010,
            0.080790148680,
            0.080701554420,
            0.080613034220,
            0.080524588040,
            0.080436215860,
            0.080347917680,
            0.080259693460,
            0.080171543180,
            0.080083466830,
            0.079995464370,
            0.079907535800,
            0.079819681080,
            0.079731900190,
            0.079644193120,
            0.079556559840,
            0.079469000330,
            0.079381514570,
            0.079294102530,
            0.079206764200,
            0.079119499540,
            0.079032308540,
            0.078945191180,
            0.078858147430,
            0.078771177270,
            0.078684280680,
            0.078597457630,
            0.078510708100,
            0.078424032080,
            0.078337429530,
            0.078250900430,
            0.078164444760,
            0.078078062510,
            0.077991753630,
            0.077905518110,
            0.077819355940,
            0.077733267070,
            0.077647251500,
            0.077561309190,
            0.077475440120,
            0.077389644280,
            0.077303921630,
            0.077218272150,
            0.077132695820,
            0.077047192620,
            0.076961762510,
            0.076876405480,
            0.076791121500,
            0.076705910550,
            0.076620772610,
            0.076535707640,
            0.076450715630,
            0.076365796540,
            0.076280950360,
            0.076196177070,
            0.076111476630,
            0.076026849020,
            0.075942294220,
            0.075857812190,
            0.075773402930,
            0.075689066400,
            0.075604802580,
            0.075520611430,
            0.075436492950,
            0.075352447090,
            0.075268473850,
            0.075184573180,
            0.075100745070,
            0.075016989490,
            0.074933306410,
            0.074849695810,
            0.074766157660,
            0.074682691940,
            0.074599298630,
            0.074515977690,
            0.074432729100,
            0.074349552830,
            0.074266448860,
            0.074183417160,
            0.074100457710,
            0.074017570470,
            0.073934755430,
            0.073852012560,
            0.073769341820,
            0.073686743200,
            0.073604216670,
            0.073521762200,
            0.073439379760,
            0.073357069330,
            0.073274830870,
            0.073192664380,
            0.073110569810,
            0.073028547130,
            0.072946596340,
            0.072864717380,
            0.072782910250,
            0.072701174900,
            0.072619511330,
            0.072537919480,
            0.072456399350,
            0.072374950900,
            0.072293574100,
            0.072212268930,
            0.072131035360,
            0.072049873370,
            0.071968782910,
            0.071887763970,
            0.071806816520,
            0.071725940530,
            0.071645135980,
            0.071564402830,
            0.071483741050,
            0.071403150620,
            0.071322631520,
            0.071242183700,
            0.071161807150,
            0.071081501840,
            0.071001267730,
            0.070921104800,
            0.070841013020,
            0.070760992360,
            0.070681042790,
            0.070601164290,
            0.070521356830,
            0.070441620370,
            0.070361954890,
            0.070282360350,
            0.070202836740,
            0.070123384020,
            0.070044002160,
            0.069964691140,
            0.069885450910,
            0.069806281470,
            0.069727182760,
            0.069648154780,
            0.069569197480,
            0.069490310830,
            0.069411494820,
            0.069332749400,
            0.069254074550,
            0.069175470240,
            0.069096936440,
            0.069018473120,
            0.068940080250,
            0.068861757790,
            0.068783505730,
            0.068705324030,
            0.068627212660,
            0.068549171580,
            0.068471200780,
            0.068393300220,
            0.068315469860,
            0.068237709690,
            0.068160019660,
            0.068082399750,
            0.068004849930,
            0.067927370170,
            0.067849960440,
            0.067772620700,
            0.067695350920,
            0.067618151080,
            0.067541021150,
            0.067463961090,
            0.067386970870,
            0.067310050470,
            0.067233199840,
            0.067156418970,
            0.067079707820,
            0.067003066350,
            0.066926494540,
            0.066849992350,
            0.066773559760,
            0.066697196740,
            0.066620903240,
            0.066544679250,
            0.066468524720,
            0.066392439640,
            0.066316423960,
            0.066240477650,
            0.066164600690,
            0.066088793030,
            0.066013054660,
            0.065937385540,
            0.065861785630,
            0.065786254910,
            0.065710793340,
            0.065635400890,
            0.065560077530,
            0.065484823220,
            0.065409637940,
            0.065334521650,
            0.065259474330,
            0.065184495930,
            0.065109586420,
            0.065034745780,
            0.064959973980,
            0.064885270970,
            0.064810636720,
            0.064736071220,
            0.064661574410,
            0.064587146270,
            0.064512786770,
            0.064438495870,
            0.064364273540,
            0.064290119750,
            0.064216034470,
            0.064142017660,
            0.064068069290,
            0.063994189320,
            0.063920377730,
            0.063846634480,
            0.063772959540,
            0.063699352870,
            0.063625814450,
            0.063552344230,
            0.063478942190,
            0.063405608290,
            0.063332342500,
            0.063259144790,
            0.063186015120,
            0.063112953450,
            0.063039959760,
            0.062967034020,
            0.062894176180,
            0.062821386210,
            0.062748664090,
            0.062676009780,
            0.062603423230,
            0.062530904430,
            0.062458453330,
            0.062386069910,
            0.062313754120,
            0.062241505940,
            0.062169325330,
            0.062097212260,
            0.062025166690,
            0.061953188580,
            0.061881277910,
            0.061809434640,
            0.061737658740,
            0.061665950170,
            0.061594308890,
            0.061522734880,
            0.061451228100,
            0.061379788510,
            0.061308416090,
            0.061237110780,
            0.061165872570,
            0.061094701420,
            0.061023597290,
            0.060952560140,
            0.060881589950,
            0.060810686680,
            0.060739850280,
            0.060669080740,
            0.060598378010,
            0.060527742060,
            0.060457172860,
            0.060386670360,
            0.060316234540,
            0.060245865350,
            0.060175562780,
            0.060105326770,
            0.060035157290,
            0.059965054310,
            0.059895017800,
            0.059825047710,
            0.059755144020,
            0.059685306690,
            0.059615535680,
            0.059545830960,
            0.059476192480,
            0.059406620230,
            0.059337114160,
            0.059267674230,
            0.059198300410,
            0.059128992670,
            0.059059750970,
            0.058990575260,
            0.058921465530,
            0.058852421730,
            0.058783443830,
            0.058714531790,
            0.058645685570,
            0.058576905140,
            0.058508190460,
            0.058439541500,
            0.058370958230,
            0.058302440600,
            0.058233988570,
            0.058165602120,
            0.058097281210,
            0.058029025800,
            0.057960835860,
            0.057892711340,
            0.057824652220,
            0.057756658460,
            0.057688730010,
            0.057620866850,
            0.057553068940,
            0.057485336230,
            0.057417668710,
            0.057350066320,
            0.057282529040,
            0.057215056820,
            0.057147649630,
            0.057080307430,
            0.057013030190,
            0.056945817870,
            0.056878670430,
            0.056811587840,
            0.056744570060,
            0.056677617050,
            0.056610728780,
            0.056543905210,
            0.056477146300,
            0.056410452020,
            0.056343822330,
            0.056277257190,
            0.056210756570,
            0.056144320420,
            0.056077948710,
            0.056011641410,
            0.055945398480,
            0.055879219880,
            0.055813105570,
            0.055747055520,
            0.055681069690,
            0.055615148040,
            0.055549290530,
            0.055483497140,
            0.055417767810,
            0.055352102520,
            0.055286501220,
            0.055220963880,
            0.055155490460,
            0.055090080930,
            0.055024735240,
            0.054959453360,
            0.054894235250,
            0.054829080880,
            0.054763990200,
            0.054698963190,
            0.054633999790,
            0.054569099980,
            0.054504263720,
            0.054439490960,
            0.054374781670,
            0.054310135820,
            0.054245553370,
            0.054181034270,
            0.054116578490,
            0.054052185990,
            0.053987856740,
            0.053923590700,
            0.053859387820,
            0.053795248080,
            0.053731171430,
            0.053667157830,
            0.053603207250,
            0.053539319650,
            0.053475494990,
            0.053411733240,
            0.053348034350,
            0.053284398290,
            0.053220825010,
            0.053157314490,
            0.053093866680,
            0.053030481540,
            0.052967159040,
            0.052903899140,
            0.052840701800,
            0.052777566980,
            0.052714494640,
            0.052651484750,
            0.052588537270,
            0.052525652150,
            0.052462829360,
            0.052400068870,
            0.052337370630,
            0.052274734600,
            0.052212160750,
            0.052149649040,
            0.052087199420,
            0.052024811870,
            0.051962486340,
            0.051900222800,
            0.051838021200,
            0.051775881500,
            0.051713803670,
            0.051651787680,
            0.051589833470,
            0.051527941020,
            0.051466110280,
            0.051404341210,
            0.051342633780,
            0.051280987950,
            0.051219403670,
            0.051157880910,
            0.051096419640,
            0.051035019810,
            0.050973681370,
            0.050912404310,
            0.050851188570,
            0.050790034110,
            0.050728940900,
            0.050667908900,
            0.050606938070,
            0.050546028380,
            0.050485179770,
            0.050424392210,
            0.050363665670,
            0.050303000100,
            0.050242395470,
            0.050181851730,
            0.050121368850,
            0.050060946790,
            0.050000585510,
            0.049940284960,
            0.049880045120,
            0.049819865940,
            0.049759747380,
            0.049699689400,
            0.049639691970,
            0.049579755040,
            0.049519878570,
            0.049460062530,
            0.049400306880,
            0.049340611570,
            0.049280976570,
            0.049221401840,
            0.049161887340,
            0.049102433030,
            0.049043038870,
            0.048983704820,
            0.048924430840,
            0.048865216890,
            0.048806062930,
            0.048746968930,
            0.048687934840,
            0.048628960620,
            0.048570046240,
            0.048511191650,
            0.048452396820,
            0.048393661710,
            0.048334986260,
            0.048276370460,
            0.048217814250,
            0.048159317600,
            0.048100880470,
            0.048042502810,
            0.047984184590,
            0.047925925770,
            0.047867726310,
            0.047809586170,
            0.047751505310,
            0.047693483690,
            0.047635521260,
            0.047577618000,
            0.047519773860,
            0.047461988800,
            0.047404262770,
            0.047346595750,
            0.047288987690,
            0.047231438550,
            0.047173948290,
            0.047116516880,
            0.047059144260,
            0.047001830410,
            0.046944575280,
            0.046887378830,
            0.046830241020,
            0.046773161810,
            0.046716141170,
            0.046659179050,
            0.046602275410,
            0.046545430210,
            0.046488643410,
            0.046431914980,
            0.046375244860,
            0.046318633030,
            0.046262079440,
            0.046205584060,
            0.046149146830,
            0.046092767730,
            0.046036446710,
            0.045980183730,
            0.045923978750,
            0.045867831730,
            0.045811742640,
            0.045755711420,
            0.045699738050,
            0.045643822480,
            0.045587964660,
            0.045532164570,
            0.045476422160,
            0.045420737390,
            0.045365110220,
            0.045309540600,
            0.045254028510,
            0.045198573900,
            0.045143176720,
            0.045087836950,
            0.045032554530,
            0.044977329430,
            0.044922161610,
            0.044867051030,
            0.044811997640,
            0.044757001420,
            0.044702062300,
            0.044647180270,
            0.044592355270,
            0.044537587270,
            0.044482876220,
            0.044428222090,
            0.044373624830,
            0.044319084410,
            0.044264600780,
            0.044210173900,
            0.044155803740,
            0.044101490250,
            0.044047233400,
            0.043993033130,
            0.043938889420,
            0.043884802220,
            0.043830771490,
            0.043776797190,
            0.043722879280,
            0.043669017720,
            0.043615212470,
            0.043561463490,
            0.043507770740,
            0.043454134180,
            0.043400553760,
            0.043347029450,
            0.043293561200,
            0.043240148990,
            0.043186792750,
            0.043133492470,
            0.043080248080,
            0.043027059560,
            0.042973926870,
            0.042920849960,
            0.042867828790,
            0.042814863320,
            0.042761953510,
            0.042709099330,
            0.042656300720,
            0.042603557660,
            0.042550870090,
            0.042498237980,
            0.042445661290,
            0.042393139980,
            0.042340674000,
            0.042288263330,
            0.042235907900,
            0.042183607700,
            0.042131362660,
            0.042079172760,
            0.042027037960,
            0.041974958210,
            0.041922933470,
            0.041870963700,
            0.041819048860,
            0.041767188920,
            0.041715383820,
            0.041663633530,
            0.041611938010,
            0.041560297220,
            0.041508711120,
            0.041457179670,
            0.041405702820,
            0.041354280530,
            0.041302912770,
            0.041251599500,
            0.041200340670,
            0.041149136240,
            0.041097986170,
            0.041046890430,
            0.040995848970,
            0.040944861740,
            0.040893928720,
            0.040843049860,
            0.040792225110,
            0.040741454450,
            0.040690737820,
            0.040640075180,
            0.040589466510,
            0.040538911750,
            0.040488410860,
            0.040437963810,
            0.040387570550,
            0.040337231040,
            0.040286945240,
            0.040236713120,
            0.040186534630,
            0.040136409720,
            0.040086338370,
            0.040036320530,
            0.039986356150,
            0.039936445200,
            0.039886587640,
            0.039836783420,
            0.039787032510,
            0.039737334860,
            0.039687690440,
            0.039638099200,
            0.039588561100,
            0.039539076110,
            0.039489644170,
            0.039440265260,
            0.039390939330,
            0.039341666330,
            0.039292446240,
            0.039243279000,
            0.039194164580,
            0.039145102940,
            0.039096094030,
            0.039047137820,
            0.038998234270,
            0.038949383320,
            0.038900584960,
            0.038851839120,
            0.038803145780,
            0.038754504880,
            0.038705916400,
            0.038657380290,
            0.038608896510,
            0.038560465010,
            0.038512085770,
            0.038463758730,
            0.038415483860,
            0.038367261120,
            0.038319090460,
            0.038270971850,
            0.038222905240,
            0.038174890600,
            0.038126927870,
            0.038079017040,
            0.038031158040,
            0.037983350840,
            0.037935595410,
            0.037887891690,
            0.037840239660,
            0.037792639260,
            0.037745090460,
            0.037697593220,
            0.037650147500,
            0.037602753260,
            0.037555410440,
            0.037508119030,
            0.037460878970,
            0.037413690220,
            0.037366552750,
            0.037319466510,
            0.037272431460,
            0.037225447570,
            0.037178514780,
            0.037131633070,
            0.037084802390,
            0.037038022700,
            0.036991293950,
            0.036944616120,
            0.036897989150,
            0.036851413010,
            0.036804887660,
            0.036758413050,
            0.036711989150,
            0.036665615920,
            0.036619293310,
            0.036573021280,
            0.036526799800,
            0.036480628820,
            0.036434508310,
            0.036388438220,
            0.036342418510,
            0.036296449140,
            0.036250530070,
            0.036204661260,
            0.036158842670,
            0.036113074270,
            0.036067356000,
            0.036021687830,
            0.035976069720,
            0.035930501620,
            0.035884983510,
            0.035839515330,
            0.035794097050,
            0.035748728620,
            0.035703410010,
            0.035658141180,
            0.035612922080,
            0.035567752670,
            0.035522632920,
            0.035477562790,
            0.035432542220,
            0.035387571190,
            0.035342649650,
            0.035297777570,
            0.035252954900,
            0.035208181600,
            0.035163457630,
            0.035118782950,
            0.035074157520,
            0.035029581300,
            0.034985054260,
            0.034940576340,
            0.034896147510,
            0.034851767730,
            0.034807436970,
            0.034763155170,
            0.034718922290,
            0.034674738310,
            0.034630603180,
            0.034586516850,
            0.034542479290,
            0.034498490460,
            0.034454550310,
            0.034410658810,
            0.034366815920,
            0.034323021590,
            0.034279275800,
            0.034235578480,
            0.034191929620,
            0.034148329160,
            0.034104777060,
            0.034061273290,
            0.034017817810,
            0.033974410570,
            0.033931051530,
            0.033887740670,
            0.033844477920,
            0.033801263260,
            0.033758096650,
            0.033714978040,
            0.033671907390,
            0.033628884670,
            0.033585909840,
            0.033542982850,
            0.033500103660,
            0.033457272240,
            0.033414488540,
            0.033371752520,
            0.033329064150,
            0.033286423390,
            0.033243830190,
            0.033201284510,
            0.033158786320,
            0.033116335570,
            0.033073932230,
            0.033031576250,
            0.032989267600,
            0.032947006230,
            0.032904792100,
            0.032862625190,
            0.032820505430,
            0.032778432800,
            0.032736407260,
            0.032694428760,
            0.032652497270,
            0.032610612740,
            0.032568775140,
            0.032526984430,
            0.032485240560,
            0.032443543500,
            0.032401893200,
            0.032360289640,
            0.032318732760,
            0.032277222520,
            0.032235758900,
            0.032194341840,
            0.032152971310,
            0.032111647270,
            0.032070369680,
            0.032029138490,
            0.031987953680,
            0.031946815200,
            0.031905723000,
            0.031864677060,
            0.031823677330,
            0.031782723770,
            0.031741816340,
            0.031700955000,
            0.031660139710,
            0.031619370440,
            0.031578647140,
            0.031537969770,
            0.031497338300,
            0.031456752680,
            0.031416212880,
            0.031375718850,
            0.031335270560,
            0.031294867970,
            0.031254511030,
            0.031214199710,
            0.031173933970,
            0.031133713760,
            0.031093539060,
            0.031053409820,
            0.031013325990,
            0.030973287550,
            0.030933294440,
            0.030893346640,
            0.030853444110,
            0.030813586790,
            0.030773774660,
            0.030734007680,
            0.030694285800,
            0.030654608980,
            0.030614977200,
            0.030575390400,
            0.030535848550,
            0.030496351600,
            0.030456899530,
            0.030417492290,
            0.030378129840,
            0.030338812140,
            0.030299539150,
            0.030260310840,
            0.030221127160,
            0.030181988080,
            0.030142893560,
            0.030103843550,
            0.030064838020,
            0.030025876920,
            0.029986960230,
            0.029948087900,
            0.029909259890,
            0.029870476160,
            0.029831736680,
            0.029793041400,
            0.029754390280,
            0.029715783290,
            0.029677220390,
            0.029638701540,
            0.029600226700,
            0.029561795830,
            0.029523408890,
            0.029485065840,
            0.029446766650,
            0.029408511270,
            0.029370299660,
            0.029332131800,
            0.029294007630,
            0.029255927120,
            0.029217890230,
            0.029179896930,
            0.029141947170,
            0.029104040910,
            0.029066178120,
            0.029028358750,
            0.028990582770,
            0.028952850140,
            0.028915160820,
            0.028877514780,
            0.028839911960,
            0.028802352340,
            0.028764835880,
            0.028727362530,
            0.028689932260,
            0.028652545040,
            0.028615200810,
            0.028577899550,
            0.028540641210,
            0.028503425750,
            0.028466253140,
            0.028429123340,
            0.028392036320,
            0.028354992020,
            0.028317990410,
            0.028281031460,
            0.028244115130,
            0.028207241370,
            0.028170410150,
            0.028133621440,
            0.028096875180,
            0.028060171350,
            0.028023509910,
            0.027986890810,
            0.027950314020,
            0.027913779500,
            0.027877287220,
            0.027840837120,
            0.027804429190,
            0.027768063370,
            0.027731739630,
            0.027695457930,
            0.027659218240,
            0.027623020500,
            0.027586864700,
            0.027550750780,
            0.027514678710,
            0.027478648460,
            0.027442659980,
            0.027406713230,
            0.027370808180,
            0.027334944790,
            0.027299123030,
            0.027263342840,
            0.027227604200,
            0.027191907070,
            0.027156251410,
            0.027120637180,
            0.027085064340,
            0.027049532860,
            0.027014042690,
            0.026978593810,
            0.026943186170,
            0.026907819730,
            0.026872494450,
            0.026837210310,
            0.026801967250,
            0.026766765250,
            0.026731604260,
            0.026696484240,
            0.026661405170,
            0.026626367000,
            0.026591369690,
            0.026556413210,
            0.026521497510,
            0.026486622570,
            0.026451788330,
            0.026416994780,
            0.026382241860,
            0.026347529540,
            0.026312857780,
            0.026278226550,
            0.026243635800,
            0.026209085500,
            0.026174575620,
            0.026140106100,
            0.026105676930,
            0.026071288050,
            0.026036939440,
            0.026002631050,
            0.025968362850,
            0.025934134800,
            0.025899946860,
            0.025865798990,
            0.025831691160,
            0.025797623330,
            0.025763595460,
            0.025729607520,
            0.025695659470,
            0.025661751270,
            0.025627882880,
            0.025594054260,
            0.025560265390,
            0.025526516220,
            0.025492806710,
            0.025459136830,
            0.025425506530,
            0.025391915800,
            0.025358364570,
            0.025324852830,
            0.025291380530,
            0.025257947630,
            0.025224554100,
            0.025191199890,
            0.025157884990,
            0.025124609340,
            0.025091372900,
            0.025058175650,
            0.025025017550,
            0.024991898550,
            0.024958818630,
            0.024925777740,
            0.024892775850,
            0.024859812920,
            0.024826888910,
            0.024794003790,
            0.024761157520,
            0.024728350060,
            0.024695581380,
            0.024662851440,
            0.024630160200,
            0.024597507630,
            0.024564893690,
            0.024532318340,
            0.024499781550,
            0.024467283270,
            0.024434823480,
            0.024402402140,
            0.024370019210,
            0.024337674650,
            0.024305368420,
            0.024273100500,
            0.024240870840,
            0.024208679410,
            0.024176526160,
            0.024144411070,
            0.024112334100,
            0.024080295210,
            0.024048294370,
            0.024016331530,
            0.023984406670,
            0.023952519740,
            0.023920670710,
            0.023888859540,
            0.023857086200,
            0.023825350650,
            0.023793652850,
            0.023761992770,
            0.023730370370,
            0.023698785620,
            0.023667238480,
            0.023635728910,
            0.023604256870,
            0.023572822340,
            0.023541425270,
            0.023510065630,
            0.023478743380,
            0.023447458490,
            0.023416210910,
            0.023385000630,
            0.023353827590,
            0.023322691760,
            0.023291593110,
            0.023260531590,
            0.023229507190,
            0.023198519850,
            0.023167569540,
            0.023136656230,
            0.023105779880,
            0.023074940450,
            0.023044137920,
            0.023013372230,
            0.022982643370,
            0.022951951280,
            0.022921295950,
            0.022890677320,
            0.022860095360,
            0.022829550050,
            0.022799041340,
            0.022768569190,
            0.022738133580,
            0.022707734460,
            0.022677371800,
            0.022647045570,
            0.022616755730,
            0.022586502240,
            0.022556285070,
            0.022526104180,
            0.022495959550,
            0.022465851120,
            0.022435778870,
            0.022405742760,
            0.022375742750,
            0.022345778820,
            0.022315850920,
            0.022285959020,
            0.022256103080,
            0.022226283080,
            0.022196498960,
            0.022166750710,
            0.022137038280,
            0.022107361630,
            0.022077720740,
            0.022048115570,
            0.022018546080,
            0.021989012240,
            0.021959514000,
            0.021930051350,
            0.021900624240,
            0.021871232630,
            0.021841876500,
            0.021812555800,
            0.021783270510,
            0.021754020580,
            0.021724805980,
            0.021695626680,
            0.021666482640,
            0.021637373830,
            0.021608300210,
            0.021579261750,
            0.021550258410,
            0.021521290160,
            0.021492356970,
            0.021463458780,
            0.021434595590,
            0.021405767340,
            0.021376974000,
            0.021348215550,
            0.021319491940,
            0.021290803140,
            0.021262149110,
            0.021233529830,
            0.021204945250,
            0.021176395340,
            0.021147880060,
            0.021119399400,
            0.021090953290,
            0.021062541720,
            0.021034164650,
            0.021005822050,
            0.020977513870,
            0.020949240090,
            0.020921000670,
            0.020892795580,
            0.020864624780,
            0.020836488230,
            0.020808385910,
            0.020780317780,
            0.020752283810,
            0.020724283950,
            0.020696318180,
            0.020668386470,
            0.020640488770,
            0.020612625060,
            0.020584795290,
            0.020556999440,
            0.020529237480,
            0.020501509360,
            0.020473815050,
            0.020446154520,
            0.020418527740,
            0.020390934670,
            0.020363375270,
            0.020335849520,
            0.020308357380,
            0.020280898820,
            0.020253473790,
            0.020226082280,
            0.020198724230,
            0.020171399630,
            0.020144108430,
            0.020116850610,
            0.020089626120,
            0.020062434940,
            0.020035277030,
            0.020008152360,
            0.019981060890,
            0.019954002580,
            0.019926977420,
            0.019899985360,
            0.019873026370,
            0.019846100410,
            0.019819207450,
            0.019792347470,
            0.019765520420,
            0.019738726260,
            0.019711964980,
            0.019685236530,
            0.019658540880,
            0.019631878000,
            0.019605247850,
            0.019578650410,
            0.019552085630,
            0.019525553480,
            0.019499053940,
            0.019472586960,
            0.019446152520,
            0.019419750570,
            0.019393381100,
            0.019367044060,
            0.019340739420,
            0.019314467140,
            0.019288227210,
            0.019262019570,
            0.019235844200,
            0.019209701070,
            0.019183590140,
            0.019157511380,
            0.019131464750,
            0.019105450230,
            0.019079467780,
            0.019053517370,
            0.019027598960,
            0.019001712520,
            0.018975858020,
            0.018950035430,
            0.018924244710,
            0.018898485830,
            0.018872758750,
            0.018847063450,
            0.018821399890,
            0.018795768050,
            0.018770167870,
            0.018744599340,
            0.018719062420,
            0.018693557080,
            0.018668083290,
            0.018642641010,
            0.018617230200,
            0.018591850850,
            0.018566502910,
            0.018541186350,
            0.018515901150,
            0.018490647260,
            0.018465424650,
            0.018440233300,
            0.018415073170,
            0.018389944230,
            0.018364846440,
            0.018339779780,
            0.018314744200,
            0.018289739690,
            0.018264766200,
            0.018239823700,
            0.018214912170,
            0.018190031560,
            0.018165181850,
            0.018140363010,
            0.018115575000,
            0.018090817790,
            0.018066091350,
            0.018041395650,
            0.018016730650,
            0.017992096320,
            0.017967492630,
            0.017942919550,
            0.017918377050,
            0.017893865090,
            0.017869383640,
            0.017844932680,
            0.017820512160,
            0.017796122060,
            0.017771762340,
            0.017747432980,
            0.017723133940,
            0.017698865180,
            0.017674626690,
            0.017650418420,
            0.017626240340,
            0.017602092430,
            0.017577974640,
            0.017553886960,
            0.017529829340,
            0.017505801760,
            0.017481804190,
            0.017457836580,
            0.017433898920,
            0.017409991160,
            0.017386113290,
            0.017362265260,
            0.017338447040,
            0.017314658610,
            0.017290899930,
            0.017267170970,
            0.017243471700,
            0.017219802090,
            0.017196162110,
            0.017172551720,
            0.017148970890,
            0.017125419600,
            0.017101897810,
            0.017078405480,
            0.017054942600,
            0.017031509130,
            0.017008105030,
            0.016984730280,
            0.016961384840,
            0.016938068680,
            0.016914781780,
            0.016891524100,
            0.016868295610,
            0.016845096280,
            0.016821926070,
            0.016798784960,
            0.016775672920,
            0.016752589920,
            0.016729535920,
            0.016706510890,
            0.016683514810,
            0.016660547630,
            0.016637609340,
            0.016614699900,
            0.016591819280,
            0.016568967440,
            0.016546144370,
            0.016523350020,
            0.016500584370,
            0.016477847380,
            0.016455139030,
            0.016432459290,
            0.016409808120,
            0.016387185490,
            0.016364591370,
            0.016342025740,
            0.016319488560,
            0.016296979800,
            0.016274499430,
            0.016252047430,
            0.016229623750,
            0.016207228370,
            0.016184861270,
            0.016162522400,
            0.016140211740,
            0.016117929260,
            0.016095674920,
            0.016073448710,
            0.016051250580,
            0.016029080510,
            0.016006938470,
            0.015984824430,
            0.015962738350,
            0.015940680210,
            0.015918649970,
            0.015896647610,
            0.015874673100,
            0.015852726410,
            0.015830807500,
            0.015808916350,
            0.015787052920,
            0.015765217190,
            0.015743409130,
            0.015721628710,
            0.015699875890,
            0.015678150650,
            0.015656452960,
            0.015634782780,
            0.015613140090,
            0.015591524860,
            0.015569937060,
            0.015548376660,
            0.015526843620,
            0.015505337930,
            0.015483859540,
            0.015462408430,
            0.015440984580,
            0.015419587940,
            0.015398218500,
            0.015376876210,
            0.015355561060,
            0.015334273010,
            0.015313012040,
            0.015291778100,
            0.015270571190,
            0.015249391250,
            0.015228238270,
            0.015207112220,
            0.015186013060,
            0.015164940770,
            0.015143895320,
            0.015122876680,
            0.015101884820,
            0.015080919700,
            0.015059981310,
            0.015039069610,
            0.015018184570,
            0.014997326170,
            0.014976494370,
            0.014955689150,
            0.014934910470,
            0.014914158300,
            0.014893432630,
            0.014872733420,
            0.014852060630,
            0.014831414250,
            0.014810794240,
            0.014790200570,
            0.014769633220,
            0.014749092150,
            0.014728577340,
            0.014708088750,
            0.014687626370,
            0.014667190150,
            0.014646780080,
            0.014626396120,
            0.014606038240,
            0.014585706420,
            0.014565400620,
            0.014545120830,
            0.014524867000,
            0.014504639110,
            0.014484437130,
            0.014464261040,
            0.014444110810,
            0.014423986400,
            0.014403887780,
            0.014383814940,
            0.014363767840,
            0.014343746450,
            0.014323750740,
            0.014303780690,
            0.014283836270,
            0.014263917450,
            0.014244024200,
            0.014224156490,
            0.014204314290,
            0.014184497580,
            0.014164706330,
            0.014144940510,
            0.014125200090,
            0.014105485040,
            0.014085795340,
            0.014066130950,
            0.014046491850,
            0.014026878020,
            0.014007289410,
            0.013987726020,
            0.013968187790,
            0.013948674720,
            0.013929186770,
            0.013909723910,
            0.013890286110,
            0.013870873350,
            0.013851485600,
            0.013832122840,
            0.013812785020,
            0.013793472130,
            0.013774184140,
            0.013754921020,
            0.013735682740,
            0.013716469280,
            0.013697280600,
            0.013678116680,
            0.013658977500,
            0.013639863020,
            0.013620773210,
            0.013601708050,
            0.013582667520,
            0.013563651580,
            0.013544660200,
            0.013525693360,
            0.013506751040,
            0.013487833200,
            0.013468939810,
            0.013450070850,
            0.013431226300,
            0.013412406120,
            0.013393610280,
            0.013374838770,
            0.013356091550,
            0.013337368590,
            0.013318669870,
            0.013299995360,
            0.013281345030,
            0.013262718860,
            0.013244116820,
            0.013225538890,
            0.013206985020,
            0.013188455210,
            0.013169949410,
            0.013151467610,
            0.013133009770,
            0.013114575880,
            0.013096165890,
            0.013077779790,
            0.013059417560,
            0.013041079150,
            0.013022764550,
            0.013004473720,
            0.012986206650,
            0.012967963300,
            0.012949743650,
            0.012931547660,
            0.012913375330,
            0.012895226610,
            0.012877101480,
            0.012858999910,
            0.012840921880,
            0.012822867370,
            0.012804836330,
            0.012786828760,
            0.012768844610,
            0.012750883870,
            0.012732946500,
            0.012715032490,
            0.012697141800,
            0.012679274410,
            0.012661430290,
            0.012643609420,
            0.012625811770,
            0.012608037300,
            0.012590286010,
            0.012572557850,
            0.012554852810,
            0.012537170860,
            0.012519511960,
            0.012501876100,
            0.012484263250,
            0.012466673380,
            0.012449106470,
            0.012431562490,
            0.012414041410,
            0.012396543210,
            0.012379067860,
            0.012361615330,
            0.012344185610,
            0.012326778660,
            0.012309394450,
            0.012292032970,
            0.012274694180,
            0.012257378070,
            0.012240084590,
            0.012222813740,
            0.012205565470,
            0.012188339780,
            0.012171136620,
            0.012153955970,
            0.012136797820,
            0.012119662130,
            0.012102548870,
            0.012085458030,
            0.012068389570,
            0.012051343480,
            0.012034319710,
            0.012017318260,
            0.012000339090,
            0.011983382180,
            0.011966447500,
            0.011949535020,
            0.011932644730,
            0.011915776590,
            0.011898930580,
            0.011882106680,
            0.011865304850,
            0.011848525080,
            0.011831767340,
            0.011815031600,
            0.011798317840,
            0.011781626030,
            0.011764956150,
            0.011748308170,
            0.011731682070,
            0.011715077810,
            0.011698495550,
            0.011681934920,
            0.011665396070,
            0.011648878970,
            0.011632383590,
            0.011615909920,
            0.011599457920,
            0.011583027570,
            0.011566618840,
            0.011550231720,
            0.011533866170,
            0.011517522170,
            0.011501199690,
            0.011484898720,
            0.011468619220,
            0.011452361180,
            0.011436124560,
            0.011419909330,
            0.011403715490,
            0.011387543000,
            0.011371391830,
            0.011355261970,
            0.011339153380,
            0.011323066040,
            0.011306999940,
            0.011290955030,
            0.011274931310,
            0.011258928730,
            0.011242947290,
            0.011226986950,
            0.011211047690,
            0.011195129490,
            0.011179232320,
            0.011163356160,
            0.011147500970,
            0.011131666750,
            0.011115853450,
            0.011100061070,
            0.011084289570,
            0.011068538930,
            0.011052809130,
            0.011037100140,
            0.011021411930,
            0.011005744490,
            0.010990097790,
            0.010974471800,
            0.010958866500,
            0.010943281870,
            0.010927717880,
            0.010912174500,
            0.010896651720,
            0.010881149510,
            0.010865667850,
            0.010850206710,
            0.010834766060,
            0.010819345890,
            0.010803946170,
            0.010788566870,
            0.010773207970,
            0.010757869450,
            0.010742551290,
            0.010727253450,
            0.010711975920,
            0.010696718680,
            0.010681481690,
            0.010666264930,
            0.010651068390,
            0.010635892030,
            0.010620735840,
            0.010605599780,
            0.010590483850,
            0.010575388000,
            0.010560312220,
            0.010545256490,
            0.010530220780,
            0.010515205060,
            0.010500209320,
            0.010485233530,
            0.010470277670,
            0.010455341710,
            0.010440425640,
            0.010425529420,
            0.010410653030,
            0.010395796450,
            0.010380959660,
            0.010366142630,
            0.010351345340,
            0.010336567770,
            0.010321809890,
            0.010307071680,
            0.010292353120,
            0.010277654180,
            0.010262974840,
            0.010248315080,
            0.010233674870,
            0.010219054190,
            0.010204453020,
            0.010189871340,
            0.010175309110,
            0.010160766330,
            0.010146242960,
            0.010131738980,
            0.010117254370,
            0.010102789110,
            0.010088343170,
            0.010073916530,
            0.010059509170,
            0.010045121060,
            0.010030752190,
            0.010016402520,
            0.010002072040,
            0.009987760726,
            0.009973468550,
            0.009959195492,
            0.009944941528,
            0.009930706637,
            0.009916490795,
            0.009902293981,
            0.009888116170,
            0.009873957341,
            0.009859817471,
            0.009845696538,
            0.009831594518,
            0.009817511389,
            0.009803447129,
            0.009789401716,
            0.009775375126,
            0.009761367337,
            0.009747378327,
            0.009733408073,
            0.009719456554,
            0.009705523746,
            0.009691609627,
            0.009677714175,
            0.009663837368,
            0.009649979183,
            0.009636139598,
            0.009622318590,
            0.009608516139,
            0.009594732220,
            0.009580966813,
            0.009567219894,
            0.009553491442,
            0.009539781435,
            0.009526089851,
            0.009512416666,
            0.009498761861,
            0.009485125411,
            0.009471507296,
            0.009457907493,
            0.009444325980,
            0.009430762736,
            0.009417217738,
            0.009403690965,
            0.009390182394,
            0.009376692004,
            0.009363219773,
            0.009349765679,
            0.009336329700,
            0.009322911815,
            0.009309512001,
            0.009296130237,
            0.009282766501,
            0.009269420771,
            0.009256093026,
            0.009242783245,
            0.009229491405,
            0.009216217484,
            0.009202961462,
            0.009189723316,
            0.009176503025,
            0.009163300568,
            0.009150115923,
            0.009136949068,
            0.009123799982,
            0.009110668644,
            0.009097555032,
            0.009084459124,
            0.009071380900,
            0.009058320337,
            0.009045277415,
            0.009032252112,
            0.009019244407,
            0.009006254279,
            0.008993281706,
            0.008980326666,
            0.008967389140,
            0.008954469105,
            0.008941566541,
            0.008928681425,
            0.008915813738)
        
	sfun = splinefun(xx, yy, method = "monoH.FC")
        assign(func.name.in.env, sfun, envir = INLA:::inla.get.inlaEnv())
	return (invisible())
    }

    pc.dof.dist = function(dof, deriv = FALSE)
    {
        ## if 'deriv', then evaluate all 'dof' using the same approximation. in this case, dof
        ## are known to be close.
        n = length(dof)
        kld = numeric(n)

        if (!deriv) {
            idx = which(dof >= dof.lim)
            if (length(idx) > 0) {
                kld[idx] = pc.dof.kld.approx(dof[idx])
            }
            idx = which(dof < dof.lim)
            if (length(idx) > 0) {
                kld[idx] = (do.call(func.name.in.env, args = list(x = dof[idx]),
                                    envir = INLA:::inla.get.inlaEnv()))
            }
        } else {
            if (all(dof < dof.lim)) {
                kld = (do.call(func.name.in.env, args = list(x = dof),
                               envir = INLA:::inla.get.inlaEnv()))
            } else {
                kld = pc.dof.kld.approx(dof)
            }
        }
	return (sqrt(2.0 * kld))
    }

    if (!exists(func.name.in.env, envir = INLA:::inla.get.inlaEnv())) {
        pc.dof.create.spline()
    }
    if (missing(lambda)) {
        stopifnot(!(missing(u) && missing(alpha)))
        stopifnot(u > 2.0 && (alpha > 0 && alpha < 1))
        lambda = -log(alpha) / pc.dof.dist(u)
    } else {
        stopifnot(!(missing(lambda)))
        stopifnot(lambda > 0.0)
    }

    stopifnot(all(dof > dof.min))
    d = pc.dof.dist(dof)

    wf = c( 1.0 / 12.0, -2.0 / 3.0, 0.0, 2.0 / 3.0, -1.0 / 12.0 )
    jac = c()
    for(df in dof) {
        step = sqrt(df) * 1e-3
        if (df - 2.0 * step < dof.min) {
            step = (df - dof.min) / 2.0
        }
        dfs = df + (-2):2 * step 
        dd = pc.dof.dist(dfs, deriv=TRUE)
        val = sum(dd * wf) / step
        jac = c(jac, abs(val))
    }
 
    val = dexp(d, rate = lambda, log = TRUE) + log(jac)
    return (if (log) val else exp(val))
}
