%%
%% WARNING! DO NOT EDIT!
%% This file is automatically generated from hyperpar.R
%%
\name{inla.hyperpar}
\alias{inla.hyperpar}
\alias{hyperpar.inla}

\title{Improved estimates for the hyperparameters}
\description{
 Improve the estimates of the  posterior marginals
 for the hyperparameters of
 the model using the grid integration strategy.
}
\usage{
 inla.hyperpar(
         result,
         skip.configurations = TRUE,
         verbose = FALSE,
         dz = 0.75,
         diff.logdens = 15,
         h = NULL,
         restart = FALSE,
         quantiles = NULL, 
         keep = FALSE)
}

\arguments{
\item{result}{An object of class
\code{inla},  ie a result of a call to
\code{inla()}}
\item{skip.configurations}{ A boolean variable; skip
configurations if the values at the main axis are to
small. (Default TRUE)}
\item{verbose}{Boolean indicating wheather the inla
program should run in a verbose mode.}
\item{dz}{Step length in the standardized scale used
in the construction of the grid, default 0.75.}
\item{diff.logdens}{The difference of the
log.density for the hyperpameters to stop numerical
integration using int.strategy='grid'.  Default 15}
\item{h}{The step-length for the gradient
calculations for the hyperparameters. Default 0.01.}
\item{restart}{A boolean defining wheather the
optimizer should start again to ind the mode or if it
should use the mode contained in the \code{object}}
\item{quantiles}{A vector of quantiles,
to compute for each posterior marginal.}
\item{keep}{A boolean variable indicating the
working files (ini file, data files and results files)
should be kept}
}
\value{
The object returned is the same as  \code{object} but the
estimates of the hyperparameters are replaced by improved estimates.}
\references{
See the references in \code{inla}}
\author{Havard Rue \email{hrue@r-inla.org}}
\note{This function might take a long time or if the number of
hyperparameters in the model is large. If it complains and says \code{I cannot get enough memory},
try to increase the value of the argument \code{dz} or decrease \code{diff.logdens}.}
\seealso{\code{\link{inla}}}
