%%
%% WARNING! DO NOT EDIT!
%% This file is automatically generated from jmarginal.R
%%
 \name{joint.marginal}
 \alias{inla.joint.marginal}
 \alias{inla.joint.marginal.eval}
 \alias{joint.marginal}
 \alias{joint.marginal.eval}
 \alias{rjmarginal}
 \alias{rjmarginal.eval}
 \alias{inla.rjmarginal}
 \alias{inla.rjmarginal.eval}

 \title{Sample and evaluate from a joint marginal approximation}
 
 \description{Sample and evalue from from a joint marginal approximation
 as returned using argument \code{selection} in \code{inla}.
 }
 
 \usage{
 inla.rjmarginal(n, jmarginal, constr)
 inla.rjmarginal.eval(fun, samples, ...) 
 }
 \arguments{
   \item{n}{The number of samples}
   \item{jmarginal}{A marginal object given  either by a \code{inla} object
     or \code{result$selection}}
   \item{constr}{Optional linear constraints;
                 see \code{?INLA::f} and argument \code{extraconstr}}
   \item{fun}{A function which is evaluated for each sample, similar to
              \code{inla.posterior.sample.eval}: please see the documentation
              for this functions for details. }
   \item{samples}{The samples, as in the form of the output from \code{inla.rjmarginal}}
 }
 
 \value{%%
 \code{inla.rjmarginal} returns a list with the samples in \code{samples}
 (matrix) and the corresponding log-densities
 in \code{log.density} (vector). Each column in \code{samples} contains one sample.

 \code{inla.rjmarginal.eval} returns a matrix, where each row is the (vector) function
 evaluated at each sample.
 }
 
 \author{Havard Rue \email{hrue@r-inla.org}}
 \seealso{\code{\link{inla}}}

 \examples{
 n = 10
 x = 1+rnorm(n)
 xx = 3 + rnorm(n)
 y = 1 + x + xx + rnorm(n)
 selection = list(xx=1, Predictor = 3:4, x=1)
 r = inla(y ~ 1 + x + xx,
          data = data.frame(y, x, xx),
          selection = selection)
 ns = 100
 xx = inla.rjmarginal(ns, r)
 
 print(cbind(mean = r$selection$mean, sample.mean = rowMeans(xx$samples)))
 print("cov matrix")
 print(round(r$selection$cov.matrix, dig=3))
 print("sample cov matrix")
 print(round(cov(t(xx$samples)), dig=3))
 
 skew = function(z) mean((z-mean(z))^3)/var(z)^1.5
 print(round(cbind(skew = r$selection$skewness,
                   sample.skew = apply(xx$sample, 1, skew)), dig=3))

 ## illustrating the eval function
 n = 10
 x = rnorm(n)
 eta = 1 + x
 y = eta + rnorm(n, sd=0.1)
 selection = list(x = 1, Predictor = c(1, 2, 4, 5),  '(Intercept)' = 1)
 r = inla(y ~ 1 + x,
          data = data.frame(y, x),
          selection = selection)
 xx = inla.rjmarginal(100,  r)
 xx.eval = inla.rjmarginal.eval(function() c(x, Predictor, Intercept),  xx)
 print(cbind(xx$samples[, 1]))
 print(cbind(xx.eval[, 1]))
}
