%%
%% WARNING! DO NOT EDIT!
%% This file is automatically generated from ar.R
%%
\name{inla.ar}
\alias{inla.ar.pacf2phi}
\alias{ar.pacf2phi}
\alias{pacf2phi}
\alias{inla.ar.phi2pacf}
\alias{ar.phi2pacf}
\alias{phi2pacf}
\alias{inla.ar.phi2acf}
\alias{ar.phi2acf}
\alias{phi2acf}
\alias{inla.ar.pacf2acf}
\alias{ar.pacf2acf}
\alias{pacf2acf}

\title{Convert between parameterizations for the AR(p) model}

\description{These functions convert between the AR(p) coefficients \code{phi}, 
             the partial autorcorrelation coefficients \code{pacf} and the
             autocorrelation function \code{acf}.
             The \code{phi}-parameterization is the same as used for \code{arima}-models in \code{R}; see \code{?arima}
             and the parameter-vector \code{a} in \code{Details}.}
\usage{
   inla.ar.pacf2phi(pac)
   inla.ar.phi2pacf(phi)
   inla.ar.pacf2acf(pac, lag.max = length(pac))
   inla.ar.phi2acf(phi, lag.max = length(phi))
}

\arguments{
  \item{pac}{The partial autorcorrelation coefficients}
  \item{phi}{The AR(p) parameters \code{phi}}
  \item{lag.max}{The maximum lag to compute the ACF for}
}
\value{
  \code{inla.ar.pacf2phi}  returns \code{phi} for given \code{pacf}.
  \code{inla.ar.phi2pacf}  returns \code{pac} for given \code{phi}.
  \code{inla.ar.phi2acf}  returns \code{acf} for given \code{phi}.
  \code{inla.ar.pacf2acf}  returns \code{acf} for given \code{pacf}.
}
\author{Havard Rue \email{hrue@r-inla.org}}
\examples{
 pac = runif(5)
 phi = inla.ar.pacf2phi(pac)
 pac2 = inla.ar.phi2pacf(phi)
 print(paste("Error:", max(abs(pac2-pac))))
 print("Correlation matrix (from pac)")
 print(toeplitz(inla.ar.pacf2acf(pac)))
 print("Correlation matrix (from phi)")
 print(toeplitz(inla.ar.phi2acf(phi)))
}
