%%
%% WARNING! DO NOT EDIT!
%% This file is automatically generated from barrier.R
%%
 \name{inla.barrier}
 \alias{inla.barrier}
 \alias{barrier}
 \alias{inla.barrier.pcmatern}
 \alias{barrier.pcmatern}
 \alias{inla.barrier.polygon}
 \alias{barrier.polygon}
 \alias{inla.barrier.q}
 \alias{barrier.q}
 \alias{inla.barrier.fem}
 \alias{barrier.fem}
 
 \title{Functions for defining the Barrier models}
 
 \description{Functions for defining Barrier models as an \code{inla rgeneric} model}

 \usage{
 inla.barrier.pcmatern(mesh, barrier.triangles, prior.range,
                       prior.sigma, range.fraction=0.2)
 inla.barrier.polygon(mesh, barrier.triangles, Omega=NULL)
 inla.barrier.q(fem, ranges, sigma=1)
 inla.barrier.fem(mesh, barrier.triangles, Omega=NULL)
 }
 \arguments{
   \item{mesh}{The mesh to build the model on, from inla.mesh.2d}
   \item{barrier.triangles}{The numerical ids of the triangles that make up the barrier area}
   \item{prior.range}{2 parameters \code{(range0,Prange)} for the prior spatial range. 
         If \code{Prange} is \code{NA}, then \code{range0} is used as a fixed range value (not tested).}
   \item{prior.sigma}{2 parameters \code{(sig0,Psig)} for the prior marginal standard deviation sigma. 
         If \code{Psig} is \code{NA}, then \code{sig0} is used as a fixed sigma value (not tested).}
   \item{range.fraction}{The length of the spatial range inside the barrier area,
                         as a fraction of the range parameter.}
   \item{Omega}{Advanced option for creating a set of permeable barriers (not documented)}
 }
 \details{
     This model is described in the ArXiv preprint arXiv:1608.03787.
     For examples, see \url{https://haakonbakka.bitbucket.io/btopic107.html}.
 }
\value{%%
  \code{inla.barrier.pcmatern} gives the (rgeneric) model object for fitting the model in INLA,
  \code{inla.barrier.polygon} gives the polygon around the barrier (mainly for plotting),
  \code{inla.barrier.q} is an internal method producing the Q matrix from a result of inla.barrier.fem,
  \code{inla.barrier.fem} is an internal method producing the Finite Element matrices.
 }
 \seealso{inla.spde2.pcmatern}
 \author{Haakon Bakka \email{bakka@r-inla.org}}
