% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/over_sp_mesh.R
\name{inla.over_sp_mesh}
\alias{inla.over_sp_mesh}
\title{Check which mesh triangles are inside a polygon}
\usage{
inla.over_sp_mesh(x, y, type = c("centroid", "vertex"), ignore.CRS = FALSE)
}
\arguments{
\item{x}{geometry (typically a \code{\link[sp]{SpatialPolygons}} object) for the queries}

\item{y}{an \code{\link{inla.mesh}} object}

\item{type}{the query type; either \code{'centroid'} (default, for triangle centroids),
or \code{'vertex'} (for mesh vertices)}

\item{ignore.CRS}{logical; whether to ignore the coordinate system information in \code{x} and \code{y}
(default \code{FALSE})}
}
\value{
A vector of triangle indices (when \code{type} is \code{'centroid'}) or
  vertex indices (when \code{type} is \code{'vertex'})
}
\description{
Wrapper for the \code{\link[sp]{over}} method to find triangle centroids
or vertices inside \code{sp} polygon objects
}
\examples{
# Create a polygon and a mesh
obj <- sp::SpatialPolygons(list(Polygons(list(Polygon(rbind(c(0,0),
                                                            c(50,0),
                                                            c(50,50),
                                                            c(0,50)))),
                                         ID=1)),
                           proj4string = inla.CRS("longlat_globe"))
mesh <- inla.mesh.create(globe = 2, crs = inla.CRS("sphere"))

## 3 vertices found in the polygon
inla.over_sp_mesh(obj, mesh, type = "vertex")

## 3 triangles found in the polygon
inla.over_sp_mesh(obj, mesh)

## Multiple transformations can lead to slightly different results due to edge cases
## 4 triangles found in the polygon
inla.over_sp_mesh(obj, inla.spTransform(mesh, CRSobj=inla.CRS("mollweide_norm")), ignore.CRS = FALSE)

## Ignoring mismatching coordinate systems is rarely useful
## 20 triangles "found in" the polygon
inla.over_sp_mesh(obj, inla.spTransform(mesh, CRSobj=inla.CRS("mollweide_norm")), ignore.CRS = TRUE)

}
\author{
Haakon Bakka, \email{bakka@r-inla.org}, and Finn Lindgren \email{finn.lindgren@gmail.com}
}
