% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{inla.mesh.1d.A}
\alias{inla.mesh.1d.A}
\alias{inla.mesh.1d.bary}
\title{Mapping matrix for 1D meshes}
\usage{
inla.mesh.1d.A(
  mesh,
  loc,
  weights = NULL,
  derivatives = NULL,
  method = c("linear", "nearest", "quadratic")
)
}
\arguments{
\item{mesh}{An \code{\link[=inla.mesh.1d]{inla.mesh.1d()}} object.}

\item{loc}{Coordinate values.}

\item{weights}{Weights to be applied to the \code{A} matrix rows.}

\item{derivatives}{If \code{TRUE}, also compute derivative weight matrices
\code{dA} and \code{d2A}.}

\item{method}{Interpolation method.  If not specified for
\code{inla.mesh.1d.A} (recommended), it is determined by the \code{mesh}
basis function properties.}
}
\description{
Calculates barycentric coordinates and weight matrices for
\code{\link[=inla.mesh.1d]{inla.mesh.1d()}} objects.
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
