% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{inla.mesh.1d}
\alias{inla.mesh.1d}
\alias{inla.mesh.1d.fem}
\title{Function space definition objects for 1D SPDE models.}
\usage{
inla.mesh.1d(
  loc,
  interval = range(loc),
  boundary = NULL,
  degree = 1,
  free.clamped = FALSE,
  ...
)

inla.mesh.1d.fem(mesh)
}
\arguments{
\item{loc}{B-spline knot locations.}

\item{interval}{Interval domain endpoints.}

\item{boundary}{Boundary condition specification.  Valid conditions are
\code{c('neumann', 'dirichlet', 'free', 'cyclic')}.  Two separate values can
be specified, one applied to each endpoint.}

\item{degree}{The B-spline basis degree.  Supported values are 0, 1, and 2.}

\item{free.clamped}{If \code{TRUE}, for \code{'free'} boundaries, clamp the
basis functions to the interval endpoints.}

\item{\dots}{Additional option, currently unused.}

\item{mesh}{An inla.mesh.1d object}
}
\description{
Create a 1D mesh specification \code{inla.mesh.1d} object, that defines a
function space for 1D SPDE models.
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
