% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.components.R
\name{inla.mesh.components}
\alias{inla.mesh.components}
\title{Compute connected mesh subsets}
\usage{
inla.mesh.components(mesh)
}
\value{
A list with elements \code{vertex} and \code{triangle}, vectors of
integer labels for which connected component they belong, and \code{info}, a
\code{data.frame} with columns
\item{component}{Connected component integer label.}
\item{nV}{The number of vertices in the component.}
\item{nT}{The number of triangles in the component.}
\item{area}{The surface area associated with the component.
Component lables are not comparable across
different meshes, but some ordering stability is guaranteed by initiating
each component from the lowest numbered triangle whenever a new component is
initiated.}
}
\description{
Compute subsets of vertices and triangles in an inla.mesh object that are
connected by edges.
}
\examples{

# Construct two simple meshes:
loc <- matrix(c(0,1,0,1), 2, 2)
mesh1 <- inla.mesh.2d(loc = loc, max.edge=0.1)
bnd <- inla.nonconvex.hull(loc, 0.3)
mesh2 <- inla.mesh.2d(boundary = bnd, max.edge=0.1)

# Compute connectivity information:
conn1 <- inla.mesh.components(mesh1)
conn2 <- inla.mesh.components(mesh2)
# One component, simply connected mesh
conn1$info
# Two disconnected components
conn2$info

# Extract the subset mesh for the largest component:
# (Note: some information is lost, such as fixed segments,
#  and boundary edge labels.)
maxi <- conn2$info$component[which.max(conn2$info$area)]
mesh3 <- inla.mesh.create(loc = mesh2$loc,
                          tv = mesh2$graph$tv[conn2$triangle == maxi,,drop=FALSE])

}
\seealso{
\code{\link[=inla.mesh.2d]{inla.mesh.2d()}}, \code{\link[=inla.mesh.create]{inla.mesh.create()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
