% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{inla.mesh.lattice}
\alias{inla.mesh.lattice}
\title{Lattice grids for inla.mesh}
\usage{
inla.mesh.lattice(
  x = seq(0, 1, length.out = 2),
  y = seq(0, 1, length.out = 2),
  z = NULL,
  dims = if (is.matrix(x)) {     dim(x) } else {     c(length(x), length(y)) },
  units = NULL,
  crs = NULL
)
}
\arguments{
\item{x}{vector or grid matrix of x-values}

\item{y}{vector of grid matrix of y-values}

\item{z}{if x is a matrix, a grid matrix of z-values}

\item{dims}{the size of the grid, length 2 vector}

\item{units}{One of \code{c("default", "longlat", "longsinlat")}.}

\item{crs}{An optional \code{CRS} or \code{inla.CRS} object}
}
\value{
An \code{inla.mesh.lattice} object.
}
\description{
Construct a lattice grid for \code{\link[=inla.mesh]{inla.mesh()}}
}
\examples{

lattice = inla.mesh.lattice(seq(0, 1, length.out=17), seq(0, 1, length.out=10))

## Use the lattice "as-is", without refinement:
mesh = inla.mesh.create(lattice=lattice, boundary=lattice$segm)
mesh = inla.mesh.create(lattice=lattice, extend=FALSE)
plot(mesh)

## Refine the triangulation, with limits on triangle angles and edges:
mesh = inla.mesh.create(lattice=lattice,
                        refine=list(max.edge=0.08),
                        extend=FALSE)
plot(mesh)

## Add an extension around the lattice, but maintain the lattice edges:
mesh = inla.mesh.create(lattice=lattice,
                        refine=list(max.edge=0.08),
                        interior=lattice$segm)
plot(mesh)

## Only add extension:
mesh = inla.mesh.create(lattice=lattice, refine=list(max.edge=0.08))
plot(mesh)

}
\seealso{
\code{\link[=inla.mesh]{inla.mesh()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
