% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{inla.mesh.project}
\alias{inla.mesh.project}
\alias{inla.mesh.projector}
\alias{inla.mesh.projector.inla.mesh}
\alias{inla.mesh.project.inla.mesh}
\alias{inla.mesh.project.inla.mesh.projector}
\alias{inla.mesh.project.inla.mesh.1d}
\alias{inla.mesh.projector.inla.mesh.1d}
\title{Methods for projecting to/from an inla.mesh}
\usage{
inla.mesh.project(...)

\method{inla.mesh.project}{inla.mesh}(mesh, loc = NULL, field = NULL, crs = NULL, ...)

\method{inla.mesh.project}{inla.mesh.1d}(mesh, loc, field = NULL, ...)

\method{inla.mesh.project}{inla.mesh.projector}(projector, field, ...)

inla.mesh.projector(...)

\method{inla.mesh.projector}{inla.mesh}(
  mesh,
  loc = NULL,
  lattice = NULL,
  xlim = NULL,
  ylim = NULL,
  dims = c(100, 100),
  projection = NULL,
  crs = NULL,
  ...
)

\method{inla.mesh.projector}{inla.mesh.1d}(mesh, loc = NULL, xlim = mesh$interval, dims = 100, ...)
}
\arguments{
\item{\dots}{Additional arguments passed on to methods.}

\item{mesh}{An \code{\link[=inla.mesh]{inla.mesh()}} or \code{\link[=inla.mesh.1d]{inla.mesh.1d()}} object.}

\item{loc}{Projection locations.  Can be a matrix or a \code{SpatialPoints}
or a \code{SpatialPointsDataFrame} object.}

\item{field}{Basis function weights, one per mesh basis function, describing
the function to be avaluated at the projection locationssFunction values for
on the mesh}

\item{crs}{An optional CRS or inla.CRS object associated with \code{loc}
and/or \code{lattice}.}

\item{projector}{An \code{inla.mesh.projector} object.}

\item{lattice}{An \code{\link[=inla.mesh.lattice]{inla.mesh.lattice()}} object.}

\item{xlim}{X-axis limits for a lattice. For R2 meshes, defaults to covering
the domain.}

\item{ylim}{Y-axis limits for a lattice. For R2 meshes, defaults to covering
the domain.}

\item{dims}{Lattice dimensions.}

\item{projection}{One of \code{c("default", "longlat", "longsinlat", "mollweide")}.}
}
\value{
For \code{inla.mesh.project(mesh, ...)}, a list with projection
information.  For \code{inla.mesh.projector(mesh, ...)}, an
\code{inla.mesh.projector} object.  For \code{inla.mesh.project(projector, field, ...)}, a field projected from the mesh onto the locations given by
the projector object.
}
\description{
Calculate a lattice projection to/from an \code{\link[=inla.mesh]{inla.mesh()}}
}
\details{
The call \code{inla.mesh.project(mesh, loc, field=..., ...)}, is a shortcut
to inla.mesh.project(inla.mesh.projector(mesh, loc), field).
}
\examples{

n = 20
loc = matrix(runif(n*2), n, 2)
mesh = inla.mesh.create(loc, refine=list(max.edge=0.05))
proj = inla.mesh.projector(mesh)
field = cos(mesh$loc[,1]*2*pi*3)*sin(mesh$loc[,2]*2*pi*7)
image(proj$x, proj$y, inla.mesh.project(proj, field))
\donttest{
if (require(rgl)) {
  plot(mesh, rgl=TRUE, col=field, draw.edges=FALSE, draw.vertices=FALSE)
}
}

}
\seealso{
\code{\link[=inla.mesh]{inla.mesh()}}, \code{\link[=inla.mesh.1d]{inla.mesh.1d()}},
\code{\link[=inla.mesh.lattice]{inla.mesh.lattice()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
