% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{inla.simplify.curve}
\alias{inla.simplify.curve}
\title{Recursive curve simplification.}
\usage{
inla.simplify.curve(loc, idx, eps)
}
\arguments{
\item{loc}{Coordinate matrix.}

\item{idx}{Index vector into \code{loc} specifying a polygonal curve.}

\item{eps}{Straightness tolerance.}
}
\value{
An index vector into \code{loc} specifying the simplified polygonal
curve.
}
\description{
Attempts to simplify a polygonal curve by joining nearly colinear segments.
}
\details{
Uses a variation of the binary splitting Ramer-Douglas-Peucker algorithm,
with a width \code{eps} ellipse instead of a rectangle, motivated by
prediction ellipse for Brownian bridge.
}
\examples{

theta = seq(0, 2*pi, length=1000)
loc = cbind(cos(theta), sin(theta))
idx = inla.simplify.curve(loc=loc, idx=1:nrow(loc), eps=0.01)
print(c(nrow(loc), length(idx)))
plot(loc, type="l")
lines(loc[idx,], col="red")

}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
