% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spde.common.R, R/spde1.R, R/spde2.R
\name{inla.spde.precision}
\alias{inla.spde.precision}
\alias{inla.spde1.precision}
\alias{inla.spde2.precision}
\alias{inla.spde.precision.inla.spde1}
\alias{inla.spde.precision.inla.spde2}
\title{Precision matrices for SPDE models

Calculates the precision matrix for given parameter values based on an
\code{inla.spde} model object.}
\usage{
inla.spde.precision(...)

inla.spde1.precision(spde, ...)

\method{inla.spde.precision}{inla.spde1}(spde, ...)

inla.spde2.precision(
  spde,
  theta = NULL,
  phi0 = inla.spde2.theta2phi0(spde, theta),
  phi1 = inla.spde2.theta2phi1(spde, theta),
  phi2 = inla.spde2.theta2phi2(spde, theta),
  ...
)

\method{inla.spde.precision}{inla.spde2}(
  spde,
  theta = NULL,
  phi0 = inla.spde2.theta2phi0(spde, theta),
  phi1 = inla.spde2.theta2phi1(spde, theta),
  phi2 = inla.spde2.theta2phi2(spde, theta),
  ...
)
}
\arguments{
\item{\dots}{Additional parameters passed on to other methods.}

\item{spde}{An \code{inla.spde} object.}

\item{theta}{The parameter vector.}

\item{phi0}{Internal parameter for a generic model.  Expert option only.}

\item{phi1}{Internal parameter for a generic model.  Expert option only.}

\item{phi2}{Internal parameter for a generic model.  Expert option only.}
}
\value{
A sparse precision matrix.
}
\description{
Precision matrices for SPDE models

Calculates the precision matrix for given parameter values based on an
\code{inla.spde} model object.
}
\seealso{
\code{\link[=inla.spde.models]{inla.spde.models()}}, \code{\link[=inla.spde2.generic]{inla.spde2.generic()}},
\code{\link[=inla.spde2.theta2phi0]{inla.spde2.theta2phi0()}}, \code{\link[=inla.spde2.theta2phi1]{inla.spde2.theta2phi1()}},
\code{\link[=inla.spde2.theta2phi2]{inla.spde2.theta2phi2()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
