%%
%% WARNING! DO NOT EDIT!
%% This file is automatically generated from lattice2node.R
%%
\name{lattice2node}
\alias{lattice2node}
\alias{inla.lattice2node}
\alias{node2lattice}
\alias{inla.node2lattice}
\alias{node2lattice.mapping}
\alias{inla.node2lattice.mapping}
\alias{lattice2node.mapping}
\alias{inla.lattice2node.mapping}
\alias{matrix2vector}
\alias{vector2matrix}
\alias{inla.matrix2vector}
\alias{inla.vector2matrix}

\title{Functions to define mapping between a lattice and nodes}

\description{These functions define mapping in between two-dimensional
  indices on a lattice and the one-dimensional node representation used
  in \code{inla}.

  The mapping from node to lattice follows the default \code{R}
  behaviour (which is column based storage), and \code{as.vector(A)} and
  \code{matrix(a, nrow, ncol)} can be used instead of
  \code{inla.matrix2vector} and \code{inla.vector2matrix}.
}

\usage{
inla.lattice2node.mapping(nrow, ncol)
inla.node2lattice.mapping(nrow, ncol)
inla.lattice2node(irow, icol, nrow, ncol)
inla.node2lattice(node, nrow, ncol)
inla.matrix2vector(a.matrix)
inla.vector2matrix(a.vector, nrow, ncol)
}

\arguments{

  \item{nrow}{Number of rows in the lattice.}

  \item{ncol}{Number of columns in the lattice.}

  \item{irow}{Lattice row index, between \code{1} and \code{nrow}}

  \item{icol}{Lattice column index, between \code{1} and \code{ncol}}

  \item{node}{The node index, between \code{1} and \code{ncol*nrow}}

  \item{a.matrix}{is a matrix to be mapped to a vector using internal
  representation defined by \code{inla.lattice2node}}

  \item{a.vector}{is a vector to be mapped into a matrix using the
    internal representation defined by \code{inla.node2lattice}}
}

\value{\code{inla.lattice2node.mapping} returns the hole mapping as a
  matrix, and \code{inla.node2lattice.mapping} returns the hole mapping
  as \code{list(irow=..., icol=...)}. \code{inla.lattice2node} and
  \code{inla.node2lattice} provide the mapping for a given set of
  lattice indices and nodes. \code{inla.matrix2vector} provide the
  mapped vector from a matrix, and \code{inla.vector2matrix} provide the
  inverse mapped matrix from vector.}
  
%%

\author{Havard Rue \email{hrue@r-inla.org}}

\seealso{\link{inla}}

\examples{
## write out the mapping using the two alternatives
nrow = 2
ncol = 3
mapping = inla.lattice2node.mapping(nrow,ncol)

for (i in 1:nrow){
    for(j in 1:ncol){
        print(paste("Alt.1: lattice index [", i,",", j,"] corresponds",
                    "to node [", mapping[i,j],"]", sep=""))
    }
}

for (i in 1:nrow){
    for(j in 1:ncol){
        print(paste("Alt.2: lattice index [", i,",", j,"] corresponds to node [",
                    inla.lattice2node(i,j,nrow,ncol), "]", sep=""))
    }
}

inv.mapping = inla.node2lattice.mapping(nrow,ncol)
for(node in 1:(nrow*ncol))
   print(paste("Alt.1: node [", node, "] corresponds to lattice index [",
               inv.mapping$irow[node], ",",
               inv.mapping$icol[node],"]", sep=""))

for(node in 1:(nrow*ncol))
   print(paste("Alt.2: node [", node, "] corresponds to lattice index [",
               inla.node2lattice(node,nrow,ncol)$irow[1], ",",
               inla.node2lattice(node,nrow,ncol)$icol[1],"]", sep=""))

## apply the mapping from matrix to vector and back
n = nrow*ncol
z = matrix(1:n,nrow,ncol)
z.vector = inla.matrix2vector(z)  # as.vector(z) could also be used
print(mapping)
print(z)
print(z.vector)

## the vector2matrix is the inverse, and should give us the z-matrix
## back. matrix(z.vector, nrow, ncol) could also be used here.
z.matrix = inla.vector2matrix(z.vector, nrow, ncol) 
print(z.matrix)
}
