%%
%% WARNING! DO NOT EDIT!
%% This file is automatically generated from f.R
%%
\name{f}
\alias{f}
\title{Define general Gaussian models in the INLA formula }
\description{

  Function used for defining of smooth and spatial terms within \code{inla} model
  formulae. The function does not evaluate anything - it
  exists purely to help set up a model. The function specifies one
  smooth function in the linear predictor (see \code{\link{inla.list.models}}) as
  \deqn{w\ f(x)}{weight*f(var)}

}
\usage{
    f(...,
         model = "iid",
         copy=NULL,
         same.as = NULL,
         n=NULL,
         nrep = NULL,
         replicate = NULL,
         ngroup = NULL,
         group = NULL,
         control.group = inla.set.control.group.default(),
         hyper = NULL,
         initial=NULL,
         prior=NULL,
         param = NULL,
         fixed = NULL,
         season.length=NULL,
         constr = NULL,
         extraconstr=list(A=NULL, e=NULL),
         values=NULL,
         cyclic = NULL,
         diagonal = NULL,
         graph=NULL,
         graph.file=NULL,
         cdf=NULL,
         quantiles=NULL,
         Cmatrix=NULL,
         rankdef=NULL,
         Z = NULL,
         nrow = NULL,
         ncol = NULL,
         nu = NULL,
         bvalue = NULL,
         spde.prefix = NULL,
         spde2.prefix = NULL,
         spde2.transform = c("logit", "log", "identity"),
         spde3.prefix = NULL,
         spde3.transform = c("logit", "log", "identity"),
         mean.linear = inla.set.control.fixed.default()$mean,
         prec.linear = inla.set.control.fixed.default()$prec,
         compute = TRUE,
         of=NULL,
         precision = exp(14),
         range = NULL,
         adjust.for.con.comp = TRUE,
         order = NULL,
         scale = NULL,
         strata = NULL,
         rgeneric = NULL,
         scale.model = NULL,
         args.slm = list(rho.min = NULL, rho.max = NULL, 
                         X = NULL, W = NULL, Q.beta = NULL),
         args.ar1c = list(Z = NULL, Q.beta = NULL),
         args.intslope = list(subject = NULL, strata = NULL, covariates = NULL), 
         correct = NULL,
         vb.correct = NULL,
         locations = NULL, 
         debug = FALSE)
}
\arguments{
\item{...}{ Name of the covariate and, possibly of the
weights vector. NB: order counts!!!! The first specified
term is the covariate and the second one is the vector of
weights (which can be negative).}
\item{model}{ A string indicating the choosen model. The
 default is \code{iid}. See
 \code{names(inla.models()$latent)} for a list of possible
 alternatives and \code{\link{inla.doc}} for detailed docs.}
\item{copy}{TODO}
\item{same.as}{TODO}
\item{n}{An optional argument which defines the dimension
of the model if this is different from
\code{length(sort(unique(covariate)))}}
\item{nrep}{TODO}
\item{replicate}{We need to write documentation here}
\item{ngroup}{TODO}
\item{group}{TODO}
\item{control.group}{TODO}
\item{hyper}{Specification of the hyperparameter, fixed or
random, initial values, priors and its parameters. See
\code{?inla.models} for the list of hyparameters for each
model and its default options or
use \code{inla.doc()} for
detailed info on the family and
supported prior distributions.}
\item{initial}{THIS OPTION IS OBSOLETE; use
\code{hyper}!!! Vector indicating the starting values for
the optimization algorithm. The length of the vector
depends on the number of hyperparamters in the choosen
\code{model}. If \code{fixed=T} the value at which the
parameters are fixed is determines through \code{initial}.
See \code{inla.models()$latent$'model name'} to have info
about the choosen model.}
\item{prior}{THIS OPTION IS OBSOLETE; use \code{hyper}!!!
Prior distribution(s) for the hyperparameters of the
!random model. The default value depends on the type of
model, see !\url{www.r-inla.org} for a detailed
description of the models. See
\code{names(inla.models()$priors)} for possible prior
choices}
\item{param}{THIS OPTION IS OBSOLETE; use \code{hyper}!!!
Vector indicating the parameters \eqn{a}{a} and \eqn{b}{b}
of the prior distribution for the hyperparameters. The
length of the vector depends on the choosen \code{model}.
See \code{inla.models()$latent$'model name'} to have info
about the choosen model.}
\item{fixed}{THIS OPTION IS OBSOLETE; use \code{hyper}!!!
Vector of boolean variables indicating wheater the
hyperparameters of the model are fixed or random. The
length of the vector depends on the choosen \code{model}
See \code{inla.models()$latent$'model name'} to have info
about the choosen model.}
\item{season.length}{Lenght of the seasonal compoment
(ONLY if \code{model="seasonal"}) }
\item{constr}{A boolean variable indicating whater to set
a sum to 0 constraint on the term. By default the sum to 0
constraint is imposed on all intrinsic models
("iid","rw1","rw1","besag", etc..).}
\item{extraconstr}{This argument defines extra linear
constraints. The argument is a list with two elements, a
matrix \code{A} and a vector \code{e}, which defines the
extra constraint \code{Ax = e}; for example
\code{extraconstr = list(A = A, e=e)}. The number of
columns of \code{A} must correspond to the length of this
\code{f}-model.  Note that this constraint comes
additional to the sum-to-zero constraint defined if
\code{constr = TRUE}.}
\item{values}{An optional vector giving all values
assumed by the covariate for which we want estimated the
effect. It must be a numeric vector, a vector of factors
or \code{NULL}.}
\item{cyclic}{A boolean specifying wheather the model is
cyclical. Only valid for "rw1" and "rw2" models, is
cyclic=T then the sum to 0 constraint is removed. For the
correct form of the grah file see \cite{Martino and Rue
(2008)}.}
\item{diagonal}{An extra constant added to the diagonal of
the precision matrix.}
\item{graph}{Defines the graph-object either as a file with
a graph-description, an \code{inla.graph}-object, or as a
(sparse) symmetric matrix.}
\item{graph.file}{THIS OPTION IS OBSOLETE AND REPLACED BY
THE MORE GENERAL ARGUMENT \code{graph}. PLEASE CHANGE YOUR
CODE.
Name of the file containing the graph
of the model; see
\url{www.r-inla.org/faq}.}
\item{cdf}{A vector of maximum 10 values between 0 and 1
\eqn{x(0), x(1),\ldots}{x(0), x(1),\ldots}. The function
returns, for each posterior marginal the probabilities
\deqn{\mbox{Prob}(X<x(p))}{Prob(X<x(p))} }
\item{quantiles}{A vector of maximum 10 quantiles,
\eqn{p(0), p(1),\dots}{p(0), p(1),\ldots} to compute for
each posterior marginal. The function returns, for each
posterior marginal, the values
\eqn{x(0), x(1),\dots}{x(0), x(1),\ldots} such that
\deqn{\mbox{Prob}(X<x(p))=p}{Prob(X<x)=p}}
\item{Cmatrix}{The specification of the precision matrix
for the generic,  generic3 or z models (up to a scaling constant).
\code{Cmatrix} is either a
(dense) matrix, a matrix created using
\code{Matrix::sparseMatrix()}, or a filename which stores the
non-zero elements of \code{Cmatrix}, in three columns:
\code{i}, \code{j} and \code{Qij}. In case of the generic3 model,
it is a list of such specifications.}
\item{rankdef}{A number \bold{defining} the rank
deficiency of the model, with sum-to-zero constraint and
possible extra-constraints taken into account. See
details.}
\item{Z}{The matrix for the z-model}
\item{nrow}{Number of rows for 2d-models}
\item{ncol}{Number of columns for 2d-models}
\item{nu}{Smoothing parameter for the Matern2d-model,
possible values are \code{c(0, 1, 2, 3)}}
\item{bvalue}{TODO}
\item{spde.prefix}{TODO}
\item{spde2.prefix}{TODO}
\item{spde2.transform}{TODO}
\item{spde3.prefix}{TODO}
\item{spde3.transform}{TODO}
\item{mean.linear}{Prior mean for the linear component,
only used if \code{model="linear"}}
\item{prec.linear}{Prior precision for the linear
component, only used if \code{model="linear"}}
\item{compute}{ A boolean variable indicating wheather the
 marginal posterior distribution for the nodes in the
 \code{f()} model should be computed or not. This is
 usefull for large models where we are only interested in
 some posterior marginals.}
\item{of}{TODO}
\item{precision}{The precision for the artifical noise added when creating a copy of a model and others.}
\item{range}{A vector of size two giving the lower and
upper range for the scaling parameter \code{beta} in the
model \code{COPY}, \code{CLINEAR}, \code{MEC} and \code{MEB}.
If \code{low = high} then the identity mapping
is used.}
\item{adjust.for.con.comp}{If TRUE (default), adjust some
of the models (currently: besag, bym, bym2 and besag2) if the
number of connected components in graph is larger than
1. If FALSE, do nothing.}
\item{order}{Defines the \code{order} of the model: for
model \code{ar} this defines the order p, in AR(p). Not
used for other models at the time being.}
\item{scale}{A scaling vector. Its meaning depends on the model.}
\item{strata}{Currently not in use}
\item{rgeneric}{A object of class \code{inla.rgeneric} which defines the model. (EXPERIMENTAL!)}
\item{scale.model}{Logical. If \code{TRUE} then scale the RW1 and RW2 and BESAG and BYM and BESAG2 and RW2D models so the their (generlized) variance is 1. Default value is \code{inla.getOption("scale.model.default")}}
\item{args.slm}{Required arguments to the model="slm"; see the documentation for further details.},
\item{args.ar1c}{Required arguments to the model="ar1c"; see the documentation for further details.},
\item{args.intslope}{A list with the \code{subject} (factor),  \code{strata} (factor) and \code{covariates} (numeric) for the \code{intslope} model; see the documentation for further details.}, 
\item{correct}{Add this model component to the list of variables to be used in the corrected Laplace approximation? If \code{NULL} use default choice,  otherwise correct if \code{TRUE} and do not if \code{FALSE}. (This option is currently experimental.)},
\item{vb.correct}{Add this model component to the list of variables to be used for the vb corrected Laplace approximation? If \code{NULL} use default choice,  otherwise correct if \code{TRUE} and do not if \code{FALSE}. (expert option)},
\item{locations}{A matrix with locations for the model \code{dmatern}. This also defines \code{n}.}
\item{debug}{Enable local debug output}
}
\value{TODO}
\details{There is no default value for \code{rankdef}, if it
is not defined by the user then it is computed by the rank
deficiency of the prior model (for the generic model, the
default is zero), plus 1 for the sum-to-zero constraint if the
prior model is proper, plus the number of extra
constraints. \bold{Oops:} This can be wrong, and then the user
must define the \code{rankdef} explicitely.}
\author{Havard Rue \email{hrue@r-inla.org}}
\seealso{\code{\link{inla}}, \code{\link{hyperpar.inla}}}
