% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spmesh.R
\name{inla.CRS}
\alias{inla.CRS}
\alias{inla.wkt_predef}
\title{Create a coordinate reference system object}
\usage{
inla.CRS(
  projargs = NULL,
  doCheckCRSArgs = TRUE,
  args = NULL,
  oblique = NULL,
  SRS_string = NULL,
  ...
)

inla.wkt_predef()
}
\arguments{
\item{projargs}{Either 1) a projection argument string suitable as input to
\code{sp::CRS}, or 2) an existing \code{CRS} object, or 3) a shortcut
reference string to a predefined projection; run
\code{names(inla.wkt_predef())} for valid predefined projections.}

\item{doCheckCRSArgs}{default TRUE, must be set to FALSE by package
developers including \code{CRS} in an S4 class definition to avoid
uncontrollable loading of the \code{rgdal} namespace.}

\item{args}{An optional list of name/value pairs to add to and/or override
the PROJ4 arguments in \code{projargs}.  \code{name=value} is converted to
\code{"+name=value"}, and \code{name=NA} is converted to \code{"+name"}.}

\item{oblique}{Vector of length at most 4 of rotation angles (in degrees)
for an oblique projection, all values defaulting to zero. The values
indicate (longitude, latitude, orientation, orbit), as explained in the
Details section below.}

\item{SRS_string}{a WKT2 string defining the coordinate system; see
\code{sp::CRS}. This takes precedence over \code{projargs}.}

\item{\dots}{Additional parameters. Not currently in use.}
}
\value{
Either an \code{sp::CRS} object or an \code{inla.CRS} object,
depending on if the coordinate reference system described by the parameters
can be expressed with a pure \code{sp::CRS} object or not.

An S3 \code{inla.CRS} object is a list, usually (but not necessarily)
containing at least one element: \item{crs }{The basic \code{sp::CRS}
object}

\code{inla.wkt_predef} returns a WKT2 string defining a projection

\code{inla.wkt_predef} returns a WKT2 string defining a projection
}
\description{
Creates either a CRS object or an inla.CRS object, describing a coordinate
reference system
}
\details{
The first two elements of the \code{oblique} vector are the (longitude,
latitude) coordinates for the oblique centre point. The third value
(orientation) is a counterclockwise rotation angle for an observer looking
at the centre point from outside the sphere. The fourth value is the
quasi-longitude (orbit angle) for a rotation along the oblique observers
equator.

Simple oblique: \code{oblique=c(0, 45)}

Polar: \code{oblique=c(0, 90)}

Quasi-transversal: \code{oblique=c(0, 0, 90)}

Satellite orbit viewpoint: \code{oblique=c(lon0-time*v1, 0, orbitangle, orbit0+time*v2)}, where \code{lon0} is the longitude at which a satellite
orbit crosses the equator at \code{time=0}, when the satellite is at an
angle \code{orbit0} further along in its orbit.  The orbital angle relative
to the equatorial plane is \code{orbitangle}, and \code{v1} and \code{v2}
are the angular velocities of the planet and the satellite, respectively.
Note that "forward" from the satellite's point of view is "to the right" in
the projection.

When \code{oblique[2]} or \code{oblique[3]} are non-zero, the resulting
projection is only correct for perfect spheres.
}
\examples{


if (require(rgdal)) {
  crs1 <- inla.CRS("longlat_globe")
  crs2 <- inla.CRS("lambert_globe")
  crs3 <- inla.CRS("mollweide_norm")
  crs4 <- inla.CRS("hammer_globe")
  crs5 <- inla.CRS("sphere")
  crs6 <- inla.CRS("globe")
} 
\dontrun{
 names(inla.wkt_predef())
}

\dontrun{
 names(inla.wkt_predef())
}
}
\seealso{
\code{\link[sp:CRS-class]{sp::CRS()}}, \code{\link[=crs_wkt]{crs_wkt()}},
\code{\link[=inla.sp_get_crs]{inla.sp_get_crs()}} \code{\link[=plot.CRS]{plot.CRS()}},
\code{\link[=inla.identical.CRS]{inla.identical.CRS()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
