% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spde.common.R, R/spde1.R, R/spde2.R
\name{inla.spde.models}
\alias{inla.spde.models}
\alias{inla.spde1.models}
\alias{inla.spde2.models}
\title{List SPDE models supported by inla.spde objects}
\usage{
inla.spde.models(function.names = FALSE)

inla.spde1.models()

inla.spde2.models()
}
\arguments{
\item{function.names}{If \code{FALSE}, return list model name lists.  If
\code{TRUE}, return list of model object constructor function names.}
}
\value{
List of available SPDE model type name lists.
}
\description{
List SPDE models supported by inla.spde objects
}
\details{
Returns a list of available SPDE model type name lists, one for each
inla.spde model class (currently \code{\link[=inla.spde1]{inla.spde1()}} and
\code{\link[=inla.spde2]{inla.spde2()}}).
}
\examples{

## Display help for each supported inla.spde2 model:
for (model in inla.spde2.models())
  print(help(paste("inla.spde2.", model, sep="")))

## Display help for each supported inla.spde* model:
models = inla.spde.models()
for (type in names(models))
  for (model in models[[type]])
    print(help(paste("inla.", type, ".", model, sep="")))

## Display help for each supported inla.spde* model (equivalent to above):
for (model in inla.spde.models(function.names=TRUE))
  print(help(model))

}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
