% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spde2.R
\name{inla.spde2.matern.sd.basis}
\alias{inla.spde2.matern.sd.basis}
\title{Approximate variance-compensating basis functions}
\usage{
inla.spde2.matern.sd.basis(
  mesh,
  B.sd,
  B.range,
  method = 1,
  local.offset.compensation = FALSE,
  alpha = 2,
  ...
)
}
\arguments{
\item{mesh}{An \code{\link[=inla.mesh]{inla.mesh()}} object.}

\item{B.sd}{Desired basis for log-standard deviations.}

\item{B.range}{Desired basis for spatial range.}

\item{method}{Construction method selector.  Expert option only.}

\item{local.offset.compensation}{If \code{FALSE}, only compensate in the
average for the \code{tau} offset.}

\item{alpha}{The model \code{alpha} parameter.}

\item{\dots}{Additional parameters passed on to internal
\code{inla.spde2.matern} calls.}
}
\value{
List of basis specifications \item{B.tau }{Basis for
\code{log(tau)}} \item{B.kappa }{Basis for \code{log(kappa)}} Intended for
passing on to \code{\link[=inla.spde2.matern]{inla.spde2.matern()}}.
}
\description{
Calculates an approximate basis for \code{tau} and \code{kappa} for an
\code{inla.spde2.matern} model where \code{tau} is a rescaling parameter.
}
\seealso{
\code{\link[=inla.spde2.matern]{inla.spde2.matern()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
