%%
%% WARNING! DO NOT EDIT!
%% This file is automatically generated from residuals.R
%%
\name{inla.ks.plot}
\alias{inla.ks.plot}
\alias{ks.plot}
\title{
  Kolmogorov-Smirnov Test Plots
}
\description{
  Illustrate a one-sample Kolmogorov-Smirnov test by plotting the
  empirical distribution deviation.
}
\usage{
inla.ks.plot(x, y, diff=TRUE, ...)
}
\arguments{
  \item{x}{a numeric vector of data values.}
  \item{y}{a cumulative distribution function such as 'pnorm'.}
  \item{diff}{logical, indicating if the normalised difference should be
    plotted.  If \code{FALSE}, the absolute distribution functions are plotted.}
  \item{...}{additional arguments for \code{\link{ks.test}}, ignored in
    the plotting.  In particular, only two-sided tests are illustrated.}
}
\details{
  In addition to the (normalised) empirical distribution deviation,
  lines for the K-S test statistic are drawn, as well as \eqn{\pm}{+/-}
  two standard deviations around the expectation under the null hypothesis.
}
\value{
  A list with class \code{"htest"}, as generated by
  \code{\link{ks.test}}
}
%%\references{
%%}
\author{
  Finn Lindgren \email{finn.lindgren@gmail.com}
}
%%\note{
%%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
  \code{\link{ks.test}}
}
\examples{
## Check for N(0,1) data
data = rowSums(matrix(runif(100*12)*2-1,100,12))/2
inla.ks.plot(data, pnorm)

\dontrun{
## Check the goodness-of-fit of cross-validated predictions
result = inla(..., control.predictor=list(cpo=TRUE))
inla.ks.plot(result$pit, punif)
}
}
