% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spmesh.R
\name{inla.has_PROJ6}
\alias{inla.has_PROJ6}
\alias{inla.not_for_PROJ6}
\alias{inla.not_for_PROJ4}
\alias{inla.fallback_PROJ6}
\alias{inla.requires_PROJ6}
\title{PROJ6 detection}
\usage{
inla.has_PROJ6()

inla.not_for_PROJ6(fun)

inla.not_for_PROJ4(fun)

inla.fallback_PROJ6(fun)

inla.requires_PROJ6(fun)
}
\arguments{
\item{fun}{The name of the calling function}
}
\value{
For \code{inla.has_PROJ6}, logical; \code{TRUE} if PROJ6 is available,
\code{FALSE} otherwise
}
\description{
Detect whether PROJ6 is available for INLA
}
\details{
\code{inla.has_PROJ6} is called to check if PROJ6&GDAL3 are available.
}
\section{Functions}{
\itemize{
\item \code{inla.not_for_PROJ6}: Called to warn about using old PROJ4
features even though PROJ6 is available

\item \code{inla.not_for_PROJ4}: Called to give an error when
calling methods that are only available for PROJ6

\item \code{inla.fallback_PROJ6}: Called to warn about falling back
to using old PROJ4 methods when a RPOJ6 method hasn't been implemented

\item \code{inla.requires_PROJ6}: Called to give an error when PROJ6
is required but not available
}}

\examples{

inla.has_PROJ6()
}
