% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{inla.mesh.boundary}
\alias{inla.mesh.boundary}
\alias{inla.mesh.interior}
\title{Constraint segment extraction for inla.mesh}
\usage{
inla.mesh.boundary(mesh, grp = NULL)

inla.mesh.interior(mesh, grp = NULL)
}
\arguments{
\item{mesh}{An \code{inla.mesh} object.}

\item{grp}{Group indices to extract.  If \code{NULL}, all boundary/interior
constrain groups are extracted.}
}
\value{
A list of \code{inla.mesh.segment} objects.
}
\description{
Constructs an list of \code{inla.mesh.segment} object from boundary or
interior constraint information in an \code{\link[=inla.mesh]{inla.mesh()}} object.
}
\examples{

loc <- matrix(runif(100 * 2) * 1000, 100, 2)
mesh <- inla.mesh.create.helper(points.domain = loc, max.edge = c(50, 500))
boundary <- inla.mesh.boundary(mesh)
interior <- inla.mesh.interior(mesh)
}
\seealso{
\code{\link[=inla.mesh.segment]{inla.mesh.segment()}}, \code{\link[=inla.mesh.create]{inla.mesh.create()}},
\code{\link[=inla.mesh.create.helper]{inla.mesh.create.helper()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
