% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spde.common.R
\name{inla.spde.make.index}
\alias{inla.spde.make.index}
\title{SPDE model index vector generation}
\usage{
inla.spde.make.index(name, n.spde, n.group = 1, n.repl = 1, ...)
}
\arguments{
\item{name}{A character string with the base name of the effect.}

\item{n.spde}{The size of the model, typically from \code{spde$n.spde}.}

\item{n.group}{The size of the \code{group} model.}

\item{n.repl}{The number of model replicates.}

\item{...}{Additional parameters.  Currently unused.}
}
\value{
A list of named index vectors. \item{name }{Indices into the vector
of latent variables} \item{name.group }{'group' indices} \item{name.repl
}{Indices for replicates}
}
\description{
Generates a list of named index vectors for an SPDE model.
}
\examples{

loc <- matrix(runif(100 * 2), 100, 2)
mesh <- inla.mesh.create.helper(points.domain = loc, max.edge = c(0.1, 0.5))
spde <- inla.spde2.matern(mesh)
index <- inla.spde.make.index("spatial", spde$n.spde, n.repl = 2)
spatial.A <- inla.spde.make.A(mesh, loc,
    index = rep(1:nrow(loc), 2),
    repl = rep(1:2, each = nrow(loc))
)
y <- 10 + rnorm(100 * 2)
stack <- inla.stack(
    data = list(y = y),
    A = list(spatial.A),
    effects = list(c(index, list(intercept = 1))),
    tag = "tag"
)
data <- inla.stack.data(stack, spde = spde)
formula <- y ~ -1 + intercept + f(spatial,
    model = spde,
    replicate = spatial.repl
)
result <- inla(formula,
    family = "gaussian", data = data,
    control.predictor = list(A = inla.stack.A(stack))
)
spde.result <- inla.spde2.result(result, "spatial", spde)
}
\seealso{
\code{\link[=inla.spde.make.A]{inla.spde.make.A()}}, \code{\link[=inla.spde2.result]{inla.spde2.result()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
