%%
%% WARNING! DO NOT EDIT!
%% This file is automatically generated from pc-cor1.R
%%
 \name{pc.cor1}
 \alias{inla.pc.cor1}
 \alias{pc.cor1}
 \alias{pc.rcor1}
 \alias{inla.pc.rcor1}
 \alias{pc.dcor1}
 \alias{inla.pc.dcor1}
 \alias{pc.pcor1}
 \alias{inla.pc.pcor1}
 \alias{pc.qcor1}
 \alias{inla.pc.qcor1}

 \title{Utility functions for the PC prior for correlation in AR(1)}

 \description{Functions to evaluate, sample, compute quantiles and
              percentiles of the PC prior for the correlation
              in the Gaussian AR(1) model where the base-model
              is correlation one.}
 \usage{
 inla.pc.rcor1(n, u, alpha, lambda)
 inla.pc.dcor1(cor, u, alpha, lambda, log = FALSE)
 inla.pc.qcor1(p, u, alpha, lambda)
 inla.pc.pcor1(q, u, alpha, lambda)
 }
 \arguments{
   \item{n}{Number of observations}
   \item{u}{The upper limit (see Details)}
   \item{alpha}{The probability going above the upper limit (see Details)}
   \item{lambda}{The rate parameter (see Details)}
   \item{cor}{Vector of correlations}
   \item{log}{Logical. Return the density in natural or log-scale.}
   \item{p}{Vector of probabilities}
   \item{q}{Vector of quantiles}
 }
 \details{
     The statement \code{Prob(cor > u) = alpha} is used to
     determine \code{lambda} unless \code{lambda} is given.
     Either \code{lambda}  must be given,  or
     \code{u} AND \code{alpha}.
 }
\value{%%
  \code{inla.pc.dcor1} gives the density,
  \code{inla.pc.pcor1} gives the distribution function,
  \code{inla.pc.qcor1} gives the quantile function, and
  \code{inla.pc.rcor1} generates random deviates.
 }
 \seealso{inla.doc("pc.rho1")}
 \author{Havard Rue \email{hrue@r-inla.org}}
 \examples{
 cor = inla.pc.rcor1(100,  lambda = 1)
 d = inla.pc.dcor1(cor, lambda = 1)
 cor = inla.pc.qcor1(c(0.3, 0.7), u = 0.5, alpha=0.75)
 inla.pc.pcor1(cor, u = 0.5, alpha=0.75)
 }
