%%
%% WARNING! DO NOT EDIT!
%% This file is automatically generated from pc-gammacount.R
%%
 \name{pc.gammacount}
 \alias{inla.pc.gammacount}
 \alias{pc.gammacount}
 \alias{pc.rgammacount}
 \alias{inla.pc.rgammacount}
 \alias{pc.dgammacount}
 \alias{inla.pc.dgammacount}
 \alias{pc.pgammacount}
 \alias{inla.pc.pgammacount}
 \alias{pc.qgammacount}
 \alias{inla.pc.qgammacount}

 \title{Utility functions for the PC prior for the \code{gammacount} likelihood}

 \description{Functions to evaluate, sample, compute quantiles and
              percentiles of the PC prior for the \code{gammacount} likelihood}
 \usage{
 inla.pc.rgammacount(n, lambda = 1)
 inla.pc.dgammacount(x, lambda = 1, log = FALSE)
 inla.pc.qgammacount(p, lambda = 1)
 inla.pc.pgammacount(q, lambda = 1)
 }
 \arguments{
   \item{n}{Number of observations}
   \item{lambda}{The rate parameter (see Details)}
   \item{x}{Evaluation points}
   \item{log}{Logical. Return the density in natural or log-scale.}
   \item{p}{Vector of probabilities}
   \item{q}{Vector of quantiles}
 }
 \details{
 This gives the PC prior for the \code{gammacount} likelihood,  which is the PC prior for
 \code{a} in \code{Gamma(a, 1)} where \code{Gamma(1, 1)} is the base model.
 }
\value{%%
  \code{inla.pc.dgammacount} gives the density,
  \code{inla.pc.pgammacount} gives the distribution function,
  \code{inla.pc.qgammacount} gives the quantile function, and
  \code{inla.pc.rgammacount} generates random deviates.
 }
 \seealso{inla.doc("pc.gammacount")}
 \author{Havard Rue \email{hrue@r-inla.org}}
 \examples{
 x = inla.pc.rgammacount(100,  lambda = 1)
 d = inla.pc.dgammacount(x, lambda = 1)
 x = inla.pc.qgammacount(0.5, lambda = 1)
 inla.pc.pgammacount(x, lambda = 1)
 }
