% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{plot.inla.trimesh}
\alias{plot.inla.trimesh}
\title{Low level triangulation mesh plotting}
\usage{
\method{plot}{inla.trimesh}(
  x,
  S,
  color = NULL,
  color.axis = NULL,
  color.n = 512,
  color.palette = cm.colors,
  color.truncate = FALSE,
  alpha = NULL,
  lwd = 1,
  specular = "black",
  draw.vertices = TRUE,
  draw.edges = TRUE,
  edge.color = rgb(0.3, 0.3, 0.3),
  ...
)
}
\arguments{
\item{x}{A 3-column triangle-to-vertex index map matrix.}

\item{S}{A 3-column vertex coordinate matrix.}

\item{color}{Color specification.  A single named color, a vector of scalar
values, or a matrix of RGB values.}

\item{color.axis}{The min/max limit values for the color mapping.}

\item{color.n}{The number of colors to use in the color palette.}

\item{color.palette}{A color palette function.}

\item{color.truncate}{If \code{TRUE}, truncate the colors at the color axis
limits.}

\item{alpha}{Transparency/opaqueness values. See \code{rgl.material}.}

\item{lwd}{Line width for edges. See \code{rgl.material}.}

\item{specular}{Specular color. See \code{rgl.material}.}

\item{draw.vertices}{If \code{TRUE}, draw triangle vertices.}

\item{draw.edges}{If \code{TRUE}, draw triangle edges.}

\item{edge.color}{Edge color specification.}

\item{\dots}{Additional parameters passed to and from other methods.}
}
\description{
Plots a triangulation mesh using \code{rgl}.
}
\seealso{
\code{\link[=plot.inla.mesh]{plot.inla.mesh()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
