%%
%% WARNING! DO NOT EDIT!
%% This file is automatically generated from qsample.R
%%
 \name{qsample}
 \alias{inla.qsample}
 \alias{qsample}

 \title{Generate samples from a GMRF using the GMRFLib implementation}

 \description{This function generate samples from a GMRF using the GMRFLib implementation}
 \usage{
 inla.qsample(
        n = 1L,
        Q,
        b,
        mu,
        sample,
        constr,
        reordering = INLA::inla.reorderings(),
        seed = 0L,
        logdens = ifelse(missing(sample), FALSE, TRUE),
        compute.mean = ifelse(missing(sample), FALSE, TRUE),
        num.threads = if (seed == 0L) "0:0" else NULL,
        selection = NULL, verbose = FALSE)
 }

 \arguments{
   \item{n}{Number of samples. Only used if \code{missing(sample)}}
   \item{Q}{The precision matrix or a filename containing it.}
   \item{b}{The linear term}
   \item{mu}{The mu term}
   \item{sample}{A matrix of optional samples where each column is a sample. If set, then evaluate the log-density for each sample only.}
   \item{constr}{Optional linear constraints; see \code{?INLA::f} and argument \code{extraconstr}}
   \item{reordering}{The type of reordering algorithm to be used for \code{TAUCS};
        either one of the names listed in \code{inla.reorderings()}
        or the output from \code{inla.qreordering(Q)}.
        The default is "auto" which try several reordering algorithm and use the best one for this particular matrix.}
   \item{seed}{Control the RNG. If \code{seed=0L} then GMRFLib will set the seed
               intelligently/at 'random',  and this is and should be the default behaviour.
               If \code{seed < 0L}  then the saved state of the RNG will be reused if possible, otherwise,
               GMRFLib will set the seed intelligently/at 'random'.
               If \code{seed > 0L} then this value is used as the seed for the RNG.

               PLEASE NOTE1: If \code{seed!=0} then the computations will run in serial mode,  over-riding
               whatever is set in \code{num.threads} (a warning might be issued).

               PLEASE NOTE2: If the PARDISO sparse matrix library is used, continuity of the samples
               with respect to small changes in the precision matrix, can be expected but is
               not guaranteed. If this feature is required, please use the TAUCS sparse matrix library.}
   \item{logdens}{If \code{TRUE}, compute also the log-density of each sample. Note that the output format then change.}
   \item{compute.mean}{If \code{TRUE}, compute also the (constrained) mean. Note that the output format then change.}
   \item{num.threads}{Maximum number of threads the
                      \code{inla}-program will use, or as 'A:B' defining the number threads in the
                      outer (A) and inner (B) layer for nested parallelism.
                      \code{seed!=0} requires serial comptuations.}
   \item{selection}{A vector of indices of each sample to
                    return. \code{NULL} means return the whole sample.
                    (Note that the log-density retured,  is for the whole sample.)
                    The use of \code{selection} cannot be combined with the use of \code{sample}.}
   \item{verbose}{Logical. Run in verbose mode or not.}
 }
\value{
      The log-density has form {-1/2(x-mu)^T Q (x-mu) + b^T x}

  If \code{logdens} is \code{FALSE},  then \code{inla.qsample} returns
  the samples in a matrix,  where each column is a sample.
  If \code{logdens} or \code{compute.mean} is \code{TRUE}, then a list
   with names \code{sample},
  \code{logdens} and \code{mean} is returned. The samples are stored in the matrix
  \code{sample} where each column is a sample, and the log
  densities of each sample are stored as the vector \code{logdens}.
  The mean (include corrections for the constraints,  if any) is store in
  the vector \code{mean}.
}
\author{Havard Rue \email{hrue@r-inla.org}}

\examples{
 g = system.file("demodata/germany.graph", package="INLA")
 Q = inla.graph2matrix(g)
 diag(Q) = dim(Q)[1L]
 x = inla.qsample(10, Q)
 \dontrun{matplot(x)}
 x = inla.qsample(10, Q, logdens=TRUE)
 \dontrun{matplot(x$sample)}

 n = 3
 Q = diag(n)
 ns = 2

 ## sample and evaluate a sample
 x = inla.qsample(n, Q=Q, logdens=TRUE)
 xx = inla.qsample(Q=Q,  sample = x$sample)
 print(x$logdens - xx$logdens)

 ## the use of a constraint
 constr = list(A = matrix(rep(1, n), 1, n), e = 0)
 x = inla.qsample(n, Q=Q, constr=constr)
 print(constr$A \%*\% x)

 ## control the RNG (require serial mode)
 x = inla.qsample(n, Q=Q, seed = 123, num.threads="1:1")
 ## restart from same seed,  only sample 1
 xx = inla.qsample(n=1, Q=Q, seed = 123, num.threads="1:1")
 ## continue from the save state, sample the remaining 2
 xxx = inla.qsample(n=n-1, Q=Q, seed = -1, num.threads="1:1")
 ## should be 0
 print(x - cbind(xx, xxx))
}
